/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractProtobufList;
import com.google.protobuf.Internal;
import com.google.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class BooleanArrayList
extends AbstractProtobufList<Boolean>
implements Internal.BooleanList,
RandomAccess,
PrimitiveNonBoxingCollection {
    private static final BooleanArrayList EMPTY_LIST = new BooleanArrayList();
    private boolean[] array;
    private int size;

    public static BooleanArrayList emptyList() {
        return EMPTY_LIST;
    }

    BooleanArrayList() {
        this(new boolean[10], 0);
    }

    private BooleanArrayList(boolean[] blArray, int n) {
        this.array = blArray;
        this.size = n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BooleanArrayList)) {
            return super.equals(object);
        }
        BooleanArrayList booleanArrayList = (BooleanArrayList)object;
        if (this.size != booleanArrayList.size) {
            return false;
        }
        boolean[] blArray = booleanArrayList.array;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = 31 * n + Internal.hashBoolean(this.array[i]);
        }
        return n;
    }

    @Override
    public Internal.BooleanList mutableCopyWithCapacity(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new BooleanArrayList(Arrays.copyOf(this.array, n), this.size);
    }

    @Override
    public Boolean get(int n) {
        return this.getBoolean(n);
    }

    @Override
    public boolean getBoolean(int n) {
        this.ensureIndexInRange(n);
        return this.array[n];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Boolean set(int n, Boolean bl) {
        return this.setBoolean(n, bl);
    }

    @Override
    public boolean setBoolean(int n, boolean bl) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        boolean bl2 = this.array[n];
        this.array[n] = bl;
        return bl2;
    }

    @Override
    public void add(int n, Boolean bl) {
        this.addBoolean(n, bl);
    }

    @Override
    public void addBoolean(boolean bl) {
        this.addBoolean(this.size, bl);
    }

    private void addBoolean(int n, boolean bl) {
        this.ensureIsMutable();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        } else {
            int n2 = this.size * 3 / 2 + 1;
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.array, 0, blArray, 0, n);
            System.arraycopy(this.array, n, blArray, n + 1, this.size - n);
            this.array = blArray;
        }
        this.array[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Boolean> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof BooleanArrayList)) {
            return super.addAll(collection);
        }
        BooleanArrayList booleanArrayList = (BooleanArrayList)collection;
        if (booleanArrayList.size == 0) {
            return false;
        }
        int n = Integer.MAX_VALUE - this.size;
        if (n < booleanArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n2 = this.size + booleanArrayList.size;
        if (n2 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n2);
        }
        System.arraycopy(booleanArrayList.array, 0, this.array, this.size, booleanArrayList.size);
        this.size = n2;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean remove(Object object) {
        this.ensureIsMutable();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.array[i])) continue;
            System.arraycopy(this.array, i + 1, this.array, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public Boolean remove(int n) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        boolean bl = this.array[n];
        System.arraycopy(this.array, n + 1, this.array, n, this.size - n);
        --this.size;
        ++this.modCount;
        return bl;
    }

    private void ensureIndexInRange(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int n) {
        return "Index:" + n + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

