/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public class NumberFn
extends Function {
    @Override
    public String getName() {
        return "number";
    }

    @Override
    public int getDataType() {
        return 2;
    }

    @Override
    public Expression simplify() throws XPathException {
        int n = this.checkArgumentCount(0, 1);
        if (n == 1) {
            this.argument[0] = this.argument[0].simplify();
            if (this.argument[0].getDataType() == 2) {
                return this.argument[0];
            }
            if (this.argument[0] instanceof Value) {
                return new NumericValue(((Value)this.argument[0]).asNumber());
            }
        }
        return this;
    }

    @Override
    public double evaluateAsNumber(Context context) throws XPathException {
        if (this.getNumberOfArguments() == 1) {
            return this.argument[0].evaluateAsNumber(context);
        }
        return Value.stringToNumber(context.getContextNodeInfo().getStringValue());
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new NumericValue(this.evaluateAsNumber(context));
    }

    @Override
    public int getDependencies() {
        if (this.getNumberOfArguments() == 1) {
            return this.argument[0].getDependencies();
        }
        return 8;
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        if (this.getNumberOfArguments() == 1) {
            NumberFn numberFn = new NumberFn();
            numberFn.addArgument(this.argument[0].reduce(n, context));
            numberFn.setStaticContext(this.getStaticContext());
            return numberFn.simplify();
        }
        if ((n & 8) != 0) {
            return this.evaluate(context);
        }
        return this;
    }
}

