/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.ProxyEmitter;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class NamespaceEmitter
extends ProxyEmitter {
    protected NamePool namePool;
    protected int nscodeXML;
    protected int nscodeNull;
    private int[] namespaces = new int[30];
    private int namespacesSize = 0;
    private int[] namespaceStack = new int[100];
    private int nsStackTop = 0;

    @Override
    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
        this.nscodeXML = namePool.getNamespaceCode("xml", "http://www.w3.org/XML/1998/namespace");
        this.nscodeNull = namePool.getNamespaceCode("", "");
        super.setNamePool(namePool);
    }

    @Override
    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        int[] nArray2 = new int[nArray.length + 1];
        int n3 = 0;
        int n4 = this.namePool.allocateNamespaceCode(n);
        if (this.isNeeded(n4)) {
            this.addToStack(n4);
            nArray2[n3++] = n4;
        }
        for (int i = 0; i < n2; ++i) {
            int n5 = nArray[i];
            if (!this.isNeeded(n5)) continue;
            this.addToStack(n5);
            nArray2[n3++] = n5;
        }
        if (this.nsStackTop >= this.namespaceStack.length) {
            int[] nArray3 = new int[this.nsStackTop * 2];
            System.arraycopy(this.namespaceStack, 0, nArray3, 0, this.nsStackTop);
            this.namespaceStack = nArray3;
        }
        this.namespaceStack[this.nsStackTop++] = n3;
        super.startElement(n, attributes, nArray2, n3);
    }

    private boolean isNeeded(int n) {
        if (n == this.nscodeXML) {
            return false;
        }
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            if (this.namespaces[i] == n) {
                return false;
            }
            if (this.namespaces[i] >> 16 != n >> 16) continue;
            return true;
        }
        return n != this.nscodeNull;
    }

    private void addToStack(int n) {
        if (this.namespacesSize + 1 >= this.namespaces.length) {
            int[] nArray = new int[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, nArray, 0, this.namespacesSize);
            this.namespaces = nArray;
        }
        this.namespaces[this.namespacesSize++] = n;
    }

    @Override
    public void endElement(int n) throws TransformerException {
        if (this.nsStackTop-- == 0) {
            throw new TransformerException("Attempt to output end tag with no matching start tag");
        }
        int n2 = this.namespaceStack[this.nsStackTop];
        this.namespacesSize -= n2;
        super.endElement(n);
    }
}

