/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.SAXONFunction;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.XSLFallback;
import com.icl.saxon.style.XSLGeneralVariable;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class SAXONReturn
extends XSLGeneralVariable {
    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public int getVariableFingerprint() {
        return -1;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.SELECT) {
                string = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        NodeImpl nodeImpl;
        NodeInfo nodeInfo;
        for (nodeInfo = (NodeInfo)((Object)this.getParentNode()); nodeInfo != null && !(nodeInfo instanceof SAXONFunction); nodeInfo = nodeInfo.getParent()) {
            if (!(nodeInfo instanceof XSLGeneralVariable)) continue;
            this.compileError(this.getDisplayName() + " must not be used within a variable definition");
        }
        if (nodeInfo == null) {
            this.compileError(this.getDisplayName() + " must only be used within a function definition");
        }
        if ((nodeImpl = (NodeImpl)this.getNextSibling()) != null && !(nodeImpl instanceof XSLFallback)) {
            this.compileError(this.getDisplayName() + " must be the last instruction in its template body");
        }
        if (this.select == null && !this.hasChildNodes()) {
            this.select = new StringValue("");
        }
    }

    @Override
    public void process(Context context) throws TransformerException {
        Value value = this.getSelectValue(context);
        context.setReturnValue(value);
    }
}

