/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.ContextNodeExpression;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.AttributeCollection;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public final class XSLValueOf
extends StyleElement {
    private Expression select;
    private boolean disable = false;

    @Override
    public boolean isInstruction() {
        return true;
    }

    public Expression getSelectExpression() {
        if (this.select == null) {
            return new ContextNodeExpression();
        }
        return this.select;
    }

    public boolean getDisableOutputEscaping() {
        return this.disable;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        String string2 = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.DISABLE_OUTPUT_ESCAPING) {
                string2 = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.SELECT) {
                string = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string == null) {
            this.reportAbsence("select");
            return;
        }
        this.select = string.trim().equals(".") ? null : this.makeExpression(string);
        if (string2 != null) {
            if (string2.equals("yes")) {
                this.disable = true;
            } else if (string2.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.checkEmpty();
    }

    @Override
    public void process(Context context) throws TransformerException {
        Outputter outputter = context.getOutputter();
        if (this.disable) {
            outputter.setEscaping(false);
        }
        if (this.select == null) {
            context.getCurrentNodeInfo().copyStringValue(outputter);
        } else {
            this.select.outputStringValue(outputter, context);
        }
        if (this.disable) {
            outputter.setEscaping(true);
        }
    }
}

