/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Bindery;
import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.expr.Value;
import com.icl.saxon.style.Procedure;
import com.icl.saxon.style.XSLGeneralVariable;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLVariable
extends XSLGeneralVariable
implements Binding {
    private int slotNumber;

    @Override
    public int getSlotNumber() {
        return this.slotNumber;
    }

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        super.validate();
        this.checkDuplicateDeclaration();
        if (this.global && !this.redundant) {
            this.slotNumber = this.getPrincipalStyleSheet().allocateSlotNumber();
        } else {
            Procedure procedure = this.getOwningProcedure();
            this.slotNumber = procedure.allocateSlotNumber();
        }
    }

    @Override
    public int getDataType() {
        if (this.assignable) {
            return -1;
        }
        if (this.select != null) {
            return this.select.getDataType();
        }
        return 4;
    }

    @Override
    public Value constantValue() {
        if (this.assignable) {
            return null;
        }
        if (this.select != null && this.select instanceof Value) {
            return (Value)this.select;
        }
        return null;
    }

    @Override
    public void process(Context context) throws TransformerException {
        Bindery bindery = context.getBindery();
        if (this.global) {
            if (!this.redundant && !bindery.isEvaluated(this)) {
                Value value = this.getSelectValue(context);
                bindery.defineGlobalVariable(this, value);
            }
        } else {
            Value value = this.getSelectValue(context);
            bindery.defineLocalVariable(this, value);
        }
    }
}

