/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamePool;
import org.xml.sax.Attributes;

public final class AttributeCollection
implements Attributes {
    private NamePool namePool;
    private Object[] list = null;
    private int used = 0;
    private static int RECSIZE = 3;
    private static int NAMECODE = 0;
    private static int TYPE = 1;
    private static int VALUE = 2;

    public AttributeCollection(NamePool namePool) {
        this.namePool = namePool;
        this.list = null;
        this.used = 0;
    }

    public AttributeCollection(NamePool namePool, int n) {
        this.namePool = namePool;
        this.list = new Object[n * RECSIZE];
        this.used = 0;
    }

    public AttributeCollection(AttributeCollection attributeCollection) {
        this.namePool = attributeCollection.namePool;
        this.list = new Object[attributeCollection.used];
        if (attributeCollection.used > 0) {
            System.arraycopy(attributeCollection.list, 0, this.list, 0, attributeCollection.used);
        }
        this.used = attributeCollection.used;
    }

    public AttributeCollection(NamePool namePool, Attributes attributes) {
        this.namePool = namePool;
        int n = attributes.getLength();
        this.used = n * RECSIZE;
        this.list = new Object[this.used];
        for (int i = 0; i < n; ++i) {
            int n2 = i * RECSIZE;
            String string = attributes.getQName(i);
            String string2 = Name.getPrefix(string);
            String string3 = attributes.getURI(i);
            String string4 = attributes.getLocalName(i);
            int n3 = this.namePool.allocate(string2, string3, string4);
            this.list[n2 + AttributeCollection.NAMECODE] = new Integer(n3);
            this.list[n2 + AttributeCollection.TYPE] = attributes.getType(i);
            this.list[n2 + AttributeCollection.VALUE] = attributes.getValue(i);
        }
    }

    public void addAttribute(int n, String string, String string2) {
        if (this.list == null) {
            this.list = new Object[5 * RECSIZE];
            this.used = 0;
        }
        if (this.list.length == this.used) {
            int n2 = this.used == 0 ? 5 * RECSIZE : this.used * 2;
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.list, 0, objectArray, 0, this.used);
            this.list = objectArray;
        }
        this.list[this.used++] = new Integer(n);
        this.list[this.used++] = string;
        this.list[this.used++] = string2;
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) {
        this.addAttribute(this.namePool.allocate(string, string2, string3), string4, string5);
    }

    public void setAttribute(String string, String string2, String string3, String string4, String string5) {
        int n = this.namePool.allocate(string, string2, string3);
        int n2 = this.findByFingerprint(n & 0xFFFFF);
        if (n2 < 0) {
            this.addAttribute(string, string2, string3, string4, string5);
        } else {
            this.list[n2 + AttributeCollection.NAMECODE] = new Integer(n);
            this.list[n2 + AttributeCollection.TYPE] = string4;
            this.list[n2 + AttributeCollection.VALUE] = string5;
        }
    }

    public void setAttribute(int n, String string, String string2) {
        int n2 = this.findByFingerprint(n & 0xFFFFF);
        if (n2 < 0) {
            this.addAttribute(n, string, string2);
        } else {
            this.list[n2 + AttributeCollection.NAMECODE] = new Integer(n);
            this.list[n2 + AttributeCollection.TYPE] = string;
            this.list[n2 + AttributeCollection.VALUE] = string2;
        }
    }

    public void clear() {
        this.used = 0;
    }

    public void compact() {
        if (this.used == 0) {
            this.list = null;
        } else if (this.list.length > this.used) {
            Object[] objectArray = new Object[this.used];
            System.arraycopy(this.list, 0, objectArray, 0, this.used);
            this.list = objectArray;
        }
    }

    @Override
    public int getLength() {
        return this.list == null ? 0 : this.used / RECSIZE;
    }

    public int getNameCode(int n) {
        int n2 = n * RECSIZE;
        if (this.list == null) {
            return -1;
        }
        if (n2 >= this.used) {
            return -1;
        }
        return (Integer)this.list[n2 + NAMECODE];
    }

    @Override
    public String getQName(int n) {
        int n2 = n * RECSIZE;
        if (this.list == null) {
            return null;
        }
        if (n2 >= this.used) {
            return null;
        }
        return this.namePool.getDisplayName(this.getNameCode(n));
    }

    @Override
    public String getLocalName(int n) {
        if (this.list == null) {
            return null;
        }
        if (n * RECSIZE >= this.used) {
            return null;
        }
        return this.namePool.getLocalName(this.getNameCode(n));
    }

    @Override
    public String getURI(int n) {
        if (this.list == null) {
            return null;
        }
        if (n * RECSIZE >= this.used) {
            return null;
        }
        return this.namePool.getURI(this.getNameCode(n));
    }

    @Override
    public String getType(int n) {
        int n2 = n * RECSIZE;
        if (this.list == null) {
            return null;
        }
        if (n2 >= this.used) {
            return null;
        }
        return (String)this.list[n2 + TYPE];
    }

    @Override
    public String getType(String string, String string2) {
        int n = this.findByName(string, string2);
        return n < 0 ? null : (String)this.list[n + TYPE];
    }

    @Override
    public String getValue(int n) {
        int n2 = n * RECSIZE;
        if (this.list == null) {
            return null;
        }
        if (n2 >= this.used) {
            return null;
        }
        return (String)this.list[n2 + VALUE];
    }

    @Override
    public String getValue(String string, String string2) {
        int n = this.findByName(string, string2);
        return n < 0 ? null : (String)this.list[n + VALUE];
    }

    public String getValueByFingerprint(int n) {
        int n2 = this.findByFingerprint(n);
        return n2 < 0 ? null : (String)this.list[n2 + VALUE];
    }

    @Override
    public int getIndex(String string) {
        int n = this.findByDisplayName(string);
        return n < 0 ? -1 : n / RECSIZE;
    }

    @Override
    public int getIndex(String string, String string2) {
        int n = this.findByName(string, string2);
        return n < 0 ? -1 : n / RECSIZE;
    }

    public int getIndexByFingerprint(int n) {
        int n2 = this.findByFingerprint(n);
        return n2 < 0 ? -1 : n2 / RECSIZE;
    }

    @Override
    public String getType(String string) {
        int n = this.findByDisplayName(string);
        return n < 0 ? null : (String)this.list[n + TYPE];
    }

    @Override
    public String getValue(String string) {
        int n = this.findByDisplayName(string);
        return n < 0 ? null : (String)this.list[n + VALUE];
    }

    private int findByName(String string, String string2) {
        if (this.namePool == null) {
            return -1;
        }
        int n = this.namePool.getFingerprint(string, string2);
        if (n == -1) {
            return -1;
        }
        return this.findByFingerprint(n);
    }

    private int findByFingerprint(int n) {
        if (this.list == null) {
            return -1;
        }
        for (int i = 0; i < this.used; i += RECSIZE) {
            if (n != ((Integer)this.list[i + NAMECODE] & 0xFFFFF)) continue;
            return i;
        }
        return -1;
    }

    private int findByDisplayName(String string) {
        if (this.list == null) {
            return -1;
        }
        String string2 = Name.getPrefix(string);
        if (string2.equals("")) {
            return this.findByName("", string);
        }
        String string3 = Name.getLocalName(string);
        for (int i = 0; i < this.getLength(); ++i) {
            String string4 = this.namePool.getLocalName(this.getNameCode(i));
            String string5 = this.namePool.getPrefix(this.getNameCode(i));
            if (!string3.equals(string4) || !string2.equals(string5)) continue;
            return i;
        }
        return -1;
    }
}

