/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.tree.NodeImpl;

abstract class TreeEnumeration
implements AxisEnumeration {
    protected NodeImpl start;
    protected NodeImpl next;
    protected NodeTest nodeTest;
    protected int last = -1;

    public TreeEnumeration(NodeImpl nodeImpl, NodeTest nodeTest) {
        this.next = nodeImpl;
        this.start = nodeImpl;
        this.nodeTest = nodeTest;
    }

    protected boolean conforms(NodeImpl nodeImpl) {
        if (nodeImpl == null) {
            return true;
        }
        return this.nodeTest.matches(nodeImpl);
    }

    protected final void advance() {
        do {
            this.step();
        } while (!this.conforms(this.next));
    }

    protected abstract void step();

    @Override
    public final boolean hasMoreElements() {
        return this.next != null;
    }

    @Override
    public final NodeInfo nextElement() {
        NodeImpl nodeImpl = this.next;
        this.advance();
        return nodeImpl;
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public boolean isReverseSorted() {
        return !this.isSorted();
    }

    @Override
    public boolean isPeer() {
        return false;
    }

    protected int count() {
        int n = 0;
        while (this.hasMoreElements()) {
            this.nextElement();
            ++n;
        }
        return n;
    }
}

