/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.migrator.line;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.migrator.line.ConversionRule;

public class MultiGroupConversionRule
implements ConversionRule {
    private static final int MAX_GROUPS = 10;
    private Pattern pattern;
    private String[] replacementTable = new String[10];

    public MultiGroupConversionRule(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    public void addReplacement(int n, String string) {
        if (n == 0) {
            throw new IllegalArgumentException("regex groups start at 1, not zero");
        }
        this.replacementTable[n] = string;
    }

    public String getReplacement(int n) {
        return this.replacementTable[n];
    }

    @Override
    public String replace(Matcher matcher) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            String string = this.getReplacement(i);
            if (string != null) {
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append(matcher.group(i));
        }
        return stringBuilder.toString();
    }

    @Override
    public String getAdditionalLine() {
        return null;
    }
}

