/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.png;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.codec.png.PNGDecodeParam;
import org.apache.batik.ext.awt.image.codec.png.PNGRed;
import org.apache.batik.ext.awt.image.renderable.DeferRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.MagicNumberRegistryEntry;
import org.apache.batik.util.ParsedURL;

public class PNGRegistryEntry
extends MagicNumberRegistryEntry {
    static final byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public PNGRegistryEntry() {
        super("PNG", "png", "image/png", 0, signature);
    }

    public Filter handleStream(InputStream inputStream, ParsedURL parsedURL, boolean bl) {
        Object[] objectArray;
        String string;
        final DeferRable deferRable = new DeferRable();
        final InputStream inputStream2 = inputStream;
        final boolean bl2 = bl;
        if (parsedURL != null) {
            string = "url.format.unreadable";
            objectArray = new Object[]{"PNG", parsedURL};
        } else {
            string = "stream.format.unreadable";
            objectArray = new Object[]{"PNG"};
        }
        Thread thread = new Thread(){

            public void run() {
                Filter filter;
                try {
                    PNGDecodeParam pNGDecodeParam = new PNGDecodeParam();
                    pNGDecodeParam.setExpandPalette(true);
                    if (bl2) {
                        pNGDecodeParam.setPerformGammaCorrection(false);
                    } else {
                        pNGDecodeParam.setPerformGammaCorrection(true);
                        pNGDecodeParam.setDisplayExponent(2.2f);
                    }
                    PNGRed pNGRed = new PNGRed(inputStream2, pNGDecodeParam);
                    deferRable.setBounds((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, pNGRed.getWidth(), pNGRed.getHeight()));
                    pNGRed = new Any2sRGBRed((CachableRed)pNGRed);
                    pNGRed = new FormatRed((CachableRed)pNGRed, GraphicsUtil.sRGB_Unpre);
                    WritableRaster writableRaster = (WritableRaster)pNGRed.getData();
                    ColorModel colorModel = pNGRed.getColorModel();
                    BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
                    pNGRed = GraphicsUtil.wrap((RenderedImage)bufferedImage);
                    filter = new RedRable((CachableRed)pNGRed);
                }
                catch (IOException iOException) {
                    filter = ImageTagRegistry.getBrokenLinkImage((Object)((Object)PNGRegistryEntry.this), (String)string, (Object[])objectArray);
                }
                catch (ThreadDeath threadDeath) {
                    Filter filter2 = ImageTagRegistry.getBrokenLinkImage((Object)((Object)PNGRegistryEntry.this), (String)string, (Object[])objectArray);
                    deferRable.setSource(filter2);
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    filter = ImageTagRegistry.getBrokenLinkImage((Object)((Object)PNGRegistryEntry.this), (String)string, (Object[])objectArray);
                }
                deferRable.setSource(filter);
            }
        };
        thread.start();
        return deferRable;
    }
}

