/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.dice;

import VASSAL.build.module.DieRoll;
import VASSAL.build.module.dice.DieServer;
import VASSAL.build.module.dice.RollSet;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BonesDiceServer
extends DieServer {
    public BonesDiceServer() {
        this.name = "Bones";
        this.description = "Bones Dice Server";
        this.emailOnly = false;
        this.maxRolls = 0;
        this.maxEmails = 0;
        this.serverURL = "http://dice.nomic.net/cgi-bin/randroll.pl";
        this.passwdRequired = false;
        this.canDoSeparateDice = true;
    }

    @Override
    public String[] buildInternetRollString(RollSet rollSet) {
        DieRoll[] dieRollArray = rollSet.getDieRolls();
        StringBuilder stringBuilder = new StringBuilder("req=");
        for (int i = 0; i < dieRollArray.length; ++i) {
            stringBuilder.append("{{").append(dieRollArray[i].getNumDice()).append("D").append(dieRollArray[i].getNumSides());
            if (dieRollArray[i].getPlus() != 0) {
                stringBuilder.append("+").append(dieRollArray[i].getPlus());
            }
            stringBuilder.append("}}\n");
        }
        try {
            return new String[]{new URI("http", "dice.nomic.net", "/cgi-bin/randroll.pl", stringBuilder.toString(), null).toURL().toString()};
        }
        catch (MalformedURLException malformedURLException) {
            ErrorDialog.bug(malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            ErrorDialog.bug(uRISyntaxException);
        }
        return null;
    }

    @Override
    public void parseInternetRollString(RollSet rollSet, Vector<String> vector) {
        Iterator<String> iterator = vector.iterator();
        for (int i = 0; i < rollSet.dieRolls.length; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(iterator.next(), " ");
            for (int j = 0; j < rollSet.dieRolls[i].getNumDice(); ++j) {
                rollSet.dieRolls[i].setResult(j, Integer.parseInt(stringTokenizer.nextToken()));
            }
        }
    }

    @Override
    public void roll(RollSet rollSet, FormattedString formattedString) {
        super.doInternetRoll(rollSet, formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doIRoll(RollSet rollSet) throws IOException {
        String[] stringArray = this.buildInternetRollString(rollSet);
        Vector<String> vector = new Vector<String>();
        URL uRL = new URL(stringArray[0]);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.connect();
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                vector.add(string);
            }
            bufferedReader.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        this.parseInternetRollString(rollSet, vector);
    }
}

