/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.Symbol;
import VASSAL.build.module.gamepieceimage.SymbolItemInstance;
import VASSAL.configure.StringEnum;
import VASSAL.tools.ArrayUtils;
import VASSAL.tools.SequenceEncoder;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolItem
extends Item {
    public static final String TYPE = "Symbol";
    protected static final String SET = "set";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String LINE_WIDTH = "linewidth";
    protected String symbolSet = "";
    protected int height = 30;
    protected int width = 40;
    protected double lineWidth = 1.0;

    public SymbolItem() {
    }

    public SymbolItem(GamePieceLayout gamePieceLayout) {
        super(gamePieceLayout);
        this.width = this.getLayout().getLayoutWidth() / 2;
        this.height = (int)((double)this.width * 0.75);
    }

    public SymbolItem(GamePieceLayout gamePieceLayout, String string) {
        this(gamePieceLayout);
        this.setConfigureName(string);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return ArrayUtils.insert(super.getAttributeDescriptions(), 2, "Symbol Set:  ", "Width:  ", "Height:  ", "Line Width:  ");
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return ArrayUtils.insert(super.getAttributeTypes(), 2, SetConfig.class, Integer.class, Integer.class, Double.class);
    }

    @Override
    public String[] getAttributeNames() {
        return ArrayUtils.insert(super.getAttributeNames(), 2, SET, WIDTH, HEIGHT, LINE_WIDTH);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (!SET.equals(string)) {
            if (WIDTH.equals(string)) {
                if (object instanceof String) {
                    object = Integer.valueOf((String)object);
                }
                this.width = (Integer)object;
                if (this.width < 1) {
                    this.width = 1;
                }
            } else if (HEIGHT.equals(string)) {
                if (object instanceof String) {
                    object = Integer.valueOf((String)object);
                }
                this.height = (Integer)object;
                if (this.height < 1) {
                    this.height = 1;
                }
            } else if (LINE_WIDTH.equals(string)) {
                if (object instanceof String) {
                    object = Double.valueOf((String)object);
                }
                this.lineWidth = (Double)object;
                if (this.lineWidth < 0.0) {
                    this.lineWidth = 0.0;
                }
            } else {
                super.setAttribute(string, object);
            }
        }
        if (this.layout != null) {
            this.layout.refresh();
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (SET.equals(string)) {
            return this.symbolSet;
        }
        if (WIDTH.equals(string)) {
            return String.valueOf(this.width);
        }
        if (HEIGHT.equals(string)) {
            return String.valueOf(this.height);
        }
        if (LINE_WIDTH.equals(string)) {
            return String.valueOf(this.lineWidth);
        }
        return super.getAttributeValueString(string);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void draw(Graphics graphics, GamePieceImage gamePieceImage) {
        SymbolItemInstance symbolItemInstance = null;
        if (gamePieceImage != null) {
            symbolItemInstance = gamePieceImage.getSymbolInstance(this.getConfigureName());
        }
        Symbol symbol = null;
        if (symbolItemInstance == null) {
            symbol = new Symbol("NATO Unit Symbols", "Infantry", "None", "Division");
            symbolItemInstance = new SymbolItemInstance();
        } else {
            symbol = new Symbol("NATO Unit Symbols", symbolItemInstance.getSymbol1(), symbolItemInstance.getSymbol2(), symbolItemInstance.getSize());
        }
        Point point = this.layout.getPosition(this);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.getWidth(), this.getHeight());
        if (this.getRotation() != 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(this.getRotation()), this.layout.getPosition((Item)this).x, this.layout.getPosition((Item)this).y);
            graphics2D.transform(affineTransform);
        }
        if (this.isAntialias()) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        symbol.draw(graphics, rectangle, symbolItemInstance.getFgColor().getColor(), symbolItemInstance.getBgColor().getColor(), symbolItemInstance.getSizeColor().getColor(), (float)this.lineWidth);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public static Item decode(GamePieceLayout gamePieceLayout, String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        SymbolItem symbolItem = new SymbolItem(gamePieceLayout);
        decoder.nextToken();
        symbolItem.width = decoder.nextInt(54);
        symbolItem.height = decoder.nextInt(54);
        symbolItem.lineWidth = decoder.nextDouble(1.0);
        return symbolItem;
    }

    @Override
    public String encode() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(TYPE, ';');
        sequenceEncoder.append(this.width);
        sequenceEncoder.append(this.height);
        sequenceEncoder.append(this.lineWidth);
        SequenceEncoder sequenceEncoder2 = new SequenceEncoder(sequenceEncoder.getValue(), '|');
        sequenceEncoder2.append(super.encode());
        return sequenceEncoder2.getValue();
    }

    public static class SetConfig
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return Symbol.SYMBOL_SETS;
        }
    }
}

