/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.module.map.PieceCollection;
import VASSAL.build.module.map.SimplePieceCollection;
import VASSAL.counters.Deck;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class CompoundPieceCollection
implements PieceCollection {
    protected SimplePieceCollection[] layers;
    protected int bottomLayer = 0;
    protected boolean[] enabled;

    protected CompoundPieceCollection(int n) {
        this.initLayers(n);
    }

    protected void initLayers(int n) {
        this.layers = new SimplePieceCollection[n];
        this.enabled = new boolean[n];
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new SimplePieceCollection();
            this.enabled[i] = true;
        }
    }

    public int getLayerForPiece(GamePiece gamePiece) {
        return 0;
    }

    public String getLayerNameForPiece(GamePiece gamePiece) {
        return "";
    }

    public int getLayerForName(String string) {
        return -1;
    }

    protected PieceCollection getCollectionForPiece(GamePiece gamePiece) {
        return this.layers[this.getLayerForPiece(gamePiece)];
    }

    public void add(GamePiece gamePiece) {
        this.getCollectionForPiece(gamePiece).add(gamePiece);
    }

    public void clear() {
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i].clear();
        }
    }

    public GamePiece[] getPieces() {
        return this.getPieces(false);
    }

    protected GamePiece[] getPieces(boolean bl) {
        ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>();
        int n = this.bottomLayer;
        for (int i = 0; i < this.layers.length; ++i) {
            if (bl || !bl && this.enabled[n]) {
                arrayList.addAll(Arrays.asList(this.layers[n].getPieces()));
            }
            if (++n < this.layers.length) continue;
            n = 0;
        }
        return arrayList.toArray(new GamePiece[arrayList.size()]);
    }

    public GamePiece[] getAllPieces() {
        return this.getPieces(true);
    }

    public int indexOf(GamePiece gamePiece) {
        int n = this.getLayerForPiece(gamePiece);
        int n2 = this.layers[n].indexOf(gamePiece);
        if (n2 >= 0) {
            for (int i = 0; i < n - 1; ++i) {
                n2 += this.layers[i].getPieces().length;
            }
        }
        return n2;
    }

    public void remove(GamePiece gamePiece) {
        this.getCollectionForPiece(gamePiece).remove(gamePiece);
    }

    public void moveToBack(GamePiece gamePiece) {
        this.getCollectionForPiece(gamePiece).moveToBack(gamePiece);
    }

    public void moveToFront(GamePiece gamePiece) {
        this.getCollectionForPiece(gamePiece).moveToFront(gamePiece);
    }

    public boolean canMerge(GamePiece gamePiece, GamePiece gamePiece2) {
        boolean bl = false;
        bl = gamePiece instanceof Deck || gamePiece2 instanceof Deck ? true : (gamePiece instanceof Stack ? (gamePiece2 instanceof Stack ? this.canStacksMerge((Stack)gamePiece, (Stack)gamePiece2) : this.canStackAndPieceMerge((Stack)gamePiece, gamePiece2)) : (gamePiece2 instanceof Stack ? this.canStackAndPieceMerge((Stack)gamePiece2, gamePiece) : this.canPiecesMerge(gamePiece, gamePiece2)));
        return bl;
    }

    protected boolean canStacksMerge(Stack stack, Stack stack2) {
        return this.canPiecesMerge(stack.topPiece(), stack2.topPiece());
    }

    protected boolean canStackAndPieceMerge(Stack stack, GamePiece gamePiece) {
        boolean bl = false;
        GamePiece gamePiece2 = stack.topPiece();
        if (gamePiece2 != null) {
            bl = this.canPiecesMerge(gamePiece2, gamePiece);
        }
        return bl;
    }

    protected boolean canPiecesMerge(GamePiece gamePiece, GamePiece gamePiece2) {
        boolean bl = false;
        if (gamePiece != null && gamePiece2 != null) {
            bl = !Boolean.TRUE.equals(gamePiece.getProperty("NoStack")) && !Boolean.TRUE.equals(gamePiece2.getProperty("NoStack")) && !Boolean.TRUE.equals(gamePiece.getProperty("Invisible")) && !Boolean.TRUE.equals(gamePiece2.getProperty("Invisible"));
        }
        return bl;
    }

    public int getLayerCount() {
        return this.layers.length;
    }

    public void setBottomLayer(int n) {
        this.bottomLayer = n;
        if (this.bottomLayer < 0) {
            this.bottomLayer = this.getLayerCount() - 1;
        }
        if (this.bottomLayer >= this.getLayerCount()) {
            this.bottomLayer = 0;
        }
    }

    public int getBottomLayer() {
        return this.bottomLayer;
    }

    public int getTopLayer() {
        int n = this.bottomLayer - 1;
        if (n < 0) {
            n = this.getLayerCount() - 1;
        }
        return n;
    }

    public void rotate(boolean bl, boolean bl2) {
        if (bl2) {
            for (int i = 0; i < this.layers.length; ++i) {
                this.rotate(bl);
                if (this.layers[this.getTopLayer()].getPieces().length <= 0) continue;
                return;
            }
        } else {
            this.rotate(bl);
        }
    }

    public void rotate(boolean bl) {
        if (bl) {
            this.setBottomLayer(this.bottomLayer - 1);
        } else {
            this.setBottomLayer(this.bottomLayer + 1);
        }
    }

    public void setLayerEnabled(int n, boolean bl) {
        if (n >= 0 && n < this.layers.length) {
            this.enabled[n] = bl;
        }
    }

    public void toggleLayerEnabled(int n) {
        if (n >= 0 && n < this.layers.length) {
            this.enabled[n] = !this.enabled[n];
        }
    }

    public void setLayerEnabled(String string, boolean bl) {
        this.setLayerEnabled(this.getLayerForName(string), bl);
    }

    public void toggleLayerEnabled(String string) {
        this.toggleLayerEnabled(this.getLayerForName(string));
    }

    public void reset() {
        this.setBottomLayer(0);
        for (int i = 0; i < this.layers.length; ++i) {
            this.enabled[i] = true;
        }
    }
}

