/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.HybridClient;
import VASSAL.chat.ServerAddressBook;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.jdesktop.swingworker.SwingWorker;

public class DynamicClient
extends HybridClient {
    public static final String LEGACY_URL = "http://www.vassalengine.org/util/getServerImpl";
    public static final String JABBER_URL = "http://www.vassalengine.org/util/getJabberServerImpl";
    private boolean connecting;
    private Properties overrides;

    public DynamicClient() {
        this(LEGACY_URL);
    }

    public DynamicClient(String string) {
    }

    protected ChatServerConnection buildDelegate() throws IOException {
        Properties properties = ServerAddressBook.getInstance().getCurrentServerProperties();
        return ChatServerFactory.build(properties);
    }

    public void setConnected(final boolean bl) {
        if (bl && !this.isConnected()) {
            if (!this.connecting) {
                this.connecting = true;
                new SwingWorker<ChatServerConnection, Void>(){

                    protected ChatServerConnection doInBackground() throws Exception {
                        return DynamicClient.this.buildDelegate();
                    }

                    protected void done() {
                        try {
                            DynamicClient.this.setDelegate((ChatServerConnection)this.get());
                            DynamicClient.super.setConnected(bl);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException executionException) {
                            Throwable throwable = executionException.getCause();
                            DynamicClient.this.fireStatus(Resources.getString("Server.bad_address3"));
                            ErrorDialog.showDetails(throwable, ThrowableUtils.getStackTrace(throwable), "Error.network_communication_error", new Object[0]);
                            throwable.printStackTrace();
                        }
                        DynamicClient.this.connecting = false;
                    }
                }.execute();
            }
        } else {
            super.setConnected(bl);
            if (!this.isConnected()) {
                try {
                    this.setDelegate(this.buildDelegate());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void setOverrides(Properties properties) {
        this.overrides = properties;
        if ("jabber".equals(this.overrides.getProperty("type"))) {
            // empty if block
        }
    }
}

