/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.build.GameModule;
import VASSAL.chat.peer2peer.AcceptPeerThread;
import VASSAL.chat.peer2peer.P2PPlayer;
import VASSAL.chat.peer2peer.PeerPool;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.swing.Dialogs;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PendingPeerManager;

public class DirectPeerPool
implements PeerPool,
ChatControlsInitializer {
    protected static final String ADDRESS_PREF = "PeerAddressBook";
    private AcceptPeerThread acceptThread;
    private JButton inviteButton;
    private JDialog frame;
    private int listenPort;
    private static StringArrayConfigurer addressConfig;
    private JButton invitePeerButton;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private JList addressList;
    private DefaultListModel addressBook;
    private Properties params = new Properties();
    private boolean serverMode;

    public DirectPeerPool() {
        this(new Properties());
    }

    public DirectPeerPool(Properties properties) {
        this.params.putAll((Map<?, ?>)properties);
        this.serverMode = "server".equals(this.params.getProperty("mode"));
        this.inviteButton = new JButton(Resources.getString("Peer2Peer.connect"));
        this.inviteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectPeerPool.this.frame.setVisible(true);
            }
        });
        this.inviteButton.setEnabled(false);
        this.inviteButton.setVisible("server".equals(this.params.getProperty("mode")));
    }

    public void initialize(P2PPlayer p2PPlayer, PendingPeerManager pendingPeerManager) throws IOException {
        this.listenPort = 5050;
        String string = this.params.getProperty("listenPort");
        if (string != null && string.length() > 0) {
            try {
                this.listenPort = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.acceptThread = new AcceptPeerThread(this.listenPort, pendingPeerManager);
        this.acceptThread.setName("Accept Peer Thread");
        p2PPlayer.getInfo().setPort(this.acceptThread.getPort());
        this.acceptThread.start();
        if (this.frame == null) {
            this.initComponents(p2PPlayer, pendingPeerManager);
            this.inviteButton.setEnabled(true);
        }
    }

    protected boolean isServerMode() {
        return this.serverMode;
    }

    public void disconnect() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
            this.inviteButton.setEnabled(false);
        }
        if (this.acceptThread != null) {
            this.acceptThread.halt();
            this.acceptThread = null;
        }
    }

    public void connectFailed(PeerInfo peerInfo) {
        JOptionPane.showMessageDialog(this.frame, Resources.getString("Peer2Peer.could_not_reach", peerInfo.getAddresses(), String.valueOf(peerInfo.getPort())), Resources.getString("Peer2Peer.invite_failed"), 1);
    }

    /*
     * WARNING - void declaration
     */
    public void initComponents(P2PPlayer p2PPlayer, final PendingPeerManager pendingPeerManager) {
        void var4_7;
        if (addressConfig == null) {
            addressConfig = new StringArrayConfigurer(ADDRESS_PREF, null);
            Prefs.getGlobalPrefs().addOption(null, addressConfig);
        }
        String[] stringArray = addressConfig.getStringArray();
        this.addressBook = new DefaultListModel();
        this.addressList = new JList(this.addressBook);
        for (String string : stringArray) {
            this.addToList(new Entry(string));
        }
        Object var4_5 = null;
        if (GameModule.getGameModule() != null) {
            JFrame jFrame = GameModule.getGameModule().getFrame();
        }
        this.frame = new JDialog((Frame)var4_7, Resources.getString("Peer2Peer.direct_connection"));
        this.frame.setDefaultCloseOperation(1);
        this.frame.setLayout(new MigLayout());
        this.frame.add((Component)new WTextArea(Resources.getString("Peer2Peer.other_players_address")), "growx, span 4,wrap");
        JScrollPane jScrollPane = new JScrollPane(this.addressList);
        this.frame.add((Component)jScrollPane, "span 4, grow, push, w 300, h 400, wrap");
        this.invitePeerButton = new JButton(Resources.getString("Peer2Peer.connect"));
        this.invitePeerButton.setToolTipText(Resources.getString("Peer2Peer.invite_button_tooltip"));
        this.invitePeerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectPeerPool.this.invite(pendingPeerManager);
            }
        });
        this.frame.add((Component)this.invitePeerButton, "growx, push");
        this.addButton = new JButton(Resources.getString("General.add"));
        this.addButton.setToolTipText(Resources.getString("Peer2Peer.add_button_tooltip"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectPeerPool.this.addEntry();
            }
        });
        this.frame.add((Component)this.addButton, "growx, push");
        this.editButton = new JButton(Resources.getString("General.edit"));
        this.editButton.setToolTipText(Resources.getString("Peer2Peer.edit_button_tooltip"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectPeerPool.this.editEntry();
            }
        });
        this.frame.add((Component)this.editButton, "growx, push");
        this.removeButton = new JButton(Resources.getString("General.remove"));
        this.removeButton.setToolTipText(Resources.getString("Peer2Peer.remove_button_tooltip"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectPeerPool.this.removeEntries();
            }
        });
        this.frame.add((Component)this.removeButton, "growx, push, wrap");
        this.frame.pack();
        this.frame.setLocationRelativeTo((Component)var4_7);
    }

    protected void invite(PendingPeerManager pendingPeerManager) {
        int[] nArray = this.addressList.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            Entry entry = (Entry)this.addressBook.getElementAt(nArray[i]);
            PeerInfo peerInfo = PeerInfo.deFormat(entry.getAddress() + ":" + entry.getPort() + " " + entry.getDescription());
            if (peerInfo != null) {
                pendingPeerManager.addNewPeer(peerInfo);
                GameModule.getGameModule().warn(Resources.getString("Chat.invite_sent", entry.toString()));
                continue;
            }
            JOptionPane.showMessageDialog(this.frame, Resources.getString("Peer2Peer.invalid_format"));
        }
    }

    protected void addEntry() {
        Entry entry = new Entry();
        if (entry.edit() && !this.addressBook.contains(entry)) {
            this.addToList(entry);
            this.saveAddressBook();
        }
    }

    protected void addToList(Entry entry) {
        boolean bl = false;
        for (int i = 0; i < this.addressBook.getSize() && !bl; ++i) {
            if (entry.compareTo((Entry)this.addressBook.getElementAt(i)) >= 0) continue;
            this.addressBook.insertElementAt(entry, i);
            bl = true;
        }
        if (!bl) {
            this.addressBook.addElement(entry);
        }
    }

    protected void editEntry() {
        Entry entry;
        int n = this.addressList.getSelectedIndex();
        if (n >= 0 && (entry = (Entry)this.addressBook.getElementAt(n)).edit()) {
            this.addressBook.removeElementAt(n);
            this.addToList(entry);
            this.saveAddressBook();
        }
    }

    protected void removeEntries() {
        int[] nArray = this.addressList.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        Entry[] entryArray = new Entry[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            entryArray[i] = (Entry)this.addressBook.getElementAt(nArray[i]);
        }
        JPanel jPanel = new JPanel(new MigLayout("", "10[][]10"));
        String string = entryArray.length == 1 ? Resources.getString("Peer2Peer.remove_entry") : Resources.getString("Peer2Peer.remove_entries", entryArray.length);
        jPanel.add((Component)new JLabel(string), "align center, wrap");
        jPanel.add((Component)new JLabel(), "wrap");
        for (int i = 0; i < entryArray.length; ++i) {
            jPanel.add((Component)new JLabel(entryArray[i].toString()), "wrap");
        }
        Integer n = (Integer)Dialogs.showDialog(null, Resources.getString("Peer2Peer.remove_entry"), jPanel, 3, null, 2, null, null, null, null);
        if (n != null && n == 0) {
            for (int i = 0; i < entryArray.length; ++i) {
                this.addressBook.removeElement(entryArray[i]);
            }
            this.saveAddressBook();
        }
    }

    protected void saveAddressBook() {
        String[] stringArray = new String[this.addressBook.size()];
        int n = 0;
        Enumeration enumeration = this.addressBook.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = ((Entry)enumeration.nextElement()).encode();
        }
        addressConfig.setValue(stringArray);
    }

    public void initializeControls(ChatServerControls chatServerControls) {
        chatServerControls.getToolbar().add(this.inviteButton);
    }

    public void uninitializeControls(ChatServerControls chatServerControls) {
        chatServerControls.getToolbar().remove(this.inviteButton);
        chatServerControls.getToolbar().repaint();
    }

    private class WTextArea
    extends JTextArea {
        private static final long serialVersionUID = 1L;

        public WTextArea(String string) {
            super(string);
            this.setEditable(false);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setBackground(UIManager.getColor("OptionPane.background"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry
    implements Comparable<Entry> {
        String description;
        String address;
        String port;
        JTextField descriptionField;
        JTextField addressField;
        JTextField portField;

        public Entry() {
            this("", "", "5050", "");
        }

        public Entry(String string, String string2, String string3, String string4) {
            this.description = string;
            this.address = string2;
            this.port = string3;
        }

        public Entry(String string) {
            this.decode(string);
        }

        public String getDescription() {
            return this.description;
        }

        public String getAddress() {
            return this.address;
        }

        public String getPort() {
            return this.port;
        }

        public String toString() {
            return this.description + " [" + this.address + ":" + this.port;
        }

        private void decode(String string) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '|');
            this.description = decoder.nextToken("");
            this.address = decoder.nextToken("");
            this.port = decoder.nextToken("5050");
        }

        public String encode() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder('|');
            sequenceEncoder.append(this.description);
            sequenceEncoder.append(this.address);
            sequenceEncoder.append(this.port);
            return sequenceEncoder.getValue();
        }

        @Override
        public int compareTo(Entry entry) {
            return this.toString().compareTo(entry.toString());
        }

        public boolean edit() {
            this.descriptionField = new JTextField(this.description);
            this.addressField = new JTextField(this.address);
            this.portField = new JTextField(this.port);
            JPanel jPanel = new JPanel(new MigLayout("", "[align right]rel[]", ""));
            jPanel.add(new JLabel(Resources.getString("Editor.description_label")));
            jPanel.add((Component)this.descriptionField, "wrap, grow, push");
            jPanel.add(new JLabel(Resources.getString("Chat.ip_address")));
            jPanel.add((Component)this.addressField, "wrap, grow, push");
            jPanel.add(new JLabel(Resources.getString("ServerAddressBook.port")));
            jPanel.add((Component)this.portField, "wrap, grow, push");
            Integer n = (Integer)Dialogs.showDialog(null, Resources.getString("Peer2Peer.add_peer_connection"), jPanel, -1, null, 2, null, null, null, null);
            if (n != null && n == 0) {
                this.description = this.descriptionField.getText();
                this.address = this.addressField.getText();
                this.port = this.portField.getText();
                return true;
            }
            return false;
        }
    }
}

