/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class FontConfigurer
extends Configurer {
    private JPanel p;
    private JComboBox size;
    private JComboBox family;
    private int[] sizes;

    public FontConfigurer(String string, String string2) {
        this(string, string2, new Font("SansSerif", 0, 12));
    }

    public FontConfigurer(String string, String string2, Font font) {
        this(string, string2, font, new int[]{9, 10, 11, 12, 15, 18});
    }

    public FontConfigurer(String string, String string2, Font font, int[] nArray) {
        super(string, string2, font);
        this.sizes = nArray;
    }

    public String getValueString() {
        return FontConfigurer.encode((Font)this.value);
    }

    public void setValue(String string) {
        this.setValue(FontConfigurer.decode(string));
    }

    public Component getControls() {
        if (this.p == null) {
            int n;
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 0));
            this.p.add(new JLabel(this.name));
            this.family = new JComboBox();
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            for (n = 0; n < stringArray.length; ++n) {
                this.family.addItem(stringArray[n]);
            }
            this.family.setSelectedItem(this.value == null ? "SansSerif" : ((Font)this.value).getFamily());
            this.family.setMaximumSize(new Dimension(this.family.getMaximumSize().width, this.family.getPreferredSize().height));
            this.p.add(this.family);
            this.size = new JComboBox();
            for (n = 0; n < this.sizes.length; ++n) {
                this.size.addItem(this.sizes[n] + "");
            }
            this.size.setSelectedItem(this.value == null ? this.sizes[this.sizes.length / 2] + "" : ((Font)this.value).getSize() + "");
            this.size.setMaximumSize(new Dimension(this.size.getMaximumSize().width, this.size.getPreferredSize().height));
            this.p.add(this.size);
            ItemListener itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    FontConfigurer.this.setValue(new Font((String)FontConfigurer.this.family.getSelectedItem(), 0, Integer.parseInt((String)FontConfigurer.this.size.getSelectedItem())));
                }
            };
            this.size.addItemListener(itemListener);
            this.family.addItemListener(itemListener);
        }
        return this.p;
    }

    public static Font decode(String string) {
        int n = string.indexOf(44);
        return new Font(string.substring(0, n), 0, Integer.parseInt(string.substring(n + 1)));
    }

    public static String encode(Font font) {
        return font.getName() + "," + font.getSize();
    }

    public static void main(String[] stringArray) {
        final JFrame jFrame = new JFrame();
        jFrame.setLayout(new BoxLayout(jFrame.getContentPane(), 1));
        FontConfigurer fontConfigurer = new FontConfigurer("a", "Font: ", null, new int[]{4, 5, 6, 13});
        jFrame.add(fontConfigurer.getControls());
        final JTextArea jTextArea = new JTextArea();
        jTextArea.setText("The quick brown fox jumps over the lazy dog.");
        jFrame.add(new ScrollPane(jTextArea));
        fontConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Font font = (Font)propertyChangeEvent.getNewValue();
                FontConfigurer fontConfigurer = new FontConfigurer(null, null, font);
                fontConfigurer.setValue(fontConfigurer.getValueString());
                font = (Font)fontConfigurer.getValue();
                jTextArea.setFont(font);
                jFrame.pack();
            }
        });
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

