/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.Region;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ChooseComponentDialog;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class SendToLocation
extends Decorator
implements TranslatablePiece {
    public static final String ID = "sendto;";
    private static final String _0 = "0";
    public static final String BACK_MAP = "backMap";
    public static final String BACK_POINT = "backPoint";
    protected static final String DEST_GRIDLOCATION = "Grid location on selected Map";
    protected static final String DEST_LOCATION = "Location on selected Map";
    protected static final String DEST_ZONE = "Zone on selected Map";
    protected static final String DEST_REGION = "Region on selected Map";
    protected static final String DEST_COUNTER = "Another counter, selected by properties";
    protected static final String[] DEST_OPTIONS = new String[]{"Grid location on selected Map", "Location on selected Map", "Zone on selected Map", "Region on selected Map", "Another counter, selected by properties"};
    protected KeyCommand[] command;
    protected String commandName;
    protected String backCommandName;
    protected NamedKeyStroke key;
    protected NamedKeyStroke backKey;
    protected FormattedString mapId = new FormattedString("");
    protected FormattedString boardName = new FormattedString("");
    protected FormattedString x = new FormattedString("");
    protected FormattedString xIndex = new FormattedString("");
    protected FormattedString xOffset = new FormattedString("");
    protected FormattedString y = new FormattedString("");
    protected FormattedString yIndex = new FormattedString("");
    protected FormattedString yOffset = new FormattedString("");
    protected FormattedString gridLocation = new FormattedString("");
    protected KeyCommand sendCommand;
    protected KeyCommand backCommand;
    protected String description;
    protected String destination;
    protected FormattedString zone = new FormattedString("");
    protected FormattedString region = new FormattedString("");
    protected PropertyExpression propertyFilter = new PropertyExpression("");
    private Map map;

    public SendToLocation() {
        this("sendto;;;;;0;0;;;", null);
    }

    public SendToLocation(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.commandName = decoder.nextToken("");
        this.key = decoder.nextNamedKeyStroke(null);
        this.mapId.setFormat(decoder.nextToken(""));
        this.boardName.setFormat(decoder.nextToken(""));
        this.x.setFormat(decoder.nextToken(_0));
        this.y.setFormat(decoder.nextToken(_0));
        this.backCommandName = decoder.nextToken("");
        this.backKey = decoder.nextNamedKeyStroke(null);
        this.xIndex.setFormat(decoder.nextToken(_0));
        this.yIndex.setFormat(decoder.nextToken(_0));
        this.xOffset.setFormat(decoder.nextToken(_0));
        this.yOffset.setFormat(decoder.nextToken(_0));
        this.description = decoder.nextToken("");
        this.destination = decoder.nextToken(DEST_LOCATION.substring(0, 1));
        if (this.destination.length() == 0) {
            this.destination = DEST_LOCATION.substring(0, 1);
        }
        this.zone.setFormat(decoder.nextToken(""));
        this.region.setFormat(decoder.nextToken(""));
        this.propertyFilter.setExpression(decoder.nextToken(""));
        this.gridLocation.setFormat(decoder.nextToken(""));
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.commandName).append(this.key).append(this.mapId.getFormat()).append(this.boardName.getFormat()).append(this.x.getFormat()).append(this.y.getFormat()).append(this.backCommandName).append(this.backKey).append(this.xIndex.getFormat()).append(this.yIndex.getFormat()).append(this.xOffset.getFormat()).append(this.yOffset.getFormat()).append(this.description).append(this.destination).append(this.zone.getFormat()).append(this.region.getFormat()).append(this.propertyFilter.getExpression()).append(this.gridLocation.getFormat());
        return ID + sequenceEncoder.getValue();
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.command == null) {
            this.sendCommand = new KeyCommand(this.commandName, this.key, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.backCommand = new KeyCommand(this.backCommandName, this.backKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            ArrayList arrayList = new ArrayList();
            if (this.commandName.length() > 0 && this.key != null && !this.key.isNull()) {
                arrayList.add(this.sendCommand);
            }
            if (this.backCommandName.length() > 0 && this.backKey != null && !this.backKey.isNull()) {
                arrayList.add(this.backCommand);
            }
            this.command = arrayList.toArray(new KeyCommand[arrayList.size()]);
        }
        for (KeyCommand keyCommand : this.command) {
            if (keyCommand.getName().equals(this.backCommandName)) {
                keyCommand.setEnabled(this.getMap() != null && this.getProperty(BACK_MAP) != null && this.getProperty(BACK_POINT) != null);
                continue;
            }
            Point point = this.getSendLocation();
            keyCommand.setEnabled(this.getMap() != null && point != null && (this.map != this.getMap() || !point.equals(this.getPosition())));
        }
        return this.command;
    }

    private void LogBadGridLocation(Point point) {
        String string = "* " + Decorator.getOutermost(this).getName();
        string = this.getMap() == null ? string + "getMap is null" : (point == null ? string + "p is null" : string + "getMap: " + this.getMap().getMapName() + "; p: (" + point.x + "," + point.y + "; Position: (" + this.getPosition().x + "," + this.getPosition().y + "); map: " + this.map.getMapName() + ";");
        new Chatter.DisplayText(GameModule.getGameModule().getChatter(), string).execute();
    }

    public String myGetState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        Map map = (Map)this.getProperty(BACK_MAP);
        if (map != null) {
            sequenceEncoder.append(map.getIdentifier());
        } else {
            sequenceEncoder.append("");
        }
        Point point = (Point)this.getProperty(BACK_POINT);
        if (point != null) {
            sequenceEncoder.append(point.x).append(point.y);
        } else {
            sequenceEncoder.append("").append("");
        }
        return sequenceEncoder.getValue();
    }

    private Point getSendLocation() {
        GamePiece gamePiece = Decorator.getOutermost(this);
        this.map = null;
        Point point = null;
        if (this.destination.equals(DEST_COUNTER.substring(0, 1))) {
            GamePiece gamePiece2 = null;
            for (GamePiece gamePiece3 : GameModule.getGameModule().getGameState().getAllPieces()) {
                if (gamePiece3 instanceof Stack) {
                    Stack stack = (Stack)gamePiece3;
                    for (int i = 0; !(i >= stack.getPieceCount() || this.propertyFilter.accept(this, stack.getPieceAt(i)) && (gamePiece2 = stack.getPieceAt(i)) != null); ++i) {
                    }
                } else if (this.propertyFilter.accept(this, gamePiece3)) {
                    gamePiece2 = gamePiece3;
                }
                if (gamePiece2 == null) continue;
                break;
            }
            if (gamePiece2 != null) {
                this.map = gamePiece2.getMap();
                if (this.map != null) {
                    point = gamePiece2.getPosition();
                }
            }
        } else {
            this.map = Map.getMapById(this.mapId.getText(gamePiece));
            if (this.map == null) {
                this.map = this.getMap();
            }
            if (this.map != null) {
                switch (this.destination.charAt(0)) {
                    case 'G': {
                        Board board = this.map.getBoardByName(this.boardName.getText(gamePiece));
                        if (board == null) break;
                        try {
                            point = board.getGrid().getLocation(this.gridLocation.getText(gamePiece));
                            if (point == null) break;
                            point.translate(board.bounds().x, board.bounds().y);
                        }
                        catch (MapGrid.BadCoords badCoords) {
                            this.LogBadGridLocation(point);
                            SendToLocation.reportDataError(this, Resources.getString("Error.not_found", "Grid Location"), this.map.getMapName());
                        }
                        break;
                    }
                    case 'L': {
                        int n = this.x.getTextAsInt((PropertySource)gamePiece, "Xlocation", this);
                        int n2 = this.y.getTextAsInt((PropertySource)gamePiece, "YLocation", this);
                        point = new Point(n, n2);
                        Board board = this.map.getBoardByName(this.boardName.getText(gamePiece));
                        if (board == null || point == null) break;
                        point.translate(board.bounds().x, board.bounds().y);
                        break;
                    }
                    case 'Z': {
                        String string = this.zone.getText(gamePiece);
                        Zone zone = this.map.findZone(string);
                        if (zone == null) {
                            SendToLocation.reportDataError(this, Resources.getString("Error.not_found", "Zone"), this.zone.debugInfo(string, "Zone"));
                            break;
                        }
                        Rectangle rectangle = zone.getBounds();
                        Rectangle rectangle2 = zone.getBoard().bounds();
                        point = new Point(rectangle2.x + rectangle.x + rectangle.width / 2, rectangle2.y + rectangle.y + rectangle.height / 2);
                        break;
                    }
                    case 'R': {
                        String string = this.region.getText(gamePiece);
                        Region region = this.map.findRegion(string);
                        if (region == null) {
                            SendToLocation.reportDataError(this, Resources.getString("Error.not_found", "Region"), this.region.debugInfo(string, "Region"));
                            break;
                        }
                        Rectangle rectangle = region.getBoard().bounds();
                        if (region == null) break;
                        point = new Point(region.getOrigin().x + rectangle.x, region.getOrigin().y + rectangle.y);
                    }
                }
            }
        }
        if (point != null && this.destination.charAt(0) != 'G') {
            point = this.offsetDestination(point.x, point.y, gamePiece);
        }
        return point;
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        Command command = null;
        this.myGetKeyCommands();
        if (this.sendCommand.matches(keyStroke)) {
            GamePiece gamePiece = Decorator.getOutermost(this);
            Stack stack = gamePiece.getParent();
            Point point = this.getSendLocation();
            if (this.map != null && point != null) {
                if (this.map == this.getMap() && point.equals(this.getPosition())) {
                    return null;
                }
                this.setProperty(BACK_MAP, this.getMap());
                this.setProperty(BACK_POINT, this.getPosition());
                this.setOldProperties();
                if (!Boolean.TRUE.equals(gamePiece.getProperty("IgnoreGrid"))) {
                    point = this.map.snapTo(point);
                }
                command = this.map.placeOrMerge(gamePiece, point);
                if (this.map.getMoveKey() != null) {
                    command.append(gamePiece.keyEvent(this.map.getMoveKey()));
                }
                if (stack != null) {
                    command.append(stack.pieceRemoved(gamePiece));
                }
            }
        } else if (this.backCommand.matches(keyStroke)) {
            GamePiece gamePiece = Decorator.getOutermost(this);
            Map map = (Map)this.getProperty(BACK_MAP);
            Point point = (Point)this.getProperty(BACK_POINT);
            if (map != null && point != null) {
                this.setOldProperties();
                command = map.placeOrMerge(gamePiece, point);
                ChangeTracker changeTracker = new ChangeTracker(this);
                this.setProperty(BACK_MAP, null);
                this.setProperty(BACK_POINT, null);
                command.append(changeTracker.getChangeCommand());
                if (map.getMoveKey() != null) {
                    command.append(gamePiece.keyEvent(map.getMoveKey()));
                }
            }
            this.setProperty(BACK_MAP, null);
            this.setProperty(BACK_POINT, null);
        }
        return command;
    }

    protected Point offsetDestination(int n, int n2, GamePiece gamePiece) {
        int n3 = n + this.parse("xIndex", this.xIndex, gamePiece) * this.parse("xOffset", this.xOffset, gamePiece);
        int n4 = n2 + this.parse("yIndex", this.yIndex, gamePiece) * this.parse("yOffset", this.yOffset, gamePiece);
        return new Point(n3, n4);
    }

    private int parse(String string, FormattedString formattedString, GamePiece gamePiece) {
        int n = 0;
        String string2 = formattedString.getText((PropertySource)gamePiece, _0);
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            SendToLocation.reportDataError(this, Resources.getString("Error.non_number_error"), formattedString.debugInfo(string2, string), numberFormatException);
        }
        return n;
    }

    public void mySetState(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        String string2 = decoder.nextToken("");
        if (string2.length() > 0) {
            this.setProperty(BACK_MAP, Map.getMapById(string2));
        }
        String string3 = decoder.nextToken("");
        String string4 = decoder.nextToken("");
        if (string3.length() > 0 && string4.length() > 0) {
            try {
                this.setProperty(BACK_POINT, new Point(Integer.parseInt(string3), Integer.parseInt(string4)));
            }
            catch (NumberFormatException numberFormatException) {
                SendToLocation.reportDataError(this, Resources.getString("Error.non_number_error"), "Back Point=(" + string3 + "," + string4 + ")", numberFormatException);
            }
        }
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public String getDescription() {
        String string = "Send to Location";
        if (this.description.length() > 0) {
            string = string + " - " + this.description;
        }
        return string;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SendToLocation.htm");
    }

    public PieceI18nData getI18nData() {
        return this.getI18nData(new String[]{this.commandName, this.backCommandName}, new String[]{this.getCommandDescription(this.description, "Send command"), this.getCommandDescription(this.description, "Back command")});
    }

    public static class Ed
    implements PieceEditor {
        protected StringConfigurer nameInput;
        protected StringConfigurer backNameInput;
        protected NamedHotKeyConfigurer keyInput;
        protected NamedHotKeyConfigurer backKeyInput;
        protected FormattedStringConfigurer mapIdInput;
        protected FormattedStringConfigurer boardNameInput;
        protected FormattedStringConfigurer xInput;
        protected FormattedStringConfigurer yInput;
        protected BooleanConfigurer advancedInput;
        protected FormattedStringConfigurer xIndexInput;
        protected FormattedStringConfigurer xOffsetInput;
        protected FormattedStringConfigurer yIndexInput;
        protected FormattedStringConfigurer yOffsetInput;
        protected StringConfigurer descInput;
        protected StringEnumConfigurer destInput;
        protected PropertyExpressionConfigurer propertyInput;
        protected FormattedStringConfigurer zoneInput;
        protected FormattedStringConfigurer regionInput;
        protected JPanel controls = new JPanel();
        protected Box mapControls;
        protected Box boardControls;
        protected Box advancedControls;
        protected StringConfigurer gridLocationInput;

        public Ed(SendToLocation sendToLocation) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.descInput = new StringConfigurer(null, "Description:  ", sendToLocation.description);
            this.controls.add(this.descInput.getControls());
            this.nameInput = new StringConfigurer(null, "Command name:  ", sendToLocation.commandName);
            this.controls.add(this.nameInput.getControls());
            this.keyInput = new NamedHotKeyConfigurer(null, "Keyboard Command:  ", sendToLocation.key);
            this.controls.add(this.keyInput.getControls());
            this.backNameInput = new StringConfigurer(null, "Send Back Command name:  ", sendToLocation.backCommandName);
            this.controls.add(this.backNameInput.getControls());
            this.backKeyInput = new NamedHotKeyConfigurer(null, "Send Back Keyboard Command:  ", sendToLocation.backKey);
            this.controls.add(this.backKeyInput.getControls());
            this.destInput = new StringEnumConfigurer(null, "Destination:  ", DEST_OPTIONS);
            this.destInput.setValue(SendToLocation.DEST_LOCATION);
            for (int i = 0; i < DEST_OPTIONS.length; ++i) {
                if (!DEST_OPTIONS[i].substring(0, 1).equals(sendToLocation.destination)) continue;
                this.destInput.setValue(DEST_OPTIONS[i]);
            }
            this.destInput.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Ed.this.updateVisibility();
                }
            });
            this.controls.add(this.destInput.getControls());
            this.mapControls = Box.createHorizontalBox();
            this.mapIdInput = new FormattedExpressionConfigurer(null, "Map:  ", sendToLocation.mapId.getFormat(), sendToLocation);
            this.mapControls.add(this.mapIdInput.getControls());
            JButton jButton = new JButton("Select");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.this.selectMap();
                }
            });
            this.mapControls.add(jButton);
            JButton jButton2 = new JButton("Clear");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.this.clearMap();
                }
            });
            this.mapControls.add(jButton2);
            this.controls.add(this.mapControls);
            this.boardControls = Box.createHorizontalBox();
            this.boardNameInput = new FormattedExpressionConfigurer(null, "Board:  ", sendToLocation.boardName.getFormat(), sendToLocation);
            this.boardControls.add(this.boardNameInput.getControls());
            jButton = new JButton("Select");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.this.selectBoard();
                }
            });
            jButton2 = new JButton("Clear");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.this.clearBoard();
                }
            });
            this.boardControls.add(jButton);
            this.boardControls.add(jButton2);
            this.controls.add(this.boardControls);
            this.xInput = new FormattedExpressionConfigurer(null, "X Position:  ", sendToLocation.x.getFormat(), sendToLocation);
            this.controls.add(this.xInput.getControls());
            this.yInput = new FormattedExpressionConfigurer(null, "Y Position:  ", sendToLocation.y.getFormat(), sendToLocation);
            this.controls.add(this.yInput.getControls());
            this.zoneInput = new FormattedExpressionConfigurer(null, "Zone Name:  ", sendToLocation.zone.getFormat(), sendToLocation);
            this.controls.add(this.zoneInput.getControls());
            this.regionInput = new FormattedExpressionConfigurer(null, "Region Name:  ", sendToLocation.region.getFormat(), sendToLocation);
            this.controls.add(this.regionInput.getControls());
            this.propertyInput = new PropertyExpressionConfigurer(null, "Property Match:  ", sendToLocation.propertyFilter);
            this.controls.add(this.propertyInput.getControls());
            this.gridLocationInput = new StringConfigurer(null, "Grid Location:  ", sendToLocation.gridLocation.getFormat());
            this.controls.add(this.gridLocationInput.getControls());
            this.advancedInput = new BooleanConfigurer(null, "Advanced Options", false);
            this.advancedInput.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Ed.this.updateVisibility();
                }
            });
            this.controls.add(this.advancedInput.getControls());
            this.advancedControls = Box.createHorizontalBox();
            this.xIndexInput = new FormattedExpressionConfigurer(null, "Additional X offset:  ", sendToLocation.xIndex.getFormat(), sendToLocation);
            this.advancedControls.add(this.xIndexInput.getControls());
            this.xOffsetInput = new FormattedExpressionConfigurer(null, " times ", sendToLocation.xOffset.getFormat(), sendToLocation);
            this.advancedControls.add(this.xOffsetInput.getControls());
            this.controls.add(this.advancedControls);
            this.advancedControls = Box.createHorizontalBox();
            this.yIndexInput = new FormattedExpressionConfigurer(null, "Additional Y offset:  ", sendToLocation.yIndex.getFormat(), sendToLocation);
            this.advancedControls.add(this.yIndexInput.getControls());
            this.yOffsetInput = new FormattedExpressionConfigurer(null, " times ", sendToLocation.yOffset.getFormat(), sendToLocation);
            this.advancedControls.add(this.yOffsetInput.getControls());
            this.controls.add(this.advancedControls);
            this.updateVisibility();
        }

        private void updateVisibility() {
            this.advancedInput.getControls().setVisible(!this.destInput.getValue().equals(SendToLocation.DEST_GRIDLOCATION));
            boolean bl = this.advancedInput.booleanValue() != false && this.advancedInput.getControls().isVisible();
            this.xIndexInput.getControls().setVisible(bl);
            this.xOffsetInput.getControls().setVisible(bl);
            this.yIndexInput.getControls().setVisible(bl);
            this.yOffsetInput.getControls().setVisible(bl);
            String string = this.destInput.getValueString();
            this.xInput.getControls().setVisible(string.equals(SendToLocation.DEST_LOCATION));
            this.yInput.getControls().setVisible(string.equals(SendToLocation.DEST_LOCATION));
            this.mapControls.setVisible(!string.equals(SendToLocation.DEST_COUNTER));
            this.boardControls.setVisible(string.equals(SendToLocation.DEST_LOCATION) || string.equals(SendToLocation.DEST_GRIDLOCATION));
            this.zoneInput.getControls().setVisible(string.equals(SendToLocation.DEST_ZONE));
            this.regionInput.getControls().setVisible(string.equals(SendToLocation.DEST_REGION));
            this.propertyInput.getControls().setVisible(string.equals(SendToLocation.DEST_COUNTER));
            this.gridLocationInput.getControls().setVisible(string.equals(SendToLocation.DEST_GRIDLOCATION));
            Window window = SwingUtilities.getWindowAncestor(this.controls);
            if (window != null) {
                window.pack();
            }
        }

        private void clearBoard() {
            this.boardNameInput.setValue("");
        }

        private void clearMap() {
            this.mapIdInput.setValue("");
        }

        private void selectBoard() {
            ChooseComponentDialog chooseComponentDialog = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.controls), Board.class);
            chooseComponentDialog.setVisible(true);
            if (chooseComponentDialog.getTarget() != null) {
                Board board = (Board)chooseComponentDialog.getTarget();
                this.boardNameInput.setValue(board.getName());
            }
        }

        private void selectMap() {
            ChooseComponentDialog chooseComponentDialog = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.controls), Map.class);
            chooseComponentDialog.setVisible(true);
            if (chooseComponentDialog.getTarget() != null) {
                Map map = (Map)chooseComponentDialog.getTarget();
                this.mapIdInput.setValue(map.getMapName());
            }
        }

        public Component getControls() {
            return this.controls;
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.nameInput.getValueString()).append(this.keyInput.getValueString()).append(this.mapIdInput.getValueString()).append(this.boardNameInput.getValueString()).append(this.xInput.getValueString()).append(this.yInput.getValueString()).append(this.backNameInput.getValueString()).append(this.backKeyInput.getValueString()).append(this.xIndexInput.getValueString()).append(this.yIndexInput.getValueString()).append(this.xOffsetInput.getValueString()).append(this.yOffsetInput.getValueString()).append(this.descInput.getValueString()).append(this.destInput.getValueString().charAt(0)).append(this.zoneInput.getValueString()).append(this.regionInput.getValueString()).append(this.propertyInput.getValueString()).append(this.gridLocationInput.getValueString());
            return SendToLocation.ID + sequenceEncoder.getValue();
        }

        public String getState() {
            return "";
        }
    }
}

