/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GameModuleAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(GameModuleAction.class);
    protected Component comp;
    protected boolean actionCancelled;
    protected List<Runnable> actions = new ArrayList<Runnable>();

    public GameModuleAction(String string, Component component) {
        super(string);
        this.comp = component;
    }

    protected String getMessage(Exception exception) {
        String string = exception.getClass().getSimpleName();
        if (exception.getMessage() != null) {
            string = string + ":  " + exception.getMessage();
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.performAction(actionEvent);
            if (!this.actionCancelled) {
                this.runActions();
            }
        }
        catch (Exception exception) {
            this.reportError(exception);
        }
    }

    protected abstract void performAction(ActionEvent var1) throws Exception;

    protected void reportError(Exception exception) {
        logger.error("", (Throwable)exception);
        JOptionPane.showMessageDialog(this.comp, this.getMessage(exception));
    }

    public void addAction(Runnable runnable) {
        this.actions.add(runnable);
    }

    protected void runActions() {
        for (Runnable runnable : this.actions) {
            runnable.run();
        }
    }
}

