/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.build.GameModule;
import VASSAL.chat.LockableChatServerConnection;
import VASSAL.chat.LockableRoom;
import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.chat.PlayerStatus;
import VASSAL.chat.PrivateChatEncoder;
import VASSAL.chat.PrivateChatManager;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.SimpleStatus;
import VASSAL.chat.SoundEncoder;
import VASSAL.chat.SynchEncoder;
import VASSAL.chat.jabber.AccountInfo;
import VASSAL.chat.jabber.JabberPlayer;
import VASSAL.chat.jabber.JabberRoom;
import VASSAL.chat.jabber.LockableJabberRoomControls;
import VASSAL.chat.jabber.PacketProcessor;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.chat.ui.InviteAction;
import VASSAL.chat.ui.KickAction;
import VASSAL.chat.ui.LockableRoomTreeRenderer;
import VASSAL.chat.ui.PrivateMessageAction;
import VASSAL.chat.ui.RoomInteractionControlsInitializer;
import VASSAL.chat.ui.SendSoundAction;
import VASSAL.chat.ui.ShowProfileAction;
import VASSAL.chat.ui.SimpleStatusControlsInitializer;
import VASSAL.chat.ui.SynchAction;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.io.DeobfuscatingInputStream;
import VASSAL.tools.io.FastByteArrayOutputStream;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.ObfuscatingOutputStream;
import VASSAL.tools.swing.Dialogs;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.muc.DefaultParticipantStatusListener;
import org.jivesoftware.smackx.muc.DefaultUserStatusListener;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.packet.MUCUser;
import org.jivesoftware.smackx.packet.VCard;

public class JabberClient
implements LockableChatServerConnection,
PacketListener,
ServerStatus,
ChatControlsInitializer,
PlayerEncoder {
    private static final String QUERY_ROOMS = "http://jabber.org/protocol/muc#rooms";
    private static final String QUERY_USER = "http://jabber.org/protocol/muc#user";
    private static final String INVITE = "Invite";
    private static final String REAL_NAME = "realName";
    public static final String JID_RESOURCE = "/VASSAL";
    public static final String ROOM_CONFIG = "roomConfig";
    public static final String ROOM_JID = "roomJid";
    public static final String ROOM_NAME = "roomName";
    public static final String OWNER = "owner";
    private MessageBoard msgSvr;
    private XMPPConnection conn;
    private String host;
    private int port = 5222;
    private PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private JabberPlayer me;
    private String conferenceService;
    private MonitorRooms monitor;
    private CommandEncoder encoder;
    private final JabberRoom defaultRoom;
    private MultiUserChat currentChat;
    private AccountInfo account;
    private SynchEncoder synchEncoder;
    protected SoundEncoder soundEncoder;
    protected PrivateChatEncoder privateChatEncoder;
    protected RoomInteractionControlsInitializer roomControls;
    protected SimpleStatusControlsInitializer playerStatusControls;
    protected JabberPlayer.Manager playerMgr = new JabberPlayer.Manager();
    protected JabberRoom.Manager roomMgr = new JabberRoom.Manager();
    protected PropertyChangeListener idChangeListener;
    protected UserStatusListener kickListener;
    protected InvitationListener inviteListener;
    protected ParticipantStatusListener userListener;

    public JabberClient(CommandEncoder commandEncoder, String string, int n, AccountInfo accountInfo) {
        XMPPConnection.DEBUG_ENABLED = "true".equals(System.getProperty("debugJabber"));
        this.host = string;
        this.conferenceService = "conference." + string;
        this.encoder = commandEncoder;
        this.account = accountInfo;
        this.defaultRoom = this.roomMgr.getRoomByName(this, "Main Room");
        this.roomControls = new LockableJabberRoomControls(this);
        this.roomControls.addPlayerActionFactory(ShowProfileAction.factory());
        this.roomControls.addPlayerActionFactory(SynchAction.factory(this));
        PrivateChatManager privateChatManager = new PrivateChatManager(this);
        this.roomControls.addPlayerActionFactory(PrivateMessageAction.factory(this, privateChatManager));
        this.roomControls.addPlayerActionFactory(SendSoundAction.factory(this, Resources.getString("Chat.send_wakeup"), "wakeUpSound", "phone1.wav"));
        this.roomControls.addPlayerActionFactory(InviteAction.factory(this));
        this.roomControls.addPlayerActionFactory(KickAction.factory(this));
        this.playerStatusControls = new SimpleStatusControlsInitializer(this);
        this.synchEncoder = new SynchEncoder(this, this);
        this.soundEncoder = new SoundEncoder(this);
        this.privateChatEncoder = new PrivateChatEncoder(this, privateChatManager);
        this.idChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (JabberClient.this.me != null) {
                    SimpleStatus simpleStatus = (SimpleStatus)JabberClient.this.me.getStatus();
                    simpleStatus.updateStatus();
                    JabberClient.this.me.setStatus(simpleStatus);
                    JabberClient.this.me.setName((String)GameModule.getGameModule().getPrefs().getValue("RealName"));
                }
                if (JabberClient.this.monitor != null) {
                    JabberClient.this.monitor.sendStatus(JabberClient.this.me);
                }
            }
        };
        this.kickListener = new DefaultUserStatusListener(){

            public void kicked(String string, String string2) {
                JabberClient.this.fireStatus(Resources.getString("Chat.kicked", JabberClient.this.getRoom().getName()));
                JabberClient.this.setRoom(JabberClient.this.defaultRoom);
            }
        };
        this.inviteListener = new InvitationListener(){

            public void invitationReceived(XMPPConnection xMPPConnection, String string, String string2, String string3, String string4, Message message) {
                if (JabberClient.INVITE.equals(string3)) {
                    String string5 = string2.split("@")[0];
                    JabberPlayer jabberPlayer = JabberClient.this.playerMgr.getPlayer(string2 + JabberClient.JID_RESOURCE);
                    String string6 = jabberPlayer.getName() + "(" + string5 + ")";
                    String string7 = JabberClient.this.roomMgr.getRoomByJID(JabberClient.this, string).getName();
                    int n = Dialogs.showConfirmDialog(GameModule.getGameModule().getFrame(), Resources.getString("Chat.invite_heading"), Resources.getString("Chat.invite_heading"), Resources.getString("Chat.invitation", string6, string7), 3, null, 0, JabberClient.INVITE + string2, Resources.getString("Chat.ignore_invitation"));
                    if (n == 0) {
                        JabberClient.this.doInvite(string2, string7);
                    } else {
                        MultiUserChat.decline((XMPPConnection)xMPPConnection, (String)string, (String)string2, (String)"");
                    }
                }
            }
        };
        this.userListener = new DefaultParticipantStatusListener(){

            public void kicked(String string, String string2, String string3) {
                this.revokeMembership(string);
            }

            public void left(String string) {
                this.revokeMembership(string);
            }

            private void revokeMembership(String string) {
                LockableRoom lockableRoom = JabberClient.this.getCurrentRoom();
                if (lockableRoom.isLocked() && lockableRoom.isOwner(JabberClient.this.me.getJid())) {
                    try {
                        String string2 = JabberPlayer.xmppAddressToJid(string);
                        JabberClient.this.currentChat.revokeMembership(JabberClient.this.playerMgr.getPlayer(string2).getId());
                    }
                    catch (XMPPException xMPPException) {
                        xMPPException.printStackTrace();
                    }
                }
            }
        };
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public boolean isConnected() {
        return this.conn != null && this.conn.isConnected();
    }

    public void sendToOthers(Command command) {
        if (this.currentChat != null) {
            try {
                this.currentChat.sendMessage(this.encodeMessage(this.encoder.encode(command)));
            }
            catch (XMPPException xMPPException) {
                this.reportXMPPException(xMPPException);
            }
        }
    }

    public void setConnected(boolean bl) {
        if (bl) {
            if (!this.isConnected()) {
                if (this.conn != null) {
                    this.conn.disconnect();
                }
                try {
                    this.playerMgr.clear();
                    this.roomMgr.clear();
                    String string = this.account.getUserName();
                    String string2 = this.account.getPassword();
                    this.me = this.playerMgr.getPlayerByLogin(this, this.account.getUserName());
                    GameModule gameModule = GameModule.getGameModule();
                    SimpleStatus simpleStatus = (SimpleStatus)this.me.getStatus();
                    simpleStatus.updateStatus();
                    this.me.setStatus(simpleStatus);
                    this.me.setName((String)gameModule.getPrefs().getValue("RealName"));
                    ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration(this.host, this.port);
                    connectionConfiguration.setCompressionEnabled(true);
                    connectionConfiguration.setDebuggerEnabled(XMPPConnection.DEBUG_ENABLED);
                    connectionConfiguration.setReconnectionAllowed(true);
                    this.conn = new XMPPConnection(connectionConfiguration);
                    this.conn.connect();
                    this.conn.addConnectionListener((org.jivesoftware.smack.ConnectionListener)new ConnectionListener());
                    try {
                        this.conn.login(string, string2, "VASSAL");
                    }
                    catch (XMPPException xMPPException) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("name", this.me.getName());
                        try {
                            this.conn.getAccountManager().createAccount(string, string2, hashMap);
                        }
                        catch (XMPPException xMPPException2) {
                            if (xMPPException2.getXMPPError() != null && xMPPException2.getXMPPError().getCode() == 409) {
                                this.fireStatus(Resources.getString("Chat.invalid_password", string));
                                this.setConnected(false);
                                return;
                            }
                            this.setConnected(false);
                            throw xMPPException2;
                        }
                        this.conn.disconnect();
                        this.conn.connect();
                        try {
                            this.conn.login(string, string2, "VASSAL");
                        }
                        catch (XMPPException xMPPException3) {
                            this.setConnected(false);
                            throw xMPPException3;
                        }
                        VCard vCard = new VCard();
                        vCard.setNickName(this.me.getName());
                        vCard.save(this.conn);
                    }
                    this.monitor = new MonitorRooms();
                    this.monitor.init();
                    this.propSupport.firePropertyChange("Connected", null, Boolean.TRUE);
                    this.fireStatus(Resources.getString("Server.connected", this.host + ":" + this.port));
                    this.setRoom(this.defaultRoom);
                    GameModule.getGameModule().addIdChangeListener(this.idChangeListener);
                    MultiUserChat.addInvitationListener((XMPPConnection)this.conn, (InvitationListener)this.inviteListener);
                }
                catch (XMPPException xMPPException) {
                    this.reportXMPPException(xMPPException);
                    if (xMPPException.getWrappedThrowable() != null && xMPPException.getWrappedThrowable().getLocalizedMessage() != null) {
                        this.fireStatus(xMPPException.getWrappedThrowable().getMessage());
                    }
                    this.setConnected(false);
                }
            }
        } else if (this.isConnected()) {
            this.leaveCurrentRoom();
            if (this.monitor != null) {
                this.monitor.disconnect();
            }
            this.conn.disconnect();
            this.tidyConnection();
        }
    }

    private void tidyConnection() {
        this.conn = null;
        this.monitor = null;
        this.currentChat = null;
        this.propSupport.firePropertyChange("Connected", null, Boolean.FALSE);
        this.playerMgr.clear();
        this.roomMgr.clear();
        this.fireStatus(Resources.getString("Server.disconnected", this.host + ":" + this.port));
    }

    private void leaveCurrentRoom() {
        if (this.currentChat != null) {
            this.currentChat.leave();
            this.currentChat.removeMessageListener((PacketListener)this);
            this.currentChat.removeUserStatusListener(this.kickListener);
            this.currentChat.removeParticipantStatusListener(this.userListener);
            this.currentChat = null;
        }
    }

    public void initializeControls(ChatServerControls chatServerControls) {
        this.playerStatusControls.initializeControls(chatServerControls);
        this.roomControls.initializeControls(chatServerControls);
        chatServerControls.setRoomControlsVisible(true);
        GameModule.getGameModule().addCommandEncoder(this.synchEncoder);
        GameModule.getGameModule().addCommandEncoder(this.privateChatEncoder);
        GameModule.getGameModule().addCommandEncoder(this.soundEncoder);
        chatServerControls.getRoomTree().setCellRenderer(new LockableRoomTreeRenderer());
    }

    public void uninitializeControls(ChatServerControls chatServerControls) {
        this.roomControls.uninitializeControls(chatServerControls);
        this.playerStatusControls.uninitializeControls(chatServerControls);
        GameModule.getGameModule().removeCommandEncoder(this.synchEncoder);
        GameModule.getGameModule().removeCommandEncoder(this.privateChatEncoder);
        GameModule.getGameModule().removeCommandEncoder(this.soundEncoder);
    }

    public void processPacket(Packet packet) {
        Message message = (Message)packet;
        if (!message.getFrom().equals(this.currentChat.getRoom() + "/" + this.currentChat.getNickname())) {
            this.propSupport.firePropertyChange("Msg", null, this.decodeMessage(message.getBody()));
        }
    }

    public void processServerMessage(String string, String string2) {
        GameModule gameModule = GameModule.getGameModule();
        gameModule.warn("##### " + Resources.getString("JabberClient.message_from_admin", this.host + ":" + this.port));
        if (string != null) {
            gameModule.warn(Resources.getString("JabberClient.subject") + string);
        }
        gameModule.warn(string2);
        gameModule.warn("##### " + Resources.getString("JabberClient.end_message"));
    }

    public Room getRoom() {
        return this.monitor.getCurrentRoom();
    }

    public JabberRoom getRoomByName(String string) {
        return this.roomMgr.getRoomByName(this, string);
    }

    public String getCurrentRoomJID() {
        return this.currentChat == null ? null : this.currentChat.getRoom();
    }

    public LockableRoom getCurrentRoom() {
        return this.monitor.getCurrentRoom();
    }

    public void setRoom(String string) {
        this.setRoom(this.roomMgr.getRoomByName(this, string));
    }

    public void setRoom(Room room) {
        JabberRoom jabberRoom = null;
        try {
            jabberRoom = room instanceof JabberRoom ? (JabberRoom)room : this.roomMgr.getRoomByName(this, room.getName());
            if (!jabberRoom.equals(this.getRoom())) {
                String string = jabberRoom.canJoin(this.me);
                if (string != null) {
                    this.fireStatus(Resources.getString("Chat.failed_to_join", jabberRoom.getName(), string));
                    return;
                }
                this.leaveCurrentRoom();
                this.currentChat = jabberRoom.join(this, (JabberPlayer)this.getUserInfo());
                if (jabberRoom.isOwnedByMe()) {
                    this.currentChat.addParticipantStatusListener(this.userListener);
                }
                this.fireStatus(Resources.getString("Chat.joined_room", jabberRoom.getName()));
                if (!jabberRoom.isOwnedByMe() && !this.isDefaultRoom(jabberRoom)) {
                    new SynchAction(jabberRoom.getOwningPlayer(), this).actionPerformed(null);
                    GameModule.getGameModule().warn(Resources.getString("Chat.synchronize_complete"));
                } else {
                    SynchAction.clearSynchRoom();
                }
                this.currentChat.addUserStatusListener(this.kickListener);
                this.monitor.sendRoomChanged();
                this.monitor.sendStatus(this.me, jabberRoom);
            }
        }
        catch (XMPPException xMPPException) {
            this.reportXMPPException(xMPPException);
            String string = null;
            if (xMPPException.getXMPPError() != null) {
                XMPPError xMPPError = xMPPException.getXMPPError();
                if (xMPPError.getCode() == 407) {
                    string = Resources.getString("Chat.not_a_member");
                } else {
                    string = xMPPException.getXMPPError().getMessage();
                    if (string == null) {
                        string = xMPPException.getXMPPError().getCondition();
                    }
                }
            } else {
                string = xMPPException.getMessage();
            }
            this.fireStatus(Resources.getString("Chat.failed_to_join", jabberRoom.getName(), string));
        }
    }

    public Room[] getAvailableRooms() {
        return this.monitor.getAvailableRooms();
    }

    protected void fireRoomsUpdated() {
        this.propSupport.firePropertyChange("AvailableRooms", null, this.getAvailableRooms());
        this.propSupport.firePropertyChange("Room", null, this.getRoom());
    }

    protected void fireStatus(String string) {
        this.propSupport.firePropertyChange("Status", null, string);
    }

    public Player getUserInfo() {
        return this.playerMgr.getPlayerByLogin(this, this.account.getUserName());
    }

    public void setUserInfo(Player player) {
        if (this.monitor != null) {
            this.monitor.sendStatus((JabberPlayer)player);
        }
    }

    public String getDefaultRoomName() {
        return this.defaultRoom.getName();
    }

    public boolean isDefaultRoom(Room room) {
        return room == null ? false : room.getName().equals(this.getDefaultRoomName());
    }

    public void sendTo(Player player, Command command) {
        Chat chat = this.conn.getChatManager().createChat(((JabberPlayer)player).getJid(), null);
        try {
            chat.sendMessage(this.encodeMessage(this.encoder.encode(command)));
        }
        catch (XMPPException xMPPException) {
            this.reportXMPPException(xMPPException);
        }
    }

    public boolean isInvitable(Player player) {
        JabberRoom jabberRoom;
        return !player.equals(this.me) && !(jabberRoom = this.monitor.getCurrentRoom()).contains(player) && jabberRoom.isOwnedByMe() && jabberRoom.isLocked();
    }

    public void sendInvite(Player player) {
        try {
            this.currentChat.grantMembership(player.getId());
        }
        catch (XMPPException xMPPException) {
            ErrorDialog.bug(new Throwable("Unable to grant membership to room " + this.getCurrentRoom().getName() + " to player " + player.getId(), xMPPException));
        }
        this.currentChat.invite(((JabberPlayer)player).getRawJid(), INVITE);
    }

    public void doInvite(String string, String string2) {
        this.setRoom(string2);
    }

    public boolean isKickable(Player player) {
        JabberRoom jabberRoom;
        return !player.equals(this.me) && (jabberRoom = this.monitor.getCurrentRoom()).contains(player) && jabberRoom.isOwnedByMe() && jabberRoom.isLocked();
    }

    public void doKick(Player player) {
        try {
            this.currentChat.kickParticipant(((JabberPlayer)player).getLoginName(), "");
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
    }

    private void reportXMPPException(XMPPException xMPPException) {
        xMPPException.printStackTrace();
    }

    public MessageBoard getMessageServer() {
        return this.msgSvr;
    }

    public ServerStatus getStatusServer() {
        return this;
    }

    public XMPPConnection getConnection() {
        return this.conn;
    }

    public String getModule() {
        return "vassal-" + GameModule.getGameModule().getGameName();
    }

    public String getConferenceService() {
        return this.conferenceService;
    }

    public static String unescapeNode(String string) {
        return StringUtils.unescapeNode((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String encodeMessage(String string) {
        ObfuscatingOutputStream obfuscatingOutputStream = null;
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        try {
            obfuscatingOutputStream = new ObfuscatingOutputStream(fastByteArrayOutputStream);
            obfuscatingOutputStream.write(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            IOUtils.closeQuietly((OutputStream)obfuscatingOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(obfuscatingOutputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)obfuscatingOutputStream);
        }
        IOUtils.closeQuietly((OutputStream)obfuscatingOutputStream);
        String string2 = new String(fastByteArrayOutputStream.toByteArray());
        IOUtils.closeQuietly((OutputStream)fastByteArrayOutputStream);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String decodeMessage(String string) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        DeobfuscatingInputStream deobfuscatingInputStream = null;
        String string2 = "";
        try {
            deobfuscatingInputStream = new DeobfuscatingInputStream(byteArrayInputStream);
            string2 = IOUtils.toString((InputStream)deobfuscatingInputStream, (String)"UTF-8");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)byteArrayInputStream);
            IOUtils.closeQuietly((InputStream)deobfuscatingInputStream);
        }
        return string2;
    }

    public void lockRoom(LockableRoom lockableRoom) {
        if (lockableRoom instanceof JabberRoom) {
            JabberRoom jabberRoom = (JabberRoom)lockableRoom;
            jabberRoom.toggleLock(this.currentChat);
            try {
                this.monitor.sendRoomChanged();
            }
            catch (XMPPException xMPPException) {
                // empty catch block
            }
        }
    }

    public CommandEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(CommandEncoder commandEncoder) {
        this.encoder = commandEncoder;
    }

    public ServerStatus.ModuleSummary[] getHistory(String string) {
        return new ServerStatus.ModuleSummary[0];
    }

    public ServerStatus.ModuleSummary[] getStatus() {
        ArrayList arrayList = new ArrayList();
        try {
            for (HostedRoom hostedRoom : MultiUserChat.getHostedRooms((XMPPConnection)this.conn, (String)this.conferenceService)) {
                MultiUserChat.getRoomInfo((XMPPConnection)this.conn, (String)hostedRoom.getJid());
            }
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
        return arrayList.toArray(new ServerStatus.ModuleSummary[arrayList.size()]);
    }

    public String[] getSupportedTimeRanges() {
        return new String[0];
    }

    public static void main(String[] stringArray) {
        XMPPConnection.DEBUG_ENABLED = true;
        CommandEncoder commandEncoder = new CommandEncoder(){

            public Command decode(String string) {
                System.err.println(string);
                return null;
            }

            public String encode(Command command) {
                return null;
            }
        };
        final String string = stringArray.length == 0 ? "test" : stringArray[0];
        final String string2 = stringArray.length == 0 ? "test" : stringArray[1];
        AccountInfo accountInfo = new AccountInfo(){

            public String getPassword() {
                return string2;
            }

            public String getUserName() {
                return string;
            }

            public String getModule() {
                return "JabberTestModule";
            }

            public String getRealName() {
                return string;
            }
        };
        JabberClient jabberClient = new JabberClient(commandEncoder, "localhost", 5222, accountInfo);
        jabberClient.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                System.err.println(propertyChangeEvent.getPropertyName() + "=" + propertyChangeEvent.getNewValue());
            }
        });
        ChatServerControls chatServerControls = new ChatServerControls();
        chatServerControls.setClient(jabberClient);
        JFrame jFrame = new JFrame(string);
        jFrame.add(chatServerControls.getControls());
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    public String getHost() {
        return this.host;
    }

    public String playerToString(Player player) {
        return ((JabberPlayer)player).getJid();
    }

    public Player stringToPlayer(String string) {
        return this.playerMgr.getPlayer(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String testConnection(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer;
        block13: {
            stringBuffer = new StringBuffer(Resources.getString("JabberClient.testing_connection") + string + ":" + string2 + " " + string3 + "/" + string4).append("\n");
            if (string.length() == 0) {
                return stringBuffer.append(Resources.getString("JabberClient.error_no_host")).toString();
            }
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return stringBuffer.append(Resources.getString("JabberClient.error_port_number")).toString();
            }
            ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration(string, n);
            connectionConfiguration.setCompressionEnabled(true);
            connectionConfiguration.setDebuggerEnabled(XMPPConnection.DEBUG_ENABLED);
            connectionConfiguration.setReconnectionAllowed(true);
            XMPPConnection xMPPConnection = new XMPPConnection(connectionConfiguration);
            try {
                stringBuffer.append(Resources.getString("JabberClient.attempting_to_connect")).append("\n");
                xMPPConnection.connect();
                stringBuffer.append(Resources.getString("JabberClient.success")).append("\n");
                stringBuffer.append(Resources.getString("JabberClient.attempting_to_login")).append("\n");
                try {
                    xMPPConnection.login(string3, string4, "VASSAL");
                    stringBuffer.append(Resources.getString("JabberClient.success"));
                }
                catch (XMPPException xMPPException) {
                    stringBuffer.append(Resources.getString("JabberClient.login_failed")).append("\n");
                    stringBuffer.append(Resources.getString("JabberClient.attempting_to_create")).append("\n");
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("name", GameModule.getUserId());
                    try {
                        xMPPConnection.getAccountManager().createAccount(string3, string4, hashMap);
                        stringBuffer.append(Resources.getString("JabberClient.success"));
                    }
                    catch (XMPPException xMPPException2) {
                        stringBuffer.append(Resources.getString("JabberClient.failed")).append("\n");
                        if (xMPPException2.getXMPPError() != null && xMPPException2.getXMPPError().getCode() == 409) {
                            stringBuffer.append(Resources.getString("Chat.invalid_password")).append("\n");
                            break block13;
                        }
                        stringBuffer.append(JabberClient.formatXMPPError(xMPPException2));
                    }
                }
            }
            catch (XMPPException xMPPException) {
                stringBuffer.append(Resources.getString("JabberClient.failed")).append("\n");
                stringBuffer.append(JabberClient.formatXMPPError(xMPPException));
            }
            finally {
                xMPPConnection.disconnect();
            }
        }
        return stringBuffer.toString();
    }

    private static String formatXMPPError(XMPPException xMPPException) {
        XMPPError xMPPError = xMPPException.getXMPPError();
        if (xMPPError == null) {
            return Resources.getString("Server.server_error", xMPPException.getMessage(), "", "");
        }
        return Resources.getString("Server.server_error", xMPPException.getXMPPError().getMessage(), xMPPException.getXMPPError().getCondition(), xMPPException.getXMPPError().getCode());
    }

    private class ConnectionListener
    implements org.jivesoftware.smack.ConnectionListener {
        private ConnectionListener() {
        }

        public void connectionClosed() {
        }

        public void connectionClosedOnError(Exception exception) {
            XMPPException xMPPException;
            String string = exception.getMessage();
            if (exception instanceof XMPPException && (xMPPException = (XMPPException)exception).getStreamError() != null && "conflict".equals(xMPPException.getStreamError().getCode())) {
                string = Resources.getString("Server.account_in_use");
            }
            if (string != null) {
                JabberClient.this.fireStatus(string);
            }
            JabberClient.this.setConnected(false);
        }

        public void reconnectingIn(int n) {
        }

        public void reconnectionFailed(Exception exception) {
        }

        public void reconnectionSuccessful() {
        }
    }

    private class MonitorRooms
    implements PacketListener,
    ParticipantStatusListener {
        private static final String ROOM_CHANGE_ACTION = "changedRoom";
        private MultiUserChat monitorRoom;
        private Comparator<Room> roomSortOrder = new Comparator<Room>(){

            @Override
            public int compare(Room room, Room room2) {
                if (room.equals(JabberClient.this.defaultRoom) && !room2.equals(JabberClient.this.defaultRoom)) {
                    return -1;
                }
                if (room2.equals(JabberClient.this.defaultRoom) && !room.equals(JabberClient.this.defaultRoom)) {
                    return 1;
                }
                return room.getName().compareTo(room2.getName());
            }
        };

        private MonitorRooms() {
        }

        public void init() throws XMPPException {
            block2: {
                new TrackRooms().addTo(JabberClient.this.conn);
                new TrackStatus(this.getMonitorRoomJID().toLowerCase()).addTo(JabberClient.this.conn);
                new ListenForChat().addTo(JabberClient.this.conn);
                this.monitorRoom = new MultiUserChat(JabberClient.this.conn, this.getMonitorRoomJID());
                this.monitorRoom.addMessageListener((PacketListener)this);
                this.monitorRoom.addParticipantStatusListener((ParticipantStatusListener)this);
                this.monitorRoom.join(StringUtils.parseName((String)JabberClient.this.conn.getUser()));
                try {
                    this.monitorRoom.sendConfigurationForm(new Form("submit"));
                }
                catch (XMPPException xMPPException) {
                    if (xMPPException.getXMPPError().getCode() == 403) break block2;
                    throw xMPPException;
                }
            }
            this.sendStatus(JabberClient.this.me);
        }

        public String getMonitorRoomJID() {
            return StringUtils.escapeNode((String)JabberClient.this.getModule()) + "@" + JabberClient.this.getConferenceService();
        }

        protected void sendStatus(JabberPlayer jabberPlayer) {
            this.sendStatus(jabberPlayer, null, jabberPlayer.getJoinedRoom());
        }

        protected void sendStatus(JabberPlayer jabberPlayer, JabberRoom jabberRoom) {
            this.sendStatus(jabberPlayer, null, jabberRoom);
        }

        protected void sendStatus(JabberPlayer jabberPlayer, String string, JabberRoom jabberRoom) {
            SimpleStatus simpleStatus = (SimpleStatus)jabberPlayer.getStatus();
            Presence presence = new Presence(Presence.Type.available);
            presence.setStatus("");
            presence.setMode(Presence.Mode.chat);
            presence.setProperty("looking", (Object)simpleStatus.isLooking());
            presence.setProperty("away", (Object)simpleStatus.isAway());
            presence.setProperty("ip", (Object)simpleStatus.getIp());
            presence.setProperty("client", (Object)simpleStatus.getClient());
            presence.setProperty("moduleVersion", (Object)simpleStatus.getModuleVersion());
            presence.setProperty("crc", (Object)simpleStatus.getCrc());
            presence.setProperty(JabberClient.REAL_NAME, (Object)jabberPlayer.getName());
            if (jabberRoom != null) {
                presence.setProperty(JabberClient.ROOM_CONFIG, (Object)jabberRoom.encodeConfig());
                presence.setProperty(JabberClient.ROOM_JID, (Object)jabberRoom.getJID());
                presence.setProperty(JabberClient.ROOM_NAME, (Object)jabberRoom.getName());
            }
            presence.setTo(string == null ? this.monitorRoom.getRoom() : string);
            JabberClient.this.conn.sendPacket((Packet)presence);
        }

        public Room[] getAvailableRooms() {
            Set set;
            List list;
            HashMap<JabberRoom, Collection<JabberPlayer>> hashMap = new HashMap<JabberRoom, Collection<JabberPlayer>>();
            for (JabberPlayer object2 : JabberClient.this.playerMgr.getAllPlayers()) {
                JabberRoom jabberRoom = object2.getJoinedRoom();
                if (jabberRoom == null) continue;
                list = (ArrayList<JabberPlayer>)hashMap.get(jabberRoom);
                if (list == null) {
                    list = new ArrayList<JabberPlayer>();
                    hashMap.put(jabberRoom, list);
                }
                list.add(object2);
            }
            if (!hashMap.containsKey(JabberClient.this.defaultRoom)) {
                set = Collections.emptyList();
                hashMap.put(JabberClient.this.defaultRoom, set);
            }
            set = hashMap.keySet();
            for (JabberRoom jabberRoom : set) {
                list = (List)hashMap.get(jabberRoom);
                jabberRoom.setPlayers(list.toArray(new JabberPlayer[list.size()]));
            }
            Room[] roomArray = set.toArray(new Room[set.size()]);
            Arrays.sort(roomArray, this.roomSortOrder);
            return roomArray;
        }

        public JabberRoom getCurrentRoom() {
            String string = JabberClient.this.getCurrentRoomJID();
            return JabberClient.this.roomMgr.getRoomByJID(JabberClient.this, string);
        }

        public void sendRoomChanged() throws XMPPException {
            Message message = this.monitorRoom.createMessage();
            message.setBody(ROOM_CHANGE_ACTION);
            this.monitorRoom.sendMessage(message);
        }

        public void disconnect() {
            this.monitorRoom.leave();
        }

        public String getAbsolutePlayerJID(String string) {
            return StringUtils.parseResource((String)string) + "@" + JabberClient.this.host + JabberClient.JID_RESOURCE;
        }

        private void sendRoomQuery(String string) {
            DiscoverItems discoverItems = new DiscoverItems();
            discoverItems.setType(IQ.Type.GET);
            discoverItems.setTo(string);
            discoverItems.setNode(JabberClient.QUERY_ROOMS);
            JabberClient.this.conn.sendPacket((Packet)discoverItems);
        }

        public void processPacket(Packet packet) {
            Message message = (Message)packet;
            if (ROOM_CHANGE_ACTION.equals(message.getBody())) {
                String string = this.getAbsolutePlayerJID(packet.getFrom());
                JabberClient.this.playerMgr.getPlayer(this.getAbsolutePlayerJID(packet.getFrom()));
                this.sendRoomQuery(string);
            }
        }

        public void joined(String string) {
            JabberClient.this.playerMgr.getPlayer(this.getAbsolutePlayerJID(string));
        }

        public void left(String string) {
            String string2 = this.getAbsolutePlayerJID(string);
            JabberClient.this.playerMgr.deletePlayer(string2);
            JabberClient.this.fireRoomsUpdated();
        }

        public void kicked(String string, String string2, String string3) {
        }

        public void voiceGranted(String string) {
        }

        public void voiceRevoked(String string) {
        }

        public void banned(String string, String string2, String string3) {
        }

        public void membershipGranted(String string) {
        }

        public void membershipRevoked(String string) {
        }

        public void moderatorGranted(String string) {
        }

        public void moderatorRevoked(String string) {
        }

        public void ownershipGranted(String string) {
        }

        public void ownershipRevoked(String string) {
        }

        public void adminGranted(String string) {
        }

        public void adminRevoked(String string) {
        }

        public void nicknameChanged(String string, String string2) {
        }

        private class ListenForChat
        extends PacketProcessor {
            private PacketFilter chatFilter = new MessageTypeFilter(Message.Type.chat);
            private PacketFilter serverMessageFilter = new MessageTypeFilter(Message.Type.normal);

            private ListenForChat() {
            }

            protected boolean acceptPacket(Packet packet) {
                if (this.chatFilter.accept(packet)) {
                    return true;
                }
                if (this.serverMessageFilter.accept(packet)) {
                    return ((Message)packet).getFrom().equals(JabberClient.this.getConnection().getHost());
                }
                return false;
            }

            protected void process(Packet packet) {
                if (this.chatFilter.accept(packet)) {
                    JabberClient.this.processPacket(packet);
                } else {
                    Message message = (Message)packet;
                    JabberClient.this.processServerMessage(message.getSubject(), message.getBody());
                }
            }
        }

        private class TrackRooms
        extends PacketProcessor {
            private PacketFilter roomResponseFilter = new AndFilter(new PacketFilter[]{new IQTypeFilter(IQ.Type.RESULT), new PacketTypeFilter(DiscoverItems.class)});
            private PacketFilter newPlayerFilter = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), new FromContainsFilter(MonitorRooms.this.getMonitorRoomJID())});

            public void process(Packet packet) {
                if (this.roomResponseFilter.accept(packet)) {
                    DiscoverItems discoverItems = (DiscoverItems)packet;
                    JabberPlayer jabberPlayer = JabberClient.this.playerMgr.getPlayer(packet.getFrom());
                    Iterator iterator = discoverItems.getItems();
                    while (iterator.hasNext()) {
                        String string = ((DiscoverItems.Item)iterator.next()).getEntityID();
                        JabberRoom jabberRoom = JabberClient.this.roomMgr.getRoomByJID(JabberClient.this, string);
                        try {
                            jabberRoom.setInfo(MultiUserChat.getRoomInfo((XMPPConnection)JabberClient.this.getConnection(), (String)string));
                        }
                        catch (XMPPException xMPPException) {
                            // empty catch block
                        }
                        if (string.equals(MonitorRooms.this.monitorRoom.getRoom())) continue;
                        jabberPlayer.join(JabberClient.this.roomMgr.getRoomByJID(JabberClient.this, string));
                    }
                    JabberClient.this.fireRoomsUpdated();
                } else if (this.newPlayerFilter.accept(packet)) {
                    MonitorRooms.this.sendRoomQuery(MonitorRooms.this.getAbsolutePlayerJID(packet.getFrom()));
                }
            }

            public boolean acceptPacket(Packet packet) {
                boolean bl = false;
                if (this.roomResponseFilter.accept(packet)) {
                    bl = JabberClient.QUERY_ROOMS.equals(((DiscoverItems)packet).getNode());
                } else if (this.newPlayerFilter.accept(packet)) {
                    bl = ((Presence)packet).isAvailable();
                }
                return bl;
            }
        }

        private class TrackStatus
        extends PacketProcessor {
            String prefix;
            private PacketFilter changeStatusFilter = new PacketFilter(){

                public boolean accept(Packet packet) {
                    String string;
                    Presence presence;
                    boolean bl = false;
                    if (packet instanceof Presence && (presence = (Presence)packet).getType() == Presence.Type.available && presence.getMode() == Presence.Mode.chat && (string = presence.getFrom()) != null && string.toLowerCase().startsWith(TrackStatus.this.prefix)) {
                        bl = true;
                    }
                    return bl;
                }
            };

            public TrackStatus(String string) {
                this.prefix = string;
            }

            public boolean acceptPacket(Packet packet) {
                return packet instanceof Presence;
            }

            public void process(Packet packet) {
                String string;
                String string2;
                Object object;
                Object object2;
                String string3;
                Object object3;
                JabberPlayer jabberPlayer;
                Presence presence;
                if (this.changeStatusFilter.accept(packet)) {
                    presence = (Presence)packet;
                    jabberPlayer = JabberClient.this.playerMgr.getPlayer(MonitorRooms.this.getAbsolutePlayerJID(presence.getFrom()));
                    object3 = (SimpleStatus)jabberPlayer.getStatus();
                    string3 = object3 == null ? "" : ((SimpleStatus)object3).getProfile();
                    object2 = presence.getProperty("looking");
                    object = presence.getProperty("away");
                    string2 = presence.getProperty("ip").toString();
                    string = presence.getProperty("client").toString();
                    String string4 = presence.getProperty("moduleVersion").toString();
                    String string5 = presence.getProperty("crc").toString();
                    object3 = new SimpleStatus(object2 == null ? false : (Boolean)object2, object == null ? false : (Boolean)object, string3, string, string2, string4, string5);
                    jabberPlayer.setStatus((PlayerStatus)object3);
                    jabberPlayer.setName(String.valueOf(presence.getProperty(JabberClient.REAL_NAME)));
                    JabberClient.this.fireRoomsUpdated();
                }
                if (packet instanceof Presence && (presence = (Presence)packet).getType().equals((Object)Presence.Type.available)) {
                    jabberPlayer = presence.getExtension(JabberClient.QUERY_USER);
                    object3 = null;
                    if (jabberPlayer != null && jabberPlayer instanceof MUCUser) {
                        string3 = ((MUCUser)jabberPlayer).getItem().getAffiliation();
                        object2 = JabberClient.this.playerMgr.getPlayer(MonitorRooms.this.getAbsolutePlayerJID(presence.getFrom())).getJid();
                        object = (String)presence.getProperty(JabberClient.ROOM_JID);
                        string2 = (String)presence.getProperty(JabberClient.ROOM_CONFIG);
                        string = (String)presence.getProperty(JabberClient.ROOM_NAME);
                        if (object == null) {
                            object = StringUtils.parseName((String)presence.getFrom()) + "@" + JabberClient.this.getConferenceService();
                        }
                        if ((object3 = JabberClient.this.roomMgr.getRoomByJID(JabberClient.this, (String)object, string)) != null) {
                            if (JabberClient.OWNER.equals(string3)) {
                                ((JabberRoom)object3).addOwner((String)object2);
                            } else {
                                ((JabberRoom)object3).removeOwner((String)object2);
                            }
                        }
                        if (string2 != null && object3 != null) {
                            ((JabberRoom)object3).decodeConfig(string2);
                        }
                    }
                }
            }
        }
    }
}

