/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.node.AsynchronousServerNode;
import VASSAL.chat.node.Node;
import VASSAL.tools.PropertiesEncoder;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

public class StatusReporter
implements Runnable {
    private HttpRequestWrapper reportStatus;
    private String lastReportedContents;
    private String currentContents;
    private long sleepInterval = 2000L;
    private static final long MIN_SLEEP = 2000L;
    private static final long MAX_SLEEP = 0x6DDD00L;
    private AsynchronousServerNode server;

    public StatusReporter(HttpRequestWrapper httpRequestWrapper, AsynchronousServerNode asynchronousServerNode) {
        this.reportStatus = httpRequestWrapper;
        this.server = asynchronousServerNode;
        new Thread((Runnable)this, "status reporter").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContents(Node[] nodeArray) {
        if (this.reportStatus == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node : nodeArray) {
            Node node2 = this.server.getModule(node);
            try {
                String iOException = new PropertiesEncoder(node.getInfo()).getProperties().getProperty("name");
                if (iOException == null) continue;
                stringBuilder.append(node2.getId()).append('\t').append(node.getParent().getId()).append('\t').append(iOException).append('\n');
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        StatusReporter statusReporter = this;
        synchronized (statusReporter) {
            this.currentContents = stringBuilder.toString();
        }
    }

    private synchronized void sendContents() {
        if (this.currentContents != null && !this.currentContents.equals(this.lastReportedContents)) {
            try {
                Properties properties = new Properties();
                properties.put("STATUS", this.currentContents);
                this.reportStatus.doPost("updateConnections", properties);
                this.sleepInterval = 2000L;
            }
            catch (IOException iOException) {
                this.sleepInterval = Math.min(2L * this.sleepInterval, 0x6DDD00L);
            }
            this.lastReportedContents = this.currentContents;
            System.err.println("----" + new Date());
            System.err.println(this.currentContents);
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.sleepInterval);
                    this.sendContents();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }
}

