/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.script.AbstractInterpreter;
import VASSAL.script.expression.ExpressionException;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.io.IOUtils;
import bsh.BeanShellExpressionValidator;
import bsh.EvalError;
import bsh.NameSpace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionInterpreter
extends AbstractInterpreter {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ExpressionInterpreter.class);
    protected static final String INIT_SCRIPT = "/VASSAL/script/init_expression.bsh";
    protected static final String THIS = "_interp";
    protected static final String SOURCE = "_source";
    protected static final String MAGIC1 = "_xyzzy";
    protected static final String MAGIC2 = "_plugh";
    protected static final String MAGIC3 = "_plover";
    protected static NameSpace topLevelNameSpace;
    protected NameSpace expressionNameSpace;
    protected String expression;
    protected PropertySource source;
    protected List<String> variables = new ArrayList<String>();
    protected static HashMap<String, ExpressionInterpreter> cache;

    public static ExpressionInterpreter createInterpreter(String string) throws ExpressionException {
        String string2 = string == null ? "" : ExpressionInterpreter.strip(string);
        ExpressionInterpreter expressionInterpreter = cache.get(string2);
        if (expressionInterpreter == null) {
            expressionInterpreter = new ExpressionInterpreter(string2);
            cache.put(string2, expressionInterpreter);
        }
        return expressionInterpreter;
    }

    protected static String strip(String string) {
        String string2 = string.trim();
        if (string2.startsWith("{") && string2.endsWith("}")) {
            return string2.substring(1, string2.length() - 1);
        }
        return string;
    }

    private ExpressionInterpreter(String string) throws ExpressionException {
        this.expression = string;
        this.setClassLoader(this.getClass().getClassLoader());
        if (topLevelNameSpace == null) {
            this.initialiseStatic();
        }
        this.expressionNameSpace = new NameSpace(topLevelNameSpace, "expression");
        this.variables = new BeanShellExpressionValidator(this.expression).getVariables();
        this.setNameSpace(this.expressionNameSpace);
        if (this.expression.length() > 0) {
            try {
                this.eval("String _plugh() { _plover=" + this.expression + "; return " + MAGIC3 + ".toString();}");
            }
            catch (EvalError evalError) {
                throw new ExpressionException(this.getExpression());
            }
        }
        this.setVar(THIS, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseStatic() {
        topLevelNameSpace = new NameSpace(null, this.getClassManager(), "topLevel");
        this.setNameSpace(topLevelNameSpace);
        this.getNameSpace().importClass("VASSAL.build.module.properties.PropertySource");
        this.getNameSpace().importClass("VASSAL.script.ExpressionInterpreter");
        URL uRL = this.getClass().getResource(INIT_SCRIPT);
        logger.info("Attempting to load /VASSAL/script/init_expression.bsh URI generated=" + uRL.toString());
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            try {
                this.eval(bufferedReader);
            }
            catch (EvalError evalError) {
                logger.error("Error trying to read init script: " + uRL.toString());
                WarningDialog.show(evalError, "", new Object[0]);
            }
        }
        catch (IOException iOException) {
            try {
                logger.error("Error trying to read init script: " + uRL.toString());
                WarningDialog.show(iOException, "", new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)bufferedReader);
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
    }

    public String getExpression() {
        return this.expression;
    }

    public String evaluate(PropertySource propertySource) throws ExpressionException {
        return this.evaluate(propertySource, false);
    }

    public String evaluate(PropertySource propertySource, boolean bl) throws ExpressionException {
        String string;
        if (this.getExpression().length() == 0) {
            return "";
        }
        this.source = propertySource == null ? GameModule.getGameModule() : propertySource;
        this.setNameSpace(this.expressionNameSpace);
        for (String string2 : this.variables) {
            String string3;
            string = string2;
            if (string.length() > 2 && string.startsWith("$") && string.endsWith("$")) {
                string = string.substring(1, string.length() - 1);
            }
            Object object = bl ? this.source.getLocalizedProperty(string) : this.source.getProperty(string);
            String string4 = string3 = object == null ? "" : object.toString();
            if (string3 == null) {
                this.setVar(string2, "");
                continue;
            }
            if ("true".equals(string3)) {
                this.setVar(string2, true);
                continue;
            }
            if ("false".equals(string3)) {
                this.setVar(string2, false);
                continue;
            }
            try {
                this.setVar(string2, Integer.valueOf(string3));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    this.setVar(string2, Float.valueOf(string3).floatValue());
                }
                catch (NumberFormatException numberFormatException2) {
                    this.setVar(string2, string3);
                }
            }
        }
        this.setVar(THIS, this);
        this.setVar(SOURCE, this.source);
        Object object = "";
        try {
            this.eval("_xyzzy=_plugh()");
            object = this.get(MAGIC1).toString();
        }
        catch (EvalError evalError) {
            string = evalError.getRawMessage();
            int n = string.indexOf("_plugh();'' : ");
            throw new ExpressionException(this.getExpression(), string.substring(n + "_plugh();'' : ".length()));
        }
        return object;
    }

    public String evaluate() throws ExpressionException {
        return this.getExpression().length() == 0 ? "" : this.evaluate(GameModule.getGameModule());
    }

    public Object wrap(String string) {
        if (string == null) {
            return "";
        }
        if ("true".equals(string)) {
            return Boolean.TRUE;
        }
        if ("false".equals(string)) {
            return Boolean.FALSE;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    public Object getProperty(String string) {
        Object object = this.source.getProperty(string);
        return object == null ? "" : this.wrap(object.toString());
    }

    public Object getLocalizedProperty(String string) {
        Object object = this.source.getLocalizedProperty(string);
        return object == null ? "" : this.wrap(object.toString());
    }

    public Object sumStack(String string, PropertySource propertySource) {
        Stack stack;
        int n = 0;
        if (propertySource instanceof GamePiece && (stack = ((GamePiece)propertySource).getParent()) != null) {
            for (int i = 0; i < stack.getPieceCount(); ++i) {
                try {
                    n += Integer.valueOf(stack.getPieceAt(i).getProperty(string).toString()).intValue();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    public Object sumLocation(String string, PropertySource propertySource) {
        GamePiece gamePiece;
        Map map;
        int n = 0;
        if (propertySource instanceof GamePiece && (map = (gamePiece = (GamePiece)propertySource).getMap()) != null) {
            String string2 = map.locationName(gamePiece.getPosition());
            GamePiece[] gamePieceArray = map.getPieces();
            for (int i = 0; i < gamePieceArray.length; ++i) {
                if (!string2.equals(map.locationName(gamePieceArray[i].getPosition()))) continue;
                if (gamePieceArray[i] instanceof Stack) {
                    Stack stack = (Stack)gamePieceArray[i];
                    for (int j = 0; j < stack.getPieceCount(); ++j) {
                        try {
                            n += Integer.valueOf(stack.getPieceAt(j).getProperty(string).toString()).intValue();
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                try {
                    n += Integer.valueOf(gamePieceArray[i].getProperty(string).toString()).intValue();
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    static {
        cache = new HashMap();
    }
}

