/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.tools.ArrayUtils;
import VASSAL.tools.NamedKeyStroke;
import java.awt.Color;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.KeyStroke;

public class SequenceEncoder {
    private StringBuilder buffer;
    private final char delimit;

    public SequenceEncoder(char c) {
        this.delimit = c;
    }

    public SequenceEncoder(String string, char c) {
        this(c);
        this.append(string);
    }

    public SequenceEncoder append(String string) {
        if (this.buffer == null) {
            this.buffer = new StringBuilder();
        } else {
            this.buffer.append(this.delimit);
        }
        if (string != null) {
            if (string.endsWith("\\") || string.startsWith("'") && string.endsWith("'")) {
                this.buffer.append("'");
                this.appendEscapedString(string);
                this.buffer.append("'");
            } else {
                this.appendEscapedString(string);
            }
        }
        return this;
    }

    public SequenceEncoder append(char c) {
        return this.append(String.valueOf(c));
    }

    public SequenceEncoder append(int n) {
        return this.append(String.valueOf(n));
    }

    public SequenceEncoder append(long l) {
        return this.append(String.valueOf(l));
    }

    public SequenceEncoder append(double d) {
        return this.append(String.valueOf(d));
    }

    public SequenceEncoder append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public SequenceEncoder append(KeyStroke keyStroke) {
        return this.append(HotKeyConfigurer.encode(keyStroke));
    }

    public SequenceEncoder append(NamedKeyStroke namedKeyStroke) {
        return this.append(NamedHotKeyConfigurer.encode(namedKeyStroke));
    }

    public SequenceEncoder append(Color color) {
        return this.append(ColorConfigurer.colorToString(color));
    }

    public SequenceEncoder append(String[] stringArray) {
        return this.append(StringArrayConfigurer.arrayToString(stringArray));
    }

    public SequenceEncoder append(PropertyExpression propertyExpression) {
        return this.append(propertyExpression.getExpression());
    }

    public String getValue() {
        return this.buffer != null ? this.buffer.toString() : null;
    }

    private void appendEscapedString(String string) {
        int n = 0;
        int n2 = string.indexOf(this.delimit);
        while (n <= n2) {
            this.buffer.append(string.substring(n, n2)).append('\\');
            n = n2;
            n2 = string.indexOf(this.delimit, n2 + 1);
        }
        this.buffer.append(string.substring(n));
    }

    public static void main(String[] stringArray) {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (int i = 0; i < stringArray.length; ++i) {
            sequenceEncoder.append(stringArray[i]);
        }
        System.out.println(sequenceEncoder.getValue());
        Decoder decoder = new Decoder(sequenceEncoder.getValue(), ',');
        while (decoder.hasMoreTokens()) {
            System.out.println(decoder.nextToken());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Decoder
    implements Iterator<String> {
        private String val;
        private final char delimit;

        public Decoder(String string, char c) {
            this.val = string;
            this.delimit = c;
        }

        public boolean hasMoreTokens() {
            return this.val != null;
        }

        public String nextToken() {
            String string;
            if (!this.hasMoreTokens()) {
                throw new NoSuchElementException();
            }
            int n = this.val.indexOf(this.delimit);
            if (n < 0) {
                string = this.val;
                this.val = null;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = 0;
                int n3 = n;
                while (n2 < n3 && this.val.charAt(n3 - 1) == '\\') {
                    stringBuilder.append(this.val.substring(n2, n3 - 1));
                    n2 = n3;
                    n3 = this.val.indexOf(this.delimit, n3 + 1);
                }
                if (n3 < 0) {
                    stringBuilder.append(this.val.substring(n2));
                    this.val = null;
                } else {
                    stringBuilder.append(this.val.substring(n2, n3));
                    this.val = n3 >= this.val.length() - 1 ? "" : this.val.substring(n3 + 1);
                }
                string = stringBuilder.toString();
            }
            if (string.startsWith("'") && string.endsWith("'") && string.length() > 1) {
                string = string.substring(1, string.length() - 1);
            }
            return string;
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreTokens();
        }

        @Override
        public String next() {
            return this.nextToken();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Decoder copy() {
            return new Decoder(this.val, this.delimit);
        }

        public int nextInt(int n) {
            if (this.val != null) {
                try {
                    n = Integer.parseInt(this.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return n;
        }

        public long nextLong(long l) {
            if (this.val != null) {
                try {
                    l = Long.parseLong(this.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return l;
        }

        public double nextDouble(double d) {
            if (this.val != null) {
                try {
                    d = Double.parseDouble(this.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return d;
        }

        public boolean nextBoolean(boolean bl) {
            return this.val != null ? "true".equals(this.nextToken()) : bl;
        }

        public char nextChar(char c) {
            if (this.val != null) {
                String string = this.nextToken();
                c = string.length() > 0 ? string.charAt(0) : c;
            }
            return c;
        }

        public KeyStroke nextKeyStroke(char c) {
            return this.nextKeyStroke(KeyStroke.getKeyStroke((int)c, 2));
        }

        public Color nextColor(Color color) {
            if (this.val != null) {
                String string = this.nextToken();
                color = string.length() > 0 ? ColorConfigurer.stringToColor(string) : null;
            }
            return color;
        }

        public KeyStroke nextKeyStroke(KeyStroke keyStroke) {
            if (this.val != null) {
                String string = this.nextToken();
                keyStroke = string.length() == 0 ? null : (string.indexOf(44) < 0 ? KeyStroke.getKeyStroke((int)string.charAt(0), 2) : HotKeyConfigurer.decode(string));
            }
            return keyStroke;
        }

        public NamedKeyStroke nextNamedKeyStroke(char c) {
            return this.nextNamedKeyStroke(NamedKeyStroke.getNamedKeyStroke(c, 2));
        }

        public NamedKeyStroke nextNamedKeyStroke() {
            return this.nextNamedKeyStroke(NamedKeyStroke.NULL_KEYSTROKE);
        }

        public NamedKeyStroke nextNamedKeyStroke(NamedKeyStroke namedKeyStroke) {
            if (this.val != null) {
                String string = this.nextToken();
                namedKeyStroke = string.length() == 0 ? null : (string.indexOf(44) < 0 ? NamedKeyStroke.getNamedKeyStroke(string.charAt(0), 2) : NamedHotKeyConfigurer.decode(string));
            }
            return namedKeyStroke == null ? NamedKeyStroke.NULL_KEYSTROKE : namedKeyStroke;
        }

        public String nextToken(String string) {
            return this.val != null ? this.nextToken() : string;
        }

        public String[] nextStringArray(int n) {
            String[] stringArray = this.val != null ? StringArrayConfigurer.stringToArray(this.nextToken()) : new String[]{};
            if (stringArray.length < n) {
                stringArray = ArrayUtils.copyOf(stringArray, n);
            }
            return stringArray;
        }
    }
}

