/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableUtils {
    private static final Logger logger = LoggerFactory.getLogger(ThrowableUtils.class);

    private ThrowableUtils() {
    }

    public static <T extends Throwable> T getAncestor(Class<T> clazz, Throwable throwable) {
        for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
            if (!clazz.isInstance(throwable2)) continue;
            return (T)((Throwable)clazz.cast(throwable2));
        }
        return null;
    }

    public static <T extends Throwable> T getRecent(Class<T> clazz, Throwable throwable) {
        if (clazz.isInstance(throwable)) {
            return (T)((Throwable)clazz.cast(throwable));
        }
        return ThrowableUtils.getAncestor(clazz, throwable);
    }

    public static <T extends Throwable> void throwAncestor(Class<T> clazz, Throwable throwable) throws T {
        T t = ThrowableUtils.getAncestor(clazz, throwable);
        if (t != null) {
            ThrowableUtils.throwMe(clazz, throwable);
        }
    }

    public static <T extends Throwable> void throwRecent(Class<T> clazz, Throwable throwable) throws T {
        if (clazz.isInstance(throwable)) {
            ThrowableUtils.throwMe(clazz, throwable);
        } else {
            ThrowableUtils.throwAncestor(clazz, throwable);
        }
    }

    private static <T extends Throwable> void throwMe(Class<T> clazz, Throwable throwable) throws T {
        Throwable throwable2 = null;
        try {
            throwable2 = (Throwable)clazz.cast(((Throwable)clazz.getConstructor(new Class[0]).newInstance(new Object[0])).initCause(throwable));
        }
        catch (Throwable throwable3) {
            logger.warn("ignored", throwable3);
        }
        if (throwable2 != null) {
            throw throwable2;
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }
}

