/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.zip.ZipFile;
import javax.imageio.stream.ImageInputStream;

public class IOUtils
extends org.apache.commons.io.IOUtils {
    protected IOUtils() {
    }

    public static int copy(FileInputStream fileInputStream, FileOutputStream fileOutputStream) throws IOException {
        long l = IOUtils.copyLarge(fileInputStream, fileOutputStream);
        return l > Integer.MAX_VALUE ? -1 : (int)l;
    }

    public static long copyLarge(FileInputStream fileInputStream, FileOutputStream fileOutputStream) throws IOException {
        FileChannel fileChannel = fileInputStream.getChannel();
        return fileChannel.transferTo(0L, fileChannel.size(), fileOutputStream.getChannel());
    }

    public static int copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        long l = IOUtils.copyLarge(inputStream, outputStream, byArray);
        return l > Integer.MAX_VALUE ? -1 : (int)l;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        long l = 0L;
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static void closeQuietly(ObjectInput objectInput) {
        if (objectInput == null) {
            return;
        }
        try {
            objectInput.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ObjectOutput objectOutput) {
        if (objectOutput == null) {
            return;
        }
        try {
            objectOutput.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ImageInputStream imageInputStream) {
        if (imageInputStream == null) {
            return;
        }
        try {
            imageInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

