/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import VASSAL.tools.concurrent.RunnableFuture;
import VASSAL.tools.swing.EDTRunnableFuture;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDTExecutorService
extends AbstractExecutorService {
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final ReentrantLock lock = new ReentrantLock();
    protected final EDTRunnableFuture<Void> poison_pill = new EDTRunnableFuture<Void>(){

        @Override
        protected void runOnEDT() {
        }
    };

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.isTerminated()) {
                boolean bl = true;
                return bl;
            }
            this.poison_pill.get(l, timeUnit);
            boolean bl = true;
            return bl;
        }
        catch (TimeoutException timeoutException) {
            boolean bl = false;
            return bl;
        }
        catch (CancellationException cancellationException) {
            throw new IllegalStateException(cancellationException);
        }
        catch (ExecutionException executionException) {
            throw new IllegalStateException(executionException);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown.get() && this.poison_pill.isDone();
    }

    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            if (this.shutdown.get()) {
                return;
            }
            this.submit(this.poison_pill);
            this.shutdown.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    protected <T> RunnableFuture<T> newTask(final Callable<T> callable) {
        return new EDTRunnableFuture<T>(){

            @Override
            protected void runOnEDT() throws Exception {
                this.result = callable.call();
            }
        };
    }

    protected <T> RunnableFuture<T> newTask(final Runnable runnable, T t) {
        return new EDTRunnableFuture<T>(t){

            @Override
            protected void runOnEDT() {
                runnable.run();
            }
        };
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture<Object> runnableFuture = this.newTask(runnable, null);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> runnableFuture = this.newTask(runnable, t);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> runnableFuture = this.newTask(callable);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    public <T> EDTRunnableFuture<T> submit(EDTRunnableFuture<T> eDTRunnableFuture) {
        this.execute(eDTRunnableFuture);
        return eDTRunnableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        if (collection == null) {
            throw new NullPointerException();
        }
        ArrayList<RunnableFuture<T>> arrayList = new ArrayList<RunnableFuture<T>>(collection.size());
        boolean bl = false;
        try {
            for (Callable<T> object : collection) {
                RunnableFuture<T> runnableFuture = this.newTask(object);
                arrayList.add(runnableFuture);
                this.execute(runnableFuture);
            }
            for (Future future : arrayList) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
            bl = true;
            ArrayList<RunnableFuture<T>> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (!bl) {
                for (Future future : arrayList) {
                    future.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (timeUnit == null) {
            throw new NullPointerException();
        }
        long l2 = timeUnit.toNanos(l);
        ArrayList<Future<T>> arrayList = new ArrayList<Future<T>>(collection.size());
        boolean bl = false;
        try {
            for (Callable<T> callable : collection) {
                arrayList.add(this.newTask(callable));
            }
            long l3 = System.nanoTime();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.execute((Runnable)iterator.next());
                long l4 = System.nanoTime();
                l3 = l4;
                if ((l2 -= l4 - l3) > 0L) continue;
                ArrayList<Future<T>> arrayList2 = arrayList;
                return arrayList2;
            }
            for (Future object : arrayList) {
                if (object.isDone()) continue;
                if (l2 <= 0L) {
                    ArrayList<Future<T>> arrayList3 = arrayList;
                    return arrayList3;
                }
                try {
                    object.get(l2, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {
                }
                catch (TimeoutException timeoutException) {
                    ArrayList<Future<T>> arrayList4 = arrayList;
                    if (!bl) {
                        for (Future future : arrayList) {
                            future.cancel(true);
                        }
                    }
                    return arrayList4;
                }
                long l5 = System.nanoTime();
                l2 -= l5 - l3;
                l3 = l5;
            }
            bl = true;
            ArrayList<Future<T>> arrayList5 = arrayList;
            return arrayList5;
        }
        finally {
            if (!bl) {
                for (Future future : arrayList) {
                    future.cancel(true);
                }
            }
        }
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            if (this.shutdown.get()) {
                throw new RejectedExecutionException();
            }
            EventQueue.invokeLater(runnable);
        }
        finally {
            this.lock.unlock();
        }
    }
}

