/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.POIDocument;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hwpf.model.CHPBinTable;
import org.apache.poi.hwpf.model.FibBase;
import org.apache.poi.hwpf.model.FileInformationBlock;
import org.apache.poi.hwpf.model.FontTable;
import org.apache.poi.hwpf.model.ListTables;
import org.apache.poi.hwpf.model.PAPBinTable;
import org.apache.poi.hwpf.model.SectionTable;
import org.apache.poi.hwpf.model.StyleSheet;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.hwpf.usermodel.ObjectPoolImpl;
import org.apache.poi.hwpf.usermodel.ObjectsPool;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.poifs.crypt.ChunkedCipherInputStream;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.BoundedInputStream;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndianByteArrayInputStream;
import org.apache.poi.util.LittleEndianInput;

public abstract class HWPFDocumentCore
extends POIDocument {
    protected static final String STREAM_OBJECT_POOL = "ObjectPool";
    protected static final String STREAM_WORD_DOCUMENT = "WordDocument";
    protected static final String STREAM_TABLE_0 = "0Table";
    protected static final String STREAM_TABLE_1 = "1Table";
    protected static final int FIB_BASE_LEN = 68;
    protected static final int RC4_REKEYING_INTERVAL = 512;
    protected ObjectPoolImpl _objectPool;
    protected FileInformationBlock _fib;
    protected StyleSheet _ss;
    protected CHPBinTable _cbt;
    protected PAPBinTable _pbt;
    protected SectionTable _st;
    protected FontTable _ft;
    protected ListTables _lt;
    protected byte[] _mainStream;
    private EncryptionInfo _encryptionInfo;

    protected HWPFDocumentCore() {
        super((DirectoryNode)null);
    }

    public static POIFSFileSystem verifyAndBuildPOIFS(InputStream istream) throws IOException {
        InputStream is = FileMagic.prepareToCheckMagic((InputStream)istream);
        FileMagic fm = FileMagic.valueOf((InputStream)is);
        if (fm != FileMagic.OLE2) {
            throw new IllegalArgumentException("The document is really a " + fm + " file");
        }
        return new POIFSFileSystem(is);
    }

    public HWPFDocumentCore(InputStream istream) throws IOException {
        this(HWPFDocumentCore.verifyAndBuildPOIFS(istream));
    }

    public HWPFDocumentCore(POIFSFileSystem pfilesystem) throws IOException {
        this(pfilesystem.getRoot());
    }

    public HWPFDocumentCore(DirectoryNode directory) throws IOException {
        super(directory);
        this._mainStream = this.getDocumentEntryBytes(STREAM_WORD_DOCUMENT, 68, Integer.MAX_VALUE);
        this._fib = new FileInformationBlock(this._mainStream);
        DirectoryEntry objectPoolEntry = null;
        if (directory.hasEntry(STREAM_OBJECT_POOL)) {
            objectPoolEntry = (DirectoryEntry)directory.getEntry(STREAM_OBJECT_POOL);
        }
        this._objectPool = new ObjectPoolImpl(objectPoolEntry);
    }

    public abstract Range getRange();

    public abstract Range getOverallRange();

    public String getDocumentText() {
        return this.getText().toString();
    }

    @Internal
    public abstract StringBuilder getText();

    public CHPBinTable getCharacterTable() {
        return this._cbt;
    }

    public PAPBinTable getParagraphTable() {
        return this._pbt;
    }

    public SectionTable getSectionTable() {
        return this._st;
    }

    public StyleSheet getStyleSheet() {
        return this._ss;
    }

    public ListTables getListTables() {
        return this._lt;
    }

    public FontTable getFontTable() {
        return this._ft;
    }

    public FileInformationBlock getFileInformationBlock() {
        return this._fib;
    }

    public ObjectsPool getObjectsPool() {
        return this._objectPool;
    }

    public abstract TextPieceTable getTextTable();

    @Internal
    public byte[] getMainStream() {
        return this._mainStream;
    }

    public EncryptionInfo getEncryptionInfo() throws IOException {
        FibBase fibBase;
        if (this._encryptionInfo != null) {
            return this._encryptionInfo;
        }
        if (this._fib != null && this._fib.getFibBase() != null) {
            fibBase = this._fib.getFibBase();
        } else {
            byte[] fibBaseBytes = this._mainStream != null ? this._mainStream : this.getDocumentEntryBytes(STREAM_WORD_DOCUMENT, -1, 68);
            fibBase = new FibBase(fibBaseBytes, 0);
        }
        if (!fibBase.isFEncrypted()) {
            return null;
        }
        String tableStrmName = fibBase.isFWhichTblStm() ? STREAM_TABLE_1 : STREAM_TABLE_0;
        byte[] tableStream = this.getDocumentEntryBytes(tableStrmName, -1, fibBase.getLKey());
        LittleEndianByteArrayInputStream leis = new LittleEndianByteArrayInputStream(tableStream);
        EncryptionMode em = fibBase.isFObfuscated() ? EncryptionMode.xor : null;
        EncryptionInfo ei = new EncryptionInfo((LittleEndianInput)leis, em);
        Decryptor dec = ei.getDecryptor();
        dec.setChunkSize(512);
        try {
            String pass = Biff8EncryptionKey.getCurrentUserPassword();
            if (pass == null) {
                pass = "VelvetSweatshop";
            }
            if (!dec.verifyPassword(pass)) {
                throw new EncryptedDocumentException("document is encrypted, password is invalid - use Biff8EncryptionKey.setCurrentUserPasswort() to set password before opening");
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage(), e);
        }
        this._encryptionInfo = ei;
        return ei;
    }

    protected void updateEncryptionInfo() {
        this.readProperties();
        String password = Biff8EncryptionKey.getCurrentUserPassword();
        FibBase fBase = this._fib.getFibBase();
        if (password == null) {
            fBase.setLKey(0);
            fBase.setFEncrypted(false);
            fBase.setFObfuscated(false);
            this._encryptionInfo = null;
        } else {
            if (this._encryptionInfo == null) {
                this._encryptionInfo = new EncryptionInfo(EncryptionMode.cryptoAPI);
                fBase.setFEncrypted(true);
                fBase.setFObfuscated(false);
            }
            Encryptor enc = this._encryptionInfo.getEncryptor();
            byte[] salt = this._encryptionInfo.getVerifier().getSalt();
            if (salt == null) {
                enc.confirmPassword(password);
            } else {
                byte[] verifier = this._encryptionInfo.getDecryptor().getVerifier();
                enc.confirmPassword(password, null, null, verifier, salt, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getDocumentEntryBytes(String name, int encryptionOffset, int len) throws IOException {
        DirectoryNode dir = this.getDirectory();
        DocumentEntry documentProps = (DocumentEntry)dir.getEntry(name);
        DocumentInputStream dis = dir.createDocumentInputStream((Entry)documentProps);
        EncryptionInfo ei = encryptionOffset > -1 ? this.getEncryptionInfo() : null;
        int streamSize = documentProps.getSize();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(Math.min(streamSize, len));
        Object is = dis;
        try {
            if (ei != null) {
                try {
                    Decryptor dec = ei.getDecryptor();
                    is = dec.getDataStream((InputStream)dis, streamSize, 0);
                    if (encryptionOffset > 0) {
                        ChunkedCipherInputStream cis = (ChunkedCipherInputStream)is;
                        byte[] plain = new byte[encryptionOffset];
                        cis.readPlain(plain, 0, encryptionOffset);
                        bos.write(plain);
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            if (len < Integer.MAX_VALUE) {
                is = new BoundedInputStream((InputStream)is, (long)len);
            }
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((Closeable)is);
            IOUtils.closeQuietly((Closeable)dis);
        }
    }
}

