/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.handler.component.StatsField;
import org.apache.solr.handler.component.StatsInfo;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.search.DocSet;

public class StatsComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "stats";

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.req.getParams().getBool(COMPONENT_NAME, false)) {
            rb.setNeedDocSet(true);
            rb.doStats = true;
            rb._statsInfo = new StatsInfo(rb);
            for (StatsField statsField : rb._statsInfo.getStatsFields()) {
                if (statsField.getSchemaField() == null || !statsField.getSchemaField().getType().isPointField() || statsField.getSchemaField().hasDocValues()) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't calculate stats on a PointField without docValues");
            }
        }
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        if (!rb.doStats) {
            return;
        }
        LinkedHashMap<String, StatsValues> statsValues = new LinkedHashMap<String, StatsValues>();
        for (StatsField statsField : rb._statsInfo.getStatsFields()) {
            DocSet docs = statsField.computeBaseDocSet();
            statsValues.put(statsField.getOutputKey(), statsField.computeLocalStatsValues(docs));
        }
        rb.rsp.add(COMPONENT_NAME, StatsComponent.convertToResponse(statsValues));
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        if (!rb.doStats) {
            return;
        }
        if ((sreq.purpose & 4) != 0) {
            sreq.purpose |= 0x200;
        } else {
            sreq.params.set(COMPONENT_NAME, new String[]{"false"});
        }
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!rb.doStats || (sreq.purpose & 0x200) == 0) {
            return;
        }
        Map<String, StatsValues> allStatsValues = rb._statsInfo.getAggregateStatsValues();
        for (ShardResponse srsp : sreq.responses) {
            NamedList stats = null;
            try {
                stats = (NamedList)srsp.getSolrResponse().getResponse().get(COMPONENT_NAME);
            }
            catch (Exception e) {
                if (rb.req.getParams().getBool("shards.tolerant", false)) continue;
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to read stats info for shard: " + srsp.getShard(), (Throwable)e);
            }
            NamedList<NamedList<?>> stats_fields = StatsComponent.unwrapStats(stats);
            if (stats_fields == null) continue;
            for (int i = 0; i < stats_fields.size(); ++i) {
                String key = stats_fields.getName(i);
                StatsValues stv = allStatsValues.get(key);
                NamedList shardStv = (NamedList)stats_fields.get(key);
                stv.accumulate(shardStv);
            }
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (!rb.doStats || rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        Map<String, StatsValues> allStatsValues = rb._statsInfo.getAggregateStatsValues();
        rb.rsp.add(COMPONENT_NAME, StatsComponent.convertToResponse(allStatsValues));
        rb._statsInfo = null;
    }

    public static NamedList<NamedList<?>> unwrapStats(NamedList<NamedList<NamedList<?>>> stats) {
        if (null == stats) {
            return null;
        }
        return (NamedList)stats.get("stats_fields");
    }

    public static NamedList<NamedList<NamedList<?>>> convertToResponse(Map<String, StatsValues> statsValues) {
        SimpleOrderedMap stats = new SimpleOrderedMap();
        SimpleOrderedMap stats_fields = new SimpleOrderedMap();
        stats.add("stats_fields", (Object)stats_fields);
        for (Map.Entry<String, StatsValues> entry : statsValues.entrySet()) {
            String key = entry.getKey();
            NamedList<?> stv = entry.getValue().getStatsValues();
            stats_fields.add(key, stv);
        }
        return stats;
    }

    @Override
    public String getDescription() {
        return "Calculate Statistics";
    }
}

