/*
 * Decompiled with CFR 0.152.
 */
package traer.physics;

import traer.physics.Vector3D;

public class Particle {
    protected Vector3D position;
    protected Vector3D velocity;
    protected Vector3D force;
    protected float mass;
    protected float age;
    protected boolean dead;
    boolean fixed;

    public Particle(float m, Vector3D p) {
        this.position = p;
        this.velocity = new Vector3D();
        this.force = new Vector3D();
        this.mass = m;
        this.fixed = false;
        this.age = 0.0f;
        this.dead = false;
    }

    public final void moveTo(float x, float y, float z) {
        this.position.set(x, y, z);
    }

    public final void moveBy(float x, float y, float z) {
        this.position.x += x;
        this.position.y += y;
        this.position.z += z;
    }

    public final void addVelocity(float x, float y, float z) {
        this.velocity.x += x;
        this.velocity.y += y;
        this.velocity.z += z;
    }

    public final void setForce(float x, float y, float z) {
        this.force.set(x, y, z);
    }

    public final void makeFixed() {
        this.fixed = true;
        this.velocity.clear();
    }

    public final boolean isFixed() {
        return this.fixed;
    }

    public final boolean isFree() {
        return !this.fixed;
    }

    public final void makeFree() {
        this.fixed = false;
    }

    public final Vector3D position() {
        return this.position;
    }

    public final void setVelocity(float x, float y, float z) {
        this.velocity.set(x, y, z);
    }

    public final Vector3D velocity() {
        return this.velocity;
    }

    public final float mass() {
        return this.mass;
    }

    public final void setMass(float m) {
        this.mass = m;
    }

    public final Vector3D force() {
        return this.force;
    }

    public final float age() {
        return this.age;
    }

    public final void kill() {
        this.dead = true;
    }

    public final boolean isDead() {
        return this.dead;
    }
}

