/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.BooleanEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class NotEvaluator
extends BooleanEvaluator {
    protected static final long serialVersionUID = 1L;

    public NotEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.subEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting one value but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public Boolean evaluate(Tuple tuple) throws IOException {
        List<Object> results = this.evaluateAll(tuple);
        if (1 != results.size()) {
            String message = String.format(Locale.ROOT, "%s(...) only works with 1 value but %d were provided", this.constructingFactory.getFunctionName(this.getClass()), results.size());
            throw new IOException(message);
        }
        Object result = results.get(0);
        if (null == result) {
            throw new IOException(String.format(Locale.ROOT, "Unable to evaluate %s(...) because a null value was found", this.constructingFactory.getFunctionName(this.getClass())));
        }
        if (!(result instanceof Boolean)) {
            throw new IOException(String.format(Locale.ROOT, "Unable to evaluate %s(...) of a non-boolean value [%s]", this.constructingFactory.getFunctionName(this.getClass()), results.stream().map(item -> item.getClass().getSimpleName()).collect(Collectors.joining(","))));
        }
        return (Boolean)result == false;
    }
}

