/*
 * This file contains D-Bus adaptor classes generated by qt-svc-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#include <TelepathyQt/AbstractAdaptor>
#include <TelepathyQt/Global>
#include <TelepathyQt/Types>

#include <QObject>
#include <QtDBus>

namespace Tp
{
namespace Service
{

/**
 * \class ChannelAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel".
 */
class TP_QT_EXPORT ChannelAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel\">\n"
"    <property access=\"read\" type=\"s\" name=\"ChannelType\"/>\n"
"    <property access=\"read\" type=\"as\" name=\"Interfaces\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"TargetHandle\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"TargetID\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"TargetHandleType\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"Requested\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"InitiatorHandle\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"InitiatorID\"/>\n"
"    <method name=\"Close\"/>\n"
"    <method name=\"GetChannelType\">\n"
"      <arg direction=\"out\" type=\"s\" name=\"channelType\"/>\n"
"    </method>\n"
"    <method name=\"GetHandle\">\n"
"      <arg direction=\"out\" type=\"u\" name=\"targetHandleType\"/>\n"
"      <arg direction=\"out\" type=\"u\" name=\"targetHandle\"/>\n"
"    </method>\n"
"    <method name=\"GetInterfaces\">\n"
"      <arg direction=\"out\" type=\"as\" name=\"interfaces\"/>\n"
"    </method>\n"
"    <signal name=\"Closed\"/>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QString ChannelType READ ChannelType )
    Q_PROPERTY(QStringList Interfaces READ Interfaces )
    Q_PROPERTY(uint TargetHandle READ TargetHandle )
    Q_PROPERTY(QString TargetID READ TargetID )
    Q_PROPERTY(uint TargetHandleType READ TargetHandleType )
    Q_PROPERTY(bool Requested READ Requested )
    Q_PROPERTY(uint InitiatorHandle READ InitiatorHandle )
    Q_PROPERTY(QString InitiatorID READ InitiatorID )

public:
    ChannelAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > CloseContextPtr;
    typedef Tp::MethodInvocationContextPtr< QString > GetChannelTypeContextPtr;
    typedef Tp::MethodInvocationContextPtr< uint, uint > GetHandleContextPtr;
    typedef Tp::MethodInvocationContextPtr< QStringList > GetInterfacesContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c ChannelType of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'channelType' with type QString.
     *
     * 
     * \htmlonly
     * <p>The channel's type. This cannot change once the channel has
     *   been created.</p>
     * 
     * <p>For compatibility between older connection managers and newer
     *   clients, if this is unavailable or is an empty string,
     *   clients MUST use the result of calling
     *    \endhtmlonly GetChannelType() \htmlonly .</p>
     * 
     * <div class="rationale">
     *   The GetAll method lets clients retrieve all properties in one
     *   round-trip, which is desirable.
     * </div>
     * 
     * <p>When requesting a channel, the request MUST specify a channel
     *   type, and the request MUST fail if the specified channel type
     *   cannot be supplied.</p>
     * 
     * <div class="rationale">
     *   Common sense.
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c ChannelType.
     */
    QString ChannelType() const;
    /**
     * Return the value of the exported D-Bus object property \c Interfaces of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'interfaces' with type QStringList.
     *
     * 
     * \htmlonly
     * <p>Extra interfaces provided by this channel. This SHOULD NOT include
     *   the channel type and the Channel interface itself, and cannot
     *   change once the channel has been created.</p>
     * 
     * <p>For compatibility between older connection managers and newer
     *   clients, if this is unavailable, or if this is an empty list and
     *    \endhtmlonly \link requestPropertyChannelType() ChannelType \endlink \htmlonly  is an empty string,
     *   clients MUST use the result of calling
     *    \endhtmlonly GetInterfaces() \htmlonly  instead. If this is an
     *   empty list but ChannelType is non-empty, clients SHOULD NOT call
     *   GetInterfaces; this implies that connection managers that implement
     *   the ChannelType property MUST also implement the Interfaces property
     *   correctly.</p>
     * 
     * <div class="rationale">
     *   The GetAll method lets clients retrieve all properties in one
     *   round-trip, which is desirable.
     * </div>
     * 
     * <p>When requesting a channel with a particular value for this
     *   property, the request must fail without side-effects unless the
     *   connection manager expects to be able to provide a channel whose
     *   interfaces include at least the interfaces requested.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Interfaces.
     */
    QStringList Interfaces() const;
    /**
     * Return the value of the exported D-Bus object property \c TargetHandle of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'targetHandle' with type uint.
     *
     * 
     * \htmlonly
     * <p>The handle (a representation for the identifier) of the contact,
     *   chatroom, etc. with which this handle communicates. Its type
     *   is given by the  \endhtmlonly \link requestPropertyTargetHandleType() TargetHandleType \endlink \htmlonly 
     *   property.</p>
     * 
     * <p>This is fixed for the lifetime of the channel, so channels which
     *   could potentially be used to communicate with multiple contacts,
     *   and do not have an identity of their own (such as a Handle_Type_Room
     *   handle), must have TargetHandleType set to Handle_Type_None and
     *   TargetHandle set to 0.</p>
     * 
     * <p>Unlike in the telepathy-spec 0.16 API, there is no particular
     *   uniqueness guarantee - there can be many channels with the same
     *   (channel type, handle type, handle) tuple. This is necessary
     *   to support conversation threads in XMPP and SIP, for example.</p>
     * 
     * <p>If this is present in a channel request, it must be nonzero,
     *    \endhtmlonly \link requestPropertyTargetHandleType() TargetHandleType \endlink \htmlonly 
     *   MUST be present and not Handle_Type_None, and
     *    \endhtmlonly \link requestPropertyTargetID() TargetID \endlink \htmlonly  MUST NOT be
     *   present. Properties from
     *    \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.Addressing1 \htmlonly 
     *   MUST NOT be present.</p>
     * 
     * <p>The channel that satisfies the request MUST either:</p>
     * 
     * <ul>
     *   <li>have the specified TargetHandle property; or</li>
     *   <li>have  \endhtmlonly \link requestPropertyTargetHandleType() TargetHandleType \endlink \htmlonly  =
     *     Handle_Type_None, TargetHandle = 0, and be configured such that
     *     it could communicate with the specified handle in some other way
     *     (e.g. have the requested contact handle in its Group
     *     interface)</li>
     * </ul>
     * \endhtmlonly
     *
     * \return The value of exported property \c TargetHandle.
     */
    uint TargetHandle() const;
    /**
     * Return the value of the exported D-Bus object property \c TargetID of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'targetID' with type QString.
     *
     * 
     * \htmlonly
     * <p>The string that would result from inspecting the
     *    \endhtmlonly \link requestPropertyTargetHandle() TargetHandle \endlink \htmlonly 
     *   property (i.e. the identifier in the IM protocol of the contact,
     *   room, etc. with which this channel communicates), or the empty
     *   string if the TargetHandle is 0.</p>
     * 
     * <div class="rationale">
     *   <p>The presence of this property avoids the following race
     *     condition:</p>
     * 
     *   <ul>
     *     <li>New channel C is signalled with target handle T</li>
     *     <li>Client calls  \endhtmlonly ConnectionInterface::InspectHandles() \htmlonly (CONTACT,
     *       [T])</li>
     *     <li>Channel C closes, removing the last reference to handle T</li>
     *     <li> \endhtmlonly ConnectionInterface::InspectHandles() \htmlonly (CONTACT,
     *       [T]) returns an error</li>
     *   </ul>
     * </div>
     * 
     * <p>If this is present in a channel request,
     *    \endhtmlonly \link requestPropertyTargetHandleType() TargetHandleType \endlink \htmlonly 
     *   MUST be present and not Handle_Type_None, and
     *    \endhtmlonly \link requestPropertyTargetHandle() TargetHandle \endlink \htmlonly  MUST NOT be
     *   present. Properties from
     *    \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.Addressing1 \htmlonly 
     *   MUST NOT be present.The request MUST fail with error InvalidHandle,
     *   without side-effects, if the requested TargetID would not be
     *   accepted by
     *    \endhtmlonly ConnectionInterface::RequestHandles() \htmlonly .</p>
     * 
     * <p>The returned channel must be related to the handle corresponding
     *   to the given identifier, in the same way as if TargetHandle
     *   had been part of the request instead.</p>
     * 
     * <div class="rationale">
     *   <p>Requesting channels with a string identifier saves a round-trip
     *     (the call to RequestHandles). It also allows the channel
     *     dispatcher to accept a channel request for an account that is not
     *     yet connected (and thus has no valid handles), bring the account
     *     online, and pass on the same parameters to the new connection's
     *     CreateChannel method.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c TargetID.
     */
    QString TargetID() const;
    /**
     * Return the value of the exported D-Bus object property \c TargetHandleType of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'targetHandleType' with type uint.
     *
     * 
     * \htmlonly
     * <p>The type of  \endhtmlonly \link requestPropertyTargetHandle() TargetHandle \endlink \htmlonly .</p>
     * 
     * <p>If this is omitted from a channel request, connection managers
     *   SHOULD treat this as equivalent to Handle_Type_None.</p>
     * 
     * <p>If this is omitted or is Handle_Type_None,
     *    \endhtmlonly \link requestPropertyTargetHandle() TargetHandle \endlink \htmlonly  and
     *    \endhtmlonly \link requestPropertyTargetID() TargetID \endlink \htmlonly  MUST be omitted from the
     *   request.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c TargetHandleType.
     */
    uint TargetHandleType() const;
    /**
     * Return the value of the exported D-Bus object property \c Requested of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'requested' with type bool.
     *
     * 
     * \htmlonly
     * <p>True if this channel was created in response to a local request,
     *   such as a call to
     *    \endhtmlonly ConnectionInterface::RequestChannel() \htmlonly 
     *   or
     *    \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly .</p>
     * 
     * <div class="rationale">
     *   <p>The idea of this property is to distinguish between &quot;incoming&quot;
     *     and &quot;outgoing&quot; channels, in a way that doesn't break down when
     *     considering special cases like contact lists that are automatically
     *     created on connection to the server, or chatrooms that an
     *     IRC proxy/bouncer like irssi-proxy or bip was already in.</p>
     * 
     *   <p>The reason we want to make that distinction is that UIs for
     *     things that the user explicitly requested should start up
     *     automatically, whereas for incoming messages and VoIP calls we
     *     should first ask the user whether they want to open the messaging
     *     UI or accept the call.</p>
     * </div>
     * 
     * <p>If the channel was not explicitly requested (even if it was
     *   created as a side-effect of a call to one of those functions,
     *   e.g. because joining a Tube in a MUC context on XMPP implies
     *   joining that MUC), then this property is false.</p>
     * 
     * <p>For compatibility with older connection managers, clients SHOULD
     *   assume that this property is true if they see a channel announced
     *   by the
     *    \endhtmlonly ConnectionInterface::NewChannel() \htmlonly 
     *   signal with the suppress_handler parameter set to true.</p>
     * 
     * <div class="rationale">
     *   <p>In a correct connection manager, the only way to get such a
     *     channel is to request it.</p>
     * </div>
     * 
     * <p>Clients MAY additionally assume that this property is false
     *   if they see a channel announced by the NewChannel signal with the
     *   suppress_handler parameter set to false.</p>
     * 
     * <div class="rationale">
     *   <p>This is more controversial, since it's possible to get that
     *     parameter set to false by requesting a channel. However, there's
     *     no good reason to do so, and we've deprecated this practice.</p>
     * 
     *   <p>In the particular case of the channel dispatcher, the only
     *     side-effect of wrongly thinking a channel is unrequested
     *     is likely to be that the user has to confirm that they want to
     *     use it, so it seems fairly harmless to assume in the channel
     *     dispatcher that channels with suppress_handler false are
     *     indeed unrequested.</p>
     * </div>
     * 
     * <p>It does not make sense for this property to be in channel
     *   requests—it will always be true for channels returned by
     *   CreateChannel, and callers of EnsureChannel cannot control whether an
     *   existing channel was originally requested locally—so it MUST NOT
     *   be accepted.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Requested.
     */
    bool Requested() const;
    /**
     * Return the value of the exported D-Bus object property \c InitiatorHandle of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'initiatorHandle' with type uint.
     *
     * 
     * \htmlonly
     * <p>The contact who initiated the channel; for instance, the contact
     *   who invited the local user to a chatroom, or the contact who
     *   initiated a call.</p>
     * 
     * <p>This does <em>not</em> necessarily represent the contact who
     *   created the underlying protocol-level construct. For instance, if
     *   Rob creates a chatroom, Will joins that chatroom, and Will invites Simon
     *   to join it, then Simon will see Will as the InitiatorHandle of the
     *   channel representing the chatroom.</p>
     * 
     * <div class="rationale">
     *   <p>The room creator is generally a less useful piece of information
     *     than the inviter, is less likely to be available at invitation
     *     time (i.e. can't necessarily be an immutable property), and is
     *     less likely to be available at all. The creator of a chatroom
     *     is not currently available via Telepathy; if added in future, it
     *     is likely to be made available as a property on the Chatroom
     *     interface (<a href="http://bugs.freedesktop.org/show_bug.cgi?id=23151">bug 23151</a>).</p>
     * </div>
     * 
     * <p>For channels requested by the
     *   local user, this MUST be the value of
     *    \endhtmlonly \link ConnectionInterface::requestPropertySelfHandle() ConnectionInterface::SelfHandle \endlink \htmlonly 
     *   at the time the channel was created (i.e. not a channel-specific
     *   handle).</p>
     * 
     * <div class="rationale">
     *   <p>On some protocols, the SelfHandle may change (as signalled by
     *      \endhtmlonly ConnectionInterface::SelfContactChanged() \htmlonly ),
     *     but this property is immutable. Hence, locally-requested channels'
     *     InitiatorHandle and InitiatorID may not match the current
     *     SelfHandle;  \endhtmlonly \link requestPropertyRequested() Requested \endlink \htmlonly  can be used to
     *     determine whether the channel was created locally.</p>
     * </div>
     * 
     * <p>For channels requested by a remote user, this MUST be their handle.
     *   If unavailable or not applicable, this MUST be 0 (for instance,
     *   contact lists are not really initiated by anyone in particular, and
     *   it's easy to imagine a protocol where chatroom invitations can be
     *   anonymous).</p>
     * 
     * <p>For channels with the  \endhtmlonly ChannelInterfaceGroupInterface \htmlonly 
     *   interface, this SHOULD be the same
     *   contact who is signalled as the &quot;Actor&quot; causing the self-handle
     *   to be placed in the local-pending set.</p>
     * 
     * <p>This SHOULD NOT be a channel-specific handle, if possible.</p>
     * 
     * <p>It does not make sense for this property to be in channel
     *   requests - the initiator will always be the local user - so it
     *   MUST NOT be accepted.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c InitiatorHandle.
     */
    uint InitiatorHandle() const;
    /**
     * Return the value of the exported D-Bus object property \c InitiatorID of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'initiatorID' with type QString.
     *
     * 
     * \htmlonly
     * <p>The string that would result from inspecting the
     *    \endhtmlonly \link requestPropertyInitiatorHandle() InitiatorHandle \endlink \htmlonly 
     *   property (i.e. the initiator's identifier in the IM protocol).</p>
     * 
     * <div class="rationale">
     *   <p>The presence of this property avoids the following race
     *     condition:</p>
     * 
     *   <ul>
     *     <li>New StreamedMedia channel C is signalled with initiator
     *       handle I</li>
     *     <li>Client calls  \endhtmlonly ConnectionInterface::InspectHandles() \htmlonly (CONTACT,
     *       [I])</li>
     *     <li>Channel C closes, removing the last reference to handle I</li>
     *     <li> \endhtmlonly ConnectionInterface::InspectHandles() \htmlonly (CONTACT,
     *       [I]) returns an error</li>
     *     <li>Client can indicate that a call was missed, but not who
     *       called!</li>
     *   </ul>
     * </div>
     * 
     * <p>It does not make sense for this property to be in channel
     *   requests - the initiator will always be the local user - so it
     *   MUST NOT be accepted.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c InitiatorID.
     */
    QString InitiatorID() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c Close on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void close(const Tp::Service::ChannelAdaptor::CloseContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Request that the channel be closed. This is not the case until the 
     * Closed signal has been emitted, and depending on the connection manager 
     * this may simply remove you from the channel on the server, rather than 
     * causing it to stop existing entirely. Some channels such as contact 
     * list channels may not be closed.
     *
     */
    void Close(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetChannelType on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getChannelType(const Tp::Service::ChannelAdaptor::GetChannelTypeContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Returns the interface name for the type of this channel. Clients SHOULD 
     * use the ChannelType property instead, falling back to this method only 
     * if necessary. The GetAll method lets clients retrieve all properties in 
     * one round-trip.
     *
     * \return
     *     
     *     The interface name
     */
    QString GetChannelType(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetHandle on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getHandle(const Tp::Service::ChannelAdaptor::GetHandleContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Returns the handle type and number if this channel represents a 
     * communication with a particular contact, room or server-stored list, or 
     * zero if it is transient and defined only by its contents. Clients 
     * SHOULD use the TargetHandle and TargetHandleType properties instead, 
     * falling back to this method only if necessary. The GetAll method lets 
     * clients retrieve all properties in one round-trip.
     *
     * \param targetHandle Output parameter
     *     
     *     The same as TargetHandle.
     * \return
     *     
     *     The same as TargetHandleType.
     */
    uint GetHandle(const QDBusMessage& dbusMessage, uint& targetHandle);
    /**
     * Begins a call to the exported D-Bus method \c GetInterfaces on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getInterfaces(const Tp::Service::ChannelAdaptor::GetInterfacesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Get the optional interfaces implemented by the channel. Clients SHOULD 
     * use the Interfaces property instead, falling back to this method only 
     * if necessary. The GetAll method lets clients retrieve all properties in 
     * one round-trip.
     *
     * \return
     *     
     *     An array of the D-Bus interface names
     */
    QStringList GetInterfaces(const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c Closed on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void closed();
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     */
    void Closed();
};

/**
 * \class ChannelInterfaceAnonymityAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Anonymity".
 */
class TP_QT_EXPORT ChannelInterfaceAnonymityAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.Anonymity")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.Anonymity\">\n"
"    <property access=\"read\" type=\"u\" name=\"AnonymityModes\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"AnonymityMandatory\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"AnonymousID\"/>\n"
"  </interface>\n"
"")
    Q_PROPERTY(uint AnonymityModes READ AnonymityModes )
    Q_PROPERTY(bool AnonymityMandatory READ AnonymityMandatory )
    Q_PROPERTY(QString AnonymousID READ AnonymousID )

public:
    ChannelInterfaceAnonymityAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceAnonymityAdaptor();


public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c AnonymityModes of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'anonymityModes' with type uint.
     *
     * 
     * \htmlonly
     * The list of initially requested anonymity modes on the channel.  This
     * MUST NOT change, and is Requestable.
     * \endhtmlonly
     *
     * \return The value of exported property \c AnonymityModes.
     */
    uint AnonymityModes() const;
    /**
     * Return the value of the exported D-Bus object property \c AnonymityMandatory of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'anonymityMandatory' with type bool.
     *
     * 
     * Whether or not the anonymity settings are required for this channel. 
     * This MUST NOT change, and is Requestable.
     *
     * \return The value of exported property \c AnonymityMandatory.
     */
    bool AnonymityMandatory() const;
    /**
     * Return the value of the exported D-Bus object property \c AnonymousID of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'anonymousID' with type QString.
     *
     * 
     * \htmlonly
     * <p>This is the ID that the remote user of the channel MAY see
     * (assuming there's a single ID).  For example, for SIP connections
     * where the From address has been scrambled by the CM, the scrambled
     * address would be available here for the client to see.  This is
     * completely optional, and MAY be an empty string (&quot;&quot;) in
     * cases where anonymity modes are not set, or the CM doesn't know
     * what the remote contact will see, or any other case where this
     * doesn't make sense.</p>
     * 
     * <p>This MAY change over the lifetime of the channel, and SHOULD NOT
     * be used with the Request interface.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c AnonymousID.
     */
    QString AnonymousID() const;
};

/**
 * \class ChannelInterfaceCallStateAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.CallState".
 */
class TP_QT_EXPORT ChannelInterfaceCallStateAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.CallState")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.CallState\">\n"
"    <method name=\"GetCallStates\">\n"
"      <arg direction=\"out\" type=\"a{uu}\" name=\"states\">\n"
"        <annotation value=\"Tp::ChannelCallStateMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <signal name=\"CallStateChanged\">\n"
"      <arg type=\"u\" name=\"contact\"/>\n"
"      <arg type=\"u\" name=\"state\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")

public:
    ChannelInterfaceCallStateAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceCallStateAdaptor();

    typedef Tp::MethodInvocationContextPtr< Tp::ChannelCallStateMap > GetCallStatesContextPtr;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetCallStates on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getCallStates(const Tp::Service::ChannelInterfaceCallStateAdaptor::GetCallStatesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Get the current call states for all contacts involved in this call.
     *
     * \return
     *     
     *     The current call states. Participants where the call state flags 
     *     would be 0 (all unset) may be omitted from this mapping.
     */
    Tp::ChannelCallStateMap GetCallStates(const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c CallStateChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void callStateChanged(uint contact, uint state);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param contact
     *     
     *     An integer handle for the contact.
     * \param state
     *     
     *     The new state for this contact.
     */
    void CallStateChanged(uint contact, uint state);
};

/**
 * \class ChannelInterfaceCaptchaAuthenticationAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.CaptchaAuthentication1".
 */
class TP_QT_EXPORT ChannelInterfaceCaptchaAuthenticationAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.CaptchaAuthentication1")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.CaptchaAuthentication1\">\n"
"    <property access=\"read\" type=\"b\" name=\"CanRetryCaptcha\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"CaptchaStatus\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"CaptchaError\"/>\n"
"    <property access=\"read\" type=\"a{sv}\" name=\"CaptchaErrorDetails\"/>\n"
"    <method name=\"GetCaptchas\">\n"
"      <arg direction=\"out\" type=\"a(ussuas)\" name=\"captchaInfo\">\n"
"        <annotation value=\"Tp::CaptchaInfoList\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"      <arg direction=\"out\" type=\"u\" name=\"numberRequired\"/>\n"
"      <arg direction=\"out\" type=\"s\" name=\"language\"/>\n"
"    </method>\n"
"    <method name=\"GetCaptchaData\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"ID\"/>\n"
"      <arg direction=\"in\" type=\"s\" name=\"mimeType\"/>\n"
"      <arg direction=\"out\" type=\"ay\" name=\"captchaData\"/>\n"
"    </method>\n"
"    <method name=\"AnswerCaptchas\">\n"
"      <arg direction=\"in\" type=\"a{us}\" name=\"answers\">\n"
"        <annotation value=\"Tp::CaptchaAnswers\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"CancelCaptcha\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"reason\"/>\n"
"      <arg direction=\"in\" type=\"s\" name=\"debugMessage\"/>\n"
"    </method>\n"
"  </interface>\n"
"")
    Q_PROPERTY(bool CanRetryCaptcha READ CanRetryCaptcha )
    Q_PROPERTY(uint CaptchaStatus READ CaptchaStatus )
    Q_PROPERTY(QString CaptchaError READ CaptchaError )
    Q_PROPERTY(QVariantMap CaptchaErrorDetails READ CaptchaErrorDetails )

public:
    ChannelInterfaceCaptchaAuthenticationAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceCaptchaAuthenticationAdaptor();

    typedef Tp::MethodInvocationContextPtr< Tp::CaptchaInfoList, uint, QString > GetCaptchasContextPtr;
    typedef Tp::MethodInvocationContextPtr< QByteArray > GetCaptchaDataContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > AnswerCaptchasContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > CancelCaptchaContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c CanRetryCaptcha of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'canRetryCaptcha' with type bool.
     *
     * 
     * \htmlonly
     * <p>If true,  \endhtmlonly GetCaptchas() \htmlonly 
     *   can be expected to return new captcha information when
     *   in the Local_Pending state. If false,
     *    \endhtmlonly GetCaptchas() \htmlonly  will return
     *   NotAvailable on subsequent calls.</p>
     * 
     * <div class="rationale">
     *   <p>Refreshing the captcha isn't required to work, although
     *     some protocols and implementations allow it. This is usually
     *     done in case a given captcha is unintelligible.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c CanRetryCaptcha.
     */
    bool CanRetryCaptcha() const;
    /**
     * Return the value of the exported D-Bus object property \c CaptchaStatus of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'captchaStatus' with type uint.
     *
     * 
     * \htmlonly
     * <p>The current status of this channel.</p>
     * 
     * <p>Because only the Handler should call methods on this interface,
     *   the Handler MAY reduce round-trips by not fetching the initial
     *   value of this property, and instead assume that is initially
     *   Local_Pending.</p>
     * 
     * <div class="rationale">
     *   <p>This assumption normally avoids the need to call GetAll(),
     *     since the values of  \endhtmlonly \link requestPropertyCaptchaError() CaptchaError \endlink \htmlonly 
     *     and  \endhtmlonly \link requestPropertyCaptchaErrorDetails() CaptchaErrorDetails \endlink \htmlonly 
     *     are also implied by this assumption, and the only other
     *     property is  \endhtmlonly \link requestPropertyCanRetryCaptcha() CanRetryCaptcha \endlink \htmlonly ,
     *     which is immutable.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c CaptchaStatus.
     */
    uint CaptchaStatus() const;
    /**
     * Return the value of the exported D-Bus object property \c CaptchaError of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'captchaError' with type QString.
     *
     * 
     * \htmlonly
     * <p>The reason for the  \endhtmlonly \link requestPropertyCaptchaStatus() CaptchaStatus \endlink \htmlonly , or
     *   an empty string if the state is neither Try_Again nor Failed.</p>
     * 
     * <p>Typical values: &quot;&quot;, Cancelled, AuthenticationFailed,
     *   CaptchaNotSupported</p>
     * 
     * <p>In particular, an ordinary authentication failure (as would
     *   be produced for an incorrect answer) SHOULD be represented by
     *   <tp:error-ref>AuthenticationFailed</tp:error-ref>,
     *   cancellation by the user's request SHOULD be represented
     *   by <tp:error-ref>Cancelled</tp:error-ref>, cancellation due
     *   to the inability to display the captcha to the user or otherwise
     *   answer it SHOULD be represented by
     *   <tp:error-ref>CaptchaNotSupported</tp:error-ref>, and
     *   cancellation by a local process due to inconsistent or invalid
     *   challenges from the server SHOULD be represented by
     *   <tp:error-ref>ServiceConfused</tp:error-ref>.</p>
     * 
     * <p>If this interface appears on a  \endhtmlonly ChannelTypeServerAuthenticationInterface \htmlonly 
     *   channel, and connection to the server fails with an authentication
     *   failure, this error code SHOULD be copied into the
     *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly 
     *   signal.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c CaptchaError.
     */
    QString CaptchaError() const;
    /**
     * Return the value of the exported D-Bus object property \c CaptchaErrorDetails of type \c QVariantMap.
     *
     * Adaptees should export this property as a Qt property named
     * 'captchaErrorDetails' with type QVariantMap.
     *
     * 
     * \htmlonly
     * <p>If  \endhtmlonly \link requestPropertyCaptchaError() CaptchaError \endlink \htmlonly  is non-empty,
     *   any additional information about the last
     *   disconnection; otherwise, the empty map. The keys and values are
     *   the same as for the second argument of
     *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly .</p>
     * 
     * <p>If this interface appears on a  \endhtmlonly ChannelTypeServerAuthenticationInterface \htmlonly 
     *   channel, and connection to the server fails with an authentication
     *   failure, these details SHOULD be copied into the
     *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly 
     *   signal.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c CaptchaErrorDetails.
     */
    QVariantMap CaptchaErrorDetails() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetCaptchas on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getCaptchas(const Tp::Service::ChannelInterfaceCaptchaAuthenticationAdaptor::GetCaptchasContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Gets information regarding each of the captcha methods
     *   available and which and how many need to be successfully answered</p>
     * 
     * <p>To call this method successfully, the state must be Local_Pending
     *   or Try_Again. If it is Local_Pending, it remains Local_Pending. If
     *   called more than once while in Local_Pending state, or if the state
     *   is Try_Again, this method fetches a new set of captcha challenges,
     *   if possible, and the state returns to Local_Pending.</p>
     * 
     * <div class="rationale">
     *   <p>For instance, you could call GetCaptchas again from Local_Pending
     *     state if the user indicates that they can't understand the
     *     initially-offered captcha.</p>
     * 
     *   <p>This is a method, not a property, so that it can be used to
     *     fetch more than one set of captcha challenges, and so that
     *     change notification is not required. Only the Handler should
     *     call this method and calling GetAll would not reduce round-trips,
     *     so the usual reasons to prefer a property do not apply here.</p>
     * </div>
     * \endhtmlonly
     *
     * \param numberRequired Output parameter
     *     
     *     \htmlonly
     *     The number of captcha methods required to be answered
     *     in order to successfully complete this captcha challenge
     *     (most frequently 1, but XMPP allows servers to demand that
     *     more than one captcha is answered).
     *     \endhtmlonly
     * \param language Output parameter
     *     
     *     \htmlonly
     *     The language of each Label in Captcha_Info if available,
     *     for instance en_US, or &quot;&quot; if unknown.
     *     \endhtmlonly
     * \return
     *     
     *     \htmlonly
     *     Information about each of the available captcha methods.
     *     \endhtmlonly
     */
    Tp::CaptchaInfoList GetCaptchas(const QDBusMessage& dbusMessage, uint& numberRequired, QString& language);
    /**
     * Begins a call to the exported D-Bus method \c GetCaptchaData on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getCaptchaData(uint ID, const QString& mimeType, const Tp::Service::ChannelInterfaceCaptchaAuthenticationAdaptor::GetCaptchaDataContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Fetch and return the captcha data. In protocols
     *   where captchas are downloaded out-of-band (for instance via HTTP),
     *   the connection manager is expected to do so.</p>
     * <p>Returns an empty array if the type was &quot;qa&quot;</p>
     * <div class="rationale">
     *   <p>If audio-based and image-based captchas are both available,
     *     we don't want to waste time downloading the audio until/unless
     *     the user asks to hear it. The extra D-Bus round-trips are not
     *     a problem, since they are expected to be quick compared with
     *     the time taken for the user to solve the captcha.</p>
     * </div>
     * \endhtmlonly
     *
     * \param ID
     *     
     *     The ID of the captcha of which to retrieve data.
     * \param mimeType
     *     
     *     MIME type picked by the Handler, chosen from the list of MIME types 
     *     received in GetCaptchas. XEP-0158 allows the same captcha to be 
     *     made available in multiple formats, for instance the same spoken 
     *     question as audio/x-wav, application/ogg and audio/speex.
     * \return
     *     
     *     Captcha data as requested.
     */
    QByteArray GetCaptchaData(uint ID, const QString& mimeType, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c AnswerCaptchas on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void answerCaptchas(const Tp::CaptchaAnswers& answers, const Tp::Service::ChannelInterfaceCaptchaAuthenticationAdaptor::AnswerCaptchasContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Answer as many captchas as desired and/or required.</p>
     * <p>Callable in state Local_Pending only. State changes to
     *   Remote_Pending.</p>
     * \endhtmlonly
     *
     * \param answers
     *     
     *     The mapping of captcha IDs to answer strings.
     */
    void AnswerCaptchas(const Tp::CaptchaAnswers& answers, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c CancelCaptcha on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void cancelCaptcha(uint reason, const QString& debugMessage, const Tp::Service::ChannelInterfaceCaptchaAuthenticationAdaptor::CancelCaptchaContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Cancel. State changes to Failed with error NotAvailable or
     *   Cancelled if it isn't already Failed. All you can do now is
     *   to close the channel.</p>
     * \endhtmlonly
     *
     * \param reason
     *     
     *     Reason for cancelling. This MAY be used to choose an error response 
     *     to the remote server, and SHOULD also be reflected in the 
     *     CaptchaError.
     * \param debugMessage
     *     
     *     A textual description of the reason for cancelling, supplied by the 
     *     Handler. This message SHOULD NOT be sent to the remote server, but 
     *     SHOULD be copied into the &apos;debug-message&apos; field of the 
     *     CaptchaErrorDetails and ConnectionError.
     */
    void CancelCaptcha(uint reason, const QString& debugMessage, const QDBusMessage& dbusMessage);
};

/**
 * \class ChannelInterfaceChatStateAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.ChatState".
 */
class TP_QT_EXPORT ChannelInterfaceChatStateAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.ChatState")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.ChatState\">\n"
"    <property access=\"read\" type=\"a{uu}\" name=\"ChatStates\">\n"
"      <annotation value=\"Tp::ChatStateMap\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <method name=\"SetChatState\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"state\"/>\n"
"    </method>\n"
"    <signal name=\"ChatStateChanged\">\n"
"      <arg type=\"u\" name=\"contact\"/>\n"
"      <arg type=\"u\" name=\"state\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(Tp::ChatStateMap ChatStates READ ChatStates )

public:
    ChannelInterfaceChatStateAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceChatStateAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > SetChatStateContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c ChatStates of type \c Tp::ChatStateMap.
     *
     * Adaptees should export this property as a Qt property named
     * 'chatStates' with type Tp::ChatStateMap.
     *
     * 
     * \htmlonly
     * <p>A map containing the chat states of all contacts in this
     *   channel whose chat state is not Inactive.</p>
     * 
     * <p>Contacts in this channel, but who are not listed in this map,
     *   may be assumed to be in the Inactive state.</p>
     * 
     * <p>In implementations that do not have this property, its value may be
     *   assumed to be empty until a
     *    \endhtmlonly ChatStateChanged() \htmlonly  signal indicates
     *   otherwise.</p>
     * 
     * <div class="rationale">
     *   <p>This property was not present in older versions of telepathy-spec,
     *     because chat states in XMPP are not state-recoverable (if you
     *     miss the change notification signal, there's no way to know the
     *     state). However, this property still allows clients to recover
     *     state changes that were seen by the CM before the client started
     *     to deal with the channel.</p>
     * 
     *   <p>In CMs that follow older spec versions, assuming Inactive will
     *     mean that initial chat states will always be assumed to be
     *     Inactive, which is the best we can do. XEP 0085 specifies
     *     Inactive as the &quot;neutral&quot; state to be assumed unless told
     *     otherwise.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c ChatStates.
     */
    Tp::ChatStateMap ChatStates() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c SetChatState on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void setChatState(uint state, const Tp::Service::ChannelInterfaceChatStateAdaptor::SetChatStateContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Set the local state and notify other members of the channel that it has 
     * changed.
     *
     * \param state
     *     
     *     The new state.
     */
    void SetChatState(uint state, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c ChatStateChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void chatStateChanged(uint contact, uint state);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param contact
     *     
     *     An integer handle for the contact.
     * \param state
     *     
     *     The new state of this contact.
     */
    void ChatStateChanged(uint contact, uint state);
};

/**
 * \class ChannelInterfaceConferenceAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Conference".
 */
class TP_QT_EXPORT ChannelInterfaceConferenceAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.Conference")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.Conference\">\n"
"    <property access=\"read\" type=\"ao\" name=\"Channels\"/>\n"
"    <property access=\"read\" type=\"ao\" name=\"InitialChannels\"/>\n"
"    <property access=\"read\" type=\"au\" name=\"InitialInviteeHandles\"/>\n"
"    <property access=\"read\" type=\"as\" name=\"InitialInviteeIDs\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"InvitationMessage\"/>\n"
"    <property access=\"read\" type=\"a{uo}\" name=\"OriginalChannels\">\n"
"      <annotation value=\"Tp::ChannelOriginatorMap\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <signal name=\"ChannelMerged\">\n"
"      <arg type=\"o\" name=\"channel\"/>\n"
"      <arg type=\"u\" name=\"channelSpecificHandle\"/>\n"
"      <arg type=\"a{sv}\" name=\"properties\"/>\n"
"    </signal>\n"
"    <signal name=\"ChannelRemoved\">\n"
"      <arg type=\"o\" name=\"channel\"/>\n"
"      <arg type=\"a{sv}\" name=\"details\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(Tp::ObjectPathList Channels READ Channels )
    Q_PROPERTY(Tp::ObjectPathList InitialChannels READ InitialChannels )
    Q_PROPERTY(Tp::UIntList InitialInviteeHandles READ InitialInviteeHandles )
    Q_PROPERTY(QStringList InitialInviteeIDs READ InitialInviteeIDs )
    Q_PROPERTY(QString InvitationMessage READ InvitationMessage )
    Q_PROPERTY(Tp::ChannelOriginatorMap OriginalChannels READ OriginalChannels )

public:
    ChannelInterfaceConferenceAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceConferenceAdaptor();


public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Channels of type \c Tp::ObjectPathList.
     *
     * Adaptees should export this property as a Qt property named
     * 'channels' with type Tp::ObjectPathList.
     *
     * 
     * \htmlonly
     *  <p>The individual  \endhtmlonly ChannelInterface \htmlonly s that
     *    are continued by this conference, which have the same  \endhtmlonly \link ChannelInterface::requestPropertyChannelType() ChannelInterface::ChannelType \endlink \htmlonly  as this one, but with  \endhtmlonly \link ChannelInterface::requestPropertyTargetHandleType() ChannelInterface::TargetHandleType \endlink \htmlonly  = CONTACT.</p>
     * 
     *  <p>This property MUST NOT be requestable; instead, the
     *     \endhtmlonly \link requestPropertyInitialChannels() InitialChannels \endlink \htmlonly  property may be
     *    specified when requesting a channel.</p>
     * 
     *  <div class="rationale">
     *    <p>This is consistent with requesting
     *       \endhtmlonly \link requestPropertyInitialInviteeHandles() InitialInviteeHandles \endlink \htmlonly  and
     *       \endhtmlonly \link requestPropertyInitialInviteeIDs() InitialInviteeIDs \endlink \htmlonly , rather than
     *      requesting  \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertyMembers() ChannelInterfaceGroupInterface::Members \endlink \htmlonly 
     *      and some hypothetical ID version of that property.</p>
     * </div>
     * 
     *  <p>Change notification is via the
     *     \endhtmlonly ChannelMerged() \htmlonly  and
     *     \endhtmlonly ChannelRemoved() \htmlonly  signals.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Channels.
     */
    Tp::ObjectPathList Channels() const;
    /**
     * Return the value of the exported D-Bus object property \c InitialChannels of type \c Tp::ObjectPathList.
     *
     * Adaptees should export this property as a Qt property named
     * 'initialChannels' with type Tp::ObjectPathList.
     *
     * 
     * \htmlonly
     * <p>The initial value of  \endhtmlonly \link requestPropertyChannels() Channels \endlink \htmlonly .</p>
     * 
     * <p>This property SHOULD be requestable. Omitting it from a request is
     *   equivalent to providing it with an empty list as value. Requests
     *   where its value has at least two channel paths SHOULD be expected to
     *   succeed on any implementation of this interface. If
     *    \endhtmlonly \link requestPropertyInitialInviteeHandles() InitialInviteeHandles \endlink \htmlonly  and
     *    \endhtmlonly \link requestPropertyInitialInviteeIDs() InitialInviteeIDs \endlink \htmlonly  are
     *   <var>Allowed_Properties</var> in  \endhtmlonly \link ConnectionInterfaceRequestsInterface::requestPropertyRequestableChannelClasses() ConnectionInterfaceRequestsInterface::RequestableChannelClasses \endlink \htmlonly , then requests with zero
     *   or one channel paths SHOULD also succeed; otherwise, clients SHOULD
     *   NOT make requests with zero or one paths for this property.</p>
     * 
     * <div class="rationale">
     *   <p>In GSM, a pair of calls can be merged into a conference, but you
     *     can't start a conference call from zero or one existing calls. In
     *     XMPP and MSN, you can create a new chatroom, or upgrade one 1-1
     *     channel into a chatroom; however, on these protocols, it is also
     *     possible to fake GSM-style merging by upgrading the first channel,
     *     then inviting the targets of all the other channels into it.</p>
     * </div>
     * 
     * <p>If possible, the  \endhtmlonly \link requestPropertyChannels() Channels \endlink \htmlonly ' states SHOULD
     *   NOT be altered by merging them into a conference. However, depending on
     *   the protocol, the Channels MAY be placed in a &quot;frozen&quot; state by placing
     *   them in this property's value or by calling
     *    \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.MergeableConference.DRAFT.Merge \htmlonly  on them.</p>
     * 
     * <div class="rationale">
     *   <p>In Jingle, nothing special will happen to merged calls. UIs MAY
     *     automatically place calls on hold before merging them, if that is
     *     the desired behaviour; this SHOULD always work. Not doing
     *     an implicit hold/unhold seems to preserve least-astonishment.</p>
     * 
     *   <p>In GSM, the calls that are merged go into a state similar to
     *     Hold, but they cannot be unheld, only split from the conference
     *     call using  \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.Splittable.DRAFT.Split \htmlonly .</p>
     * </div>
     * 
     * <p>Depending on the protocol, it might be signalled to remote users
     *   that this channel is a continuation of all the requested channels,
     *   or that it is only a continuation of the first channel in the
     *   list.</p>
     * 
     * <div class="rationale">
     *   <p>In MSN, the conference steals the underlying switchboard (protocol
     *     construct) from one of its component channels, so the conference
     *     appears to remote users to be a continuation of that channel and no
     *     other. The connection manager has to make some arbitrary choice, so
     *     we arbitrarily mandate that it SHOULD choose the first channel in
     *     the list as the one to continue.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c InitialChannels.
     */
    Tp::ObjectPathList InitialChannels() const;
    /**
     * Return the value of the exported D-Bus object property \c InitialInviteeHandles of type \c Tp::UIntList.
     *
     * Adaptees should export this property as a Qt property named
     * 'initialInviteeHandles' with type Tp::UIntList.
     *
     * 
     * \htmlonly
     * <p>A list of additional contacts invited to this conference when it
     *   was created.</p>
     * 
     * <p>If it is possible to invite new contacts when creating a conference
     *   (as opposed to merging several channels into one new conference
     *   channel), this property SHOULD be requestable, and appear in the allowed
     *   properties in  \endhtmlonly \link ConnectionInterfaceRequestsInterface::requestPropertyRequestableChannelClasses() ConnectionInterfaceRequestsInterface::RequestableChannelClasses \endlink \htmlonly . Otherwise, this property
     *   SHOULD NOT be requestable, and its value SHOULD always be the empty
     *   list.</p>
     * 
     * <div class="rationale">
     *   <p>On GSM you have to place a 1-1 call before you can merge it into a
     *     conference; on the other hand, you can invite new contacts to XMPP
     *     Muji calls and XMPP/MSN/Skype ad-hoc chat rooms without starting a
     *     1-1 channel with them first.</p>
     * </div>
     * 
     * <p>If included in a request, the given contacts are automatically
     *   invited into the new channel, as if they had been added with
     *    \endhtmlonly ChannelInterfaceGroupInterface::AddMembers() \htmlonly (InitialInviteeHandles,
     *    \endhtmlonly \link requestPropertyInvitationMessage() InvitationMessage \endlink \htmlonly ) immediately after
     *   the channel was created.</p>
     * 
     * <div class="rationale">
     *   <p>This is a simple convenience API for the common case that a UI
     *     upgrades a 1-1 chat to a multi-user chat solely in order to invite
     *     someone else to participate.</p>
     * </div>
     * 
     * <p>If the local user was not the initiator of this channel, the
     *    \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertySelfHandle() ChannelInterfaceGroupInterface::SelfHandle \endlink \htmlonly  SHOULD appear in the value of this
     *   property, together with any other contacts invited at the same time
     *   (if that information is known).</p>
     * 
     * <p>InitialInviteeHandles, InitialInviteeIDs and InitialChannels MAY be
     *   combined in a single request.</p>
     * 
     * <div class="rationale">
     *   <p>For example, if you have a 1-1 channel C1 with Rob, and you want
     *     to invite Sjoerd to join the discussion, you can do so by
     *     requesting a channel with InitialChannels=[C1] and
     *     InitialInviteeHandles=[sjoerd],
     *     or InitialChannels=[C1] and
     *     InitialInviteeIDs=[&quot;sjoerd@example.com&quot;].</p>
     * </div>
     * 
     * <p>If a request includes some combination of InitialInviteeHandles,
     *   InitialInviteeIDs and InitialChannels, then the value of
     *   InitialInviteeHandles on the resulting channel SHOULD be the union of
     *   the handles from InitialInviteeHandles, the handles corresponding
     *   to the InitialInviteeIDs, and the target handles of the
     *   InitialChannels, with any duplicate handles removed. Because this
     *   property is immutable, its value SHOULD be computed before the
     *   channel is announced via the NewChannels signal.</p>
     * 
     * <div class="rationale">
     *   <p>This simplifies identification of new channels in clients - they
     *     only have to look at one of the properties, not both. For example,
     *     after either of the requests mentioned above, the NewChannels
     *     signal would announce the channel with InitialChannels=[C1],
     *     InitialInviteeHandles=[rob, sjoerd], and
     *     InitialInviteeIDs=[&quot;rob@example.net&quot;, &quot;sjoerd.example.com&quot;].</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c InitialInviteeHandles.
     */
    Tp::UIntList InitialInviteeHandles() const;
    /**
     * Return the value of the exported D-Bus object property \c InitialInviteeIDs of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'initialInviteeIDs' with type QStringList.
     *
     * 
     * \htmlonly
     * <p>A list of additional contacts invited to this conference when it
     *   was created.</p>
     * 
     * <p>This property SHOULD be requestable if and only if
     *    \endhtmlonly \link requestPropertyInitialInviteeHandles() InitialInviteeHandles \endlink \htmlonly  is requestable.
     *   Its semantics are the same, except that it takes a list of the
     *   string representations of contact handles; invitations are sent to
     *   any contact present in either or both of these properties.</p>
     * 
     * <p>When a channel is created, the values of InitialInviteeHandles and
     *   InitialInviteeIDs MUST correspond to each other. In particular, this
     *   means that the value of InitialInviteeIDs will include the TargetID
     *   of each channel in InitialChannels, and the ID corresponding to each
     *   handle in InitialInviteeHandles.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c InitialInviteeIDs.
     */
    QStringList InitialInviteeIDs() const;
    /**
     * Return the value of the exported D-Bus object property \c InvitationMessage of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'invitationMessage' with type QString.
     *
     * 
     * \htmlonly
     * <p>The message that was sent to the
     *    \endhtmlonly \link requestPropertyInitialInviteeHandles() InitialInviteeHandles \endlink \htmlonly  when they were
     *   invited.</p>
     * 
     * <p>This property SHOULD be requestable, and appear in the allowed
     *   properties in  \endhtmlonly \link ConnectionInterfaceRequestsInterface::requestPropertyRequestableChannelClasses() ConnectionInterfaceRequestsInterface::RequestableChannelClasses \endlink \htmlonly , in protocols where
     *   invitations can have an accompanying text message.</p>
     * 
     * <div class="rationale">
     *   <p>This allows invitations with a message to be sent when using
     *      \endhtmlonly \link requestPropertyInitialInviteeHandles() InitialInviteeHandles \endlink \htmlonly  or
     *      \endhtmlonly \link requestPropertyInitialInviteeIDs() InitialInviteeIDs \endlink \htmlonly .</p>
     * </div>
     * 
     * <p>If the local user was not the initiator of this channel, the
     *   message with which they were invited (if any) SHOULD appear in the
     *   value of this property.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c InvitationMessage.
     */
    QString InvitationMessage() const;
    /**
     * Return the value of the exported D-Bus object property \c OriginalChannels of type \c Tp::ChannelOriginatorMap.
     *
     * Adaptees should export this property as a Qt property named
     * 'originalChannels' with type Tp::ChannelOriginatorMap.
     *
     * 
     * \htmlonly
     * <p>On GSM conference calls, it is possible to have the same phone
     *   number in a conference twice; for instance, it could be the number of
     *   a corporate switchboard. This is represented using channel-specific
     *   handles; whether or not a channel uses channel-specific handles is
     *   reported in  \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertyGroupFlags() ChannelInterfaceGroupInterface::GroupFlags \endlink \htmlonly .
     *   The  \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertyHandleOwners() ChannelInterfaceGroupInterface::HandleOwners \endlink \htmlonly 
     *   property specifies the mapping from opaque channel-specific handles
     *   to actual numbers; this property specifies the original 1-1 channel
     *   corresponding to each channel-specific handle in the conference.</p>
     * 
     * <p>In protocols where this situation cannot arise, such as XMPP,
     *   this property MAY remain empty.</p>
     * 
     * <p>For example, consider this situation:</p>
     * 
     * <ol>
     *   <li>Place a call (with path <tt>/call/to/simon</tt>) to the contact
     *     <tt>+441234567890</tt> (which is assigned the handle <var>h</var>,
     *     say), and ask to be put through to Simon McVittie;</li>
     *   <li>Put that call on hold;</li>
     *   <li>Place another call (with path <tt>/call/to/jonny</tt>) to
     *     <tt>+441234567890</tt>, and ask to be put
     *     through to Jonny Lamb;</li>
     *   <li>Request a new channel with
     *      \endhtmlonly \link requestPropertyInitialChannels() InitialChannels \endlink \htmlonly :
     *     <tt>['/call/to/simon', '/call/to/jonny']</tt>.</li>
     * </ol>
     * 
     * <p>The new channel will have the following properties, for some handles
     *   <var>s</var> and <var>j</var>:</p>
     * 
     * <blockquote>
     *   <code>{<br/>
     *     ... \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertyGroupFlags() ChannelInterfaceGroupInterface::GroupFlags \endlink \htmlonly :
     *         Channel_Specific_Handles | (other flags),<br/>
     *     ... \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertyMembers() ChannelInterfaceGroupInterface::Members \endlink \htmlonly :
     *         [self_handle, s, j],<br/>
     *     ... \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertyHandleOwners() ChannelInterfaceGroupInterface::HandleOwners \endlink \htmlonly :
     *         { s: h, j: h },<br/>
     *     ... \endhtmlonly \link requestPropertyInitialChannels() InitialChannels \endlink \htmlonly :
     *         ['/call/to/simon', '/call/to/jonny'],<br/>
     *     ... \endhtmlonly \link requestPropertyChannels() Channels \endlink \htmlonly :
     *         ['/call/to/simon', '/call/to/jonny'],<br/>
     *     ... \endhtmlonly \link requestPropertyOriginalChannels() OriginalChannels \endlink \htmlonly :
     *         { s: '/call/to/simon', j: '/call/to/jonny' },<br/>
     *     # ...standard properties like ChannelType: Group elided...<br/>
     *   }</code>
     * </blockquote>
     * 
     * <p>Change notification is via the
     *    \endhtmlonly ChannelMerged() \htmlonly  and
     *    \endhtmlonly ChannelRemoved() \htmlonly  signals: if
     *   <var>Channel_Specific_Handle</var> in the former is non-zero, this
     *   property SHOULD be updated to map that handle to the merged channel's
     *   path.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c OriginalChannels.
     */
    Tp::ChannelOriginatorMap OriginalChannels() const;

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c ChannelMerged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void channelMerged(const QDBusObjectPath& channel, uint channelSpecificHandle, const QVariantMap& properties);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param channel
     *     
     *     The channel that was added to Channels.
     * \param channelSpecificHandle
     *     
     *     A new channel-specific handle for the TargetHandle of Channel, as 
     *     will appear in OriginalChannels, or 0 if a global handle is used 
     *     for Channel&apos;s TargetHandle on the Group interface of this 
     *     channel.
     * \param properties
     *     
     *     Channel&apos;s immutable properties.
     */
    void ChannelMerged(const QDBusObjectPath& channel, uint channelSpecificHandle, const QVariantMap& properties);
    /**
     * Represents the exported D-Bus signal \c ChannelRemoved on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void channelRemoved(const QDBusObjectPath& channel, const QVariantMap& details);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param channel
     *     
     *     The channel that was removed from Channels.
     * \param details
     *     
     *     \htmlonly
     *     Additional information about the removal, which may include
     *     the same well-known keys as the Details argument of
     *      \\\\endhtmlonly ChannelInterfaceGroupInterface::MembersChangedDetailed() \\\\htmlonly , with the same semantics.
     *     \endhtmlonly
     */
    void ChannelRemoved(const QDBusObjectPath& channel, const QVariantMap& details);
};

/**
 * \class ChannelInterfaceDTMFAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.DTMF".
 */
class TP_QT_EXPORT ChannelInterfaceDTMFAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.DTMF")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.DTMF\">\n"
"    <property access=\"read\" type=\"b\" name=\"CurrentlySendingTones\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"InitialTones\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"DeferredTones\"/>\n"
"    <method name=\"StartTone\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"streamID\"/>\n"
"      <arg direction=\"in\" type=\"y\" name=\"event\"/>\n"
"    </method>\n"
"    <method name=\"StopTone\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"streamID\"/>\n"
"    </method>\n"
"    <method name=\"MultipleTones\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"tones\"/>\n"
"    </method>\n"
"    <signal name=\"TonesDeferred\">\n"
"      <arg type=\"s\" name=\"tones\"/>\n"
"    </signal>\n"
"    <signal name=\"SendingTones\">\n"
"      <arg type=\"s\" name=\"tones\"/>\n"
"    </signal>\n"
"    <signal name=\"StoppedTones\">\n"
"      <arg type=\"b\" name=\"cancelled\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(bool CurrentlySendingTones READ CurrentlySendingTones )
    Q_PROPERTY(QString InitialTones READ InitialTones )
    Q_PROPERTY(QString DeferredTones READ DeferredTones )

public:
    ChannelInterfaceDTMFAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceDTMFAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > StartToneContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > StopToneContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > MultipleTonesContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c CurrentlySendingTones of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'currentlySendingTones' with type bool.
     *
     * 
     * Indicates whether there are DTMF tones currently being sent in the 
     * channel. If so, the client should wait for StoppedTones signal before 
     * trying to send more tones.
     *
     * \return The value of exported property \c CurrentlySendingTones.
     */
    bool CurrentlySendingTones() const;
    /**
     * Return the value of the exported D-Bus object property \c InitialTones of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'initialTones' with type QString.
     *
     * 
     * If non-empty in a channel request that will create a new channel, the 
     * connection manager should send the tones immediately after at least one 
     * eligible audio stream has been created in the channel. This should only 
     * be used with InitialAudio=true. This property is immutable (cannot 
     * change).
     *
     * \return The value of exported property \c InitialTones.
     */
    QString InitialTones() const;
    /**
     * Return the value of the exported D-Bus object property \c DeferredTones of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'deferredTones' with type QString.
     *
     * 
     * \htmlonly
     * <p>The tones waiting for the user to continue, if any.</p>
     * 
     * <p>When this property is set to a non-empty value,
     *    \endhtmlonly TonesDeferred() \htmlonly  is emitted.
     *   When any tones are played (i.e. whenever
     *    \endhtmlonly SendingTones() \htmlonly  is emitted),
     *   this property is reset to the empty string.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c DeferredTones.
     */
    QString DeferredTones() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c StartTone on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void startTone(uint streamID, uchar event, const Tp::Service::ChannelInterfaceDTMFAdaptor::StartToneContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Start sending a DTMF tone to all eligible streams in the channel. Where 
     * possible, the tone will continue until StopTone is called. On certain 
     * protocols, it may only be possible to send events with a predetermined 
     * length. In this case, the implementation MAY emit a fixed-length tone, 
     * and the StopTone method call SHOULD return NotAvailable. The client may 
     * wish to control the exact duration and timing of the tones sent as a 
     * result of user&apos;s interaction with the dialpad, thus starting and 
     * stopping the tone sending explicitly. Tone overlaping or queueing is 
     * not supported, so this method can only be called if no DTMF tones are 
     * already being played.
     *
     * \param streamID
     *     
     *     A stream ID as defined in the StreamedMedia channel type. This 
     *     argument is included for backwards compatibility and MUST be 
     *     ignored by the implementations - the tone SHOULD be sent to all 
     *     eligible streams in the channel.
     * \param event
     *     
     *     A numeric event code from the DTMF_Event enum.
     */
    void StartTone(uint streamID, uchar event, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c StopTone on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void stopTone(uint streamID, const Tp::Service::ChannelInterfaceDTMFAdaptor::StopToneContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Stop sending any DTMF tones which have been started using the StartTone 
     * or MultipleTones methods. If there is no current tone, this method will 
     * do nothing. If MultipleTones was used, the client should not assume the 
     * sending has stopped immediately; instead, the client should wait for 
     * the StoppedTones signal. On some protocols it might be impossible to 
     * cancel queued tones immediately.
     *
     * \param streamID
     *     
     *     A stream ID as defined in the StreamedMedia channel type. This 
     *     argument is included for backwards compatibility and MUST be 
     *     ignored by the implementations - the sending SHOULD be stoped in 
     *     all eligible streams in the channel.
     */
    void StopTone(uint streamID, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c MultipleTones on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void multipleTones(const QString& tones, const Tp::Service::ChannelInterfaceDTMFAdaptor::MultipleTonesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Send multiple DTMF events to all eligible streams in the channel. Each 
     * tone will be played for an implementation-defined number of 
     * milliseconds (typically 250ms), followed by a gap before the next tone 
     * is played (typically 100ms). The duration and gap are defined by the 
     * protocol or connection manager. In cases where the client knows in 
     * advance the tone sequence it wants to send, it&apos;s easier to use 
     * this method than manually start and stop each tone in the sequence. The 
     * tone and gap lengths may need to vary for interoperability, according 
     * to the protocol and other implementations&apos; ability to recognise 
     * tones. At the time of writing, GStreamer uses a minimum of 250ms tones 
     * and 100ms gaps when playing in-band DTMF in the normal audio stream, or 
     * 70ms tones and 50ms gaps when encoding DTMF as audio/telephone-event. 
     * Tone overlaping or queueing is not supported, so this method can only 
     * be called if no DTMF tones are already being played.
     *
     * \param tones
     *     
     *     \htmlonly
     *     <p>A string representation of one or more DTMF
     *       events. Implementations of this method MUST support all of the
     *       following characters in this string:</p>
     *     
     *     <ul>
     *       <li>the digits 0-9, letters A-D and a-d, and symbols '*' and '#'
     *         correspond to the members of <tp:type>DTMF_Event</tp:type></li>
     *     
     *       <li>any of 'p', 'P', 'x', 'X' or ',' (comma) results in an
     *         implementation-defined pause, typically for 3 seconds</li>
     *     
     *       <li>'w' or 'W' waits for the user to continue, by stopping
     *         interpretation of the string, and if there is more to be played,
     *         emitting the  \\\\endhtmlonly TonesDeferred() \\\\htmlonly  signal
     *         with the rest of the string as its argument: see that signal
     *         for details</li>
     *     </ul>
     *     \endhtmlonly
     */
    void MultipleTones(const QString& tones, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c TonesDeferred on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void tonesDeferred(const QString& tones);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param tones
     *     
     *     The new non-empty value of DeferredTones.
     */
    void TonesDeferred(const QString& tones);
    /**
     * Represents the exported D-Bus signal \c SendingTones on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void sendingTones(const QString& tones);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param tones
     *     
     *     DTMF string (one or more events) that is to be played.
     */
    void SendingTones(const QString& tones);
    /**
     * Represents the exported D-Bus signal \c StoppedTones on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void stoppedTones(bool cancelled);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param cancelled
     *     
     *     True if the DTMF tones were actively cancelled via StopTone.
     */
    void StoppedTones(bool cancelled);
};

/**
 * \class ChannelInterfaceDestroyableAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Destroyable".
 */
class TP_QT_EXPORT ChannelInterfaceDestroyableAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.Destroyable")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.Destroyable\">\n"
"    <method name=\"Destroy\"/>\n"
"  </interface>\n"
"")

public:
    ChannelInterfaceDestroyableAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceDestroyableAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > DestroyContextPtr;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c Destroy on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void destroy(const Tp::Service::ChannelInterfaceDestroyableAdaptor::DestroyContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Close the channel abruptly, possibly with loss of data. The
     *   connection manager MUST NOT re-create the channel unless/until
     *   more events occur.</p>
     * 
     * <div class="rationale">
     *   <p>The main motivating situation for this method is that when a Text
     *     channel with pending messages is closed with Close, it comes back
     *     as an incoming channel (to avoid a race between Close and an
     *     incoming message). If Destroy is called on a Text channel, the CM
     *     should delete all pending messages and close the channel, and
     *     the channel shouldn't be re-created until/unless another message
     *     arrives.</p>
     * </div>
     * 
     * <p>Most clients SHOULD call
     *    \endhtmlonly ChannelInterface::Close() \htmlonly 
     *   instead. However, if a client explicitly intends to destroy the
     *   channel with possible loss of data, it SHOULD call this method
     *   if this interface is supported (according to the
     *    \endhtmlonly \link ChannelInterface::requestPropertyInterfaces() ChannelInterface::Interfaces \endlink \htmlonly 
     *   property), falling back to Close if not.</p>
     * 
     * <p>In particular, channel dispatchers SHOULD use this method if
     *   available when terminating channels that cannot be handled
     *   correctly (for instance, if no handler has been installed for
     *   a channel type, or if the handler crashes repeatedly).</p>
     * 
     * <p>Connection managers do not need to implement this interface on
     *   channels where Close and Destroy would be equivalent.</p>
     * 
     * <div class="rationale">
     *   <p>Callers need to be able to fall back to Close in any case.</p>
     * </div>
     * \endhtmlonly
     *
     */
    void Destroy(const QDBusMessage& dbusMessage);
};

/**
 * \class ChannelInterfaceFileTransferMetadataAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.FileTransfer.Metadata".
 */
class TP_QT_EXPORT ChannelInterfaceFileTransferMetadataAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.FileTransfer.Metadata")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.FileTransfer.Metadata\">\n"
"    <property access=\"readwrite\" type=\"s\" name=\"ServiceName\"/>\n"
"    <property access=\"readwrite\" type=\"a{sas}\" name=\"Metadata\">\n"
"      <annotation value=\"Tp::Metadata\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QString ServiceName READ ServiceName WRITE SetServiceName)
    Q_PROPERTY(Tp::Metadata Metadata READ Metadata WRITE SetMetadata)

public:
    ChannelInterfaceFileTransferMetadataAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceFileTransferMetadataAdaptor();


public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c ServiceName of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'serviceName' with type QString.
     *
     * 
     * \htmlonly
     * <p>A string representing the service name that will be used
     *   over the file transfer channel. This property is equivalent
     *   to the  \endhtmlonly \link ChannelTypeDBusTubeInterface::requestPropertyServiceName() ChannelTypeDBusTubeInterface::ServiceName \endlink \htmlonly 
     *   and  \endhtmlonly \link ChannelTypeStreamTubeInterface::requestPropertyService() ChannelTypeStreamTubeInterface::Service \endlink \htmlonly 
     *   properties. If no service name is given then this property
     *   will be the empty string.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c ServiceName.
     */
    QString ServiceName() const;
    /**
     * Set the value of the exported D-Bus object property \c ServiceName of type \c QString.
     *
     * Adaptees should export this property as a writable Qt property named
     * 'serviceName' with type QString.
     *
     * 
     * \htmlonly
     * <p>A string representing the service name that will be used
     *   over the file transfer channel. This property is equivalent
     *   to the  \endhtmlonly \link ChannelTypeDBusTubeInterface::requestPropertyServiceName() ChannelTypeDBusTubeInterface::ServiceName \endlink \htmlonly 
     *   and  \endhtmlonly \link ChannelTypeStreamTubeInterface::requestPropertyService() ChannelTypeStreamTubeInterface::Service \endlink \htmlonly 
     *   properties. If no service name is given then this property
     *   will be the empty string.</p>
     * \endhtmlonly
     */
    void SetServiceName(const QString &newValue);
    /**
     * Return the value of the exported D-Bus object property \c Metadata of type \c Tp::Metadata.
     *
     * Adaptees should export this property as a Qt property named
     * 'metadata' with type Tp::Metadata.
     *
     * 
     * \htmlonly
     * <p>Additional information about the file transfer set by the
     *   channel initiator. If no additional information is given then
     *   this property will be empty.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Metadata.
     */
    Tp::Metadata Metadata() const;
    /**
     * Set the value of the exported D-Bus object property \c Metadata of type \c Tp::Metadata.
     *
     * Adaptees should export this property as a writable Qt property named
     * 'metadata' with type Tp::Metadata.
     *
     * 
     * \htmlonly
     * <p>Additional information about the file transfer set by the
     *   channel initiator. If no additional information is given then
     *   this property will be empty.</p>
     * \endhtmlonly
     */
    void SetMetadata(const Tp::Metadata &newValue);
};

/**
 * \class ChannelInterfaceGroupAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Group".
 */
class TP_QT_EXPORT ChannelInterfaceGroupAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.Group")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.Group\">\n"
"    <property access=\"read\" type=\"u\" name=\"GroupFlags\"/>\n"
"    <property access=\"read\" type=\"a{uu}\" name=\"HandleOwners\">\n"
"      <annotation value=\"Tp::HandleOwnerMap\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"a(uuus)\" name=\"LocalPendingMembers\">\n"
"      <annotation value=\"Tp::LocalPendingInfoList\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"au\" name=\"Members\"/>\n"
"    <property access=\"read\" type=\"au\" name=\"RemotePendingMembers\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"SelfHandle\"/>\n"
"    <property access=\"read\" type=\"a{us}\" name=\"MemberIdentifiers\">\n"
"      <annotation value=\"Tp::HandleIdentifierMap\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <method name=\"AddMembers\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"      <arg direction=\"in\" type=\"s\" name=\"message\"/>\n"
"    </method>\n"
"    <method name=\"GetAllMembers\">\n"
"      <arg direction=\"out\" type=\"au\" name=\"members\"/>\n"
"      <arg direction=\"out\" type=\"au\" name=\"localPending\"/>\n"
"      <arg direction=\"out\" type=\"au\" name=\"remotePending\"/>\n"
"    </method>\n"
"    <method name=\"GetGroupFlags\">\n"
"      <arg direction=\"out\" type=\"u\" name=\"groupFlags\"/>\n"
"    </method>\n"
"    <method name=\"GetHandleOwners\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"handles\"/>\n"
"      <arg direction=\"out\" type=\"au\" name=\"owners\"/>\n"
"    </method>\n"
"    <method name=\"GetLocalPendingMembers\">\n"
"      <arg direction=\"out\" type=\"au\" name=\"handles\"/>\n"
"    </method>\n"
"    <method name=\"GetLocalPendingMembersWithInfo\">\n"
"      <arg direction=\"out\" type=\"a(uuus)\" name=\"info\">\n"
"        <annotation value=\"Tp::LocalPendingInfoList\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"GetMembers\">\n"
"      <arg direction=\"out\" type=\"au\" name=\"handles\"/>\n"
"    </method>\n"
"    <method name=\"GetRemotePendingMembers\">\n"
"      <arg direction=\"out\" type=\"au\" name=\"handles\"/>\n"
"    </method>\n"
"    <method name=\"GetSelfHandle\">\n"
"      <arg direction=\"out\" type=\"u\" name=\"selfHandle\"/>\n"
"    </method>\n"
"    <method name=\"RemoveMembers\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"      <arg direction=\"in\" type=\"s\" name=\"message\"/>\n"
"    </method>\n"
"    <method name=\"RemoveMembersWithReason\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"      <arg direction=\"in\" type=\"s\" name=\"message\"/>\n"
"      <arg direction=\"in\" type=\"u\" name=\"reason\"/>\n"
"    </method>\n"
"    <signal name=\"HandleOwnersChanged\">\n"
"      <arg type=\"a{uu}\" name=\"added\">\n"
"        <annotation value=\"Tp::HandleOwnerMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg type=\"au\" name=\"removed\"/>\n"
"    </signal>\n"
"    <signal name=\"HandleOwnersChangedDetailed\">\n"
"      <arg type=\"a{uu}\" name=\"added\">\n"
"        <annotation value=\"Tp::HandleOwnerMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg type=\"au\" name=\"removed\"/>\n"
"      <arg type=\"a{us}\" name=\"identifiers\">\n"
"        <annotation value=\"Tp::HandleIdentifierMap\" name=\"com.trolltech.QtDBus.QtTypeName.In2\"/>\n"
"      </arg>\n"
"    </signal>\n"
"    <signal name=\"SelfHandleChanged\">\n"
"      <arg type=\"u\" name=\"selfHandle\"/>\n"
"    </signal>\n"
"    <signal name=\"SelfContactChanged\">\n"
"      <arg type=\"u\" name=\"selfHandle\"/>\n"
"      <arg type=\"s\" name=\"selfID\"/>\n"
"    </signal>\n"
"    <signal name=\"GroupFlagsChanged\">\n"
"      <arg type=\"u\" name=\"added\"/>\n"
"      <arg type=\"u\" name=\"removed\"/>\n"
"    </signal>\n"
"    <signal name=\"MembersChanged\">\n"
"      <arg type=\"s\" name=\"message\"/>\n"
"      <arg type=\"au\" name=\"added\"/>\n"
"      <arg type=\"au\" name=\"removed\"/>\n"
"      <arg type=\"au\" name=\"localPending\"/>\n"
"      <arg type=\"au\" name=\"remotePending\"/>\n"
"      <arg type=\"u\" name=\"actor\"/>\n"
"      <arg type=\"u\" name=\"reason\"/>\n"
"    </signal>\n"
"    <signal name=\"MembersChangedDetailed\">\n"
"      <arg type=\"au\" name=\"added\"/>\n"
"      <arg type=\"au\" name=\"removed\"/>\n"
"      <arg type=\"au\" name=\"localPending\"/>\n"
"      <arg type=\"au\" name=\"remotePending\"/>\n"
"      <arg type=\"a{sv}\" name=\"details\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(uint GroupFlags READ GroupFlags )
    Q_PROPERTY(Tp::HandleOwnerMap HandleOwners READ HandleOwners )
    Q_PROPERTY(Tp::LocalPendingInfoList LocalPendingMembers READ LocalPendingMembers )
    Q_PROPERTY(Tp::UIntList Members READ Members )
    Q_PROPERTY(Tp::UIntList RemotePendingMembers READ RemotePendingMembers )
    Q_PROPERTY(uint SelfHandle READ SelfHandle )
    Q_PROPERTY(Tp::HandleIdentifierMap MemberIdentifiers READ MemberIdentifiers )

public:
    ChannelInterfaceGroupAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceGroupAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > AddMembersContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::UIntList, Tp::UIntList, Tp::UIntList > GetAllMembersContextPtr;
    typedef Tp::MethodInvocationContextPtr< uint > GetGroupFlagsContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::UIntList > GetHandleOwnersContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::UIntList > GetLocalPendingMembersContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::LocalPendingInfoList > GetLocalPendingMembersWithInfoContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::UIntList > GetMembersContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::UIntList > GetRemotePendingMembersContextPtr;
    typedef Tp::MethodInvocationContextPtr< uint > GetSelfHandleContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > RemoveMembersContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > RemoveMembersWithReasonContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c GroupFlags of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'groupFlags' with type uint.
     *
     * 
     * An integer representing the bitwise-OR of flags on this channel. The 
     * user interface can use this to present information about which 
     * operations are currently valid. Change notification is via the 
     * GroupFlagsChanged signal.
     *
     * \return The value of exported property \c GroupFlags.
     */
    uint GroupFlags() const;
    /**
     * Return the value of the exported D-Bus object property \c HandleOwners of type \c Tp::HandleOwnerMap.
     *
     * Adaptees should export this property as a Qt property named
     * 'handleOwners' with type Tp::HandleOwnerMap.
     *
     * 
     * A map from channel-specific handles to their owners, including at least 
     * all of the channel-specific handles in this channel&apos;s members, 
     * local-pending or remote-pending sets as keys. Any handle not in the 
     * keys of this mapping is not channel-specific in this channel. Handles 
     * which are channel-specific, but for which the owner is unknown, MUST 
     * appear in this mapping with 0 as owner. Change notification is via the 
     * HandleOwnersChanged signal.
     *
     * \return The value of exported property \c HandleOwners.
     */
    Tp::HandleOwnerMap HandleOwners() const;
    /**
     * Return the value of the exported D-Bus object property \c LocalPendingMembers of type \c Tp::LocalPendingInfoList.
     *
     * Adaptees should export this property as a Qt property named
     * 'localPendingMembers' with type Tp::LocalPendingInfoList.
     *
     * 
     * An array of structs containing handles representing contacts requesting 
     * channel membership and awaiting local approval with AddMembers.
     *
     * \return The value of exported property \c LocalPendingMembers.
     */
    Tp::LocalPendingInfoList LocalPendingMembers() const;
    /**
     * Return the value of the exported D-Bus object property \c Members of type \c Tp::UIntList.
     *
     * Adaptees should export this property as a Qt property named
     * 'members' with type Tp::UIntList.
     *
     * 
     * The members of this channel.
     *
     * \return The value of exported property \c Members.
     */
    Tp::UIntList Members() const;
    /**
     * Return the value of the exported D-Bus object property \c RemotePendingMembers of type \c Tp::UIntList.
     *
     * Adaptees should export this property as a Qt property named
     * 'remotePendingMembers' with type Tp::UIntList.
     *
     * 
     * An array of handles representing contacts who have been invited to the 
     * channel and are awaiting remote approval.
     *
     * \return The value of exported property \c RemotePendingMembers.
     */
    Tp::UIntList RemotePendingMembers() const;
    /**
     * Return the value of the exported D-Bus object property \c SelfHandle of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'selfHandle' with type uint.
     *
     * 
     * The handle for the user on this channel (which can also be a local or 
     * remote pending member), or 0 if the user is not a member at all (which 
     * is likely to be the case, for instance, on ContactList channels). Note 
     * that this is different from the result of Connection.GetSelfHandle on 
     * some protocols, so the value of this handle should always be used with 
     * the methods of this interface.
     *
     * \return The value of exported property \c SelfHandle.
     */
    uint SelfHandle() const;
    /**
     * Return the value of the exported D-Bus object property \c MemberIdentifiers of type \c Tp::HandleIdentifierMap.
     *
     * Adaptees should export this property as a Qt property named
     * 'memberIdentifiers' with type Tp::HandleIdentifierMap.
     *
     * 
     * The string identifiers for handles mentioned in this channel, to give 
     * clients the minimal information necessary to create contacts without 
     * waiting for round-trips. Connection managers MUST include at least the 
     * identifiers for SelfHandle, Members, LocalPendingMembers (and their 
     * actors if any), RemotePendingMembers and HandleOwners.
     *
     * \return The value of exported property \c MemberIdentifiers.
     */
    Tp::HandleIdentifierMap MemberIdentifiers() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c AddMembers on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void addMembers(const Tp::UIntList& contacts, const QString& message, const Tp::Service::ChannelInterfaceGroupAdaptor::AddMembersContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Invite all the given contacts into the channel, or accept requests for
     *   channel membership for contacts on the pending local list.</p>
     * 
     * <p>A message may be provided along with the request, which will be sent
     * to the server if supported. See the CHANNEL_GROUP_FLAG_MESSAGE_ADD and
     * CHANNEL_GROUP_FLAG_MESSAGE_ACCEPT
     *  \endhtmlonly \link requestPropertyGroupFlags() GroupFlags \endlink \htmlonly  to see in which cases this
     * message should be provided.</p>
     * 
     * <p>Attempting to add contacts who are already members is allowed;
     *   connection managers must silently accept this, without error.</p>
     * \endhtmlonly
     *
     * \param contacts
     *     
     *     An array of contact handles to invite to the channel
     * \param message
     *     
     *     A string message, which can be blank if desired
     */
    void AddMembers(const Tp::UIntList& contacts, const QString& message, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetAllMembers on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getAllMembers(const Tp::Service::ChannelInterfaceGroupAdaptor::GetAllMembersContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Returns arrays of all current, local and remote pending channel members.
     *
     * \param localPending Output parameter
     *     
     *     array of handles of local pending members
     * \param remotePending Output parameter
     *     
     *     array of handles of remote pending members
     * \return
     *     
     *     array of handles of current members
     */
    Tp::UIntList GetAllMembers(const QDBusMessage& dbusMessage, Tp::UIntList& localPending, Tp::UIntList& remotePending);
    /**
     * Begins a call to the exported D-Bus method \c GetGroupFlags on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getGroupFlags(const Tp::Service::ChannelInterfaceGroupAdaptor::GetGroupFlagsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Returns the value of the GroupFlags property.
     *
     * \return
     *     
     *     The value of the GroupFlags property
     */
    uint GetGroupFlags(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetHandleOwners on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getHandleOwners(const Tp::UIntList& handles, const Tp::Service::ChannelInterfaceGroupAdaptor::GetHandleOwnersContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * If the CHANNEL_GROUP_FLAG_CHANNEL_SPECIFIC_HANDLES flag is set on the 
     * channel, then the handles of the group members are specific to this 
     * channel, and are not meaningful in a connection-wide context such as 
     * contact lists. This method allows you to find the owner of the handle 
     * if it can be discovered in this channel, or 0 if the owner is not 
     * available.
     *
     * \param handles
     *     
     *     A list of integer handles representing members of the channel
     * \return
     *     
     *     An array of integer handles representing the owner handles of the 
     *     given room members, in the same order, or 0 if the owner is not 
     *     available
     */
    Tp::UIntList GetHandleOwners(const Tp::UIntList& handles, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetLocalPendingMembers on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getLocalPendingMembers(const Tp::Service::ChannelInterfaceGroupAdaptor::GetLocalPendingMembersContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Returns the To_Be_Added handle (only) for each structure in the 
     * LocalPendingMembers property.
     *
     * \return
     */
    Tp::UIntList GetLocalPendingMembers(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetLocalPendingMembersWithInfo on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getLocalPendingMembersWithInfo(const Tp::Service::ChannelInterfaceGroupAdaptor::GetLocalPendingMembersWithInfoContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Returns the LocalPendingMembers property.
     *
     * \return
     *     
     *     An array of structs containing: A handle representing the contact 
     *     requesting channel membership A handle representing the contact 
     *     making the request, or 0 if unknown The reason for the request: one 
     *     of the values of Channel_Group_Change_Reason A string message 
     *     containing the reason for the request if any (or blank if none)
     */
    Tp::LocalPendingInfoList GetLocalPendingMembersWithInfo(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetMembers on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getMembers(const Tp::Service::ChannelInterfaceGroupAdaptor::GetMembersContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Returns the Members property.
     *
     * \return
     */
    Tp::UIntList GetMembers(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetRemotePendingMembers on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getRemotePendingMembers(const Tp::Service::ChannelInterfaceGroupAdaptor::GetRemotePendingMembersContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Returns an array of handles representing contacts who have been invited 
     * to the channel and are awaiting remote approval.
     *
     * \return
     */
    Tp::UIntList GetRemotePendingMembers(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetSelfHandle on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getSelfHandle(const Tp::Service::ChannelInterfaceGroupAdaptor::GetSelfHandleContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Returns the value of the SelfHandle property.
     *
     * \return
     */
    uint GetSelfHandle(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RemoveMembers on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void removeMembers(const Tp::UIntList& contacts, const QString& message, const Tp::Service::ChannelInterfaceGroupAdaptor::RemoveMembersContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Requests the removal of contacts from a channel, reject their
     *   request for channel membership on the pending local list, or
     *   rescind their invitation on the pending remote list.</p>
     * 
     * <p>If the  \endhtmlonly \link requestPropertySelfHandle() SelfHandle \endlink \htmlonly  is in a Group,
     *   it can be removed via this method, in order to leave the group
     *   gracefully. This is the recommended way to leave a chatroom, close
     *   or reject a  \endhtmlonly ChannelTypeStreamedMediaInterface \htmlonly 
     *   call, and so on.</p>
     * 
     * <p>Accordingly, connection managers SHOULD support
     *   doing this, regardless of the value of
     *    \endhtmlonly \link requestPropertyGroupFlags() GroupFlags \endlink \htmlonly .
     *   If doing so fails with PermissionDenied, this is considered to a bug
     *   in the connection manager, but clients MUST recover by falling back
     *   to closing the channel with the  \endhtmlonly ChannelInterface::Close() \htmlonly 
     *   method.</p>
     * 
     * <p>Removing any contact from the local pending list is always
     *   allowed. Removing contacts other than the
     *    \endhtmlonly \link requestPropertySelfHandle() SelfHandle \endlink \htmlonly  from the channel's members
     *   is allowed if and only if Channel_Group_Flag_Can_Remove is in the
     *    \endhtmlonly \link requestPropertyGroupFlags() GroupFlags \endlink \htmlonly ,
     *   while removing contacts other than the
     *    \endhtmlonly \link requestPropertySelfHandle() SelfHandle \endlink \htmlonly  from the remote pending list
     *   is allowed if and only if Channel_Group_Flag_Can_Rescind is in the
     *    \endhtmlonly \link requestPropertyGroupFlags() GroupFlags \endlink \htmlonly .</p>
     * 
     * <p>A message may be provided along with the request, which will be
     *   sent to the server if supported. See the
     *   Channel_Group_Flag_Message_Remove,
     *   Channel_Group_Flag_Message_Depart,
     *   Channel_Group_Flag_Message_Reject and
     *   Channel_Group_Flag_Message_Rescind
     *    \endhtmlonly \link requestPropertyGroupFlags() GroupFlags \endlink \htmlonly  to see in which cases this
     *   message should be provided.</p>
     * \endhtmlonly
     *
     * \param contacts
     *     
     *     An array of contact handles to remove from the channel
     * \param message
     *     
     *     A string message, which can be blank if desired
     */
    void RemoveMembers(const Tp::UIntList& contacts, const QString& message, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RemoveMembersWithReason on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void removeMembersWithReason(const Tp::UIntList& contacts, const QString& message, uint reason, const Tp::Service::ChannelInterfaceGroupAdaptor::RemoveMembersWithReasonContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * As RemoveMembers, but a reason code may be provided where appropriate. 
     * The reason code may be ignored if the underlying protocol is unable to 
     * represent the given reason.
     *
     * \param contacts
     *     
     *     An array of contact handles to remove from the channel
     * \param message
     *     
     *     A string message, which can be blank if desired
     * \param reason
     *     
     *     A reason for the change
     */
    void RemoveMembersWithReason(const Tp::UIntList& contacts, const QString& message, uint reason, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c HandleOwnersChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void handleOwnersChanged(const Tp::HandleOwnerMap& added, const Tp::UIntList& removed);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param added
     *     
     *     A map from channel-specific handles to their owners, in which the 
     *     keys include all the handles that were added to the keys of the 
     *     HandleOwners property, and all the handles in that property whose 
     *     owner has changed
     * \param removed
     *     
     *     The channel-specific handles that were removed from the keys of the 
     *     HandleOwners property, as a result of the contact leaving this 
     *     group in a previous MembersChanged signal
     */
    void HandleOwnersChanged(const Tp::HandleOwnerMap& added, const Tp::UIntList& removed);
    /**
     * Represents the exported D-Bus signal \c HandleOwnersChangedDetailed on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void handleOwnersChangedDetailed(const Tp::HandleOwnerMap& added, const Tp::UIntList& removed, const Tp::HandleIdentifierMap& identifiers);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param added
     *     
     *     A map from channel-specific handles to their owners, in which the 
     *     keys include all the handles that were added to the keys of the 
     *     HandleOwners property, and all the handles in that property whose 
     *     owner has changed
     * \param removed
     *     
     *     The channel-specific handles that were removed from the keys of the 
     *     HandleOwners property, as a result of the contact leaving this 
     *     group in a previous MembersChanged signal
     * \param identifiers
     *     
     *     The string identifiers for handles mentioned in this signal, to 
     *     give clients the minimal information necessary to create contacts 
     *     without waiting for round-trips. Connection managers MUST include 
     *     at least the identifiers for all handles in the Added map, and MAY 
     *     include those from Removed array.
     */
    void HandleOwnersChangedDetailed(const Tp::HandleOwnerMap& added, const Tp::UIntList& removed, const Tp::HandleIdentifierMap& identifiers);
    /**
     * Represents the exported D-Bus signal \c SelfHandleChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void selfHandleChanged(uint selfHandle);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param selfHandle
     *     
     *     The new value of the SelfHandle property.
     */
    void SelfHandleChanged(uint selfHandle);
    /**
     * Represents the exported D-Bus signal \c SelfContactChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void selfContactChanged(uint selfHandle, const QString& selfID);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param selfHandle
     *     
     *     The new value of the SelfHandle property.
     * \param selfID
     *     
     *     The new value of the SelfHandle property&apos;s identifier.
     */
    void SelfContactChanged(uint selfHandle, const QString& selfID);
    /**
     * Represents the exported D-Bus signal \c GroupFlagsChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void groupFlagsChanged(uint added, uint removed);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param added
     *     
     *     A bitwise OR of the flags which have been set
     * \param removed
     *     
     *     A bitwise OR of the flags which have been cleared
     */
    void GroupFlagsChanged(uint added, uint removed);
    /**
     * Represents the exported D-Bus signal \c MembersChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void membersChanged(const QString& message, const Tp::UIntList& added, const Tp::UIntList& removed, const Tp::UIntList& localPending, const Tp::UIntList& remotePending, uint actor, uint reason);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param message
     *     
     *     A string message from the server, or blank if not
     * \param added
     *     
     *     A list of members added to the channel
     * \param removed
     *     
     *     A list of members removed from the channel
     * \param localPending
     *     
     *     A list of members who are pending local approval
     * \param remotePending
     *     
     *     A list of members who are pending remote approval
     * \param actor
     *     
     *     The contact handle of the person who made the change, or 0 if not 
     *     known
     * \param reason
     *     
     *     A reason for the change
     */
    void MembersChanged(const QString& message, const Tp::UIntList& added, const Tp::UIntList& removed, const Tp::UIntList& localPending, const Tp::UIntList& remotePending, uint actor, uint reason);
    /**
     * Represents the exported D-Bus signal \c MembersChangedDetailed on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void membersChangedDetailed(const Tp::UIntList& added, const Tp::UIntList& removed, const Tp::UIntList& localPending, const Tp::UIntList& remotePending, const QVariantMap& details);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param added
     *     
     *     A list of members added to the channel
     * \param removed
     *     
     *     A list of members removed from the channel
     * \param localPending
     *     
     *     A list of members who are pending local approval
     * \param remotePending
     *     
     *     A list of members who are pending remote approval
     * \param details
     *     
     *     \htmlonly
     *     <p>Information about the change, which may include the following
     *       well-known keys:</p>
     *     
     *     <dl>
     *       <dt>actor (u — <tp:type>Contact_Handle</tp:type>)</dt>
     *       <dd>The contact handle of the person who made the change; 0 or
     *         omitted if unknown or not applicable.</dd>
     *     
     *       <dt>change-reason (u — <tp:type>Channel_Group_Change_Reason</tp:type>)</dt>
     *       <dd>A reason for the change.</dd>
     *     
     *       <dt>contact-ids (a{us} — <tp:type>Handle_Identifier_Map</tp:type>)</dt>
     *       <dd>
     *         <p>The string identifiers for handles mentioned in this signal, to
     *         give clients the minimal information necessary to react to the
     *         event without waiting for round-trips.  Connection managers
     *         SHOULD include the identifiers for members added to the group and
     *         for the actor (if any); they MAY omit the identifiers for handles
     *         which have been removed from the group.</p>
     *     
     *         <div class="rationale">
     *           <p>On IRC, an event such as a netsplit could cause the vast
     *           majority of a channel to leave.  Given that clients should
     *           already know the identifiers of a channel's members, including
     *           potentially hundreds of strings in the netsplit signal is
     *           unnecessary.</p>
     *         </div>
     *     
     *         <p>Clients MUST NOT assume that the presence or absence of a
     *           handle in this mapping is meaningful. This mapping is merely
     *           an optimization for round-trip reduction, and connection
     *           managers MAY add additional handles, omit some handles, or
     *           omit the mapping completely.</p>
     *       </dd>
     *     
     *       <dt>message (s)</dt>
     *       <dd>A string message from the server regarding the change</dd>
     *     
     *       <dt>error (s — <tp:type>DBus_Error_Name</tp:type>)</dt>
     *       <dd>A (possibly implementation-specific) DBus error describing the
     *         change, providing more specific information than the
     *         <tp:type>Channel_Group_Change_Reason</tp:type> enum allows. This
     *         MUST only be present if it is strictly more informative than
     *         'change-reason'; if present, 'change-reason' MUST be set to the
     *         closest available reason.
     *     
     *         <div class="rationale">
     *           A SIP connection manager might want to signal &quot;402 Payment
     *           required&quot; as something more specific than Error or
     *           Permission_Denied so that a SIP-aware UI could handle it
     *           specially; including a namespaced error permits this to be done
     *           without <tp:type>Channel_Group_Change_Reason</tp:type> being
     *           extended to encompass every error any CM ever wants to report.
     *         </div>
     *       </dd>
     *     
     *       <dt>debug-message (s)</dt>
     *       <dd>Debugging information on the change. SHOULD NOT be shown to
     *         users in normal circumstances.</dd>
     *     </dl>
     *     \endhtmlonly
     */
    void MembersChangedDetailed(const Tp::UIntList& added, const Tp::UIntList& removed, const Tp::UIntList& localPending, const Tp::UIntList& remotePending, const QVariantMap& details);
};

/**
 * \class ChannelInterfaceHoldAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Hold".
 */
class TP_QT_EXPORT ChannelInterfaceHoldAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.Hold")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.Hold\">\n"
"    <method name=\"GetHoldState\">\n"
"      <arg direction=\"out\" type=\"u\" name=\"holdState\"/>\n"
"      <arg direction=\"out\" type=\"u\" name=\"reason\"/>\n"
"    </method>\n"
"    <method name=\"RequestHold\">\n"
"      <arg direction=\"in\" type=\"b\" name=\"hold\"/>\n"
"    </method>\n"
"    <signal name=\"HoldStateChanged\">\n"
"      <arg type=\"u\" name=\"holdState\"/>\n"
"      <arg type=\"u\" name=\"reason\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")

public:
    ChannelInterfaceHoldAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceHoldAdaptor();

    typedef Tp::MethodInvocationContextPtr< uint, uint > GetHoldStateContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > RequestHoldContextPtr;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetHoldState on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getHoldState(const Tp::Service::ChannelInterfaceHoldAdaptor::GetHoldStateContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Return whether the local user has placed the channel on hold.
     *
     * \param reason Output parameter
     *     
     *     The reason why the channel is in that state
     * \return
     *     
     *     The state of the channel
     */
    uint GetHoldState(const QDBusMessage& dbusMessage, uint& reason);
    /**
     * Begins a call to the exported D-Bus method \c RequestHold on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestHold(bool hold, const Tp::Service::ChannelInterfaceHoldAdaptor::RequestHoldContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request that the channel be put on hold (be instructed not to send
     *   any media streams to you) or be taken off hold.</p>
     * 
     * <p>If the connection manager can immediately tell that the requested
     *   state change could not possibly succeed, this method SHOULD
     *   return the NotAvailable error. If the requested state is the
     *   same as the current state, this method SHOULD return successfully
     *   without doing anything.</p>
     * 
     * <p>Otherwise, this method SHOULD immediately set the hold state to
     *   Local_Hold_State_Pending_Hold or Local_Hold_State_Pending_Unhold
     *   (as appropriate), emitting
     *    \endhtmlonly HoldStateChanged() \htmlonly  if this is a change,
     *   and return successfully.</p>
     * 
     * <p>The eventual success or failure of the request is indicated by a
     *   subsequent HoldStateChanged signal, changing the hold state to
     *   Local_Hold_State_Held or Local_Hold_State_Unheld.</p>
     * 
     * <p>If the channel has multiple streams, and the connection manager
     *   succeeds in changing the hold state of one stream but fails to
     *   change the hold state of another, it SHOULD attempt to revert
     *   all streams to their previous hold states.</p>
     * 
     * <p>The following state transitions SHOULD be used, where
     *   appropriate:</p>
     * 
     * <ul>
     *   <li>Successful hold:
     *     (Unheld, any reason) → (Pending_Hold, Requested) →
     *     (Held, Requested)
     *   </li>
     *   <li>Successful unhold:
     *     (Held, any reason) → (Pending_Unhold, Requested) →
     *     (Unheld, Requested)
     *   </li>
     *   <li>Attempting to unhold fails at the first attempt to acquire a
     *     resource:
     *     (Held, any reason) → (Pending_Unhold, Requested) →
     *     (Held, Resource_Not_Available)
     *   </li>
     *   <li>Attempting to unhold acquires one resource, but fails to acquire
     *     a second, and takes time to release the first:
     *     (Held, any reason) → (Pending_Unhold, Requested) →
     *     (Pending_Hold, Resource_Not_Available) →
     *     (Held, Resource_Not_Available)
     *   </li>
     * </ul>
     * \endhtmlonly
     *
     * \param hold
     *     
     *     A boolean indicating whether or not the channel should be on hold
     */
    void RequestHold(bool hold, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c HoldStateChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void holdStateChanged(uint holdState, uint reason);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param holdState
     *     
     *     The state of the channel
     * \param reason
     *     
     *     The reason for the state change
     */
    void HoldStateChanged(uint holdState, uint reason);
};

/**
 * \class ChannelInterfaceMediaSignallingAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.MediaSignalling".
 */
class TP_QT_EXPORT ChannelInterfaceMediaSignallingAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.MediaSignalling")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.MediaSignalling\">\n"
"    <method name=\"GetSessionHandlers\">\n"
"      <arg direction=\"out\" type=\"a(os)\" name=\"sessionHandlers\">\n"
"        <annotation value=\"Tp::MediaSessionHandlerInfoList\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <signal name=\"NewSessionHandler\">\n"
"      <arg type=\"o\" name=\"sessionHandler\"/>\n"
"      <arg type=\"s\" name=\"sessionType\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")

public:
    ChannelInterfaceMediaSignallingAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceMediaSignallingAdaptor();

    typedef Tp::MethodInvocationContextPtr< Tp::MediaSessionHandlerInfoList > GetSessionHandlersContextPtr;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetSessionHandlers on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getSessionHandlers(const Tp::Service::ChannelInterfaceMediaSignallingAdaptor::GetSessionHandlersContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Returns all currently active session handlers on this channel as a list 
     * of (session_handler_path, type).
     *
     * \return
     */
    Tp::MediaSessionHandlerInfoList GetSessionHandlers(const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c NewSessionHandler on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void newSessionHandler(const QDBusObjectPath& sessionHandler, const QString& sessionType);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param sessionHandler
     *     
     *     Object path of the new Media.SessionHandler object
     * \param sessionType
     *     
     *     String indicating type of session, eg &quot;rtp&quot;
     */
    void NewSessionHandler(const QDBusObjectPath& sessionHandler, const QString& sessionType);
};

/**
 * \class ChannelInterfaceMergeableConferenceAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.MergeableConference.DRAFT".
 */
class TP_QT_EXPORT ChannelInterfaceMergeableConferenceAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.MergeableConference.DRAFT")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.MergeableConference.DRAFT\">\n"
"    <method name=\"Merge\">\n"
"      <arg direction=\"in\" type=\"o\" name=\"channel\"/>\n"
"    </method>\n"
"  </interface>\n"
"")

public:
    ChannelInterfaceMergeableConferenceAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceMergeableConferenceAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > MergeContextPtr;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c Merge on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void merge(const QDBusObjectPath& channel, const Tp::Service::ChannelInterfaceMergeableConferenceAdaptor::MergeContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request that the given channel be incorporated into this
     *   channel.</p>
     * 
     * <p>The given channel SHOULD be added to  \endhtmlonly \link ChannelInterfaceConferenceInterface::requestPropertyChannels() ChannelInterfaceConferenceInterface::Channels \endlink \htmlonly  if and only if the
     *   underlying protocol signals the merge in some way. It MUST NOT be
     *   added to  \endhtmlonly \link ChannelInterfaceConferenceInterface::requestPropertyInitialChannels() ChannelInterfaceConferenceInterface::InitialChannels \endlink \htmlonly  (to preserve
     *   immutability).</p>
     * 
     * <div class="rationale">
     *   <p>In GSM it is possible to merge additional calls into an ongoing
     *     conference.</p>
     * 
     *   <p>In XMPP this method could be implemented to merge a 1-1 Text
     *     channel into a MUC Text channel by inviting the peer from the Text
     *     channel into the MUC, or to merge a 1-1 Jingle call into a Muji
     *     call by inviting the peer from the Jingle call into the Muji call.
     *     (MUC and Muji channels are both implemented by XMPP MUCs, with
     *     Handle_Type_Room.)</p>
     * </div>
     * \endhtmlonly
     *
     * \param channel
     *     
     *     \htmlonly
     *     <p>A channel with the same  \\\\endhtmlonly \\\\link ChannelInterface::requestPropertyChannelType() ChannelInterface::ChannelType \\\\endlink \\\\htmlonly 
     *       as this one, but with  \\\\endhtmlonly \\\\link ChannelInterface::requestPropertyTargetHandleType() ChannelInterface::TargetHandleType \\\\endlink \\\\htmlonly  = CONTACT.</p>
     *     \endhtmlonly
     */
    void Merge(const QDBusObjectPath& channel, const QDBusMessage& dbusMessage);
};

/**
 * \class ChannelInterfaceMessagesAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Messages".
 */
class TP_QT_EXPORT ChannelInterfaceMessagesAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.Messages")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.Messages\">\n"
"    <property access=\"read\" type=\"as\" name=\"SupportedContentTypes\"/>\n"
"    <property access=\"read\" type=\"au\" name=\"MessageTypes\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"MessagePartSupportFlags\"/>\n"
"    <property access=\"read\" type=\"aaa{sv}\" name=\"PendingMessages\">\n"
"      <annotation value=\"Tp::MessagePartListList\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"u\" name=\"DeliveryReportingSupport\"/>\n"
"    <method name=\"SendMessage\">\n"
"      <arg direction=\"in\" type=\"aa{sv}\" name=\"message\">\n"
"        <annotation value=\"Tp::MessagePartList\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg direction=\"in\" type=\"u\" name=\"flags\"/>\n"
"      <arg direction=\"out\" type=\"s\" name=\"token\"/>\n"
"    </method>\n"
"    <method name=\"GetPendingMessageContent\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"messageID\"/>\n"
"      <arg direction=\"in\" type=\"au\" name=\"parts\"/>\n"
"      <arg direction=\"out\" type=\"a{uv}\" name=\"content\">\n"
"        <annotation value=\"Tp::MessagePartContentMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <signal name=\"MessageSent\">\n"
"      <arg type=\"aa{sv}\" name=\"content\">\n"
"        <annotation value=\"Tp::MessagePartList\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg type=\"u\" name=\"flags\"/>\n"
"      <arg type=\"s\" name=\"messageToken\"/>\n"
"    </signal>\n"
"    <signal name=\"PendingMessagesRemoved\">\n"
"      <arg type=\"au\" name=\"messageIDs\"/>\n"
"    </signal>\n"
"    <signal name=\"MessageReceived\">\n"
"      <arg type=\"aa{sv}\" name=\"message\">\n"
"        <annotation value=\"Tp::MessagePartList\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QStringList SupportedContentTypes READ SupportedContentTypes )
    Q_PROPERTY(Tp::UIntList MessageTypes READ MessageTypes )
    Q_PROPERTY(uint MessagePartSupportFlags READ MessagePartSupportFlags )
    Q_PROPERTY(Tp::MessagePartListList PendingMessages READ PendingMessages )
    Q_PROPERTY(uint DeliveryReportingSupport READ DeliveryReportingSupport )

public:
    ChannelInterfaceMessagesAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceMessagesAdaptor();

    typedef Tp::MethodInvocationContextPtr< QString > SendMessageContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::MessagePartContentMap > GetPendingMessageContentContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c SupportedContentTypes of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'supportedContentTypes' with type QStringList.
     *
     * 
     * \htmlonly
     * <p>A list of MIME types supported by this channel, with more preferred
     *   MIME types appearing earlier in the list. The list MAY include &quot;&#42;&#47;*&quot;
     *   to indicate that attachments with arbitrary MIME types can be sent.
     *   This list MUST NOT be empty, since all Messages implementations
     *   MUST accept messages containing a single &quot;text/plain&quot; part.</p>
     * 
     * <p>Items in this list MUST be normalized to lower-case.</p>
     * 
     * <p>Some examples of how this property interacts with the
     *    \endhtmlonly \link requestPropertyMessagePartSupportFlags() MessagePartSupportFlags \endlink \htmlonly :</p>
     * 
     * <dl>
     *   <dt>A simple IM implementation: only plain text messages are
     *     allowed</dt>
     *   <dd>SupportedContentTypes = ['text/plain'],
     *     MessagePartSupportFlags = 0</dd>
     * 
     *   <dt>Formatted text with a plain text alternative is allowed (see the
     *     HTML interface draft)</dt>
     *   <dd>SupportedContentTypes = ['text/html', 'text/plain'],
     *     MessagePartSupportFlags = 0</dd>
     * 
     *   <dt>JPEG or PNG images may be sent, but without any attached
     *     text</dt>
     *   <dd>SupportedContentTypes = ['text/plain', 'image/jpeg',
     *     'image/png'], MessagePartSupportFlags = 0</dd>
     * 
     *   <dt>Unformatted text to which an optional JPEG or PNG image may be
     *     attached</dt>
     *   <dd>SupportedContentTypes = ['text/plain', 'image/jpeg',
     *     'image/png'], MessagePartSupportFlags = One_Attachment</dd>
     * 
     *   <dt>Formatted text to which arbitrarily many images may be
     *     attached</dt>
     *   <dd>SupportedContentTypes = ['text/html', 'text/plain', 'image/jpeg',
     *     'image/png', 'image/x-ms-bmp'], MessagePartSupportFlags =
     *     One_Attachment | Multiple_Attachments</dd>
     * 
     *   <dt>A full SIP implementation: arbitrary MIME messages are
     *     allowed</dt>
     *   <dd>SupportedContentTypes = ['&#42;&#47;*'], MessagePartSupportFlags =
     *     One_Attachment | Multiple_Attachments</dd>
     * </dl>
     * \endhtmlonly
     *
     * \return The value of exported property \c SupportedContentTypes.
     */
    QStringList SupportedContentTypes() const;
    /**
     * Return the value of the exported D-Bus object property \c MessageTypes of type \c Tp::UIntList.
     *
     * Adaptees should export this property as a Qt property named
     * 'messageTypes' with type Tp::UIntList.
     *
     * 
     * \htmlonly
     * <p>A list of message types which may be sent on this channel.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c MessageTypes.
     */
    Tp::UIntList MessageTypes() const;
    /**
     * Return the value of the exported D-Bus object property \c MessagePartSupportFlags of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'messagePartSupportFlags' with type uint.
     *
     * 
     * Flags indicating the level of support for message parts on this channel.
     *
     * \return The value of exported property \c MessagePartSupportFlags.
     */
    uint MessagePartSupportFlags() const;
    /**
     * Return the value of the exported D-Bus object property \c PendingMessages of type \c Tp::MessagePartListList.
     *
     * Adaptees should export this property as a Qt property named
     * 'pendingMessages' with type Tp::MessagePartListList.
     *
     * 
     * \htmlonly
     * <p>A list of incoming messages that have neither been acknowledged nor
     *   rejected. This list is a more detailed version of the one returned
     *   by  \endhtmlonly ChannelTypeTextInterface::ListPendingMessages() \htmlonly ,
     *   and contains the same messages, uniquely identified by the same
     *   pending message IDs. Its items can be removed using
     *    \endhtmlonly ChannelTypeTextInterface::AcknowledgePendingMessages() \htmlonly .</p>
     * 
     * <p>Change notification is via
     *    \endhtmlonly MessageReceived() \htmlonly  and
     *    \endhtmlonly PendingMessagesRemoved() \htmlonly .</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c PendingMessages.
     */
    Tp::MessagePartListList PendingMessages() const;
    /**
     * Return the value of the exported D-Bus object property \c DeliveryReportingSupport of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'deliveryReportingSupport' with type uint.
     *
     * 
     * A bitfield indicating features supported by this channel.
     *
     * \return The value of exported property \c DeliveryReportingSupport.
     */
    uint DeliveryReportingSupport() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c SendMessage on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void sendMessage(const Tp::MessagePartList& message, uint flags, const Tp::Service::ChannelInterfaceMessagesAdaptor::SendMessageContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Submit a message to the server for sending.
     *   If this method returns successfully, the message has been submitted
     *   to the server and the  \endhtmlonly MessageSent() \htmlonly 
     *   signal is emitted. A corresponding
     *    \endhtmlonly ChannelTypeTextInterface::Sent() \htmlonly 
     *   signal on the Text interface MUST also be emitted.</p>
     * 
     * <p>This method MUST return before the MessageSent signal is
     *   emitted.</p>
     * 
     * <div class="rationale">
     *   <p>This means that the process sending the message is the first
     *     to see the <tp:type>Protocol_Message_Token</tp:type>, and can
     *     relate the message to the corresponding
     *      \endhtmlonly MessageSent() \htmlonly  signal by comparing
     *     message tokens (if supported by the protocol).</p>
     * </div>
     * 
     * <p>If this method fails, message submission to the server has failed
     *   and no signal on this interface (or the Text interface) is
     *   emitted.</p>
     * 
     * <p>If this method succeeds, message submission to the server has
     *   succeeded, but the message has not necessarily reached its intended
     *   recipient. If a delivery failure is detected later, this is
     *   signalled by receiving a message whose <code>message-type</code>
     *   header maps to
     *   <tp:value-ref type="Channel_Text_Message_Type">Delivery_Report</tp:value-ref>.
     *   Similarly, if delivery is detected to have been successful
     *   (which is not possible in all protocols), a successful delivery
     *   report will be signalled.</p>
     * \endhtmlonly
     *
     * \param message
     *     
     *     The message content, including any attachments or alternatives. 
     *     This MUST NOT include the following headers, or any others that do 
     *     not make sense for a client to specify: message-sender, 
     *     message-sender-id, message-sent, message-received, 
     *     pending-message-id.
     * \param flags
     *     
     *     Flags affecting how the message is sent. The channel MAY ignore 
     *     some or all flags, depending on DeliveryReportingSupport; the flags 
     *     that were handled by the CM are provided in MessageSent.
     * \return
     *     
     *     An opaque token used to match any incoming delivery or failure 
     *     reports against this message, or an empty string if the message is 
     *     not readily identifiable.
     */
    QString SendMessage(const Tp::MessagePartList& message, uint flags, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetPendingMessageContent on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getPendingMessageContent(uint messageID, const Tp::UIntList& parts, const Tp::Service::ChannelInterfaceMessagesAdaptor::GetPendingMessageContentContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Retrieve the content of one or more parts of a pending message. Note 
     * that this function may take a considerable amount of time to return if 
     * the part&apos;s &apos;needs-retrieval&apos; flag is true; consider 
     * extending the default D-Bus method call timeout. Additional API is 
     * likely to be added in future, to stream large message parts.
     *
     * \param messageID
     *     
     *     The ID of a pending message
     * \param parts
     *     
     *     The desired entries in the array of message parts, identified by 
     *     their position. The &quot;headers&quot; part (which is not a valid 
     *     argument to this method) is considered to be part 0, so the valid 
     *     part numbers start at 1 (for the second Message_Part).
     * \return
     *     
     *     \htmlonly
     *     <p>The content of the requested parts. The keys in this mapping
     *       are positions in the array of message parts; the values are
     *       either of type 's' or 'ay' (UTF-8 text string, or byte array),
     *       following the same rules as for the value of the 'content' key in
     *       the <tp:type>Message_Part</tp:type> mappings.</p>
     *     
     *     <p>If the one of the requested part numbers was greater than zero
     *       but referred to a part that had no content (i.e. it had no
     *       'content-type' key or no 'content' key), it is simply omitted from
     *       this mapping; this is not considered to be an error condition.</p>
     *     \endhtmlonly
     */
    Tp::MessagePartContentMap GetPendingMessageContent(uint messageID, const Tp::UIntList& parts, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c MessageSent on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void messageSent(const Tp::MessagePartList& content, uint flags, const QString& messageToken);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param content
     *     
     *     \htmlonly
     *     <p>The message content (see <tp:type>Message_Part</tp:type> for full
     *       details). If the message that was passed to
     *        \\\\endhtmlonly SendMessage() \\\\htmlonly  has a formatted text
     *       part that the connection manager recognises, but no
     *       <tt>text/plain</tt> alternative, the CM MUST use the formatted text
     *       part to generate a <tt>text/plain</tt> alternative which is also
     *       included in this signal argument.</p>
     *     
     *     <p>The connection manager SHOULD include the
     *       <code>message-sender</code>, <code>message-sender-id</code> and
     *       <code>message-sent</code> headers in the representation of the
     *       message that is signalled here. If the channel has
     *       channel-specific handles, the <code>message-sender</code> and
     *       <code>message-sender-id</code> SHOULD reflect the sender that
     *       other contacts will see.</p>
     *     
     *     <p>If the connection manager can predict that the message will be
     *       altered during transmission, this argument SHOULD reflect what
     *       other contacts will receive, rather than being a copy of the
     *       argument to SendMessage (if the message is truncated,
     *       formatting or alternatives are dropped, etc., then the edited
     *       version SHOULD appear in this signal).</p>
     *     \endhtmlonly
     * \param flags
     *     
     *     Flags affecting how the message was sent. The flags might be a 
     *     subset of those passed to SendMessage if the caller requested 
     *     unsupported flags.
     * \param messageToken
     *     
     *     An opaque token used to match any incoming delivery or failure 
     *     reports against this message, or an empty string if the message is 
     *     not readily identifiable.
     */
    void MessageSent(const Tp::MessagePartList& content, uint flags, const QString& messageToken);
    /**
     * Represents the exported D-Bus signal \c PendingMessagesRemoved on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void pendingMessagesRemoved(const Tp::UIntList& messageIDs);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param messageIDs
     *     
     *     The messages that have been removed from the pending message list.
     */
    void PendingMessagesRemoved(const Tp::UIntList& messageIDs);
    /**
     * Represents the exported D-Bus signal \c MessageReceived on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void messageReceived(const Tp::MessagePartList& message);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param message
     *     
     *     \htmlonly
     *     <p>The message content, including any attachments or alternatives. If
     *       the incoming message contains formatted text without a plain text
     *       alternative, the connection manager MUST generate a
     *       <tt>text/plain</tt> alternative from the formatted text, and
     *       include it in this message (both here, and in the
     *        \\\\endhtmlonly \\\\link requestPropertyPendingMessages() PendingMessages \\\\endlink \\\\htmlonly  property).</p>
     *     \endhtmlonly
     */
    void MessageReceived(const Tp::MessagePartList& message);
};

/**
 * \class ChannelInterfacePasswordAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Password".
 */
class TP_QT_EXPORT ChannelInterfacePasswordAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.Password")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.Password\">\n"
"    <method name=\"GetPasswordFlags\">\n"
"      <arg direction=\"out\" type=\"u\" name=\"passwordFlags\"/>\n"
"    </method>\n"
"    <method name=\"ProvidePassword\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"password\"/>\n"
"      <arg direction=\"out\" type=\"b\" name=\"correct\"/>\n"
"    </method>\n"
"    <signal name=\"PasswordFlagsChanged\">\n"
"      <arg type=\"u\" name=\"added\"/>\n"
"      <arg type=\"u\" name=\"removed\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")

public:
    ChannelInterfacePasswordAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfacePasswordAdaptor();

    typedef Tp::MethodInvocationContextPtr< uint > GetPasswordFlagsContextPtr;
    typedef Tp::MethodInvocationContextPtr< bool > ProvidePasswordContextPtr;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetPasswordFlags on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getPasswordFlags(const Tp::Service::ChannelInterfacePasswordAdaptor::GetPasswordFlagsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Returns the bitwise-OR of the flags relevant to the password on this 
     * channel. The user interface can use this to present information about 
     * which operations are currently valid.
     *
     * \return
     *     
     *     An integer with the logical OR of all the flags set (values of 
     *     ChannelPasswordFlags)
     */
    uint GetPasswordFlags(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c ProvidePassword on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void providePassword(const QString& password, const Tp::Service::ChannelInterfacePasswordAdaptor::ProvidePasswordContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Provide the password so that the channel can be joined. Must be called 
     * with the correct password in order for channel joining to proceed if 
     * the &apos;provide&apos; password flag is set.
     *
     * \param password
     *     
     *     The password
     * \return
     *     
     *     A boolean indicating whether or not the password was correct
     */
    bool ProvidePassword(const QString& password, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c PasswordFlagsChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void passwordFlagsChanged(uint added, uint removed);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param added
     *     
     *     A bitwise OR of the flags which have been set
     * \param removed
     *     
     *     A bitwise OR of the flags which have been cleared
     */
    void PasswordFlagsChanged(uint added, uint removed);
};

/**
 * \class ChannelInterfaceRoomAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Room2".
 */
class TP_QT_EXPORT ChannelInterfaceRoomAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.Room2")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.Room2\">\n"
"    <property access=\"read\" type=\"s\" name=\"RoomName\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"Server\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"Creator\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"CreatorHandle\"/>\n"
"    <property access=\"read\" type=\"x\" name=\"CreationTimestamp\"/>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QString RoomName READ RoomName )
    Q_PROPERTY(QString Server READ Server )
    Q_PROPERTY(QString Creator READ Creator )
    Q_PROPERTY(uint CreatorHandle READ CreatorHandle )
    Q_PROPERTY(qlonglong CreationTimestamp READ CreationTimestamp )

public:
    ChannelInterfaceRoomAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceRoomAdaptor();


public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c RoomName of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'roomName' with type QString.
     *
     * 
     * \htmlonly
     * <p>The human-readable identifier of a chat room. Note that if
     *   non-empty, this property (and perhaps also
     *    \endhtmlonly \link requestPropertyServer() Server \endlink \htmlonly ) should be sufficient in
     *   a channel request to join the room. XMPP MUCs have a room name
     *   concept which is more like a topic, except more
     *   persistent. This D-Bus property is <strong>not</strong> this
     *   XMPP room name, but the bit before the @ in the room jid; see
     *    \endhtmlonly \link ChannelInterfaceRoomConfigInterface::requestPropertyTitle() ChannelInterfaceRoomConfigInterface::Title \endlink \htmlonly 
     *   for that concept.</p>
     * 
     * <p>This property cannot change during the lifetime of the channel. It
     *   should appear in the <var>Allowed_Properties</var> of a
     *   <tp:type>Requestable_Channel_Class</tp:type> for the connection if
     *   rooms on this connection have human-readable names, and can be joined
     *   by name.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c RoomName.
     */
    QString RoomName() const;
    /**
     * Return the value of the exported D-Bus object property \c Server of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'server' with type QString.
     *
     * 
     * \htmlonly
     * <p>For protocols with a concept of chatrooms on multiple servers with
     *   different DNS names (like XMPP), the DNS name of the server hosting
     *   this channel (for example, <tt>&quot;conference.jabber.org&quot;</tt> or
     *   <tt>&quot;groupchat.google.com&quot;</tt>). For other protocols, the empty
     *   string.</p>
     * 
     * <p>This property cannot change during the lifetime of the channel. It
     *   should appear in the <var>Allowed_Properties</var> of a
     *   <tp:type>Requestable_Channel_Class</tp:type> for the connection if
     *   and only if non-empty values are supported.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Server.
     */
    QString Server() const;
    /**
     * Return the value of the exported D-Bus object property \c Creator of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'creator' with type QString.
     *
     * 
     * \htmlonly
     * The normalized contact ID representing who created the room; or
     * the empty string if unknown.
     * \endhtmlonly
     *
     * \return The value of exported property \c Creator.
     */
    QString Creator() const;
    /**
     * Return the value of the exported D-Bus object property \c CreatorHandle of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'creatorHandle' with type uint.
     *
     * 
     * \htmlonly
     * The handle corresponding to  \endhtmlonly \link requestPropertyCreator() Creator \endlink \htmlonly ;
     * or 0 if  \endhtmlonly \link requestPropertyCreator() Creator \endlink \htmlonly  is unknown.
     * \endhtmlonly
     *
     * \return The value of exported property \c CreatorHandle.
     */
    uint CreatorHandle() const;
    /**
     * Return the value of the exported D-Bus object property \c CreationTimestamp of type \c qlonglong.
     *
     * Adaptees should export this property as a Qt property named
     * 'creationTimestamp' with type qlonglong.
     *
     * 
     * \htmlonly
     * A unix timestamp indicating when the room was created; or
     * <code>INT_MAX64</code> if unknown.
     * \endhtmlonly
     *
     * \return The value of exported property \c CreationTimestamp.
     */
    qlonglong CreationTimestamp() const;
};

/**
 * \class ChannelInterfaceRoomConfigAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.RoomConfig1".
 */
class TP_QT_EXPORT ChannelInterfaceRoomConfigAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.RoomConfig1")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.RoomConfig1\">\n"
"    <property access=\"read\" type=\"b\" name=\"Anonymous\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"InviteOnly\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"Limit\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"Moderated\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"Title\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"Description\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"Persistent\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"Private\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"PasswordProtected\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"Password\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"PasswordHint\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"CanUpdateConfiguration\"/>\n"
"    <property access=\"read\" type=\"as\" name=\"MutableProperties\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"ConfigurationRetrieved\"/>\n"
"    <method name=\"UpdateConfiguration\">\n"
"      <arg direction=\"in\" type=\"a{sv}\" name=\"properties\">\n"
"        <annotation value=\"QVariantMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </method>\n"
"  </interface>\n"
"")
    Q_PROPERTY(bool Anonymous READ Anonymous )
    Q_PROPERTY(bool InviteOnly READ InviteOnly )
    Q_PROPERTY(uint Limit READ Limit )
    Q_PROPERTY(bool Moderated READ Moderated )
    Q_PROPERTY(QString Title READ Title )
    Q_PROPERTY(QString Description READ Description )
    Q_PROPERTY(bool Persistent READ Persistent )
    Q_PROPERTY(bool Private READ Private )
    Q_PROPERTY(bool PasswordProtected READ PasswordProtected )
    Q_PROPERTY(QString Password READ Password )
    Q_PROPERTY(QString PasswordHint READ PasswordHint )
    Q_PROPERTY(bool CanUpdateConfiguration READ CanUpdateConfiguration )
    Q_PROPERTY(QStringList MutableProperties READ MutableProperties )
    Q_PROPERTY(bool ConfigurationRetrieved READ ConfigurationRetrieved )

public:
    ChannelInterfaceRoomConfigAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceRoomConfigAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > UpdateConfigurationContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Anonymous of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'anonymous' with type bool.
     *
     * 
     * True if people may join the channel without other members being made 
     * aware of their identity.
     *
     * \return The value of exported property \c Anonymous.
     */
    bool Anonymous() const;
    /**
     * Return the value of the exported D-Bus object property \c InviteOnly of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'inviteonly' with type bool.
     *
     * 
     * True if people may not join the channel until they have been invited.
     *
     * \return The value of exported property \c InviteOnly.
     */
    bool InviteOnly() const;
    /**
     * Return the value of the exported D-Bus object property \c Limit of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'limit' with type uint.
     *
     * 
     * The limit to the number of members; or 0 if there is no limit.
     *
     * \return The value of exported property \c Limit.
     */
    uint Limit() const;
    /**
     * Return the value of the exported D-Bus object property \c Moderated of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'moderated' with type bool.
     *
     * 
     * True if channel membership is not sufficient to allow participation.
     *
     * \return The value of exported property \c Moderated.
     */
    bool Moderated() const;
    /**
     * Return the value of the exported D-Bus object property \c Title of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'title' with type QString.
     *
     * 
     * \htmlonly
     * A human-visible name for the channel, if it differs from  \endhtmlonly \link ChannelInterfaceRoomInterface::requestPropertyRoomName() ChannelInterfaceRoomInterface::RoomName \endlink \htmlonly ; the
     * empty string, otherwise.
     * 
     * <div class="rationale">
     *   <p>On XMPP, this represents the <code>muc#roomconfig_roomname</code>
     *   field of the <a href="http://xmpp.org/extensions/xep-0045.html#registrar-formtype-owner"><code>muc#roomconfig</code></a>
     *   form. So for <code>jdev@conference.jabber.org</code>, for example:</p>
     * 
     *   <ul>
     *     <li> \endhtmlonly \link ChannelInterfaceRoomInterface::requestPropertyRoomName() ChannelInterfaceRoomInterface::RoomName \endlink \htmlonly 
     *       = <code>&quot;jdev&quot;</code>;</li>
     *     <li> \endhtmlonly \link ChannelInterfaceRoomInterface::requestPropertyServer() ChannelInterfaceRoomInterface::Server \endlink \htmlonly 
     *       = <code>&quot;conference.jabber.org&quot;</code>;</li>
     *     <li> \endhtmlonly \link requestPropertyTitle() Title \endlink \htmlonly  = <code>&quot;General Jabber
     *       development discussion&quot;</code>.</li>
     *   </ul>
     * 
     *   <p>XEP-0045 is awful.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c Title.
     */
    QString Title() const;
    /**
     * Return the value of the exported D-Bus object property \c Description of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'description' with type QString.
     *
     * 
     * A human-readable description of the channel&apos;s overall purpose; if 
     * any.
     *
     * \return The value of exported property \c Description.
     */
    QString Description() const;
    /**
     * Return the value of the exported D-Bus object property \c Persistent of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'persistent' with type bool.
     *
     * 
     * \htmlonly
     * <code>True</code> if the channel will remain in existence on the server after all
     * members have left it.
     * \endhtmlonly
     *
     * \return The value of exported property \c Persistent.
     */
    bool Persistent() const;
    /**
     * Return the value of the exported D-Bus object property \c Private of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'private' with type bool.
     *
     * 
     * \htmlonly
     * <code>True</code> if the channel is not visible to non-members.
     * \endhtmlonly
     *
     * \return The value of exported property \c Private.
     */
    bool Private() const;
    /**
     * Return the value of the exported D-Bus object property \c PasswordProtected of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'passwordProtected' with type bool.
     *
     * 
     * \htmlonly
     * <code>True</code> if contacts joining this channel must provide a
     * password to be granted entry.  Note that this property does not
     * indicate that a password is required <em>right now</em>; see the
     *  \endhtmlonly ChannelInterfacePasswordInterface \htmlonly 
     * interface for the API used to provide a password while joining a room.
     * \endhtmlonly
     *
     * \return The value of exported property \c PasswordProtected.
     */
    bool PasswordProtected() const;
    /**
     * Return the value of the exported D-Bus object property \c Password of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'password' with type QString.
     *
     * 
     * \htmlonly
     * If  \endhtmlonly \link requestPropertyPasswordProtected() PasswordProtected \endlink \htmlonly  is
     * <code>True</code>, the password required to enter the channel, if
     * known. If the password is unknown, or
     *  \endhtmlonly \link requestPropertyPasswordProtected() PasswordProtected \endlink \htmlonly  is
     * <code>False</code>, the empty string.
     * 
     * <div class="rationale">
     *   On XMPP—bless its cotton socks!—non-owners of a MUC cannot see its
     *   current password, even if they just provided the password in order to
     *   join the room…
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c Password.
     */
    QString Password() const;
    /**
     * Return the value of the exported D-Bus object property \c PasswordHint of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'passwordHint' with type QString.
     *
     * 
     * \htmlonly
     * <p>If  \endhtmlonly \link requestPropertyPasswordProtected() PasswordProtected \endlink \htmlonly  is
     *   <code>True</code>, an optional hint for the password.</p>
     * 
     * <p>On protocols supporting PasswordHint (indicated by its presence
     *   in  \endhtmlonly \link requestPropertyMutableProperties() MutableProperties \endlink \htmlonly ),
     *    \endhtmlonly \link requestPropertyPassword() Password \endlink \htmlonly  and PasswordHint MUST be
     *   set in a single call to
     *    \endhtmlonly UpdateConfiguration() \htmlonly .</p>
     * 
     * <div class="rationale">
     *   Skype requires that the password and its hint be supplied together.
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c PasswordHint.
     */
    QString PasswordHint() const;
    /**
     * Return the value of the exported D-Bus object property \c CanUpdateConfiguration of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'canUpdateConfiguration' with type bool.
     *
     * 
     * \htmlonly
     * If <code>True</code>, the user may call
     *  \endhtmlonly UpdateConfiguration() \htmlonly  to change the values
     * of the properties listed in
     *  \endhtmlonly \link requestPropertyMutableProperties() MutableProperties \endlink \htmlonly .
     * \endhtmlonly
     *
     * \return The value of exported property \c CanUpdateConfiguration.
     */
    bool CanUpdateConfiguration() const;
    /**
     * Return the value of the exported D-Bus object property \c MutableProperties of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'mutableProperties' with type QStringList.
     *
     * 
     * \htmlonly
     * <p>A list of (unqualified) property names on this interface which may
     *   be modified using  \endhtmlonly UpdateConfiguration() \htmlonly 
     *   (if  \endhtmlonly \link requestPropertyCanUpdateConfiguration() CanUpdateConfiguration \endlink \htmlonly  is
     *   <code>True</code>). Properties not listed here cannot be
     *   modified.</p>
     * 
     * <p>For example, IRC does not have the concept of joining a room without
     *   other participants knowing your true identity; so on IRC the
     *    \endhtmlonly \link requestPropertyAnonymous() Anonymous \endlink \htmlonly  property will always be
     *   <code>False</code>, and
     *    \endhtmlonly \link requestPropertyMutableProperties() MutableProperties \endlink \htmlonly  will not include
     *   <code>&quot;Anonymous&quot;</code>.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c MutableProperties.
     */
    QStringList MutableProperties() const;
    /**
     * Return the value of the exported D-Bus object property \c ConfigurationRetrieved of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'configurationRetrieved' with type bool.
     *
     * 
     * \htmlonly
     * <p><code>True</code> once the initial room configuration has been
     *   retrieved, or <code>False</code> otherwise. On some services, this
     *   may take some time after you've joined a room to fetch the
     *   configuration. Once this property changes to <code>True</code>, the
     *   other properties on this interface can be assumed to be accurate;
     *   this property MUST not change to <code>False</code> after it becomes
     *   <code>True</code>.</p>
     * 
     * <div class="rationale">
     *   <p>An application's “configure this room” dialog might choose to
     *     display a spinner while this property is <code>False</code>, rather
     *     than allowing the user to edit probably-inaccurate
     *     configuration.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c ConfigurationRetrieved.
     */
    bool ConfigurationRetrieved() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c UpdateConfiguration on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void updateConfiguration(const QVariantMap& properties, const Tp::Service::ChannelInterfaceRoomConfigAdaptor::UpdateConfigurationContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>If  \endhtmlonly \link requestPropertyCanUpdateConfiguration() CanUpdateConfiguration \endlink \htmlonly  is
     *   <code>True</code>, modifies the current values of one or more
     *   room properties. This method SHOULD NOT return until the change has
     *   been accepted or declined by the server.</p>
     * 
     * <p>Note that the server may ostensibly accept the changes (thus
     *   allowing this method to return success) but signal different values;
     *   for example, the server might truncate
     *    \endhtmlonly \link requestPropertyTitle() Title \endlink \htmlonly  to some maximum length. Callers
     *   SHOULD continue to listen for the <code>PropertiesChanged</code>
     *   signal, and trust the values it signals over those provided to this
     *   method.</p>
     * \endhtmlonly
     *
     * \param properties
     *     
     *     \htmlonly
     *               <p>
     *                 The new values of one or more properties on this interface, which
     *                 must be listed in
     *                  \\\\endhtmlonly \\\\link requestPropertyMutableProperties() MutableProperties \\\\endlink \\\\htmlonly . For
     *                 instance, to set up a channel for discussing top-secret corporate
     *                 merge plans, this parameter might be:
     *               </p>
     *     
     *               <blockquote>
     *                 <pre>{
     *       'Private': True,
     *       'InviteOnly': True,
     *       'Description': &quot;The first rule of #inteltakeover is: do not talk about #inteltakeover&quot;,
     *     }</pre></blockquote>
     *     \endhtmlonly
     */
    void UpdateConfiguration(const QVariantMap& properties, const QDBusMessage& dbusMessage);
};

/**
 * \class ChannelInterfaceSASLAuthenticationAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.SASLAuthentication".
 */
class TP_QT_EXPORT ChannelInterfaceSASLAuthenticationAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.SASLAuthentication")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.SASLAuthentication\">\n"
"    <property access=\"read\" type=\"as\" name=\"AvailableMechanisms\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"HasInitialData\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"CanTryAgain\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"SASLStatus\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"SASLError\"/>\n"
"    <property access=\"read\" type=\"a{sv}\" name=\"SASLErrorDetails\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"AuthorizationIdentity\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"DefaultUsername\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"DefaultRealm\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"MaySaveResponse\"/>\n"
"    <method name=\"StartMechanism\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"mechanism\"/>\n"
"    </method>\n"
"    <method name=\"StartMechanismWithData\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"mechanism\"/>\n"
"      <arg direction=\"in\" type=\"ay\" name=\"initialData\"/>\n"
"    </method>\n"
"    <method name=\"Respond\">\n"
"      <arg direction=\"in\" type=\"ay\" name=\"responseData\"/>\n"
"    </method>\n"
"    <method name=\"AcceptSASL\"/>\n"
"    <method name=\"AbortSASL\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"reason\"/>\n"
"      <arg direction=\"in\" type=\"s\" name=\"debugMessage\"/>\n"
"    </method>\n"
"    <signal name=\"SASLStatusChanged\">\n"
"      <arg type=\"u\" name=\"status\"/>\n"
"      <arg type=\"s\" name=\"reason\"/>\n"
"      <arg type=\"a{sv}\" name=\"details\"/>\n"
"    </signal>\n"
"    <signal name=\"NewChallenge\">\n"
"      <arg type=\"ay\" name=\"challengeData\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QStringList AvailableMechanisms READ AvailableMechanisms )
    Q_PROPERTY(bool HasInitialData READ HasInitialData )
    Q_PROPERTY(bool CanTryAgain READ CanTryAgain )
    Q_PROPERTY(uint SASLStatus READ SASLStatus )
    Q_PROPERTY(QString SASLError READ SASLError )
    Q_PROPERTY(QVariantMap SASLErrorDetails READ SASLErrorDetails )
    Q_PROPERTY(QString AuthorizationIdentity READ AuthorizationIdentity )
    Q_PROPERTY(QString DefaultUsername READ DefaultUsername )
    Q_PROPERTY(QString DefaultRealm READ DefaultRealm )
    Q_PROPERTY(bool MaySaveResponse READ MaySaveResponse )

public:
    ChannelInterfaceSASLAuthenticationAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceSASLAuthenticationAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > StartMechanismContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > StartMechanismWithDataContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > RespondContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > AcceptSASLContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > AbortSASLContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c AvailableMechanisms of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'availableMechanisms' with type QStringList.
     *
     * 
     * \htmlonly
     * <p>The SASL mechanisms as offered by the server, plus any
     *   pseudo-SASL mechanisms supported by the connection manager for
     *   credentials transfer. For instance, in a protocol that
     *   natively uses SASL (like XMPP), this might be
     *   <code>[ &quot;X-TELEPATHY-PASSWORD&quot;, &quot;PLAIN&quot;, &quot;DIGEST-MD5&quot;,
     *     &quot;SCRAM-SHA-1&quot; ]</code>.</p>
     * 
     * <p>To make it possible to implement a very simple password-querying
     *   user interface without knowledge of any particular SASL mechanism,
     *   implementations of this interface MUST implement the
     *   pseudo-mechanism <code>X-TELEPATHY-PASSWORD</code>, unless each
     *   of the available mechanisms either requires additional information
     *   beyond the password (such as a username), or does not use a
     *   password.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c AvailableMechanisms.
     */
    QStringList AvailableMechanisms() const;
    /**
     * Return the value of the exported D-Bus object property \c HasInitialData of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'hasInitialData' with type bool.
     *
     * 
     * \htmlonly
     * <p>If true,  \endhtmlonly StartMechanismWithData() \htmlonly 
     *   can be expected to work for SASL mechanisms not starting with
     *   <code>X-TELEPATHY-</code> (this is the case in most, but not all,
     *   protocols). If false,  \endhtmlonly StartMechanism() \htmlonly 
     *   must be used instead.</p>
     * 
     * <p>This property does not affect the <code>X-TELEPATHY-</code>
     *   pseudo-mechanisms such as <code>X-TELEPATHY-PASSWORD</code>,
     *   which can use
     *    \endhtmlonly StartMechanismWithData() \htmlonly  regardless
     *   of the value of this property.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c HasInitialData.
     */
    bool HasInitialData() const;
    /**
     * Return the value of the exported D-Bus object property \c CanTryAgain of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'canTryAgain' with type bool.
     *
     * 
     * \htmlonly
     * <p>If true,  \endhtmlonly StartMechanism() \htmlonly  and (if
     *   supported)  \endhtmlonly StartMechanismWithData() \htmlonly 
     *   can be expected to work when in one of the Failed states. If
     *   false, the only thing you can do after failure is to close the
     *   channel.</p>
     * 
     * <div class="rationale">
     *   <p>Retrying isn't required to work, although some protocols and
     *     implementations allow it.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c CanTryAgain.
     */
    bool CanTryAgain() const;
    /**
     * Return the value of the exported D-Bus object property \c SASLStatus of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'saslStatus' with type uint.
     *
     * 
     * \htmlonly
     * The current status of this channel.
     * Change notification is via the
     *  \endhtmlonly SASLStatusChanged() \htmlonly  signal.
     * \endhtmlonly
     *
     * \return The value of exported property \c SASLStatus.
     */
    uint SASLStatus() const;
    /**
     * Return the value of the exported D-Bus object property \c SASLError of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'saslError' with type QString.
     *
     * 
     * \htmlonly
     * <p>The reason for the  \endhtmlonly \link requestPropertySASLStatus() SASLStatus \endlink \htmlonly , or
     *   an empty string if the state is neither
     *   Server_Failed nor Client_Failed.</p>
     * 
     * <p>In particular, an ordinary authentication failure (as would
     *   be produced for an incorrect password) SHOULD be represented by
     *   <tp:error-ref>AuthenticationFailed</tp:error-ref>,
     *   cancellation by the user's request SHOULD be represented
     *   by <tp:error-ref>Cancelled</tp:error-ref>, and
     *   cancellation by a local process due to inconsistent or invalid
     *   challenges from the server SHOULD be represented by
     *   <tp:error-ref>ServiceConfused</tp:error-ref>.</p>
     * 
     * <p>If this interface appears on a  \endhtmlonly ChannelTypeServerAuthenticationInterface \htmlonly 
     *   channel, and connection to the server fails with an authentication
     *   failure, this error code SHOULD be copied into the
     *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly 
     *   signal.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c SASLError.
     */
    QString SASLError() const;
    /**
     * Return the value of the exported D-Bus object property \c SASLErrorDetails of type \c QVariantMap.
     *
     * Adaptees should export this property as a Qt property named
     * 'saslErrorDetails' with type QVariantMap.
     *
     * 
     * \htmlonly
     * <p>If  \endhtmlonly \link requestPropertySASLError() SASLError \endlink \htmlonly  is non-empty,
     *   any additional information about the last
     *   disconnection; otherwise, the empty map. The keys and values are
     *   the same as for the second argument of
     *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly .</p>
     * 
     * <p>If this interface appears on a  \endhtmlonly ChannelTypeServerAuthenticationInterface \htmlonly 
     *   channel, and connection to the server fails with an authentication
     *   failure, these details SHOULD be copied into the
     *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly 
     *   signal.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c SASLErrorDetails.
     */
    QVariantMap SASLErrorDetails() const;
    /**
     * Return the value of the exported D-Bus object property \c AuthorizationIdentity of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'authorizationIdentity' with type QString.
     *
     * 
     * \htmlonly
     * <p>The identity for which authorization is being attempted,
     *   typically the 'account' from the  \endhtmlonly ConnectionManagerInterface::RequestConnection() \htmlonly 
     *   parameters, normalized and formatted according to the
     *   conventions used for SASL in this protocol.</p>
     * 
     * <div class="rationale">
     *   <p>The normalization used for SASL might not be the same
     *     normalization used elsewhere: for instance, in a protocol
     *     with email-like identifiers such as XMPP or SIP, the user
     *     &quot;juliet@example.com&quot; might have to authenticate to the
     *     example.com server via SASL PLAIN as &quot;juliet&quot;.</p>
     * </div>
     * 
     * <p>This is usually achieved by using the authorization identity for
     *   authentication, but an advanced Handler could offer the option
     *   to authenticate under a different identity.</p>
     * 
     * <p>The terminology used here is that the authorization identity
     *   is who you want to act as, and the authentication identity is
     *   used to prove that you may do so. For instance, if Juliet is
     *   authorized to access a role account, &quot;sysadmin@example.com&quot;,
     *   and act on its behalf, it might be possible to authenticate
     *   as &quot;juliet@example.com&quot; with her own password, but request to
     *   be authorized as &quot;sysadmin@example.com&quot; instead of her own
     *   account. See
     *   <a href="http://tools.ietf.org/html/rfc4422#section-3.4.1">RFC
     *     4422 §3.4.1</a> for more details.</p>
     * 
     * <div class="rationale">
     *   <p>In SASL the authorization identity is normally guessed from
     *     the authentication identity, but the information available
     *     to the connection manager is the identity for which
     *     authorization is required, such as the desired JID in XMPP,
     *     so that's what we signal to UIs; it's up to the UI to
     *     choose whether to authenticate as the authorization identity
     *     or some other identity.</p>
     * 
     *   <p>As a concrete example, the &quot;sysadmin&quot; XMPP account mentioned
     *     above would have <code>{ 'account': 'sysadmin@example.com' }</code>
     *     in its Parameters, and this property would also be
     *     'sysadmin@example.com'. A simple Handler would
     *     merely prompt for sysadmin@example.com's password,
     *     and use that JID as both the authorization and authentication
     *     identity, which might result in SASL PLAIN authentication with the
     *     initial response
     *     '\\000sysadmin@example.com\\000root'.</p>
     * 
     *   <p>A more advanced Handler might also ask for an authentication
     *     identity, defaulting to 'sysadmin@example.com'; if Juliet
     *     provided authentication identity 'juliet@example.com' and
     *     password 'romeo', the Handler might perform SASL PLAIN
     *     authentication using the initial response
     *     'sysadmin@example.com\\000juliet@example.com\\000romeo'.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c AuthorizationIdentity.
     */
    QString AuthorizationIdentity() const;
    /**
     * Return the value of the exported D-Bus object property \c DefaultUsername of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'defaultUsername' with type QString.
     *
     * 
     * \htmlonly
     *         <p>The default username for use with SASL mechanisms that deal
     *           with a &quot;simple username&quot; (as defined in <a href="http://tools.ietf.org/html/rfc4422">RFC 4422</a>). If
     *           such a SASL mechanism is in use, clients SHOULD default to
     *           using the DefaultUsername; also, if the client uses
     *           the DefaultUsername, it SHOULD assume that the authorization
     *           identity  \endhtmlonly \link requestPropertyAuthorizationIdentity() AuthorizationIdentity \endlink \htmlonly 
     *           will be derived from it by the server.</p>
     * 
     *         <div class="rationale">
     *           <p>In XMPP, <a href="http://trac.tools.ietf.org/wg/xmpp/trac/ticket/49">
     *             servers typically expect</a> &quot;user@example.com&quot; to
     *             authenticate with username &quot;user&quot;; this was a SHOULD in <a href="http://tools.ietf.org/html/rfc3920">RFC 3920</a>.</p>
     * 
     *           <p><a href="http://tools.ietf.org/html/draft-ietf-xmpp-3920bis-19">3920bis</a>
     *             weakens that SHOULD to &quot;in the absence of local information
     *             provided by the server, an XMPP client SHOULD assume that
     *             the authentication identity for such a SASL mechanism is the
     *             combination of a user name and password, where the simple
     *             user name is the localpart of the user's JID&quot;.</p>
     *         </div>
     * 
     *         <p>For example, in the simple case, if the user connects with
     *          \endhtmlonly ConnectionManagerInterface::RequestConnection() \htmlonly ({
     *         account: &quot;<tt>user@example.com</tt>&quot; }) and use PLAIN with
     *         password &quot;password&quot;, he or she should authenticate like so:
     *         &quot;<tt>\\0user\\0password</tt>&quot; and the channel will look like
     *         this:</p>
     * 
     * <blockquote><pre>{ &quot;... \endhtmlonly \link requestPropertyDefaultUsername() DefaultUsername \endlink \htmlonly &quot;: &quot;user&quot;,
     *   &quot;... \endhtmlonly \link requestPropertyAuthorizationIdentity() AuthorizationIdentity \endlink \htmlonly &quot;: &quot;user@example.com }
     * </pre></blockquote>
     * 
     *         <p>In the complex case, if the same user is using his or her
     *           sysadmin powers to log in as the &quot;announcements&quot; role address,
     *           he or she would connect with  \endhtmlonly ConnectionManagerInterface::RequestConnection() \htmlonly ({
     *           account: &quot;<tt>announcements@example.com</tt>&quot; }) and the SASL
     *           channel would look like this:</p>
     * 
     * <blockquote><pre>{ &quot;... \endhtmlonly \link requestPropertyDefaultUsername() DefaultUsername \endlink \htmlonly &quot;: &quot;announcements&quot;,
     *   &quot;... \endhtmlonly \link requestPropertyAuthorizationIdentity() AuthorizationIdentity \endlink \htmlonly &quot;: &quot;announcements@example.com }
     * </pre></blockquote>
     * 
     *         <p>A sufficiently elaborate UI could give the opportunity
     *           to override the username from &quot;announcements&quot; to &quot;user&quot;.
     *           The user's simple username is still &quot;user&quot;, and the password is
     *           still &quot;password&quot;, but this time he or she is trying to authorize
     *           to act as <tt>announcements@example.com</tt>, so the UI would
     *           have to perform SASL PLAIN with this string:
     *           &quot;<tt>announcements@example.com\\0user\\0password</tt>&quot;, where
     *           &quot;announcements@example.com&quot; is the
     *            \endhtmlonly \link requestPropertyAuthorizationIdentity() AuthorizationIdentity \endlink \htmlonly .</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c DefaultUsername.
     */
    QString DefaultUsername() const;
    /**
     * Return the value of the exported D-Bus object property \c DefaultRealm of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'defaultRealm' with type QString.
     *
     * 
     * \htmlonly
     * <p>The default realm (as defined in
     *   <a href="http://tools.ietf.org/html/rfc2831#section-2.1.1">RFC
     *     2831</a>) to use for authentication, if the server does not
     *   supply one.</p>
     * 
     * <div class="rationale">
     *   <p>The server is not required to provide a realm; if it doesn't,
     *     the client is expected to ask the user or provide a sensible
     *     default, typically the requested DNS name of the server.
     *     In some implementations of <code>DIGEST-MD5</code>, the
     *     server does not specify a realm, but expects that the client
     *     will choose a particular default, and authentication will
     *     fail if the client's default is different. Connection
     *     managers for protocols where this occurs are more easily able
     *     to work around these implementations than a generic client
     *     would be.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c DefaultRealm.
     */
    QString DefaultRealm() const;
    /**
     * Return the value of the exported D-Bus object property \c MaySaveResponse of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'maySaveResponse' with type bool.
     *
     * 
     * \htmlonly
     * <p>Whether or not the client can save the authentication response and
     *   re-use it to automate future authentication challenges.</p>
     * 
     * <p>If this property is <code>False</code>, the client SHOULD NOT attempt
     *   to cache the authentication response in its own keyring.</p>
     * 
     * <p>If this property is not specified, it should be treated as if it were
     *   <code>True</code>.</p>
     * 
     * <div class="rationale">Some protocols or services may have terms and conditions
     *   that prohibit caching a user's credentials.</div>
     * \endhtmlonly
     *
     * \return The value of exported property \c MaySaveResponse.
     */
    bool MaySaveResponse() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c StartMechanism on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void startMechanism(const QString& mechanism, const Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::StartMechanismContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Start an authentication try using <var>Mechanism</var>, without
     *   sending initial data (an &quot;initial response&quot; as defined in RFC
     *   4422).</p>
     * 
     * <div class="rationale">
     *   <p>This method is appropriate for mechanisms where the client
     *     cannot send anything until it receives a challenge from the
     *     server, such as
     *     <code><a href="http://tools.ietf.org/html/rfc2831">DIGEST-MD5</a></code>
     *     in &quot;initial authentication&quot; mode.</p>
     * </div>
     * \endhtmlonly
     *
     * \param mechanism
     *     
     *     The chosen mechanism.
     */
    void StartMechanism(const QString& mechanism, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c StartMechanismWithData on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void startMechanismWithData(const QString& mechanism, const QByteArray& initialData, const Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::StartMechanismWithDataContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Start an authentication try using <var>Mechanism</var>, and send
     *   <var>Initial_Data</var> as the &quot;initial response&quot; defined in
     *   <a href="http://tools.ietf.org/html/rfc4422#section-3.3">RFC 4422
     *     §3.3</a>.</p>
     * 
     * <div class="rationale">
     *   <p>This method is appropriate for mechanisms where the client may
     *     send data first, such as <code>PLAIN</code>, or must send data
     *     first, such as
     *     <code><a href="http://tools.ietf.org/html/rfc2831">DIGEST-MD5</a></code>
     *     in &quot;subsequent authentication&quot; mode.</p>
     * 
     *   <p>Having two methods allows any mechanism where it makes a difference
     *     to distinguish between the absence of an initial response
     *     ( \endhtmlonly StartMechanism() \htmlonly ) and a zero-byte
     *     initial response (StartMechanismWithData, with Initial_Data
     *     empty).</p>
     * </div>
     * 
     * <p>If the  \endhtmlonly \link requestPropertyHasInitialData() HasInitialData \endlink \htmlonly 
     *   property is false, this indicates that the underlying protocol
     *   does not make it possible to send initial data. In such protocols,
     *   this method may only be used for the <code>X-TELEPATHY-</code>
     *   pseudo-mechanisms (such as <code>X-TELEPATHY-PASSWORD</code>),
     *   and will fail if used with an ordinary SASL mechanism.</p>
     * 
     * <div class="rationale">
     *   <p>For instance, the IRC SASL extension implemented in Charybdis and
     *     Atheme does not support initial data - the first message in the
     *     exchange only carries the mechanism. This is significant if using
     *     <code><a href="http://tools.ietf.org/html/rfc2831">DIGEST-MD5</a></code>,
     *     which cannot be used in the faster &quot;subsequent authentication&quot;
     *     mode on a protocol not supporting initial data.</p>
     * </div>
     * \endhtmlonly
     *
     * \param mechanism
     *     
     *     The chosen mechanism.
     * \param initialData
     *     
     *     Initial data (an &quot;initial response&quot; in RFC 4422&apos;s 
     *     terminology) to send with the mechanism.
     */
    void StartMechanismWithData(const QString& mechanism, const QByteArray& initialData, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c Respond on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void respond(const QByteArray& responseData, const Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::RespondContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Send a response to the the last challenge received via
     *    \endhtmlonly NewChallenge() \htmlonly .</p>
     * \endhtmlonly
     *
     * \param responseData
     *     
     *     The response data.
     */
    void Respond(const QByteArray& responseData, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c AcceptSASL on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void acceptSASL(const Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::AcceptSASLContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>If the channel's status is SASL_Status_Server_Succeeded,
     *   this method confirms successful authentication and advances
     *   the status of the channel to SASL_Status_Succeeded.</p>
     * 
     * <p>If the channel's status is SASL_Status_In_Progress, calling this
     *   method indicates that the last
     *    \endhtmlonly NewChallenge() \htmlonly  signal was in fact
     *   additional data sent after a successful SASL negotiation, and
     *   declares that from the client's point of view, authentication
     *   was successful. This advances the state of the channel to
     *   SASL_Status_Client_Accepted.</p>
     * 
     * <p>In mechanisms where the server authenticates itself to the client,
     *   calling this method indicates that the client considers this to have
     *   been successful. In the case of  \endhtmlonly ChannelTypeServerAuthenticationInterface \htmlonly 
     *   channels, this means that the connection manager MAY continue to
     *   connect, and MAY advance the  \endhtmlonly \link ConnectionInterface::requestPropertyStatus() ConnectionInterface::Status \endlink \htmlonly  to Connected.</p>
     * \endhtmlonly
     *
     */
    void AcceptSASL(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c AbortSASL on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void abortSASL(uint reason, const QString& debugMessage, const Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::AbortSASLContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Abort the current authentication try.</p>
     * 
     * <p>If the current status is SASL_Status_Server_Failed or
     *   SASL_Status_Client_Failed, this method returns successfully, but has
     *   no further effect. If the current status is SASL_Status_Succeeded
     *   or SASL_Status_Client_Accepted then NotAvailable is raised.
     *   Otherwise, it changes the channel's state to
     *   SASL_Status_Client_Failed, with an appropriate error name and
     *   reason code.</p>
     * \endhtmlonly
     *
     * \param reason
     *     
     *     Reason for abort.
     * \param debugMessage
     *     
     *     Debug message for abort.
     */
    void AbortSASL(uint reason, const QString& debugMessage, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c SASLStatusChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void saslStatusChanged(uint status, const QString& reason, const QVariantMap& details);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param status
     *     
     *     The new value of SASLStatus.
     * \param reason
     *     
     *     The new value of SASLError.
     * \param details
     *     
     *     The new value of SASLErrorDetails.
     */
    void SASLStatusChanged(uint status, const QString& reason, const QVariantMap& details);
    /**
     * Represents the exported D-Bus signal \c NewChallenge on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void newChallenge(const QByteArray& challengeData);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param challengeData
     *     
     *     The challenge data or additional data from the server.
     */
    void NewChallenge(const QByteArray& challengeData);
};

/**
 * \class ChannelInterfaceSMSAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.SMS".
 */
class TP_QT_EXPORT ChannelInterfaceSMSAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.SMS")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.SMS\">\n"
"    <property access=\"read\" type=\"b\" name=\"Flash\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"SMSChannel\"/>\n"
"    <method name=\"GetSMSLength\">\n"
"      <arg direction=\"in\" type=\"aa{sv}\" name=\"message\">\n"
"        <annotation value=\"Tp::MessagePartList\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg direction=\"out\" type=\"u\" name=\"chunksRequired\"/>\n"
"      <arg direction=\"out\" type=\"i\" name=\"remainingCharacters\"/>\n"
"      <arg direction=\"out\" type=\"i\" name=\"estimatedCost\"/>\n"
"    </method>\n"
"    <signal name=\"SMSChannelChanged\">\n"
"      <arg type=\"b\" name=\"SMSChannel\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(bool Flash READ Flash )
    Q_PROPERTY(bool SMSChannel READ SMSChannel )

public:
    ChannelInterfaceSMSAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceSMSAdaptor();

    typedef Tp::MethodInvocationContextPtr< uint, int, int > GetSMSLengthContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Flash of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'flash' with type bool.
     *
     * 
     * \htmlonly
     * <p>If <code>True</code>, then this channel is exclusively for
     *   receiving class 0 SMSes (and no SMSes can be sent using  \endhtmlonly ChannelInterfaceMessagesInterface::SendMessage() \htmlonly 
     *   on this channel). If <code>False</code>, no incoming class 0 SMSes
     *   will appear on this channel.</p>
     * 
     * <p>This property is immutable (cannot change), and therefore SHOULD
     *   appear wherever immutable properties are reported, e.g.  \endhtmlonly ConnectionInterfaceRequestsInterface::NewChannels() \htmlonly  signals.</p>
     * 
     * <div class="rationale">
     *   <p>Class 0 SMSes should be displayed immediately to the user, and
     *     need not be saved to the device memory unless the user explicitly
     *     chooses to do so. This is unlike “normal”, class 1 SMSes, which
     *     must be stored, but need not be shown immediately in their entirity
     *     to the user.</p>
     * 
     *   <p>Separating class 0 SMSes into their own channel with this
     *     immutable property allows them to be dispatched to a different
     *      \endhtmlonly ClientHandlerInterface \htmlonly —which
     *     would include this property in its  \endhtmlonly \link ClientHandlerInterface::requestPropertyHandlerChannelFilter() ClientHandlerInterface::HandlerChannelFilter \endlink \htmlonly —avoiding the normal Text
     *     channel handler having to decide for each message whether it should
     *     be displayed to the user immediately or handled normally.</p>
     * 
     *   <p>Currently, no mechanism is defined for <em>sending</em> class 0
     *     SMSes. It seems reasonable to support specifying the class of an
     *     outgoing SMS in its header <tp:type>Message_Part</tp:type>, rather
     *     than requiring the UI to request a special channel for such SMSes;
     *     hence, we define here that channels with Flash set to
     *     <code>True</code> are read-only.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c Flash.
     */
    bool Flash() const;
    /**
     * Return the value of the exported D-Bus object property \c SMSChannel of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'smsChannel' with type bool.
     *
     * 
     * \htmlonly
     *         <p>If TRUE, messages sent and received on this channel are transmitted
     *           via SMS.</p>
     * 
     *         <p>If this property is included in the channel request, the
     *           Connection Manager MUST return an appropriate channel (i.e. if TRUE
     *           the channel must be for SMSes, if FALSE it must not), or else fail
     *           to provide the requested channel with the
     *           <tp:error-ref>NotCapable</tp:error-ref>
     *           error.</p>
     * 
     *         <p>For example, to explicitly request an SMS channel to a contact.
     *           You might construct a channel request like:</p>
     * 
     *         <blockquote><pre>{
     *   Channel.Type: Channel.Type.Text,
     *   Channel.TargetHandleType: Handle_Type_Contact,
     *   Channel.TargetID: escher.cat,
     *   Channel.Interface.SMS.SMSChannel: True,
     * }</pre></blockquote>
     * 
     *         <div class="rationale">
     *           Some protocols allow us to send SMSes to a remote contact, without
     *           knowing the phone number to which those SMSes will be sent. This
     *           provides a mechanism to request such channels.
     *         </div>
     * 
     *         <p>If this property is not included in the channel request, the
     *           Connection Manager MAY return an SMS channel if that is the most
     *           appropriate medium (i.e. if the channel target is a phone
     *           number).</p>
     * 
     *         <div class="rationale">
     *           To some types of identifiers (i.e. phone numbers) it only makes
     *           sense to return an SMS channel, this is what happens currently with
     *           telepathy-ring. We don't want to break this behaviour when we are
     *           not explicit about the type of channel we want. Alternatively, for
     *           protocols where there is an SMS fallback for IM messages, it's
     *           possible that we don't care what sort of channel we get, and simply
     *           want notification of the transport.
     *         </div>
     * 
     *         <p>Some protocols have a fallback to deliver IM messages via SMS.
     *           On these protocols, the Connection Manager SHOULD set the property
     *           value as appropriate, and notify its change with
     *            \endhtmlonly SMSChannelChanged() \htmlonly .</p>
     * 
     *         <div class="rationale">
     *           Protocols such as MSN can fall back to delivering IM messages via
     *           SMS. Where possible we want clients to be able to inform the user
     *           that their messages are going to be redirected to the remote
     *           contact's phone.
     *         </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c SMSChannel.
     */
    bool SMSChannel() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetSMSLength on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getSMSLength(const Tp::MessagePartList& message, const Tp::Service::ChannelInterfaceSMSAdaptor::GetSMSLengthContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Returns the number of 140 octet chunks required to send a message
     *   via SMS, as well as the number of remaining characters available in
     *   the final chunk and, if possible, an estimate of the cost.</p>
     * 
     * <div class="rationale">
     *   <p>There are a number of different SMS encoding mechanisms, and the
     *     client doesn't know which mechanisms an individual CM might support.
     *     This method allows the client, without any knowledge of the
     *     encoding mechanism, to provide length details to the user.</p>
     * </div>
     * 
     * <p>Clients SHOULD limit the frequency with which this method is called
     * and SHOULD NOT call it for every keystroke. Clients MAY estimate the
     * remaining size between single keystrokes.</p>
     * \endhtmlonly
     *
     * \param message
     *     
     *     The message the user wishes to send.
     * \param remainingCharacters Output parameter
     *     
     *     \htmlonly
     *     <p>The number of further characters that can be fit in the final
     *       chunk. A negative value indicates that the message will be
     *       truncated by <code>abs(Remaining_Characters)</code>. The value
     *       <code>MIN_INT32</code> (<code>-2<sup>31</sup></code>)
     *       indicates the message will be truncated by an unknown amount.</p>
     *     
     *     <p>For example, in the GSM standard 7-bit encoding, a 162 character
     *       message would return 144 remaining characters (because of the
     *       space required for the multipart SMS header).</p>
     *     \endhtmlonly
     * \param estimatedCost Output parameter
     *     
     *     \htmlonly
     *     <p>The estimated cost of sending this message. The currency and
     *       scale of this value are the same as the
     *        \\\\endhtmlonly \\\\link ConnectionInterfaceBalanceInterface::requestPropertyAccountBalance() ConnectionInterfaceBalanceInterface::AccountBalance \\\\endlink \\\\htmlonly 
     *       property.</p>
     *     
     *     <p>A value of <code>-1</code> indicates the cost could not be
     *       estimated.</p>
     *     \endhtmlonly
     * \return
     *     
     *     \htmlonly
     *     <p>The number of 140 octet chunks required to send this message.</p>
     *     
     *     <p>For example, in the GSM standard 7-bit encoding, a 162 character
     *       message would require 2 chunks.</p>
     *     \endhtmlonly
     */
    uint GetSMSLength(const Tp::MessagePartList& message, const QDBusMessage& dbusMessage, int& remainingCharacters, int& estimatedCost);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c SMSChannelChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void smsChannelChanged(bool SMSChannel);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param SMSChannel
     *     
     *     The new value for SMSChannel.
     */
    void SMSChannelChanged(bool SMSChannel);
};

/**
 * \class ChannelInterfaceSecurableAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Securable".
 */
class TP_QT_EXPORT ChannelInterfaceSecurableAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.Securable")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.Securable\">\n"
"    <property access=\"read\" type=\"b\" name=\"Encrypted\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"Verified\"/>\n"
"  </interface>\n"
"")
    Q_PROPERTY(bool Encrypted READ Encrypted )
    Q_PROPERTY(bool Verified READ Verified )

public:
    ChannelInterfaceSecurableAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceSecurableAdaptor();


public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Encrypted of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'encrypted' with type bool.
     *
     * 
     * \htmlonly
     * <p>True if this channel occurs over an encrypted
     *   connection. This <strong>does not</strong> imply that steps
     *   have been taken to avoid man-in-the-middle attacks.</p>
     * 
     * <div class="rationale">
     *   <p>For future support for <a href="http://tools.ietf.org/html/rfc5056">RFC 5056 Channel
     *       Binding</a> it is desirable to be able to use some SASL
     *     mechanisms over an encrypted connection to an unverified peer,
     *     which can prove that it is the desired destination during
     *     the SASL negotiation.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c Encrypted.
     */
    bool Encrypted() const;
    /**
     * Return the value of the exported D-Bus object property \c Verified of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'verified' with type bool.
     *
     * 
     * \htmlonly
     * <p>True if this channel occurs over a connection that is
     *   protected against tampering, and has been verified to be with
     *   the desired destination: for instance, one where TLS was
     *   previously negotiated, and the TLS certificate has been
     *   verified against a configured certificate authority or
     *   accepted by the user.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Verified.
     */
    bool Verified() const;
};

/**
 * \class ChannelInterfaceServicePointAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.ServicePoint".
 */
class TP_QT_EXPORT ChannelInterfaceServicePointAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.ServicePoint")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.ServicePoint\">\n"
"    <property access=\"read\" type=\"(us)\" name=\"InitialServicePoint\">\n"
"      <annotation value=\"Tp::ServicePoint\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"(us)\" name=\"CurrentServicePoint\">\n"
"      <annotation value=\"Tp::ServicePoint\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <signal name=\"ServicePointChanged\">\n"
"      <arg type=\"(us)\" name=\"servicePoint\">\n"
"        <annotation value=\"Tp::ServicePoint\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(Tp::ServicePoint InitialServicePoint READ InitialServicePoint )
    Q_PROPERTY(Tp::ServicePoint CurrentServicePoint READ CurrentServicePoint )

public:
    ChannelInterfaceServicePointAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceServicePointAdaptor();


public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c InitialServicePoint of type \c Tp::ServicePoint.
     *
     * Adaptees should export this property as a Qt property named
     * 'initialServicePoint' with type Tp::ServicePoint.
     *
     * 
     * \htmlonly
     * <p>This property is used to indicate that the channel target is a
     * well-known service point.  Please note that the CM (or lower layers
     * of the stack or network) may forward the connection to other other
     * service points, which the CM SHOULD indicate via
     *  \endhtmlonly ServicePointChanged() \htmlonly 
     * signal.</p>
     * 
     * <p>This property SHOULD be set for channel requests that are
     * specifically targeting service points.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c InitialServicePoint.
     */
    Tp::ServicePoint InitialServicePoint() const;
    /**
     * Return the value of the exported D-Bus object property \c CurrentServicePoint of type \c Tp::ServicePoint.
     *
     * Adaptees should export this property as a Qt property named
     * 'currentServicePoint' with type Tp::ServicePoint.
     *
     * 
     * The service point that the channel is connected to. If the channel is 
     * not connected to a service point, the CM MUST set the 
     * Service_Point_Type field to None; for instance, this will be the case 
     * for ordinary calls.
     *
     * \return The value of exported property \c CurrentServicePoint.
     */
    Tp::ServicePoint CurrentServicePoint() const;

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c ServicePointChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void servicePointChanged(const Tp::ServicePoint& servicePoint);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param servicePoint
     *     
     *     The new service point that is being used.
     */
    void ServicePointChanged(const Tp::ServicePoint& servicePoint);
};

/**
 * \class ChannelInterfaceSplittableAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Splittable.DRAFT".
 */
class TP_QT_EXPORT ChannelInterfaceSplittableAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.Splittable.DRAFT")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.Splittable.DRAFT\">\n"
"    <method name=\"Split\"/>\n"
"  </interface>\n"
"")

public:
    ChannelInterfaceSplittableAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceSplittableAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > SplitContextPtr;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c Split on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void split(const Tp::Service::ChannelInterfaceSplittableAdaptor::SplitContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request that this channel is removed from any
     *  \endhtmlonly ChannelInterfaceConferenceInterface \htmlonly  of which it is a part.</p>
     * 
     * <p>This implies that the media streams within the conference are put on
     *   hold and the media streams within the member channel leaving the
     *   conference are unheld.</p>
     * \endhtmlonly
     *
     */
    void Split(const QDBusMessage& dbusMessage);
};

/**
 * \class ChannelInterfaceSubjectAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Subject2".
 */
class TP_QT_EXPORT ChannelInterfaceSubjectAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.Subject2")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.Subject2\">\n"
"    <property access=\"read\" type=\"s\" name=\"Subject\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"Actor\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"ActorHandle\"/>\n"
"    <property access=\"read\" type=\"x\" name=\"Timestamp\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"CanSet\"/>\n"
"    <method name=\"SetSubject\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"subject\"/>\n"
"    </method>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QString Subject READ Subject )
    Q_PROPERTY(QString Actor READ Actor )
    Q_PROPERTY(uint ActorHandle READ ActorHandle )
    Q_PROPERTY(qlonglong Timestamp READ Timestamp )
    Q_PROPERTY(bool CanSet READ CanSet )

public:
    ChannelInterfaceSubjectAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceSubjectAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > SetSubjectContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Subject of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'subject' with type QString.
     *
     * 
     * \htmlonly
     * <p>The human-readable subject on the channel such as the topic
     *   in an IRC channel, or the room name in XMPP MUCs.</p>
     * 
     * <div class="rationale">This property replaces the subject Telepathy
     *   property of Text channels, as Telepathy properties are soon to
     *   be deprecated completely.</div>
     * 
     * <p>This property may change during the lifetime of the channel and
     *   MUST not be included in a channel request.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Subject.
     */
    QString Subject() const;
    /**
     * Return the value of the exported D-Bus object property \c Actor of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'actor' with type QString.
     *
     * 
     * \htmlonly
     * <p>The normalized contact ID representing who last modified
     *   the subject, or the empty string if it is not known.</p>
     * 
     * <div class="rationale">This property replaces the subject-contact
     *   Telepathy property of Text channels, as Telepathy properties
     *   are soon to be deprecated completely.</div>
     * \endhtmlonly
     *
     * \return The value of exported property \c Actor.
     */
    QString Actor() const;
    /**
     * Return the value of the exported D-Bus object property \c ActorHandle of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'actorHandle' with type uint.
     *
     * 
     * \htmlonly
     * <p>The handle corresponding to  \endhtmlonly \link requestPropertyActor() Actor \endlink \htmlonly ,
     * or 0 if the  \endhtmlonly \link requestPropertyActor() Actor \endlink \htmlonly  is unknown.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c ActorHandle.
     */
    uint ActorHandle() const;
    /**
     * Return the value of the exported D-Bus object property \c Timestamp of type \c qlonglong.
     *
     * Adaptees should export this property as a Qt property named
     * 'timestamp' with type qlonglong.
     *
     * 
     * \htmlonly
     * <p>A unix timestamp indicating when the subject was last
     *  modified, or <code>INT_MAX64</code> if unknown.</p>
     * 
     * <div class="rationale">This property replaces the subject-timestamp
     *   Telepathy property of Text channels, as Telepathy properties
     *   are soon to be deprecated completely.</div>
     * \endhtmlonly
     *
     * \return The value of exported property \c Timestamp.
     */
    qlonglong Timestamp() const;
    /**
     * Return the value of the exported D-Bus object property \c CanSet of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'canSet' with type bool.
     *
     * 
     * \htmlonly
     * <p>TRUE if the  \endhtmlonly \link requestPropertySubject() Subject \endlink \htmlonly  property
     *   can be set by the user by calling
     *    \endhtmlonly SetSubject() \htmlonly , otherwise
     *   FALSE.</p>
     * 
     * <p>If implementations are unsure of what this value should be
     *   it SHOULD still be set to what it believes the value
     *   is. As a result, clients should be aware that
     *    \endhtmlonly SetSubject() \htmlonly  can still fail
     *   even with this property set to TRUE.</p>
     * 
     * <div class="rationale">In XMPP it is impossible to know whether an
     *   occupant can set the subject as XMPP server implementations
     *   are wildly inconsistent.</div>
     * \endhtmlonly
     *
     * \return The value of exported property \c CanSet.
     */
    bool CanSet() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c SetSubject on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void setSubject(const QString& subject, const Tp::Service::ChannelInterfaceSubjectAdaptor::SetSubjectContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Set the room's subject. Clients SHOULD look at the subject
     *   flags before calling this method as the user might not have
     *   permission to set the subject.</p>
     * 
     * <p>A successful return of this method indicates a successful
     *   change in subject, but clients should still listen for changes
     *   to the  \endhtmlonly \link requestPropertySubject() Subject \endlink \htmlonly  property for
     *   further changes by other users or the server.</p>
     * \endhtmlonly
     *
     * \param subject
     *     
     *     The new subject.
     */
    void SetSubject(const QString& subject, const QDBusMessage& dbusMessage);
};

/**
 * \class ChannelTypeCallAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.Call1".
 */
class TP_QT_EXPORT ChannelTypeCallAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Type.Call1")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Type.Call1\">\n"
"    <property access=\"read\" type=\"ao\" name=\"Contents\"/>\n"
"    <property access=\"read\" type=\"a{sv}\" name=\"CallStateDetails\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"CallState\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"CallFlags\"/>\n"
"    <property access=\"read\" type=\"(uuss)\" name=\"CallStateReason\">\n"
"      <annotation value=\"Tp::CallStateReason\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"b\" name=\"HardwareStreaming\"/>\n"
"    <property access=\"read\" type=\"a{uu}\" name=\"CallMembers\">\n"
"      <annotation value=\"Tp::CallMemberMap\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"a{us}\" name=\"MemberIdentifiers\">\n"
"      <annotation value=\"Tp::HandleIdentifierMap\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"u\" name=\"InitialTransport\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"InitialAudio\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"InitialVideo\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"InitialAudioName\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"InitialVideoName\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"MutableContents\"/>\n"
"    <method name=\"SetRinging\"/>\n"
"    <method name=\"SetQueued\"/>\n"
"    <method name=\"Accept\"/>\n"
"    <method name=\"Hangup\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"reason\"/>\n"
"      <arg direction=\"in\" type=\"s\" name=\"detailedHangupReason\"/>\n"
"      <arg direction=\"in\" type=\"s\" name=\"message\"/>\n"
"    </method>\n"
"    <method name=\"AddContent\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"contentName\"/>\n"
"      <arg direction=\"in\" type=\"u\" name=\"contentType\"/>\n"
"      <arg direction=\"in\" type=\"u\" name=\"initialDirection\"/>\n"
"      <arg direction=\"out\" type=\"o\" name=\"content\"/>\n"
"    </method>\n"
"    <signal name=\"ContentAdded\">\n"
"      <arg type=\"o\" name=\"content\"/>\n"
"    </signal>\n"
"    <signal name=\"ContentRemoved\">\n"
"      <arg type=\"o\" name=\"content\"/>\n"
"      <arg type=\"(uuss)\" name=\"reason\">\n"
"        <annotation value=\"Tp::CallStateReason\" name=\"com.trolltech.QtDBus.QtTypeName.In1\"/>\n"
"      </arg>\n"
"    </signal>\n"
"    <signal name=\"CallStateChanged\">\n"
"      <arg type=\"u\" name=\"callState\"/>\n"
"      <arg type=\"u\" name=\"callFlags\"/>\n"
"      <arg type=\"(uuss)\" name=\"callStateReason\">\n"
"        <annotation value=\"Tp::CallStateReason\" name=\"com.trolltech.QtDBus.QtTypeName.In2\"/>\n"
"      </arg>\n"
"      <arg type=\"a{sv}\" name=\"callStateDetails\"/>\n"
"    </signal>\n"
"    <signal name=\"CallMembersChanged\">\n"
"      <arg type=\"a{uu}\" name=\"flagsChanged\">\n"
"        <annotation value=\"Tp::CallMemberMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg type=\"a{us}\" name=\"identifiers\">\n"
"        <annotation value=\"Tp::HandleIdentifierMap\" name=\"com.trolltech.QtDBus.QtTypeName.In1\"/>\n"
"      </arg>\n"
"      <arg type=\"au\" name=\"removed\"/>\n"
"      <arg type=\"(uuss)\" name=\"reason\">\n"
"        <annotation value=\"Tp::CallStateReason\" name=\"com.trolltech.QtDBus.QtTypeName.In3\"/>\n"
"      </arg>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(Tp::ObjectPathList Contents READ Contents )
    Q_PROPERTY(QVariantMap CallStateDetails READ CallStateDetails )
    Q_PROPERTY(uint CallState READ CallState )
    Q_PROPERTY(uint CallFlags READ CallFlags )
    Q_PROPERTY(Tp::CallStateReason CallStateReason READ CallStateReason )
    Q_PROPERTY(bool HardwareStreaming READ HardwareStreaming )
    Q_PROPERTY(Tp::CallMemberMap CallMembers READ CallMembers )
    Q_PROPERTY(Tp::HandleIdentifierMap MemberIdentifiers READ MemberIdentifiers )
    Q_PROPERTY(uint InitialTransport READ InitialTransport )
    Q_PROPERTY(bool InitialAudio READ InitialAudio )
    Q_PROPERTY(bool InitialVideo READ InitialVideo )
    Q_PROPERTY(QString InitialAudioName READ InitialAudioName )
    Q_PROPERTY(QString InitialVideoName READ InitialVideoName )
    Q_PROPERTY(bool MutableContents READ MutableContents )

public:
    ChannelTypeCallAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelTypeCallAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > SetRingingContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > SetQueuedContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > AcceptContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > HangupContextPtr;
    typedef Tp::MethodInvocationContextPtr< QDBusObjectPath > AddContentContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Contents of type \c Tp::ObjectPathList.
     *
     * Adaptees should export this property as a Qt property named
     * 'contents' with type Tp::ObjectPathList.
     *
     * 
     * \htmlonly
     * <p>The list of  \endhtmlonly CallContentInterface \htmlonly  objects that
     *   are part of this call. Change notification is via the
     *    \endhtmlonly ContentAdded() \htmlonly  and
     *    \endhtmlonly ContentRemoved() \htmlonly  signals.
     * </p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Contents.
     */
    Tp::ObjectPathList Contents() const;
    /**
     * Return the value of the exported D-Bus object property \c CallStateDetails of type \c QVariantMap.
     *
     * Adaptees should export this property as a Qt property named
     * 'callStateDetails' with type QVariantMap.
     *
     * 
     * \htmlonly
     * <p>A map used to provide optional extensible details for the
     *    \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly ,
     *    \endhtmlonly \link requestPropertyCallFlags() CallFlags \endlink \htmlonly  and/or
     *    \endhtmlonly \link requestPropertyCallStateReason() CallStateReason \endlink \htmlonly .</p>
     * 
     * <p>Well-known keys and their corresponding value types include:</p>
     * 
     * <dl>
     *   <dt>hangup-message - s</dt>
     *   <dd>An optional human-readable message sent when the call was ended,
     *     corresponding to the Message argument to the
     *      \endhtmlonly Hangup() \htmlonly  method. This is only
     *     applicable when the call state is <tp:value-ref type="Call_State">Ended</tp:value-ref>.
     *     <div class="rationale">
     *       XMPP Jingle can send such messages.
     *     </div>
     *   </dd>
     * 
     *   <dt>queue-message - s</dt>
     *   <dd>An optional human-readable message sent when the local contact
     *     is being held in a queue. This is only applicable when
     *     <tp:value-ref type="Call_Flags">Locally_Queued</tp:value-ref> is in the call flags.
     *     <div class="rationale">
     *       SIP 182 notifications can have human-readable messages attached.
     *     </div>
     *   </dd>
     * 
     *   <dt>debug-message - s</dt>
     *   <dd>A message giving further details of any error indicated by the
     *      \endhtmlonly \link requestPropertyCallStateReason() CallStateReason \endlink \htmlonly . This will not
     *     normally be localized or suitable for display to users, and is only
     *     applicable when the call state is
     *     <tp:value-ref type="Call_State">Ended</tp:value-ref>.</dd>
     * 
     *   <dt>balance-required - i</dt>
     *   <dd>Optionally included when a call cannot be connected because
     *     there is <tp:error-ref>InsufficientBalance</tp:error-ref>,
     *     indicating what the required balance would be to place this call.
     *     The value of this key has the same units and scale as
     *      \endhtmlonly \link ConnectionInterfaceBalanceInterface::requestPropertyAccountBalance() ConnectionInterfaceBalanceInterface::AccountBalance \endlink \htmlonly .
     *     </dd>
     * 
     *   <dt>forwarded-to - u</dt>
     *   <dd>Optionally included when the
     *      \endhtmlonly \link requestPropertyCallStateReason() CallStateReason \endlink \htmlonly  is
     *     Forwarded. It indicates the handle to whom the Call was
     *     forwarded.</dd>
     * 
     *   <dt>forwarded-to-id - s</dt>
     *   <dd>The string that would result from inspecting the
     *     <code>forwarded-to</code> key
     *     (i.e. the contact's identifier in the IM protocol).</dd>
     * </dl>
     * \endhtmlonly
     *
     * \return The value of exported property \c CallStateDetails.
     */
    QVariantMap CallStateDetails() const;
    /**
     * Return the value of the exported D-Bus object property \c CallState of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'callState' with type uint.
     *
     * 
     * \htmlonly
     * <p>The current high-level state of this call. The
     *    \endhtmlonly \link requestPropertyCallFlags() CallFlags \endlink \htmlonly  provide additional
     *   information, and the  \endhtmlonly \link requestPropertyCallStateReason() CallStateReason \endlink \htmlonly 
     *   and  \endhtmlonly \link requestPropertyCallStateDetails() CallStateDetails \endlink \htmlonly  explain the
     *   reason for the current values for those properties.</p>
     * 
     * <p>Note that when in a conference call, this property is
     *   purely to show your state in joining the call. The receiver
     *   (or remote contact) in this context is the conference server
     *   itself. The property does not change when other call members'
     *   states change.</p>
     * 
     * <p>Clients MAY consider unknown values in this property to be an
     *   error.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c CallState.
     */
    uint CallState() const;
    /**
     * Return the value of the exported D-Bus object property \c CallFlags of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'callFlags' with type uint.
     *
     * 
     * \htmlonly
     * <p>Flags representing the status of the call as a whole,
     *   providing more specific information than the
     *    \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly .</p>
     * 
     * <p>Clients are expected to ignore unknown flags in this property,
     *   without error.</p>
     * 
     * <p>When an ongoing call is active and not on hold or has any
     *   other problems, this property will be 0.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c CallFlags.
     */
    uint CallFlags() const;
    /**
     * Return the value of the exported D-Bus object property \c CallStateReason of type \c Tp::CallStateReason.
     *
     * Adaptees should export this property as a Qt property named
     * 'callStateReason' with type Tp::CallStateReason.
     *
     * 
     * \htmlonly
     * <p>The reason for the last change to the
     *    \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  and/or
     *    \endhtmlonly \link requestPropertyCallFlags() CallFlags \endlink \htmlonly . The
     *    \endhtmlonly \link requestPropertyCallStateDetails() CallStateDetails \endlink \htmlonly  MAY provide additional
     *   information.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c CallStateReason.
     */
    Tp::CallStateReason CallStateReason() const;
    /**
     * Return the value of the exported D-Bus object property \c HardwareStreaming of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'hardwareStreaming' with type bool.
     *
     * 
     * \htmlonly
     * <p>If this property is True, all of the media streaming is done by some
     *   mechanism outside the scope of Telepathy.</p>
     * 
     * <div class="rationale">
     *   <p>A connection manager might be intended for a specialized hardware
     *     device, which will take care of the audio streaming (e.g.
     *     telepathy-ring, which uses GSM hardware which does the actual
     *     audio streaming for the call).</p>
     * </div>
     * 
     * <p>If this is False, the handler is responsible for doing the actual
     *   media streaming for at least some contents itself. Those contents
     *   will have the  \endhtmlonly CallContentInterfaceMediaInterface \htmlonly  interface, to communicate the necessary
     *   information to a streaming implementation. Connection managers SHOULD
     *   operate like this, if possible.</p>
     * 
     * <div class="rationale">
     *   <p>Many connection managers (such as telepathy-gabble) only do the
     *     call signalling, and expect the client to do the actual streaming
     *     using something like
     *     <a href="http://farsight.freedesktop.org/">Farsight</a>, to improve
     *     latency and allow better UI integration.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c HardwareStreaming.
     */
    bool HardwareStreaming() const;
    /**
     * Return the value of the exported D-Bus object property \c CallMembers of type \c Tp::CallMemberMap.
     *
     * Adaptees should export this property as a Qt property named
     * 'callMembers' with type Tp::CallMemberMap.
     *
     * 
     * \htmlonly
     * <p>A mapping from the remote contacts that are part of this call to flags
     *   describing their status. This mapping never has the local user's handle
     *   as a key.</p>
     * 
     * <p>When the call ends, this property should be an empty list,
     *   and notified with
     *    \endhtmlonly CallMembersChanged() \htmlonly </p>
     * 
     * <p>If the Call implements
     *    \endhtmlonly ChannelInterfaceGroupInterface \htmlonly  and the Group members are
     *   channel-specific handles, then this call SHOULD also use
     *   channel-specific handles.</p>
     * 
     * <p>Anonymous members are exposed as channel-specific handles
     *   with no owner.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c CallMembers.
     */
    Tp::CallMemberMap CallMembers() const;
    /**
     * Return the value of the exported D-Bus object property \c MemberIdentifiers of type \c Tp::HandleIdentifierMap.
     *
     * Adaptees should export this property as a Qt property named
     * 'memberIdentifiers' with type Tp::HandleIdentifierMap.
     *
     * 
     * The string identifiers for handles mentioned in CallMembers, to give 
     * clients the minimal information necessary to create contacts without 
     * waiting for round-trips.
     *
     * \return The value of exported property \c MemberIdentifiers.
     */
    Tp::HandleIdentifierMap MemberIdentifiers() const;
    /**
     * Return the value of the exported D-Bus object property \c InitialTransport of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'initialTransport' with type uint.
     *
     * 
     * \htmlonly
     * <p>If set on a requested channel, this indicates the transport that
     *   should be used for this call. Where not applicable, this property
     *   is defined to be <tp:value-ref type="Stream_Transport_Type">Unknown</tp:value-ref>,
     *   in particular, on CMs with hardware streaming.</p>
     * 
     * <div class="rationale">
     *   When implementing a voip gateway one wants the outgoing leg of the
     *   gatewayed to have the same transport as the incoming leg. This
     *   property allows the gateway to request a Call with the right
     *   transport from the CM.
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c InitialTransport.
     */
    uint InitialTransport() const;
    /**
     * Return the value of the exported D-Bus object property \c InitialAudio of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'initialAudio' with type bool.
     *
     * 
     * \htmlonly
     * <p>If set to True in a channel request that will create a new channel,
     *   the connection manager should immediately attempt to establish an
     *   audio stream to the remote contact, making it unnecessary for the
     *   client to call  \endhtmlonly ChannelTypeCallInterface::AddContent() \htmlonly .</p>
     * 
     * <p>If this property, or InitialVideo, is passed to EnsureChannel
     *   (as opposed to CreateChannel), the connection manager SHOULD ignore
     *   these properties when checking whether it can return an existing
     *   channel as suitable; these properties only become significant when
     *   the connection manager has decided to create a new channel.</p>
     * 
     * <p>If True on a requested channel, this indicates that the audio
     *   stream has already been requested and the client does not need to
     *   call RequestStreams, although it MAY still do so.</p>
     * 
     * <p>If True on an unrequested (incoming) channel, this indicates that
     *   the remote contact initially requested an audio stream; this does
     *   not imply that that audio stream is still active (as indicated by
     *    \endhtmlonly \link ChannelTypeCallInterface::requestPropertyContents() ChannelTypeCallInterface::Contents \endlink \htmlonly ).</p>
     * 
     * <p>The name of this new content can be decided by using the
     *    \endhtmlonly \link requestPropertyInitialAudioName() InitialAudioName \endlink \htmlonly  property.</p>
     * 
     * <p>Connection managers that support the  \endhtmlonly ConnectionInterfaceContactCapabilitiesInterface \htmlonly 
     *   interface SHOULD represent the capabilities of receiving audio
     *   and/or video calls by including a channel class in
     *   a contact's capabilities with ChannelType = Call
     *   in the fixed properties dictionary, and InitialAudio and/or
     *   InitialVideo in the allowed properties list. Clients wishing to
     *   discover whether a particular contact is likely to be able to
     *   receive audio and/or video calls SHOULD use this information.</p>
     * 
     * <div class="rationale">
     *   <p>Not all clients support video calls, and it would also be
     *     possible (although unlikely) to have a client which could only
     *     stream video, not audio.</p>
     * </div>
     * 
     * <p>Clients that are willing to receive audio and/or video calls
     *   SHOULD include the following among their channel classes if
     *   calling  \endhtmlonly ConnectionInterfaceContactCapabilitiesInterface::UpdateCapabilities() \htmlonly 
     *   (clients of a  \endhtmlonly ChannelDispatcherInterface \htmlonly 
     *   SHOULD instead arrange for the ChannelDispatcher to do this,
     *   by including the filters in their  \endhtmlonly \link ClientHandlerInterface::requestPropertyHandlerChannelFilter() ClientHandlerInterface::HandlerChannelFilter \endlink \htmlonly 
     *   properties):</p>
     * 
     * <ul>
     *   <li>{ ChannelType = Call }</li>
     *   <li>{ ChannelType = Call, InitialAudio = True }
     *     if receiving calls with audio is supported</li>
     *   <li>{ ChannelType = Call, InitialVideo = True }
     *     if receiving calls with video is supported</li>
     * </ul>
     * 
     * <div class="rationale">
     *   <p>Connection managers for protocols with capability discovery,
     *     like XMPP, need this information to advertise the appropriate
     *     capabilities for their protocol.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c InitialAudio.
     */
    bool InitialAudio() const;
    /**
     * Return the value of the exported D-Bus object property \c InitialVideo of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'initialVideo' with type bool.
     *
     * 
     * \htmlonly
     * <p>The same as  \endhtmlonly \link requestPropertyInitialAudio() InitialAudio \endlink \htmlonly , but for
     *   a video stream. This property is immutable (cannot change).</p>
     * 
     * <p>In particular, note that if this property is False, this does not
     *   imply that an active video stream has not been added, only that no
     *   video stream was active at the time the channel appeared.</p>
     * 
     * <p>This property is the correct way to discover whether connection
     *   managers, contacts etc. support video calls; it appears in
     *   capabilities structures in the same way as InitialAudio.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c InitialVideo.
     */
    bool InitialVideo() const;
    /**
     * Return the value of the exported D-Bus object property \c InitialAudioName of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'initialAudioName' with type QString.
     *
     * 
     * \htmlonly
     * <p>If  \endhtmlonly \link requestPropertyInitialAudio() InitialAudio \endlink \htmlonly  is set to
     *   True, then this property will name the intial audio content
     *   with the value of this property.</p>
     * 
     * <div class="rationale">
     *   <p>Content names are meant to be significant, but if no name
     *     can be given to initial audio content, then its name cannot
     *     be meaningful or even localized.</p>
     * </div>
     * 
     * <p>If this property is empty or missing from the channel
     *   request and InitialAudio is True, then the CM must come up
     *   with a sensible for the content, such as &quot;audio&quot;.</p>
     * 
     * <p>If the protocol has no concept of stream names then this
     *   property will not show up in the allowed properties list of
     *   the Requestable Channel Classes for call channels.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c InitialAudioName.
     */
    QString InitialAudioName() const;
    /**
     * Return the value of the exported D-Bus object property \c InitialVideoName of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'initialVideoName' with type QString.
     *
     * 
     * \htmlonly
     * <p>The same as
     *    \endhtmlonly \link requestPropertyInitialAudioName() InitialAudioName \endlink \htmlonly , but for a
     *   video stream created by setting
     *    \endhtmlonly \link requestPropertyInitialVideo() InitialVideo \endlink \htmlonly  to True. This
     *   property is immutable and so cannot change.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c InitialVideoName.
     */
    QString InitialVideoName() const;
    /**
     * Return the value of the exported D-Bus object property \c MutableContents of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'mutableContents' with type bool.
     *
     * 
     * \htmlonly
     * <p>If True, a stream of a different content type can be added
     * after the Channel has been requested </p>
     * 
     * <p>If this property is missing, clients SHOULD assume that it is False,
     *   and thus that the channel's streams cannot be changed once the call
     *   has started.</p>
     * 
     * <p>If this property isn't present in the &quot;allowed&quot; set in any of the
     *   Call entries contact capabilities, then user interfaces MAY choose to
     *   show a separate &quot;call&quot; option for each class of call.</p>
     * 
     *   <div class="rationale">
     *     <p>For example, once an audio-only Google Talk call has started,
     *       it is not possible to add a video stream; both audio and video
     *       must be requested at the start of the call if video is desired.
     *       User interfaces may use this pseudo-capability as a hint to
     *       display separate &quot;Audio call&quot; and &quot;Video call&quot; buttons, rather
     *       than a single &quot;Call1&quot; button with the option to add and remove
     *       video once the call has started for contacts without this flag.
     *     </p>
     *   </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c MutableContents.
     */
    bool MutableContents() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c SetRinging on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void setRinging(const Tp::Service::ChannelTypeCallAdaptor::SetRingingContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Indicate that the local user has been alerted about the incoming
     *   call.</p>
     * 
     * <p>This method is only useful if the
     *   channel's  \endhtmlonly \link ChannelInterface::requestPropertyRequested() ChannelInterface::Requested \endlink \htmlonly 
     *   property is False, and
     *   the  \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  is
     *   <tp:value-ref type="Call_State">Initialised</tp:value-ref> (an incoming
     *   call is ready and waiting for the user to be notified). Calling this method
     *   SHOULD set  \endhtmlonly \link requestPropertyCallFlags() CallFlags \endlink \htmlonly ' bit
     *   <tp:value-ref type="Call_Flags">Locally_Ringing</tp:value-ref>, and notify the
     *   remote contact that the local user has been alerted (if the
     *   protocol supports this); repeated calls to this method
     *   SHOULD succeed, but have no further effect.</p>
     * 
     * <p>In all other states, this method SHOULD fail with the error
     *   NotAvailable.</p>
     * \endhtmlonly
     *
     */
    void SetRinging(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c SetQueued on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void setQueued(const Tp::Service::ChannelTypeCallAdaptor::SetQueuedContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Notifies the CM that the local user is already in a call, so this
     *   call has been put in a call-waiting style queue.</p>
     * 
     * <p>This method is only useful if the
     *   channel's  \endhtmlonly \link ChannelInterface::requestPropertyRequested() ChannelInterface::Requested \endlink \htmlonly 
     *   property is False, and
     *   the  \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  is
     *   <tp:value-ref type="Call_State">Initialising</tp:value-ref> or
     *   <tp:value-ref type="Call_State">Initialised</tp:value-ref>. Calling this method
     *   SHOULD set  \endhtmlonly \link requestPropertyCallFlags() CallFlags \endlink \htmlonly ' bit
     *   <tp:value-ref type="Call_Flags">Locally_Queued</tp:value-ref>, and notify the
     *   remote contact that the call is in a queue (if the
     *   protocol supports this); repeated calls to this method
     *   SHOULD succeed, but have no further effect.</p>
     * 
     * <p>Locally_Queued is a little like Locally_Held, but applies to calls that have not
     *   been Accepted (the Locally_Queued flag should be unset by the CM when Accept
     *   is called). It should also be set in response to the state of the
     *   world, rather than in response to user action.</p>
     * \endhtmlonly
     *
     */
    void SetQueued(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c Accept on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void accept(const Tp::Service::ChannelTypeCallAdaptor::AcceptContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>For incoming calls in state
     *   <tp:value-ref type="Call_State">Initialised</tp:value-ref>, accept the incoming call.
     *   This changes the  \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  to
     *   <tp:value-ref type="Call_State">Accepted</tp:value-ref>.</p>
     * 
     * <p>For outgoing calls in state
     *   <tp:value-ref type="Call_State">Pending_Initiator</tp:value-ref>, actually
     *   call the remote contact; this changes the
     *    \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  to
     *   <tp:value-ref type="Call_State">Initialising</tp:value-ref>.</p>
     * 
     * <p>Otherwise, this method SHOULD fail with the error NotAvailable.</p>
     * 
     * <p>This method should be called exactly once per Call, by whatever
     *   client (user interface) is handling the channel.</p>
     * 
     * <p>When this method is called, for each  \endhtmlonly CallContentInterface \htmlonly  whose
     *    \endhtmlonly \link CallContentInterface::requestPropertyDisposition() CallContentInterface::Disposition \endlink \htmlonly  is
     *   <tp:value-ref type="Call_Content_Disposition">Initial</tp:value-ref>, any
     *   streams where the  \endhtmlonly \link CallStreamInterface::requestPropertyLocalSendingState() CallStreamInterface::LocalSendingState \endlink \htmlonly 
     *   is <tp:value-ref type="Sending_State">Pending_Send</tp:value-ref> will be
     *   moved to <tp:value-ref type="Sending_State">Sending</tp:value-ref> as if
     *    \endhtmlonly CallStreamInterface::SetSending() \htmlonly (True) had been called.</p>
     * \endhtmlonly
     *
     */
    void Accept(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c Hangup on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void hangup(uint reason, const QString& detailedHangupReason, const QString& message, const Tp::Service::ChannelTypeCallAdaptor::HangupContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Request that the call is ended. All contents will be removed from the 
     * Call so that the Contents property will be the empty list.
     *
     * \param reason
     *     
     *     A generic hangup reason.
     * \param detailedHangupReason
     *     
     *     A more specific reason for the call hangup, if one is available, or 
     *     an empty string otherwise.
     * \param message
     *     
     *     A human-readable message to be sent to the remote contact(s). XMPP 
     *     Jingle allows calls to be terminated with a human-readable message.
     */
    void Hangup(uint reason, const QString& detailedHangupReason, const QString& message, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c AddContent on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void addContent(const QString& contentName, uint contentType, uint initialDirection, const Tp::Service::ChannelTypeCallAdaptor::AddContentContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Request that a new Content of type Content_Type is added to the Call1. 
     * Handlers should check the value of the MutableContents property before 
     * trying to add another content as it might not be allowed.
     *
     * \param contentName
     *     
     *     The suggested name of the content to add. The content name property 
     *     should be meaningful, so should be given a name which is 
     *     significant to the user. The name could be a localized 
     *     &quot;audio&quot;, &quot;video&quot; or perhaps include some string 
     *     identifying the source, such as a webcam identifier. If there is 
     *     already a content with the same name as this property then a 
     *     sensible suffix should be added. For example, if this argument is 
     *     &quot;audio&quot; but a content of the same name already exists, a 
     *     sensible suffix such as &quot; (1)&quot; is appended to name the 
     *     new content &quot;audio (1)&quot;. A further content with the name 
     *     &quot;audio&quot; would then be named &quot;audio (2)&quot;.
     * \param contentType
     *     
     *     The media stream type of the content to be added to the call.
     * \param initialDirection
     *     
     *     The requested initial direction of the new content.
     * \return
     *     
     *     Path to the newly-created Call1.Content object.
     */
    QDBusObjectPath AddContent(const QString& contentName, uint contentType, uint initialDirection, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c ContentAdded on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void contentAdded(const QDBusObjectPath& content);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param content
     *     
     *     Path to the newly-created Content object.
     */
    void ContentAdded(const QDBusObjectPath& content);
    /**
     * Represents the exported D-Bus signal \c ContentRemoved on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void contentRemoved(const QDBusObjectPath& content, const Tp::CallStateReason& reason);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param content
     *     
     *     The Content which was removed.
     * \param reason
     *     
     *     Why the content was removed.
     */
    void ContentRemoved(const QDBusObjectPath& content, const Tp::CallStateReason& reason);
    /**
     * Represents the exported D-Bus signal \c CallStateChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void callStateChanged(uint callState, uint callFlags, const Tp::CallStateReason& callStateReason, const QVariantMap& callStateDetails);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param callState
     *     
     *     The new value of the CallState property.
     * \param callFlags
     *     
     *     The new value of the CallFlags property.
     * \param callStateReason
     *     
     *     The new value of the CallStateReason property.
     * \param callStateDetails
     *     
     *     The new value of the CallStateDetails property.
     */
    void CallStateChanged(uint callState, uint callFlags, const Tp::CallStateReason& callStateReason, const QVariantMap& callStateDetails);
    /**
     * Represents the exported D-Bus signal \c CallMembersChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void callMembersChanged(const Tp::CallMemberMap& flagsChanged, const Tp::HandleIdentifierMap& identifiers, const Tp::UIntList& removed, const Tp::CallStateReason& reason);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param flagsChanged
     *     
     *     A map from members of the call to their new call member flags, 
     *     including at least the members who have been added to CallMembers, 
     *     and the members whose flags have changed.
     * \param identifiers
     *     
     *     \htmlonly
     *     The identifiers of the contacts in the <var>Flags_Changed</var> map.
     *     \endhtmlonly
     * \param removed
     *     
     *     A list of members who have left the call, i.e. keys to be removed 
     *     from CallMembers.
     * \param reason
     *     
     *     A structured reason for the change.
     */
    void CallMembersChanged(const Tp::CallMemberMap& flagsChanged, const Tp::HandleIdentifierMap& identifiers, const Tp::UIntList& removed, const Tp::CallStateReason& reason);
};

/**
 * \class ChannelTypeContactSearchAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.ContactSearch".
 */
class TP_QT_EXPORT ChannelTypeContactSearchAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Type.ContactSearch")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Type.ContactSearch\">\n"
"    <property access=\"read\" type=\"u\" name=\"SearchState\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"Limit\"/>\n"
"    <property access=\"read\" type=\"as\" name=\"AvailableSearchKeys\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"Server\"/>\n"
"    <method name=\"Search\">\n"
"      <arg direction=\"in\" type=\"a{ss}\" name=\"terms\">\n"
"        <annotation value=\"Tp::ContactSearchMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"More\"/>\n"
"    <method name=\"Stop\"/>\n"
"    <signal name=\"SearchStateChanged\">\n"
"      <arg type=\"u\" name=\"state\"/>\n"
"      <arg type=\"s\" name=\"error\"/>\n"
"      <arg type=\"a{sv}\" name=\"details\"/>\n"
"    </signal>\n"
"    <signal name=\"SearchResultReceived\">\n"
"      <arg type=\"a{sa(sasas)}\" name=\"result\">\n"
"        <annotation value=\"Tp::ContactSearchResultMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(uint SearchState READ SearchState )
    Q_PROPERTY(uint Limit READ Limit )
    Q_PROPERTY(QStringList AvailableSearchKeys READ AvailableSearchKeys )
    Q_PROPERTY(QString Server READ Server )

public:
    ChannelTypeContactSearchAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelTypeContactSearchAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > SearchContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > MoreContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > StopContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c SearchState of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'searchState' with type uint.
     *
     * 
     * The current state of this search channel object. Change notification is 
     * via SearchStateChanged.
     *
     * \return The value of exported property \c SearchState.
     */
    uint SearchState() const;
    /**
     * Return the value of the exported D-Bus object property \c Limit of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'limit' with type uint.
     *
     * 
     * \htmlonly
     * <p>If supported by the protocol, the maximum number of results that
     *   should be returned, where <code>0</code> represents no limit. If the
     *   protocol does not support limiting results, this should be
     *   <code>0</code>.</p>
     * 
     * <p>For example, if the terms passed to
     *    \endhtmlonly Search() \htmlonly  match <i>Antonius</i>,
     *   <i>Bridget</i> and <i>Charles</i> and this property is
     *   <code>2</code>, the search service SHOULD only return <i>Antonius</i>
     *   and <i>Bridget</i>.</p>
     * 
     * <p>This property SHOULD be requestable if and only if the protocol
     *   supports specifying a limit; implementations SHOULD use
     *   <code>0</code> as the default if possible, or a protocol-specific
     *   sensible default otherwise.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Limit.
     */
    uint Limit() const;
    /**
     * Return the value of the exported D-Bus object property \c AvailableSearchKeys of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'availableSearchKeys' with type QStringList.
     *
     * 
     * The set of search keys supported by this channel. Example values 
     * include [&quot;&quot;] (for protocols where several address fields are 
     * implicitly searched) or [&quot;x-n-given&quot;, &quot;x-n-family&quot;, 
     * &quot;nickname&quot;, &quot;email&quot;] (for XMPP XEP-0055, without 
     * extensibility via Data Forms). It can be in the NewChannels signal for 
     * round-trip reduction.
     *
     * \return The value of exported property \c AvailableSearchKeys.
     */
    QStringList AvailableSearchKeys() const;
    /**
     * Return the value of the exported D-Bus object property \c Server of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'server' with type QString.
     *
     * 
     * For protocols which support searching for contacts on multiple servers 
     * with different DNS names (like XMPP), the DNS name of the server being 
     * searched by this channel, e.g. &quot;characters.shakespeare.lit&quot;. 
     * Otherwise, the empty string. XEP 0055 defines a mechanism for XMPP 
     * clients to search services of their choice for contacts, such as 
     * users.jabber.org (the &quot;Jabber User Directory&quot;). This property 
     * SHOULD be requestable if and only if the protocol supports querying 
     * multiple different servers; implementations SHOULD use a sensible 
     * default if possible if this property is not specified in a channel 
     * request. This allows a client to perform searches on a protocol it 
     * knows nothing about without requiring the user to guess a valid 
     * server&apos;s hostname.
     *
     * \return The value of exported property \c Server.
     */
    QString Server() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c Search on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void search(const Tp::ContactSearchMap& terms, const Tp::Service::ChannelTypeContactSearchAdaptor::SearchContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Send a request to start a search for contacts on this connection. This 
     * may only be called while the SearchState is Not_Started; a valid search 
     * request will cause the SearchStateChanged signal to be emitted with the 
     * state In_Progress.
     *
     * \param terms
     *     
     *     A dictionary mapping search key names to the desired values
     */
    void Search(const Tp::ContactSearchMap& terms, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c More on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void more(const Tp::Service::ChannelTypeContactSearchAdaptor::MoreContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * Request that a search in  \endhtmlonly \link requestPropertySearchState() SearchState \endlink \htmlonly 
     * <code>More_Available</code> move back to state <code>In_Progress</code>
     * and continue listing up to  \endhtmlonly \link requestPropertyLimit() Limit \endlink \htmlonly  more results.
     * \endhtmlonly
     *
     */
    void More(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c Stop on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void stop(const Tp::Service::ChannelTypeContactSearchAdaptor::StopContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Stop the current search. This may not be called while the
     *    \endhtmlonly \link requestPropertySearchState() SearchState \endlink \htmlonly  is Not_Started. If called
     *   while the SearchState is In_Progress,
     *    \endhtmlonly SearchStateChanged() \htmlonly  will be emitted,
     *   with the state Failed and the error
     *   <code>org.freedesktop.Telepathy.Error.<tp:error-ref>Cancelled</tp:error-ref></code>.</p>
     * 
     * <p>Calling this method on a search in state Completed or Failed
     *   succeeds, but has no effect.</p>
     * 
     * <div class="rationale">
     *   <p>Specifying Stop to succeed when the search has finished means that
     *     clients who call Stop just before receiving
     *      \endhtmlonly SearchStateChanged() \htmlonly  don't have to
     *     handle a useless error.</p>
     * </div>
     * 
     * <p>Depending on the protocol, the connection manager may not be
     *   able to prevent the server from sending further results after this
     *   method returns; if this is the case, it MUST ignore any further
     *   results.</p>
     * \endhtmlonly
     *
     */
    void Stop(const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c SearchStateChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void searchStateChanged(uint state, const QString& error, const QVariantMap& details);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param state
     *     
     *     The new search state
     * \param error
     *     
     *     \htmlonly
     *     If the new state is <code>Failed</code>, the name of a D-Bus error
     *     describing what went wrong. Otherwise, the empty string.
     *     \endhtmlonly
     * \param details
     *     
     *     \htmlonly
     *     <p>Additional information about the state transition, which may
     *       include the following well-known keys:</p>
     *     
     *     <dl>
     *       <dt>debug-message (s)</dt>
     *       <dd>Debugging information on the change, corresponding to the
     *         message part of a D-Bus error message, which SHOULD NOT be
     *         displayed to users under normal circumstances</dd>
     *     </dl>
     *     
     *     <div class="rationale">
     *       <p>This argument allows for future extensions. For instance,
     *         if moving to state <code>Failed</code> because the server
     *         rejected one of our search terms, we could define a key
     *         that indicates which terms were invalid.</p>
     *     </div>
     *     \endhtmlonly
     */
    void SearchStateChanged(uint state, const QString& error, const QVariantMap& details);
    /**
     * Represents the exported D-Bus signal \c SearchResultReceived on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void searchResultReceived(const Tp::ContactSearchResultMap& result);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param result
     *     
     *     A mapping from contact identifier to an array of fields 
     *     representing information about this contact.
     */
    void SearchResultReceived(const Tp::ContactSearchResultMap& result);
};

/**
 * \class ChannelTypeDBusTubeAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.DBusTube".
 */
class TP_QT_EXPORT ChannelTypeDBusTubeAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Type.DBusTube")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Type.DBusTube\">\n"
"    <property access=\"read\" type=\"s\" name=\"ServiceName\"/>\n"
"    <property access=\"read\" type=\"a{us}\" name=\"DBusNames\">\n"
"      <annotation value=\"Tp::DBusTubeParticipants\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"au\" name=\"SupportedAccessControls\"/>\n"
"    <method name=\"Offer\">\n"
"      <arg direction=\"in\" type=\"a{sv}\" name=\"parameters\">\n"
"        <annotation value=\"QVariantMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg direction=\"in\" type=\"u\" name=\"accesscontrol\"/>\n"
"      <arg direction=\"out\" type=\"s\" name=\"address\"/>\n"
"    </method>\n"
"    <method name=\"Accept\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"accesscontrol\"/>\n"
"      <arg direction=\"out\" type=\"s\" name=\"address\"/>\n"
"    </method>\n"
"    <signal name=\"DBusNamesChanged\">\n"
"      <arg type=\"a{us}\" name=\"added\">\n"
"        <annotation value=\"Tp::DBusTubeParticipants\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg type=\"au\" name=\"removed\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QString ServiceName READ ServiceName )
    Q_PROPERTY(Tp::DBusTubeParticipants DBusNames READ DBusNames )
    Q_PROPERTY(Tp::UIntList SupportedAccessControls READ SupportedAccessControls )

public:
    ChannelTypeDBusTubeAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelTypeDBusTubeAdaptor();

    typedef Tp::MethodInvocationContextPtr< QString > OfferContextPtr;
    typedef Tp::MethodInvocationContextPtr< QString > AcceptContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c ServiceName of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'serviceName' with type QString.
     *
     * 
     * \htmlonly
     * <p>A string representing the service name that will be used over the
     *   tube. It SHOULD be a well-known D-Bus service name, of the form
     *   <tt>com.example.ServiceName</tt>.</p>
     * <p>When the tube is offered, the service name is transmitted to the
     *   other end.</p>
     * <p>When requesting a channel with
     *    \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly ,
     *   this property MUST be included in the request.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c ServiceName.
     */
    QString ServiceName() const;
    /**
     * Return the value of the exported D-Bus object property \c DBusNames of type \c Tp::DBusTubeParticipants.
     *
     * Adaptees should export this property as a Qt property named
     * 'dbusNames' with type Tp::DBusTubeParticipants.
     *
     * 
     * For a multi-user (i.e. Handle_Type_Room) D-Bus tube, a mapping between 
     * contact handles and their unique bus names on this tube. For a 
     * peer-to-peer (i.e. Handle_Type_Contact) D-Bus tube, the empty 
     * dictionary. Change notification is via DBusNamesChanged.
     *
     * \return The value of exported property \c DBusNames.
     */
    Tp::DBusTubeParticipants DBusNames() const;
    /**
     * Return the value of the exported D-Bus object property \c SupportedAccessControls of type \c Tp::UIntList.
     *
     * Adaptees should export this property as a Qt property named
     * 'supportedAccessControls' with type Tp::UIntList.
     *
     * 
     * \htmlonly
     * <p>A list of the access control types that are supported with this channel.
     * Note that only Socket_Access_Control_Localhost and
     * Socket_Access_Control_Credentials can be used with D-Bus tubes.
     * Using Socket_Access_Control_Credentials is recommended.</p>
     * 
     * <div class="rationale">
     *   <p>Socket_Access_Control_Credentials is easy to implement for a
     *     D-Bus tube, because typical D-Bus library implementations like
     *     libdbus and GDBus already have to support it to be able to
     *     connect to the system or session bus, and usually enable it
     *     by default; so there's typically no good reason to relax
     *     access control to Localhost.</p>
     * </div>
     * 
     * <p>When requesting a channel with
     *    \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly ,
     *   this property MUST NOT be included in the request.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c SupportedAccessControls.
     */
    Tp::UIntList SupportedAccessControls() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c Offer on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void offer(const QVariantMap& parameters, uint accesscontrol, const Tp::Service::ChannelTypeDBusTubeAdaptor::OfferContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Offers a D-Bus tube providing the service specified.
     *
     * \param parameters
     *     
     *     The dictionary of arbitrary Parameters to send with the tube offer.
     * \param accesscontrol
     *     
     *     The access control the connection manager applies to the D-Bus 
     *     socket.
     * \return
     *     
     *     The string describing the address of the private bus. The client 
     *     SHOULD NOT attempt to connect to the address until the tube is open.
     */
    QString Offer(const QVariantMap& parameters, uint accesscontrol, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c Accept on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void accept(uint accesscontrol, const Tp::Service::ChannelTypeDBusTubeAdaptor::AcceptContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Accept a D-Bus tube that&apos;s in the &quot;local pending&quot; state. 
     * The connection manager will attempt to open the tube. The tube remains 
     * in the &quot;local pending&quot; state until the 
     * TubeChannelStateChanged signal is emitted.
     *
     * \param accesscontrol
     *     
     *     The access control the connection manager applies to the D-Bus 
     *     socket.
     * \return
     *     
     *     The string describing the address of the private bus. The client 
     *     SHOULD NOT attempt to connect to the address until the tube is open.
     */
    QString Accept(uint accesscontrol, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c DBusNamesChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void dbusNamesChanged(const Tp::DBusTubeParticipants& added, const Tp::UIntList& removed);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param added
     *     
     *     Array of handles and D-Bus names of new participants.
     * \param removed
     *     
     *     Array of handles of former participants.
     */
    void DBusNamesChanged(const Tp::DBusTubeParticipants& added, const Tp::UIntList& removed);
};

/**
 * \class ChannelTypeFileTransferAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.FileTransfer".
 */
class TP_QT_EXPORT ChannelTypeFileTransferAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Type.FileTransfer")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Type.FileTransfer\">\n"
"    <property access=\"read\" type=\"u\" name=\"State\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"ContentType\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"Filename\"/>\n"
"    <property access=\"read\" type=\"t\" name=\"Size\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"ContentHashType\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"ContentHash\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"Description\"/>\n"
"    <property access=\"read\" type=\"x\" name=\"Date\"/>\n"
"    <property access=\"read\" type=\"a{uau}\" name=\"AvailableSocketTypes\">\n"
"      <annotation value=\"Tp::SupportedSocketMap\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"t\" name=\"TransferredBytes\"/>\n"
"    <property access=\"read\" type=\"t\" name=\"InitialOffset\"/>\n"
"    <property access=\"readwrite\" type=\"s\" name=\"URI\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"FileCollection\"/>\n"
"    <method name=\"AcceptFile\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"addressType\"/>\n"
"      <arg direction=\"in\" type=\"u\" name=\"accessControl\"/>\n"
"      <arg direction=\"in\" type=\"v\" name=\"accessControlParam\"/>\n"
"      <arg direction=\"in\" type=\"t\" name=\"offset\"/>\n"
"      <arg direction=\"out\" type=\"v\" name=\"address\"/>\n"
"    </method>\n"
"    <method name=\"ProvideFile\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"addressType\"/>\n"
"      <arg direction=\"in\" type=\"u\" name=\"accessControl\"/>\n"
"      <arg direction=\"in\" type=\"v\" name=\"accessControlParam\"/>\n"
"      <arg direction=\"out\" type=\"v\" name=\"address\"/>\n"
"    </method>\n"
"    <signal name=\"FileTransferStateChanged\">\n"
"      <arg type=\"u\" name=\"state\"/>\n"
"      <arg type=\"u\" name=\"reason\"/>\n"
"    </signal>\n"
"    <signal name=\"TransferredBytesChanged\">\n"
"      <arg type=\"t\" name=\"count\"/>\n"
"    </signal>\n"
"    <signal name=\"InitialOffsetDefined\">\n"
"      <arg type=\"t\" name=\"initialOffset\"/>\n"
"    </signal>\n"
"    <signal name=\"URIDefined\">\n"
"      <arg type=\"s\" name=\"URI\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(uint State READ State )
    Q_PROPERTY(QString ContentType READ ContentType )
    Q_PROPERTY(QString Filename READ Filename )
    Q_PROPERTY(qulonglong Size READ Size )
    Q_PROPERTY(uint ContentHashType READ ContentHashType )
    Q_PROPERTY(QString ContentHash READ ContentHash )
    Q_PROPERTY(QString Description READ Description )
    Q_PROPERTY(qlonglong Date READ Date )
    Q_PROPERTY(Tp::SupportedSocketMap AvailableSocketTypes READ AvailableSocketTypes )
    Q_PROPERTY(qulonglong TransferredBytes READ TransferredBytes )
    Q_PROPERTY(qulonglong InitialOffset READ InitialOffset )
    Q_PROPERTY(QString URI READ URI WRITE SetURI)
    Q_PROPERTY(QString FileCollection READ FileCollection )

public:
    ChannelTypeFileTransferAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelTypeFileTransferAdaptor();

    typedef Tp::MethodInvocationContextPtr< QDBusVariant > AcceptFileContextPtr;
    typedef Tp::MethodInvocationContextPtr< QDBusVariant > ProvideFileContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c State of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'state' with type uint.
     *
     * 
     * \htmlonly
     * <p>The state of the file transfer as described by the
     * File_Transfer_State enum.</p>
     * 
     * <p>Change notification is via
     *    \endhtmlonly FileTransferStateChanged() \htmlonly  signal.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c State.
     */
    uint State() const;
    /**
     * Return the value of the exported D-Bus object property \c ContentType of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'contentType' with type QString.
     *
     * 
     * \htmlonly
     * <p>The file's MIME type. This cannot change once the channel has
     * been created.</p>
     * 
     * <p>This property is mandatory when requesting the channel with the
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method. Protocols which do not have a content-type property with file
     * transfers should set this value to application/octet-stream.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c ContentType.
     */
    QString ContentType() const;
    /**
     * Return the value of the exported D-Bus object property \c Filename of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'filename' with type QString.
     *
     * 
     * \htmlonly
     * <p>The name of the file on the sender's side. This is therefore given
     * as a suggested filename for the receiver. This cannot change
     * once the channel has been created.</p>
     * 
     * <p>This property should be the basename of the file being sent. For example,
     * if the sender sends the file /home/user/monkey.pdf then this property should
     * be set to monkey.pdf.</p>
     * 
     * <p>This property is mandatory when requesting the channel with the
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method. This property cannot be empty and MUST be set to a sensible value.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Filename.
     */
    QString Filename() const;
    /**
     * Return the value of the exported D-Bus object property \c Size of type \c qulonglong.
     *
     * Adaptees should export this property as a Qt property named
     * 'size' with type qulonglong.
     *
     * 
     * \htmlonly
     * <p>The size of the file. If this property is set, then the file
     * transfer is guaranteed to be this size. This cannot change once
     * the channel has been created.</p>
     * 
     * <p>When you are creating a channel with this property, its value
     * MUST be accurate and in bytes. However, when receiving a file, this
     * property still MUST be in bytes but might not be entirely accurate
     * to the byte.</p>
     * 
     * <p>This property is mandatory when requesting the channel with the
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method. If this information isn't provided in the protocol, connection managers MUST set it
     * to UINT64_MAX.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Size.
     */
    qulonglong Size() const;
    /**
     * Return the value of the exported D-Bus object property \c ContentHashType of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'contentHashType' with type uint.
     *
     * 
     * \htmlonly
     * <p>The type of the  \endhtmlonly \link requestPropertyContentHash() ContentHash \endlink \htmlonly  property.</p>
     * 
     * <p>This property is optional when requesting the channel with the
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method. However, if you wish to include the  \endhtmlonly \link requestPropertyContentHash() ContentHash \endlink \htmlonly 
     * property you MUST also include this property. If you omit this property from a
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method call then its value will be assumed to be File_Hash_Type_None.</p>
     * 
     * <p>For each supported hash type, implementations SHOULD include an entry
     *   in  \endhtmlonly \link ConnectionInterfaceRequestsInterface::requestPropertyRequestableChannelClasses() ConnectionInterfaceRequestsInterface::RequestableChannelClasses \endlink \htmlonly 
     *   with this property fixed to that hash type. If the protocol supports
     *   offering a file without a content hash, implementations SHOULD list
     *   this property in Allowed in a requestable channel class, mapping hash
     *   types they don't understand to None.
     * </p>
     * \endhtmlonly
     *
     * \return The value of exported property \c ContentHashType.
     */
    uint ContentHashType() const;
    /**
     * Return the value of the exported D-Bus object property \c ContentHash of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'contentHash' with type QString.
     *
     * 
     * \htmlonly
     * <p>Hash of the contents of the file transfer, of type described
     * in the value of the  \endhtmlonly \link requestPropertyContentHashType() ContentHashType \endlink \htmlonly 
     * property.</p>
     * 
     * <p>This property is optional when requesting the channel with the
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method. Its value MUST correspond to the appropriate type of the
     *  \endhtmlonly \link requestPropertyContentHashType() ContentHashType \endlink \htmlonly  property. If the
     * ContentHashType property is not set, or set to File_Hash_Type_None,
     * then this property will not even be looked at.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c ContentHash.
     */
    QString ContentHash() const;
    /**
     * Return the value of the exported D-Bus object property \c Description of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'description' with type QString.
     *
     * 
     * \htmlonly
     * <p>Description of the file transfer. This cannot change once the
     * channel has been created.</p>
     * 
     * <p>This property is optional when requesting the channel with the
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method. If this property was not provided by the remote party, connection managers MUST set it to
     * the empty string.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Description.
     */
    QString Description() const;
    /**
     * Return the value of the exported D-Bus object property \c Date of type \c qlonglong.
     *
     * Adaptees should export this property as a Qt property named
     * 'date' with type qlonglong.
     *
     * 
     * \htmlonly
     * <p>The last modification time of the file being transferred. This
     * cannot change once the channel has been created</p>
     * 
     * <p>This property is optional when requesting the channel with the
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Date.
     */
    qlonglong Date() const;
    /**
     * Return the value of the exported D-Bus object property \c AvailableSocketTypes of type \c Tp::SupportedSocketMap.
     *
     * Adaptees should export this property as a Qt property named
     * 'availableSocketTypes' with type Tp::SupportedSocketMap.
     *
     * 
     * \htmlonly
     * <p>A mapping from address types (members of Socket_Address_Type) to
     * arrays of access-control type (members of Socket_Access_Control)
     * that the connection manager supports for sockets with that
     * address type. For simplicity, if a CM supports offering a
     * particular type of file transfer, it is assumed to support accepting
     * it. Connection Managers MUST support at least Socket_Address_Type_IPv4.</p>
     * 
     * <p>A typical value for a host without IPv6 support:</p>
     * 
     * <pre>
     *   {
     *     Socket_Address_Type_IPv4:
     *       [Socket_Access_Control_Localhost, Socket_Access_Control_Port,
     *        Socket_Access_Control_Netmask],
     *     Socket_Address_Type_Unix:
     *       [Socket_Access_Control_Localhost, Socket_Access_Control_Credentials]
     *   }
     * </pre>
     * \endhtmlonly
     *
     * \return The value of exported property \c AvailableSocketTypes.
     */
    Tp::SupportedSocketMap AvailableSocketTypes() const;
    /**
     * Return the value of the exported D-Bus object property \c TransferredBytes of type \c qulonglong.
     *
     * Adaptees should export this property as a Qt property named
     * 'transferredBytes' with type qulonglong.
     *
     * 
     * \htmlonly
     * <p>The number of bytes that have been transferred at the time of
     * requesting the property. This will be updated as the file transfer
     * continues.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c TransferredBytes.
     */
    qulonglong TransferredBytes() const;
    /**
     * Return the value of the exported D-Bus object property \c InitialOffset of type \c qulonglong.
     *
     * Adaptees should export this property as a Qt property named
     * 'initialOffset' with type qulonglong.
     *
     * 
     * \htmlonly
     * <p>The offset in bytes from where the file should be sent. This MUST
     * be respected by both the receiver and the sender after the state
     * becomes Open, but before any data is sent or received. Until the
     *  \endhtmlonly InitialOffsetDefined() \htmlonly  signal
     * is emitted, this property is undefined.</p>
     * 
     * <p>Before setting the  \endhtmlonly \link requestPropertyState() State \endlink \htmlonly  property to
     * Open, the connection manager MUST set the InitialOffset property,
     * possibly to 0.</p>
     * 
     * <p>This property MUST NOT change after the state of the transfer has
     * changed to Open.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c InitialOffset.
     */
    qulonglong InitialOffset() const;
    /**
     * Return the value of the exported D-Bus object property \c URI of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'uri' with type QString.
     *
     * 
     * \htmlonly
     * <p>For outgoing file transfers, this requestable property allows the channel
     * requester to inform observers (and the handler, if it is not the requester
     * itself) of the URI of the file being transferred. Note that the
     * connection manager SHOULD NOT read this file directly; the handler
     * streams the file into the CM through the socket negotiated using
     *  \endhtmlonly ProvideFile() \htmlonly .</p>
     * 
     * <p>On outgoing file transfers, this property MUST NOT change after the channel
     * is requested.</p>
     * 
     * <p>For incoming file transfers, this property MAY be set by the channel
     * handler before calling  \endhtmlonly AcceptFile() \htmlonly  to
     * inform observers where the incoming file will be saved. If set by an
     * approver, the handler MUST save the file to that location.
     * Setting this property once  \endhtmlonly AcceptFile() \htmlonly 
     * has been called MUST fail. Once this property has been set
     *  \endhtmlonly URIDefined() \htmlonly  is emitted.</p>
     * 
     * <p>If set, this URI SHOULD generally point to a file on the local system, as
     * defined by <a href="http://www.apps.ietf.org/rfc/rfc1738.html#sec-3.10">
     * RFC 1738 §3.10</a>; that is, it should be of the form
     * <tt>file:///path/to/file</tt> or <tt>file://localhost/path/to/file</tt>.
     * For outgoing files, this URI MAY use a different scheme, such as
     * <tt>http:</tt>, if a remote resource is being transferred
     * to a contact.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c URI.
     */
    QString URI() const;
    /**
     * Set the value of the exported D-Bus object property \c URI of type \c QString.
     *
     * Adaptees should export this property as a writable Qt property named
     * 'uri' with type QString.
     *
     * 
     * \htmlonly
     * <p>For outgoing file transfers, this requestable property allows the channel
     * requester to inform observers (and the handler, if it is not the requester
     * itself) of the URI of the file being transferred. Note that the
     * connection manager SHOULD NOT read this file directly; the handler
     * streams the file into the CM through the socket negotiated using
     *  \endhtmlonly ProvideFile() \htmlonly .</p>
     * 
     * <p>On outgoing file transfers, this property MUST NOT change after the channel
     * is requested.</p>
     * 
     * <p>For incoming file transfers, this property MAY be set by the channel
     * handler before calling  \endhtmlonly AcceptFile() \htmlonly  to
     * inform observers where the incoming file will be saved. If set by an
     * approver, the handler MUST save the file to that location.
     * Setting this property once  \endhtmlonly AcceptFile() \htmlonly 
     * has been called MUST fail. Once this property has been set
     *  \endhtmlonly URIDefined() \htmlonly  is emitted.</p>
     * 
     * <p>If set, this URI SHOULD generally point to a file on the local system, as
     * defined by <a href="http://www.apps.ietf.org/rfc/rfc1738.html#sec-3.10">
     * RFC 1738 §3.10</a>; that is, it should be of the form
     * <tt>file:///path/to/file</tt> or <tt>file://localhost/path/to/file</tt>.
     * For outgoing files, this URI MAY use a different scheme, such as
     * <tt>http:</tt>, if a remote resource is being transferred
     * to a contact.</p>
     * \endhtmlonly
     */
    void SetURI(const QString &newValue);
    /**
     * Return the value of the exported D-Bus object property \c FileCollection of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'fileCollection' with type QString.
     *
     * 
     * \htmlonly
     * <p>The collection of files to which this channel belongs,
     *   or the empty string if this channel does not belong to
     *   a collection of files.</p>
     * 
     * <p>A channel's FileCollection property can never change.</p>
     * 
     * <p>At least on GTalk and apparently also on iChat the user can
     *   send a set of files to a contact and that contact can then
     *   pick and choose which files to actually receive.</p>
     * 
     * <p> The CM should emit all new FT channels belonging to one collection
     *   at the same time. UIs supporting this feature can then
     *   bundle all these channels together in some way, and show a
     *   nice UI. UIs not supporting it will treat them as separate
     *   transfers, which is not great but a reasonable fallback.</p>
     * 
     * <p>No mechanism is currently defined to indicate whether the UI
     *   should expect any more files in the same collection. UIs
     *   SHOULD assume that more file transfers may be added to a
     *   collection. It is possible that a &quot;no more channels in this
     *   collection&quot; indication will be added in a future version of
     *   this specification.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c FileCollection.
     */
    QString FileCollection() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c AcceptFile on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void acceptFile(uint addressType, uint accessControl, const QDBusVariant& accessControlParam, qulonglong offset, const Tp::Service::ChannelTypeFileTransferAdaptor::AcceptFileContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Accept a file transfer that&apos;s in the Pending state. The file 
     * transfer&apos;s state becomes Accepted after this method is called. At 
     * this point the client can connect to the socket. CM MUST emit 
     * InitialOffsetDefined and change the state to Open before writing to the 
     * socket. Then InitialOffset should be respected in case its value 
     * differs from the offset that was specified as an argument to AcceptFile.
     *
     * \param addressType
     *     
     *     The type of address the connection manager should listen on.
     * \param accessControl
     *     
     *     The type of access control the connection manager should apply to 
     *     the socket.
     * \param accessControlParam
     *     
     *     A parameter for the access control type, to be interpreted as 
     *     specified in the documentation for the Socket_Access_Control enum.
     * \param offset
     *     
     *     The desired offset in bytes where the file transfer should start. 
     *     The offset is taken from the beginning of the file. Specifying an 
     *     offset of zero will start the transfer from the beginning of the 
     *     file. The offset that is actually given in the InitialOffset 
     *     property can differ from this argument where the requested offset 
     *     is not supported. (For example, some protocols do not support 
     *     offsets at all so the InitialOffset property will always be 0.)
     * \return
     *     
     *     The address on which the connection manager will listen for 
     *     connections for this file transfer.
     */
    QDBusVariant AcceptFile(uint addressType, uint accessControl, const QDBusVariant& accessControlParam, qulonglong offset, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c ProvideFile on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void provideFile(uint addressType, uint accessControl, const QDBusVariant& accessControlParam, const Tp::Service::ChannelTypeFileTransferAdaptor::ProvideFileContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Provide the file for an outgoing file transfer which has been offered. 
     * Opens a socket that the client can use to provide a file to the 
     * connection manager. The channel MUST have been requested, and will 
     * change state to Open when this method is called if its state was 
     * Accepted.
     *
     * \param addressType
     *     
     *     The type of address the connection manager should listen on.
     * \param accessControl
     *     
     *     The type of access control the connection manager should apply to 
     *     the socket.
     * \param accessControlParam
     *     
     *     A parameter for the access control type, to be interpreted as 
     *     specified in the documentation for the Socket_Access_Control enum.
     * \return
     *     
     *     The address on which the connection manager will listen for 
     *     connections for this file transfer.
     */
    QDBusVariant ProvideFile(uint addressType, uint accessControl, const QDBusVariant& accessControlParam, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c FileTransferStateChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void fileTransferStateChanged(uint state, uint reason);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param state
     *     
     *     The new state of the file transfer; see the File_Transfer_State 
     *     enumeration.
     * \param reason
     *     
     *     The reason for the state change; see the 
     *     File_Transfer_State_Change_Reason enumeration. The value will 
     *     always be File_Transfer_State_Change_Reason_None, except when 
     *     changing state to cancelled.
     */
    void FileTransferStateChanged(uint state, uint reason);
    /**
     * Represents the exported D-Bus signal \c TransferredBytesChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void transferredBytesChanged(qulonglong count);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param count
     *     
     *     The number of already transferred bytes.
     */
    void TransferredBytesChanged(qulonglong count);
    /**
     * Represents the exported D-Bus signal \c InitialOffsetDefined on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void initialOffsetDefined(qulonglong initialOffset);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param initialOffset
     *     
     *     The value of the InitialOffset property.
     */
    void InitialOffsetDefined(qulonglong initialOffset);
    /**
     * Represents the exported D-Bus signal \c URIDefined on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void uriDefined(const QString& URI);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param URI
     *     
     *     The value of the URI property.
     */
    void URIDefined(const QString& URI);
};

/**
 * \class ChannelTypeRoomListAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.RoomList".
 */
class TP_QT_EXPORT ChannelTypeRoomListAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Type.RoomList")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Type.RoomList\">\n"
"    <property access=\"read\" type=\"s\" name=\"Server\"/>\n"
"    <method name=\"GetListingRooms\">\n"
"      <arg direction=\"out\" type=\"b\" name=\"inProgress\"/>\n"
"    </method>\n"
"    <method name=\"ListRooms\"/>\n"
"    <method name=\"StopListing\"/>\n"
"    <signal name=\"GotRooms\">\n"
"      <arg type=\"a(usa{sv})\" name=\"rooms\">\n"
"        <annotation value=\"Tp::RoomInfoList\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </signal>\n"
"    <signal name=\"ListingRooms\">\n"
"      <arg type=\"b\" name=\"listing\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QString Server READ Server )

public:
    ChannelTypeRoomListAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelTypeRoomListAdaptor();

    typedef Tp::MethodInvocationContextPtr< bool > GetListingRoomsContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > ListRoomsContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > StopListingContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Server of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'server' with type QString.
     *
     * 
     * For protocols with a concept of chatrooms on multiple servers with 
     * different DNS names (like XMPP), the DNS name of the server whose rooms 
     * are listed by this channel, e.g. &quot;conference.jabber.org&quot;. 
     * Otherwise, the empty string. This property cannot change during the 
     * lifetime of the channel.
     *
     * \return The value of exported property \c Server.
     */
    QString Server() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetListingRooms on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getListingRooms(const Tp::Service::ChannelTypeRoomListAdaptor::GetListingRoomsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Check to see if there is already a room list request in progress on 
     * this channel.
     *
     * \return
     *     
     *     A boolean indicating if room listing is in progress
     */
    bool GetListingRooms(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c ListRooms on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void listRooms(const Tp::Service::ChannelTypeRoomListAdaptor::ListRoomsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Request the list of rooms from the server. The ListingRooms (True) 
     * signal should be emitted when this request is being processed, GotRooms 
     * when any room information is received, and ListingRooms (False) when 
     * the request is complete.
     *
     */
    void ListRooms(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c StopListing on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void stopListing(const Tp::Service::ChannelTypeRoomListAdaptor::StopListingContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Stop the room listing if it&apos;s in progress, but don&apos;t close 
     * the channel. The ListingRooms (False) signal should be emitted when the 
     * listing stops.
     *
     */
    void StopListing(const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c GotRooms on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void gotRooms(const Tp::RoomInfoList& rooms);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param rooms
     *     
     *     \htmlonly
     *     An array of structs containing:
     *     <ul>
     *       <li>an integer room handle</li>
     *       <li>a string representing the D-Bus interface name of the channel type</li>
     *       <li>a dictionary mapping string keys to variant boxed information</li>
     *     </ul>
     *     \endhtmlonly
     */
    void GotRooms(const Tp::RoomInfoList& rooms);
    /**
     * Represents the exported D-Bus signal \c ListingRooms on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void listingRooms(bool listing);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param listing
     *     
     *     A boolean indicating if room listing is in progress
     */
    void ListingRooms(bool listing);
};

/**
 * \class ChannelTypeServerAuthenticationAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.ServerAuthentication".
 */
class TP_QT_EXPORT ChannelTypeServerAuthenticationAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Type.ServerAuthentication")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Type.ServerAuthentication\">\n"
"    <property access=\"read\" type=\"s\" name=\"AuthenticationMethod\"/>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QString AuthenticationMethod READ AuthenticationMethod )

public:
    ChannelTypeServerAuthenticationAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelTypeServerAuthenticationAdaptor();


public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c AuthenticationMethod of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'authenticationMethod' with type QString.
     *
     * 
     * \htmlonly
     * <p>This property defines the method used for the authentication step
     *   represented by this channel, which MUST be one of this channel's
     *    \endhtmlonly \link ChannelInterface::requestPropertyInterfaces() ChannelInterface::Interfaces \endlink \htmlonly .</p>
     * 
     * <p>The initially-defined interface that can be used here is
     *    \endhtmlonly ChannelInterfaceSASLAuthenticationInterface \htmlonly .</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c AuthenticationMethod.
     */
    QString AuthenticationMethod() const;
};

/**
 * \class ChannelTypeServerTLSConnectionAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.ServerTLSConnection".
 */
class TP_QT_EXPORT ChannelTypeServerTLSConnectionAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Type.ServerTLSConnection")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Type.ServerTLSConnection\">\n"
"    <property access=\"read\" type=\"o\" name=\"ServerCertificate\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"Hostname\"/>\n"
"    <property access=\"read\" type=\"as\" name=\"ReferenceIdentities\"/>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QDBusObjectPath ServerCertificate READ ServerCertificate )
    Q_PROPERTY(QString Hostname READ Hostname )
    Q_PROPERTY(QStringList ReferenceIdentities READ ReferenceIdentities )

public:
    ChannelTypeServerTLSConnectionAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelTypeServerTLSConnectionAdaptor();


public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c ServerCertificate of type \c QDBusObjectPath.
     *
     * Adaptees should export this property as a Qt property named
     * 'serverCertificate' with type QDBusObjectPath.
     *
     * 
     * A TLSCertificate containing the certificate chain as sent by the 
     * server, and other relevant information.
     *
     * \return The value of exported property \c ServerCertificate.
     */
    QDBusObjectPath ServerCertificate() const;
    /**
     * Return the value of the exported D-Bus object property \c Hostname of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'hostname' with type QString.
     *
     * 
     * The hostname or domain that the user expects to connect to. Clients 
     * SHOULD use the ReferenceIdentities property to verify the identity of 
     * the certificate. Clients MAY display this hostname to the user as the 
     * expected identity. Clients SHOULD use this property to lookup pinned 
     * certificates or other user preferences for the connection.
     *
     * \return The value of exported property \c Hostname.
     */
    QString Hostname() const;
    /**
     * Return the value of the exported D-Bus object property \c ReferenceIdentities of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'referenceIdentities' with type QStringList.
     *
     * 
     * The identities of the server we expect ServerCertificate to certify; 
     * clients SHOULD verify that ServerCertificate matches one of these 
     * identities when checking its validity. This property MUST NOT be the 
     * empty list; it MUST contain the value of the Hostname property. All 
     * other identities included in this property MUST be derived from 
     * explicit user input or choices, such as Parameters passed to 
     * RequestConnection. The primary use for this property is for XMPP 
     * services hosted by Google Apps. When connecting to Google Talk using an 
     * @gmail.com JID, the server correctly presents a certificate for 
     * gmail.com; however, for domains hosted via Google Apps, a certificate 
     * for talk.google.com is offered, due to unresolved technical 
     * limitations. If the user has explicitly chosen to create a Google Talk 
     * account, then trusting a certificate for talk.google.com is reasonable. 
     * To handle this case, the connection manager may add the values of any 
     * or all of the server, fallback-server and extra-identities parameters; 
     * the Google Talk account creation user interface may set these 
     * parameters appropriately, or the user may set them for accounts with 
     * other services.
     *
     * \return The value of exported property \c ReferenceIdentities.
     */
    QStringList ReferenceIdentities() const;
};

/**
 * \class ChannelTypeStreamTubeAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.StreamTube".
 */
class TP_QT_EXPORT ChannelTypeStreamTubeAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Type.StreamTube")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Type.StreamTube\">\n"
"    <property access=\"read\" type=\"s\" name=\"Service\"/>\n"
"    <property access=\"read\" type=\"a{uau}\" name=\"SupportedSocketTypes\">\n"
"      <annotation value=\"Tp::SupportedSocketMap\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <method name=\"Offer\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"addresstype\"/>\n"
"      <arg direction=\"in\" type=\"v\" name=\"address\"/>\n"
"      <arg direction=\"in\" type=\"u\" name=\"accesscontrol\"/>\n"
"      <arg direction=\"in\" type=\"a{sv}\" name=\"parameters\">\n"
"        <annotation value=\"QVariantMap\" name=\"com.trolltech.QtDBus.QtTypeName.In3\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"Accept\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"addresstype\"/>\n"
"      <arg direction=\"in\" type=\"u\" name=\"accesscontrol\"/>\n"
"      <arg direction=\"in\" type=\"v\" name=\"accesscontrolparam\"/>\n"
"      <arg direction=\"out\" type=\"v\" name=\"address\"/>\n"
"    </method>\n"
"    <signal name=\"NewRemoteConnection\">\n"
"      <arg type=\"u\" name=\"handle\"/>\n"
"      <arg type=\"v\" name=\"connectionParam\"/>\n"
"      <arg type=\"u\" name=\"connectionID\"/>\n"
"    </signal>\n"
"    <signal name=\"NewLocalConnection\">\n"
"      <arg type=\"u\" name=\"connectionID\"/>\n"
"    </signal>\n"
"    <signal name=\"ConnectionClosed\">\n"
"      <arg type=\"u\" name=\"connectionID\"/>\n"
"      <arg type=\"s\" name=\"error\"/>\n"
"      <arg type=\"s\" name=\"message\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QString Service READ Service )
    Q_PROPERTY(Tp::SupportedSocketMap SupportedSocketTypes READ SupportedSocketTypes )

public:
    ChannelTypeStreamTubeAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelTypeStreamTubeAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > OfferContextPtr;
    typedef Tp::MethodInvocationContextPtr< QDBusVariant > AcceptContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Service of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'service' with type QString.
     *
     * 
     * \htmlonly
     * <p> A string representing the service name that will be used over the
     *   tube.  It should be a well-known TCP service name as defined by
     *   <a href="http://www.iana.org/assignments/port-numbers">
     *     http://www.iana.org/assignments/port-numbers</a> or
     *   <a href="http://www.dns-sd.org/ServiceTypes.html">
     *     http://www.dns-sd.org/ServiceTypes.html</a>, for instance
     *   &quot;rsync&quot; or &quot;daap&quot;.</p>
     * <p>When the tube is offered, the service name is transmitted to the
     *   other end.</p>
     * <p>When requesting a channel with
     *    \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly ,
     *   this property MUST be included in the request.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Service.
     */
    QString Service() const;
    /**
     * Return the value of the exported D-Bus object property \c SupportedSocketTypes of type \c Tp::SupportedSocketMap.
     *
     * Adaptees should export this property as a Qt property named
     * 'supportedSocketTypes' with type Tp::SupportedSocketMap.
     *
     * 
     * \htmlonly
     * <p>A mapping from address types (members of Socket_Address_Type) to
     * arrays of access-control type (members of Socket_Access_Control)
     * that the connection manager supports for stream tubes with that
     * address type. For simplicity, if a CM supports offering a
     * particular type of tube, it is assumed to support accepting it.</p>
     * 
     * <p>A typical value for a host without IPv6 support:</p>
     * 
     * <pre>
     *   {
     *     Socket_Address_Type_IPv4:
     *       [Socket_Access_Control_Localhost, Socket_Access_Control_Port,
     *        Socket_Access_Control_Netmask],
     *     Socket_Address_Type_Unix:
     *       [Socket_Access_Control_Localhost, Socket_Access_Control_Credentials]
     *   }
     * </pre>
     * 
     * <p>Connection Managers MUST support at least IPv4 with the localhost
     *   access control.</p>
     * 
     * <p>When requesting a channel with
     *    \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly ,
     *   this property MUST NOT be included in the request.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c SupportedSocketTypes.
     */
    Tp::SupportedSocketMap SupportedSocketTypes() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c Offer on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void offer(uint addresstype, const QDBusVariant& address, uint accesscontrol, const QVariantMap& parameters, const Tp::Service::ChannelTypeStreamTubeAdaptor::OfferContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Offer a stream tube exporting the local socket specified.
     *
     * \param addresstype
     *     
     *     The type of the listening address of the local service, as a member 
     *     of Socket_Address_Type.
     * \param address
     *     
     *     The listening address of the local service, as indicated by the 
     *     address_type.
     * \param accesscontrol
     *     
     *     The access control the local service applies to the local socket, 
     *     specified so the connection manager can behave appropriately when 
     *     it connects.
     * \param parameters
     *     
     *     The dictionary of arbitrary Parameters to send with the tube offer.
     */
    void Offer(uint addresstype, const QDBusVariant& address, uint accesscontrol, const QVariantMap& parameters, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c Accept on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void accept(uint addresstype, uint accesscontrol, const QDBusVariant& accesscontrolparam, const Tp::Service::ChannelTypeStreamTubeAdaptor::AcceptContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Accept a stream tube that&apos;s in the &quot;local pending&quot; 
     * state. The connection manager will attempt to open the tube. The tube 
     * remains in the &quot;local pending&quot; state until the 
     * TubeChannelStateChanged signal is emitted.
     *
     * \param addresstype
     *     
     *     The type of address the connection manager should listen on.
     * \param accesscontrol
     *     
     *     \htmlonly
     *     <p>The type of access control the connection manager should apply to
     *     the socket.</p>
     *     
     *     <p>Note that if you plan to establish more than one connection
     *     through the tube, the Socket_Access_Control_Port access control
     *     can't be used as you can't connect more than once from the same
     *     port.</p>
     *     \endhtmlonly
     * \param accesscontrolparam
     *     
     *     A parameter for the access control type, to be interpreted as 
     *     specified in the documentation for the Socket_Access_Control enum.
     * \return
     *     
     *     The address on which the connection manager will listen for 
     *     connections to this tube. The client should not attempt to connect 
     *     to the address until the tube is open.
     */
    QDBusVariant Accept(uint addresstype, uint accesscontrol, const QDBusVariant& accesscontrolparam, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c NewRemoteConnection on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void newRemoteConnection(uint handle, const QDBusVariant& connectionParam, uint connectionID);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param handle
     *     
     *     The handle of the participant who opened the new connection
     * \param connectionParam
     *     
     *     \htmlonly
     *     <p>A parameter which can be used by the listening process to identify
     *     the connection. Note that this parameter has a meaningful value
     *     only in the Socket_Access_Control_Port and
     *     Socket_Access_Control_Credentials cases. If a different
     *     Socket_Access_Control has been chosen when offering the tube, this
     *     parameter should be ignored.</p>
     *     
     *     <p>In the Socket_Access_Control_Port case, the variant
     *     contains a struct Socket_Address_IPv4 (or Socket_Address_IPv6)
     *     containing the address from which the CM is connected to the client
     *     application.</p>
     *     
     *     <p>In the Socket_Access_Control_Credentials case, the variant
     *     contains the byte (D-Bus signature 'y') that has been sent with
     *     the credentials.</p>
     *     \endhtmlonly
     * \param connectionID
     *     
     *     The unique ID associated with this connection. This ID will be used 
     *     to identifiy the connection when reporting errors with 
     *     ConnectionClosed.
     */
    void NewRemoteConnection(uint handle, const QDBusVariant& connectionParam, uint connectionID);
    /**
     * Represents the exported D-Bus signal \c NewLocalConnection on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void newLocalConnection(uint connectionID);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param connectionID
     *     
     *     The unique ID associated with this connection. This ID will be used 
     *     to identifiy the connection when reporting errors with 
     *     ConnectionClosed.
     */
    void NewLocalConnection(uint connectionID);
    /**
     * Represents the exported D-Bus signal \c ConnectionClosed on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void connectionClosed(uint connectionID, const QString& error, const QString& message);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param connectionID
     *     
     *     The ID of the connection.
     * \param error
     *     
     *     \htmlonly
     *     <p>The name of a D-Bus error describing the error that occurred.</p>
     *     
     *     <p>The following errors can be used:</p>
     *     <ul>
     *       <li><code>org.freedesktop.Telepathy.Error.Cancelled</code>:
     *          user closed the socket or the tube.</li>
     *       <li><code>org.freedesktop.Telepathy.Error.ConnectionLost</code>:
     *          the bytestream relaying connection's data has been broken.</li>
     *       <li><code>org.freedesktop.Telepathy.Error.ConnectionRefused</code>:
     *          the tube offer refused the connection.</li>
     *     </ul>
     *     \endhtmlonly
     * \param message
     *     
     *     A debug message.
     */
    void ConnectionClosed(uint connectionID, const QString& error, const QString& message);
};

/**
 * \class ChannelTypeStreamedMediaAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.StreamedMedia".
 */
class TP_QT_EXPORT ChannelTypeStreamedMediaAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Type.StreamedMedia")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Type.StreamedMedia\">\n"
"    <property access=\"read\" type=\"b\" name=\"InitialAudio\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"InitialVideo\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"ImmutableStreams\"/>\n"
"    <method name=\"ListStreams\">\n"
"      <arg direction=\"out\" type=\"a(uuuuuu)\" name=\"streams\">\n"
"        <annotation value=\"Tp::MediaStreamInfoList\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"RemoveStreams\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"streams\"/>\n"
"    </method>\n"
"    <method name=\"RequestStreamDirection\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"streamID\"/>\n"
"      <arg direction=\"in\" type=\"u\" name=\"streamDirection\"/>\n"
"    </method>\n"
"    <method name=\"RequestStreams\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"contactHandle\"/>\n"
"      <arg direction=\"in\" type=\"au\" name=\"types\"/>\n"
"      <arg direction=\"out\" type=\"a(uuuuuu)\" name=\"streams\">\n"
"        <annotation value=\"Tp::MediaStreamInfoList\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <signal name=\"StreamAdded\">\n"
"      <arg type=\"u\" name=\"streamID\"/>\n"
"      <arg type=\"u\" name=\"contactHandle\"/>\n"
"      <arg type=\"u\" name=\"streamType\"/>\n"
"    </signal>\n"
"    <signal name=\"StreamDirectionChanged\">\n"
"      <arg type=\"u\" name=\"streamID\"/>\n"
"      <arg type=\"u\" name=\"streamDirection\"/>\n"
"      <arg type=\"u\" name=\"pendingFlags\"/>\n"
"    </signal>\n"
"    <signal name=\"StreamError\">\n"
"      <arg type=\"u\" name=\"streamID\"/>\n"
"      <arg type=\"u\" name=\"errorCode\"/>\n"
"      <arg type=\"s\" name=\"message\"/>\n"
"    </signal>\n"
"    <signal name=\"StreamRemoved\">\n"
"      <arg type=\"u\" name=\"streamID\"/>\n"
"    </signal>\n"
"    <signal name=\"StreamStateChanged\">\n"
"      <arg type=\"u\" name=\"streamID\"/>\n"
"      <arg type=\"u\" name=\"streamState\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(bool InitialAudio READ InitialAudio )
    Q_PROPERTY(bool InitialVideo READ InitialVideo )
    Q_PROPERTY(bool ImmutableStreams READ ImmutableStreams )

public:
    ChannelTypeStreamedMediaAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelTypeStreamedMediaAdaptor();

    typedef Tp::MethodInvocationContextPtr< Tp::MediaStreamInfoList > ListStreamsContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > RemoveStreamsContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > RequestStreamDirectionContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::MediaStreamInfoList > RequestStreamsContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c InitialAudio of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'initialAudio' with type bool.
     *
     * 
     * \htmlonly
     * <p>If set to true in a channel request that will create a new channel,
     *   the connection manager should immediately attempt to establish an
     *   audio stream to the remote contact, making it unnecessary for the
     *   client to call  \endhtmlonly ChannelTypeStreamedMediaInterface::RequestStreams() \htmlonly .</p>
     * 
     * <p>If this property, or InitialVideo, is passed to EnsureChannel
     *   (as opposed to CreateChannel), the connection manager SHOULD ignore
     *   these properties when checking whether it can return an existing
     *   channel as suitable; these properties only become significant when
     *   the connection manager has decided to create a new channel.</p>
     * 
     * <p>If true on a requested channel, this indicates that the audio
     *   stream has already been requested and the client does not need to
     *   call RequestStreams, although it MAY still do so.</p>
     * 
     * <p>If true on an unrequested (incoming) channel, this indicates that
     *   the remote contact initially requested an audio stream; this does
     *   not imply that that audio stream is still active (as indicated by
     *    \endhtmlonly ChannelTypeStreamedMediaInterface::ListStreams() \htmlonly ).</p>
     * 
     * <p>This property is immutable (cannot change), and therefore SHOULD
     *   appear wherever immutable properties are reported, e.g.  \endhtmlonly ConnectionInterfaceRequestsInterface::NewChannels() \htmlonly 
     *   signals.</p>
     * 
     * <div class="rationale"><p>This reduces D-Bus round trips.</p></div>
     * 
     * <p>Connection managers capable of signalling audio calls to contacts
     *   SHOULD include a channel class in  \endhtmlonly \link ConnectionInterfaceRequestsInterface::requestPropertyRequestableChannelClasses() ConnectionInterfaceRequestsInterface::RequestableChannelClasses \endlink \htmlonly 
     *   with  \endhtmlonly \link ChannelInterface::requestPropertyChannelType() ChannelInterface::ChannelType \endlink \htmlonly 
     *   =  \endhtmlonly ChannelTypeStreamedMediaInterface \htmlonly 
     *   and  \endhtmlonly \link ChannelInterface::requestPropertyTargetHandleType() ChannelInterface::TargetHandleType \endlink \htmlonly 
     *   = Contact in the fixed properties dictionary, and InitialAudio
     *   (and also InitialVideo, if applicable) in the allowed properties
     *   list. Clients wishing to discover whether a connection manager
     *   can signal audio and/or video calls SHOULD use this information.</p>
     * 
     * <div class="rationale">
     *   <p>Not all protocols support signalling video calls, and it would be
     *     possible (although unlikely) to have a protocol where only video,
     *     and not audio, could be signalled.</p>
     * </div>
     * 
     * <p>Connection managers that support the  \endhtmlonly ConnectionInterfaceContactCapabilitiesInterface \htmlonly 
     *   interface SHOULD represent the capabilities of receiving audio
     *   and/or video calls by including a channel class in
     *   a contact's capabilities with ChannelType = StreamedMedia
     *   in the fixed properties dictionary, and InitialAudio and/or
     *   InitialVideo in the allowed properties list. Clients wishing to
     *   discover whether a particular contact is likely to be able to
     *   receive audio and/or video calls SHOULD use this information.</p>
     * 
     * <div class="rationale">
     *   <p>Not all clients support video calls, and it would also be
     *     possible (although unlikely) to have a client which could only
     *     stream video, not audio.</p>
     * </div>
     * 
     * <p>Clients that are willing to receive audio and/or video calls
     *   SHOULD include the following among their channel classes if
     *   calling  \endhtmlonly ConnectionInterfaceContactCapabilitiesInterface::UpdateCapabilities() \htmlonly 
     *   (clients of a  \endhtmlonly ChannelDispatcherInterface \htmlonly 
     *   SHOULD instead arrange for the ChannelDispatcher to do this,
     *   by including the filters in their  \endhtmlonly \link ClientHandlerInterface::requestPropertyHandlerChannelFilter() ClientHandlerInterface::HandlerChannelFilter \endlink \htmlonly 
     *   properties):</p>
     * 
     * <ul>
     *   <li>{ ChannelType = StreamedMedia }</li>
     *   <li>{ ChannelType = StreamedMedia, InitialAudio = true }
     *     if receiving calls with audio is supported</li>
     *   <li>{ ChannelType = StreamedMedia, InitialVideo = true }
     *     if receiving calls with video is supported</li>
     * </ul>
     * 
     * <div class="rationale">
     *   <p>Connection managers for protocols with capability discovery,
     *     like XMPP, need this information to advertise the appropriate
     *     capabilities for their protocol.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c InitialAudio.
     */
    bool InitialAudio() const;
    /**
     * Return the value of the exported D-Bus object property \c InitialVideo of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'initialVideo' with type bool.
     *
     * 
     * \htmlonly
     * <p>The same as  \endhtmlonly \link requestPropertyInitialAudio() InitialAudio \endlink \htmlonly , but for
     *   a video stream. This property is immutable (cannot change).</p>
     * 
     * <p>In particular, note that if this property is false, this does not
     *   imply that an active video stream has not been added, only that no
     *   video stream was active at the time the channel appeared.</p>
     * 
     * <p>This property is the correct way to discover whether connection
     *   managers, contacts etc. support video calls; it appears in
     *   capabilities structures in the same way as InitialAudio.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c InitialVideo.
     */
    bool InitialVideo() const;
    /**
     * Return the value of the exported D-Bus object property \c ImmutableStreams of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'immutableStreams' with type bool.
     *
     * 
     * \htmlonly
     * <p>If <tt>True</tt>, once streams have been requested for this channel
     *   (either by setting  \endhtmlonly \link requestPropertyInitialAudio() InitialAudio \endlink \htmlonly  or
     *    \endhtmlonly \link requestPropertyInitialVideo() InitialVideo \endlink \htmlonly  when the channel is
     *   requested, or by calling
     *    \endhtmlonly RequestStreams() \htmlonly  on a channel with no
     *   streams), a stream of a different content type cannot be added;
     *   subsequent calls to  \endhtmlonly RequestStreams() \htmlonly 
     *   that attempt to do so will fail.</p>
     * 
     * <p>If this property is missing, clients SHOULD assume that it is false,
     *   and thus that the channel's streams can be changed once the call has
     *   started.</p>
     * 
     * <p>If this property is present in the &quot;allowed&quot; set in all of the
     *   StreamedMedia entries in a contact's capabilities, then user
     *   interfaces MAY choose to show a separate &quot;call&quot; option for each
     *   class of call.</p>
     * 
     *   <div class="rationale">
     *     <p>For example, once an audio-only Google Talk call has started,
     *       it is not possible to add a video stream; both audio and video
     *       must be requested at the start of the call if video is desired.
     *       User interfaces may use this pseudo-capability as a hint to
     *       display separate &quot;Audio call&quot; and &quot;Video call&quot; buttons, rather
     *       than a single &quot;Call&quot; button with the option to add and remove
     *       video once the call has started for contacts without this flag.
     *     </p>
     *   </div>
     * 
     * <p>This property is immutable, and therefore SHOULD be announced
     *   in  \endhtmlonly ConnectionInterfaceRequestsInterface::NewChannels() \htmlonly ,
     *   etc.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c ImmutableStreams.
     */
    bool ImmutableStreams() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c ListStreams on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void listStreams(const Tp::Service::ChannelTypeStreamedMediaAdaptor::ListStreamsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Returns an array of structs representing the streams currently active 
     * within this channel. Each stream is identified by an unsigned integer 
     * which is unique for each stream within the channel.
     *
     * \return
     *     
     *     \htmlonly
     *     An array of structs containing:
     *     <ul>
     *     <li>the stream identifier</li>
     *     <li>the contact handle who the stream is with (or 0 if the stream
     *       represents more than a single member)</li>
     *     <li>the type of the stream</li>
     *     <li>the current stream state</li>
     *     <li>the current direction of the stream</li>
     *     <li>the current pending send flags</li>
     *     </ul>
     *     \endhtmlonly
     */
    Tp::MediaStreamInfoList ListStreams(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RemoveStreams on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void removeStreams(const Tp::UIntList& streams, const Tp::Service::ChannelTypeStreamedMediaAdaptor::RemoveStreamsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request that the given streams are removed. If all streams are
     *   removed, the channel MAY close.</p>
     * 
     * <p>Clients SHOULD NOT attempt to terminate calls by removing all the
     *   streams; instead, clients SHOULD terminate calls by removing the
     *    \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertySelfHandle() ChannelInterfaceGroupInterface::SelfHandle \endlink \htmlonly 
     *   from the channel, using either
     *    \endhtmlonly ChannelInterfaceGroupInterface::RemoveMembers() \htmlonly 
     *   or
     *    \endhtmlonly ChannelInterfaceGroupInterface::RemoveMembersWithReason() \htmlonly .
     *   </p>
     * \endhtmlonly
     *
     * \param streams
     *     
     *     An array of stream identifiers (as defined in ListStreams)
     */
    void RemoveStreams(const Tp::UIntList& streams, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RequestStreamDirection on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestStreamDirection(uint streamID, uint streamDirection, const Tp::Service::ChannelTypeStreamedMediaAdaptor::RequestStreamDirectionContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request a change in the direction of an existing stream. In particular,
     * this might be useful to stop sending media of a particular type,
     * or inform the peer that you are no longer using media that is being
     * sent to you.</p>
     * 
     * <p>Depending on the protocol, streams which are no longer sending in
     * either direction should be removed and a
     *  \endhtmlonly StreamRemoved() \htmlonly  signal emitted.
     * Some direction changes can be enforced locally (for example,
     * BIDIRECTIONAL -&gt; RECEIVE can be achieved by merely stopping sending),
     * others may not be possible on some protocols, and some need agreement
     * from the remote end. In this case, the MEDIA_STREAM_PENDING_REMOTE_SEND
     * flag will be set in the
     *  \endhtmlonly StreamDirectionChanged() \htmlonly  signal, and the
     * signal
     * emitted again without the flag to indicate the resulting direction when
     * the remote end has accepted or rejected the change.</p>
     * \endhtmlonly
     *
     * \param streamID
     *     
     *     The stream identifier (as defined in ListStreams)
     * \param streamDirection
     *     
     *     The desired stream direction (a value of MediaStreamDirection)
     */
    void RequestStreamDirection(uint streamID, uint streamDirection, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RequestStreams on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestStreams(uint contactHandle, const Tp::UIntList& types, const Tp::Service::ChannelTypeStreamedMediaAdaptor::RequestStreamsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request that streams be established to exchange the given types of
     * media with the given member. In general this will try and establish a
     * bidirectional stream, but on some protocols it may not be possible to
     * indicate to the peer that you would like to receive media, so a
     * send-only stream will be created initially. In the cases where the
     * stream requires remote agreement (eg you wish to receive media from
     * them), the  \endhtmlonly StreamDirectionChanged() \htmlonly  signal
     * will be emitted with the
     * MEDIA_STREAM_PENDING_REMOTE_SEND flag set, and the signal emitted again
     * with the flag cleared when the remote end has replied.</p>
     * 
     * <p>If streams of the requested types already exist, calling this
     *   method results in the creation of additional streams. Accordingly,
     *   clients wishing to have exactly one audio stream or exactly one
     *   video stream SHOULD check for the current streams using
     *    \endhtmlonly ListStreams() \htmlonly  before calling this
     *   method.</p>
     * \endhtmlonly
     *
     * \param contactHandle
     *     
     *     A contact handle with whom to establish the streams
     * \param types
     *     
     *     An array of stream types (values of MediaStreamType)
     * \return
     *     
     *     \htmlonly
     *     An array of structs (in the same order as the given stream types)
     *     containing:
     *     <ul>
     *       <li>the stream identifier</li>
     *       <li>the contact handle who the stream is with (or 0 if the stream
     *         represents more than a single member)</li>
     *       <li>the type of the stream</li>
     *       <li>the current stream state</li>
     *       <li>the current direction of the stream</li>
     *       <li>the current pending send flags</li>
     *     </ul>
     *     \endhtmlonly
     */
    Tp::MediaStreamInfoList RequestStreams(uint contactHandle, const Tp::UIntList& types, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c StreamAdded on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void streamAdded(uint streamID, uint contactHandle, uint streamType);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param streamID
     *     
     *     The stream identifier (as defined in ListStreams)
     * \param contactHandle
     *     
     *     The contact handle who the stream is with (or 0 if it represents 
     *     more than a single member)
     * \param streamType
     *     
     *     The stream type (a value from MediaStreamType)
     */
    void StreamAdded(uint streamID, uint contactHandle, uint streamType);
    /**
     * Represents the exported D-Bus signal \c StreamDirectionChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void streamDirectionChanged(uint streamID, uint streamDirection, uint pendingFlags);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param streamID
     *     
     *     The stream identifier (as defined in ListStreams)
     * \param streamDirection
     *     
     *     The new stream direction (as defined in ListStreams)
     * \param pendingFlags
     *     
     *     The new pending send flags (as defined in ListStreams)
     */
    void StreamDirectionChanged(uint streamID, uint streamDirection, uint pendingFlags);
    /**
     * Represents the exported D-Bus signal \c StreamError on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void streamError(uint streamID, uint errorCode, const QString& message);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param streamID
     *     
     *     The stream identifier (as defined in ListStreams)
     * \param errorCode
     *     
     *     A stream error number, one of the values of MediaStreamError
     * \param message
     *     
     *     A string describing the error (for debugging purposes only)
     */
    void StreamError(uint streamID, uint errorCode, const QString& message);
    /**
     * Represents the exported D-Bus signal \c StreamRemoved on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void streamRemoved(uint streamID);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param streamID
     *     
     *     stream_id - the stream identifier (as defined in ListStreams)
     */
    void StreamRemoved(uint streamID);
    /**
     * Represents the exported D-Bus signal \c StreamStateChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void streamStateChanged(uint streamID, uint streamState);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param streamID
     *     
     *     The stream identifier (as defined in ListStreams)
     * \param streamState
     *     
     *     The new stream state (as defined in ListStreams)
     */
    void StreamStateChanged(uint streamID, uint streamState);
};

/**
 * \class ChannelTypeTextAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.Text".
 */
class TP_QT_EXPORT ChannelTypeTextAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Type.Text")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Type.Text\">\n"
"    <method name=\"AcknowledgePendingMessages\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"IDs\"/>\n"
"    </method>\n"
"    <method name=\"GetMessageTypes\">\n"
"      <arg direction=\"out\" type=\"au\" name=\"availableTypes\"/>\n"
"    </method>\n"
"    <method name=\"ListPendingMessages\">\n"
"      <arg direction=\"in\" type=\"b\" name=\"clear\"/>\n"
"      <arg direction=\"out\" type=\"a(uuuuus)\" name=\"pendingMessages\">\n"
"        <annotation value=\"Tp::PendingTextMessageList\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"Send\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"type\"/>\n"
"      <arg direction=\"in\" type=\"s\" name=\"text\"/>\n"
"    </method>\n"
"    <signal name=\"LostMessage\"/>\n"
"    <signal name=\"Received\">\n"
"      <arg type=\"u\" name=\"ID\"/>\n"
"      <arg type=\"u\" name=\"timestamp\"/>\n"
"      <arg type=\"u\" name=\"sender\"/>\n"
"      <arg type=\"u\" name=\"type\"/>\n"
"      <arg type=\"u\" name=\"flags\"/>\n"
"      <arg type=\"s\" name=\"text\"/>\n"
"    </signal>\n"
"    <signal name=\"SendError\">\n"
"      <arg type=\"u\" name=\"error\"/>\n"
"      <arg type=\"u\" name=\"timestamp\"/>\n"
"      <arg type=\"u\" name=\"type\"/>\n"
"      <arg type=\"s\" name=\"text\"/>\n"
"    </signal>\n"
"    <signal name=\"Sent\">\n"
"      <arg type=\"u\" name=\"timestamp\"/>\n"
"      <arg type=\"u\" name=\"type\"/>\n"
"      <arg type=\"s\" name=\"text\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")

public:
    ChannelTypeTextAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelTypeTextAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > AcknowledgePendingMessagesContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::UIntList > GetMessageTypesContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::PendingTextMessageList > ListPendingMessagesContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > SendContextPtr;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c AcknowledgePendingMessages on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void acknowledgePendingMessages(const Tp::UIntList& IDs, const Tp::Service::ChannelTypeTextAdaptor::AcknowledgePendingMessagesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Inform the channel that you have handled messages by displaying them to 
     * the user (or equivalent), so they can be removed from the pending queue.
     *
     * \param IDs
     *     
     *     The IDs of the messages to acknowledge
     */
    void AcknowledgePendingMessages(const Tp::UIntList& IDs, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetMessageTypes on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getMessageTypes(const Tp::Service::ChannelTypeTextAdaptor::GetMessageTypesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Return an array indicating which types of message may be sent on this 
     * channel.
     *
     * \return
     *     
     *     An array of integer message types (ChannelTextMessageType)
     */
    Tp::UIntList GetMessageTypes(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c ListPendingMessages on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void listPendingMessages(bool clear, const Tp::Service::ChannelTypeTextAdaptor::ListPendingMessagesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * List the messages currently in the pending queue, and optionally remove 
     * then all.
     *
     * \param clear
     *     
     *     If true, behave as if AcknowledgePendingMessages had also been 
     *     called.
     * \return
     *     
     *     \htmlonly
     *     An array of structs representing the pending queue. Each contains:
     *     <ul>
     *       <li>a numeric identifier</li>
     *       <li>a Unix timestamp indicating when the message was received</li>
     *       <li>the contact handle for the contact who sent the message</li>
     *       <li>the message type, taken from ChannelTextMessageType</li>
     *       <li>the bitwise-OR of the message flags from ChannelTextMessageFlags</li>
     *       <li>the text of the message</li>
     *     </ul>
     *     \endhtmlonly
     */
    Tp::PendingTextMessageList ListPendingMessages(bool clear, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c Send on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void send(uint type, const QString& text, const Tp::Service::ChannelTypeTextAdaptor::SendContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request that a message be sent on this channel. When the message has
     *   been submitted for delivery, this method will return and the
     *    \endhtmlonly Sent() \htmlonly  signal will be emitted. If the
     *   message cannot be submitted for delivery, the method returns an error
     *   and no signal is emitted.</p>
     * 
     * <p>This method SHOULD return before the Sent signal is
     *   emitted.</p>
     * 
     * <div class="rationale">
     *   <p>When a Text channel implements the  \endhtmlonly ChannelInterfaceMessagesInterface \htmlonly 
     *     interface, that &quot;SHOULD&quot; becomes a &quot;MUST&quot;.</p>
     * </div>
     * \endhtmlonly
     *
     * \param type
     *     
     *     An integer indicating the type of the message
     * \param text
     *     
     *     The message to send
     */
    void Send(uint type, const QString& text, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c LostMessage on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void lostMessage();
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     */
    void LostMessage();
    /**
     * Represents the exported D-Bus signal \c Received on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void received(uint ID, uint timestamp, uint sender, uint type, uint flags, const QString& text);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param ID
     *     
     *     A numeric identifier for acknowledging the message
     * \param timestamp
     *     
     *     A Unix timestamp indicating when the message was received
     * \param sender
     *     
     *     The handle of the contact who sent the message
     * \param type
     *     
     *     The type of the message (normal, action, notice, etc.)
     * \param flags
     *     
     *     A bitwise OR of the message flags
     * \param text
     *     
     *     The text of the message
     */
    void Received(uint ID, uint timestamp, uint sender, uint type, uint flags, const QString& text);
    /**
     * Represents the exported D-Bus signal \c SendError on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void sendError(uint error, uint timestamp, uint type, const QString& text);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param error
     *     
     *     The error that occurred
     * \param timestamp
     *     
     *     The Unix timestamp indicating when the message was sent
     * \param type
     *     
     *     The message type
     * \param text
     *     
     *     The text of the message
     */
    void SendError(uint error, uint timestamp, uint type, const QString& text);
    /**
     * Represents the exported D-Bus signal \c Sent on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void sent(uint timestamp, uint type, const QString& text);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param timestamp
     *     
     *     Unix timestamp indicating when the message was sent
     * \param type
     *     
     *     The message type (normal, action, notice, etc) from 
     *     ChannelTextMessageType
     * \param text
     *     
     *     The text of the message. If the message was, or will be, altered 
     *     during transmission, this argument SHOULD reflect what other 
     *     contacts will receive rather than being a copy of the argument to 
     *     Send.
     */
    void Sent(uint timestamp, uint type, const QString& text);
};

}
}