/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public abstract class ByteToCharDoubleByte
extends ByteToCharConverter {
    protected byte savedByte = 0;
    protected short[] index1;
    protected String[] index2;
    protected int start;
    protected int end;
    protected int badInputLength;
    protected static final char REPLACE_CHAR = '\ufffd';

    public short[] getIndex1() {
        return this.index1;
    }

    public String[] getIndex2() {
        return this.index2;
    }

    public int flush(char[] output, int outStart, int outEnd) throws MalformedInputException {
        if (this.savedByte != 0) {
            this.reset();
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.reset();
        return 0;
    }

    public int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int outputChar = 65533;
        int inputSize = 0;
        this.charOff = outOff;
        this.byteOff = inOff;
        while (this.byteOff < inEnd) {
            int byte1;
            if (this.savedByte == 0) {
                byte1 = input[this.byteOff];
                inputSize = 1;
            } else {
                byte1 = this.savedByte;
                this.savedByte = 0;
                inputSize = 0;
            }
            outputChar = this.convSingleByte(byte1);
            if (outputChar == 65533) {
                if (this.byteOff + inputSize >= inEnd) {
                    this.savedByte = (byte)byte1;
                    this.byteOff += inputSize;
                    break;
                }
                int byte2 = input[this.byteOff + inputSize] & 0xFF;
                ++inputSize;
                outputChar = this.getUnicode(byte1 &= 0xFF, byte2);
            }
            if (outputChar == 65533) {
                if (this.subMode) {
                    outputChar = this.subChars[0];
                } else {
                    this.badInputLength = inputSize;
                    throw new UnknownCharacterException();
                }
            }
            if (this.charOff >= outEnd) {
                throw new ConversionBufferFullException();
            }
            output[this.charOff++] = outputChar;
            this.byteOff += inputSize;
        }
        return this.charOff - outOff;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.savedByte = 0;
    }

    protected char convSingleByte(int b) {
        if (b >= 0) {
            return (char)b;
        }
        return '\ufffd';
    }

    protected char getUnicode(int byte1, int byte2) {
        if (byte1 < 0 || byte1 > this.index1.length || byte2 < this.start || byte2 > this.end) {
            return '\ufffd';
        }
        int n = (this.index1[byte1] & 0xF) * (this.end - this.start + 1) + (byte2 - this.start);
        return this.index2[this.index1[byte1] >> 4].charAt(n);
    }
}

