% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-insert.R
\name{dbAppendTable}
\alias{dbAppendTable}
\title{Insert rows into a table}
\usage{
dbAppendTable(conn, name, value, ..., row.names = NULL)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{Name of the table, escaped with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.}

\item{value}{A data frame of values. The column names must be consistent
with those in the target table in the database.}

\item{...}{Other arguments used by individual methods.}

\item{row.names}{Must be \code{NULL}.}
}
\description{
The \code{dbAppendTable()} method assumes that the table has been created
beforehand, e.g. with \code{\link[=dbCreateTable]{dbCreateTable()}}.
The default implementation calls \code{\link[=sqlAppendTableTemplate]{sqlAppendTableTemplate()}} and then
\code{\link[=dbExecute]{dbExecute()}} with the \code{param} argument. Backends compliant to
ANSI SQL 99 which use \code{?} as a placeholder for prepard queries don't need
to override it. Backends with a different SQL syntax which use \code{?}
as a placeholder for prepared queries can override \code{\link[=sqlAppendTable]{sqlAppendTable()}}.
Other backends (with different placeholders or with entirely different
ways to create tables) need to override the \code{dbAppendTable()} method.
}
\details{
The \code{row.names} argument is not supported by this method.
Process the values with \code{\link[=sqlRownamesToColumn]{sqlRownamesToColumn()}} before calling this method.
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")
dbCreateTable(con, "iris", iris)
dbAppendTable(con, "iris", iris)
dbReadTable(con, "iris")
dbDisconnect(con)
}
\seealso{
Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbCreateTable}}, \code{\link{dbDataType}},
  \code{\link{dbDisconnect}}, \code{\link{dbExecute}},
  \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsReadOnly}},
  \code{\link{dbIsValid}}, \code{\link{dbListFields}},
  \code{\link{dbListObjects}}, \code{\link{dbListResults}},
  \code{\link{dbListTables}}, \code{\link{dbReadTable}},
  \code{\link{dbRemoveTable}}, \code{\link{dbSendQuery}},
  \code{\link{dbSendStatement}}, \code{\link{dbWriteTable}}
}
\concept{DBIConnection generics}
