#!/bin/sh
make

if test q$TAPE = q ; then export TAPE=/dev/nst0 ; fi
case $TAPE in
/dev/nst0|/dev/st0) V=`scsi_vendor tape 1` ;;
/dev/nst1|/dev/st1) V=`scsi_vendor tape 2` ;;
esac

echo Tape vendor is $V
echo =======================

case $V in
HP) B=32 ;;
*) B=32 ;;
esac

X="--exclude=index*"

echo $B
echo $X

#===================1==========================================================
echo 'dds2tar-test  1>' make
make

#===================2==========================================================
echo ' '
echo 'dds2tar-test  2>' 'make of?'
if test ! -x ./dds2tar ; then exit 1 ; fi

#===================3==========================================================
echo ' '
echo 'dds2tar-test  3>' creating soft links
ln -sf ./dds2tar ./dds2index
ln -sf ./dds2tar ./mt-dds

#===================4==========================================================
echo ' '
echo 'dds2tar-test  4>' creating soft and hard links
ln -s dds2tar dds2tar-test-tape-link-soft
ln dds2tar dds2tar-test-tape-link-hard

#===================5==========================================================
echo ' '
echo 'dds2tar-test  5>' tar c .
tar c $X .

#===================6==========================================================
echo ' '
echo 'dds2tar-test  6>' tar -c --label dds2tar -b $B ... .
tar --label dds2tar --record-file index-of-tar $X -R -v -c -b $B .

I=`grep 'number of the file' index-of-tar | cut -c 38-43`
if test q"$I" = q ; then I=1 ; fi 
if test $I = 0 ; then exit 1 ; fi
I=`expr $I - 1`
echo file number of the archive written is $I
if test "$I" = "" ; then exit 1 ; fi

#===================7==========================================================
echo ' '
echo 'dds2tar-test  7>' tar -c . ...
tar --record-file index-of-tar-v -v -R -v -c -b $B $X .

#===================8==========================================================
echo ' '
echo 'dds2tar-test  8>' mt rewind \; mt fsf $I
mt rewind ; mt fsf $I

#===================9==========================================================
echo ' '
echo 'dds2tar-test  9>' mt-dds tell
./mt-dds tell

#==================10==========================================================
echo ' '
echo 'dds2tar-test 10>' mt-dds label
./mt-dds label

#==================11==========================================================
echo ' '
echo 'dds2tar-test 11>' mt-dds
./mt-dds

#==================12==========================================================
echo ' '
echo 'dds2tar-test 12>' dds2index
./dds2index -t index-of-dds2index

#==================13==========================================================
echo ' '
echo 'dds2tar-test 13>' find '*tape*' using index-of-tar
./dds2tar -t index-of-tar '*tape*' | tar fvt -

#==================14==========================================================
echo ' '
echo 'dds2tar-test 14>' find '*tape*' using index-of-tar-v
./dds2tar -t index-of-tar-v '*tape*' | tar fvt -

#==================15==========================================================
echo ' '
echo 'dds2tar-test 15>' find '*tape*' using index-of-dds2index
./dds2tar -t index-of-dds2index '*tape*' | tar vft -

#==================16==========================================================
echo ' '
echo 'dds2tar-test 16>' dds2tar -t index-of-tar --body Changes '|wc -c'
./dds2tar -t index-of-tar --body Changes | wc -c
ls -l Changes

#==================17==========================================================
echo 'dds2tar-test 17>' mt rewind \; mt fsf $I
mt rewind ; mt fsf $I

#==================18==========================================================
echo ' '
echo 'dds2tar-test 18>mt-dds'
mt-dds

#==================19==========================================================
echo ' '
echo 'dds2tar-test 19> mt-dds tell >'index-of-tar-t
mt-dds tell >index-of-tar-t

#==================20==========================================================
echo ' '
echo 'dds2tar-test 20> tar tR >>' index-of-tar-t
tar tR >> index-of-tar-t

#==================21==========================================================
echo ' '
echo 'dds2tar-test 21>' grep -v "'loc        '" '< index-of-tar-t > index-of-tar-t2'
grep -v 'loc        ' < index-of-tar-t > index-of-tar-t2

#==================22==========================================================
echo 'dds2tar-test 22>' mt rewind \; mt fsf $I
mt rewind ; mt fsf $I

#==================23==========================================================
echo 'dds2tar-test 23>' find '*tape*' using index-of-tar-t2 and mt-dds
echo 'dda2tar-test 23>' ./dds2tar '`mt-dds`' -t index-of-tar-t2 "'*tape*' | tar bvft 1 -"
./dds2tar `mt-dds` -v -t index-of-tar-t2 '*tape*' | tar bvft 1 -

#==================24==========================================================
echo 'dds2tar-test 24>' mt rewind \; mt fsf $I
mt rewind ; mt fsf $I

#==================25==========================================================
echo 'dds2tar-test 25>' removing links
/bin/rm dds2tar-test-tape-link-soft
/bin/rm dds2tar-test-tape-link-hard

