#include <stdio.h>
#include "dds2tar.h"
int dds_unquote(char*p){
	char *q ;

	/* do nothing if there is no quote */
	while ( *p && *p != '\\' ) p++ ;
	if ( *p == '\0' ) return 1 ;

	q = p ;
	while ( *p ){
		if ( *p == '\\' ) {
			char c = p[1] ;
			switch (c){
				case '\\' : *q++ = '\\'   , p+=2 ; continue ;
				case 't'  : *q++ = '\t'   , p+=2 ; continue ;
				case 'n'  : *q++ = '\n'   , p+=2 ; continue ;
				case 'f'  : *q++ = '\f'   , p+=2 ; continue ;
				case 'b'  : *q++ = '\b'   , p+=2 ; continue ;
				case 'r'  : *q++ = '\r'   , p+=2 ; continue ;
				case '?'  : *q++ = '\177' , p+=2 ; continue ;
			}
			if ( '0' <= c && c <= '9' ){
				int x = 0 ;
				int n = 0 ;
				sscanf(p+1,"%03o%n",&x,&n);
				*q++ = x ; p+=n+1 ; continue ;
			}
			/*
			 * Here we should never be, but if, we just proceed.
			 */
		}
		*q++ = *p++ ;
	}
	*q++ = '\0' ;
	return 1 ;
}

#ifdef TEST_IT
int main(int argc,char*argv[]){
	if ( argc < 2 ) return 0 ;
	dds_unquote(argv[1]);
	puts(argv[1]);
	return 0 ;
}
#endif

