/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

using GLib;

namespace DejaDup {

public abstract class ConfigLocationTable : Hdy.PreferencesGroup
{
  public FilteredSettings settings {get; construct;}

  protected void add_widget(string msg, Gtk.Widget w,
                            ConfigBool? check = null,
                            Gtk.Widget? mnemonic = null)
  {
    var row = new Hdy.ActionRow();
    row.title = msg;
    row.use_underline = true;
    row.activatable_widget = w;
    row.add_action(w);

    this.add(row);

    w.valign = Gtk.Align.CENTER;

    if (check != null) {
      row.sensitive = check.get_active();
      check.toggled.connect(() => {
        row.sensitive = check.get_active();
      });
    }
  }

  protected void add_wide_widget(Gtk.Widget w, ConfigBool? check = null)
  {
    var row = new Gtk.ListBoxRow();
    w.hexpand = true;
    row.add(w);

    this.add(row);

    w.valign = Gtk.Align.CENTER;

    if (check != null) {
      row.sensitive = check.get_active();
      check.toggled.connect(() => {
        row.sensitive = check.get_active();
      });
    }
  }
}

}
