/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/extensions/instrumentation/load_symbol.hpp
 *
 * $Id: configuration.hpp,v 1.10 2005/06/23 09:54:18 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: alpha] 
 *
 * @todo document
 *
 * @todo add compile switching of this feature
 *
 * @todo add configuration for dlcfn
 */
#ifndef DIAGNOSTICS__EXTENSIONS__INSTRUMENTATION__LOAD_SYMBOL_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__EXTENSIONS__INSTRUMENTATION__LOAD_SYMBOL_HPP__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>


DIAGNOSTICS_NAMESPACE_BEGIN;
INTERNAL_NAMESPACE_BEGIN;

/**
 * @brief loads and returns the symbol with name @a sym_name from
 * library @a lib_name.
 *
 * @attention If an error occurs during loading (e.g., the library @a
 * lib_name does not exist or does not contain a symbol of name @a
 * sym_name), a log message is sent to the ordinary log-stream and to
 * the panic log. Then exit(1) will be called.
 *
 * Log messages are generated on calling this method.
 * 
 * @throw never
 */ 
void * load_symbol(char const * const lib_name,
				   char const * const sym_name);

INTERNAL_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif
