/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/run_test_suite_traversal.hpp
 *
 * @brief [LEVEL: beta] @ref
 * diagnostics::unittest::Run_Test_Suite_Traversal class
 *
 * $Id: run_test_suite_traversal.hpp,v 1.11 2005/06/23 09:54:26 esdentem Exp $
 * 
 * @author Christian Schallhart
 *
 * @todo none
 *
 * @todo test 
 */
#ifndef DIAGNOSTICS__UNITTEST__TEST_SYSTEM__RUN_TEST_SUITE_TRAVERSAL_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UNITTEST__TEST_SYSTEM__RUN_TEST_SUITE_TRAVERSAL_HPP__INCLUDE_GUARD

#include <diagnostics/unittest/test_system/test_suite_traversal.hpp>


DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

// used in the interface by reference
class Test_Data;

// diagnostics/unittest/test_system/test_run_result.hpp
// used in the interface by reference
class Test_Run_Result;

// used in the interface by reference
// diagnostics/unittest/test_system/test_logger.hpp
class Test_Logger;


/**
 * @class Run_Test_Suite_Traversal
 *
 * @brief The Run_Test_Suite_Traversal executes each @ref Test_Case
 * which is mateched by traverse method of @ref
 * Test_Suite_Traversal. The @ref Test_Data, the build level and the
 * @ref Test_Run_Result of the exeucting traversal are given to the
 * traversal at construction time.
 *
 * @attention While the interface of the Run_Test_Suite_Traversal is
 * quite simple, it has to set up the test harness which is quite
 * complicated. To do so, it has to be a long distance friend of @ref
 * diagnostics::unittest::internal::Current_Test_Logger. 
 *
 * @nosubgrouping
 */
class Run_Test_Suite_Traversal :
    public Test_Suite_Traversal
{
    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Types
     * @{
     */
private:
    typedef Test_Suite_Traversal Super;
	typedef Run_Test_Suite_Traversal Self;
public:
    typedef ::std::vector<Test_Run_Result*> Test_Run_Results_t;
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Creagtion
     * @{
     */
public:
    virtual ~Run_Test_Suite_Traversal();
    Run_Test_Suite_Traversal(Level_t const build_level,
			     Test_Data & test_data,
			     Test_Run_Results_t & results);
private:
	/**
	 * @brief not available 
	 */
	Self & operator=(Self const & other);
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Hook Interface of Test_Suite_Traversal
     * @{
     */
protected:
    virtual void visit_hook(Test_Case const & test_case,
			    Path_t const & path,
			    Level_t const level);
    //@}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Encapsulated State
     * @{
     */
private:
    Level_t const m_build_level;
    Test_Data & m_test_data;
    Test_Run_Results_t & m_results;
    // @}
};


UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
