/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/dummy_values_for_tid_pid.ts.hpp
 *
 * $Id: dummy_values_for_tid_pid.ts.hpp,v 1.4 2005/06/23 09:54:30 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief Defines @ref
 * ::diagnostics::testing::Dummy_Values_For_Tid and @ref
 * ::diagnostics::testing::Dummy_Values_For_Pid. Both
 * classes define three dummy values for testing. This construction
 * became necessary, since some platforms use integers while others
 * use pointers for Tids. I added Pids since I want to handle them
 * symmetrically to Tids.
 *
 * @note DOCUMENTED
 *
 * @test
 *
 * @todo
 */


#ifndef DIAGNOSTICS__SOURCE__UTIL__DUMMY_VALUES_FOR_TID_PID_TS_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__SOURCE__UTIL__DUMMY_VALUES_FOR_TID_PID_TS_HPP__INCLUDE_GUARD

#include <diagnostics/unittest.hpp>
#include <diagnostics/frame/platform.hpp>


DIAGNOSTICS_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

#if DIAGNOSTICS_SWITCH_SYSTEM_CALLS_ENABLED == 1

INTERNAL_NAMESPACE_BEGIN;

template<typename T> struct Is_Pointer { enum { value=0 };};
template<typename T> struct Is_Pointer<T*> { enum { value=1 };};

template<bool sw, typename A, typename B> struct If_Then_Else { typedef A Type_t; };
template<typename A, typename B> struct If_Then_Else<false,A,B> { typedef B Type_t; };

template<typename T> struct Dummy_Values_Pointer_Base
{
	static T const value1;
	static T const value2;
	static T const value3;
};


template<typename T> 
T const Dummy_Values_Pointer_Base<T>::value1=NULL;

template<typename T> 
T const Dummy_Values_Pointer_Base<T>::value2=0x00FF00FF;

template<typename T> 
T const Dummy_Values_Pointer_Base<T>::value3=0xFF00FF00;


template<typename T> struct Dummy_Values_Integer_Base
{
	static T const value1;
	static T const value2;
	static T const value3;
};


template<typename T>
T const Dummy_Values_Integer_Base<T>::value1=0;

template<typename T>
T const Dummy_Values_Integer_Base<T>::value2=10;

template<typename T>
T const Dummy_Values_Integer_Base<T>::value3=100;



template<typename T>
struct Dummy_Values
	: public If_Then_Else< Is_Pointer<T>::value, 
						   Dummy_Values_Pointer_Base<T>, 
						   Dummy_Values_Integer_Base<T> > :: Type_t
{
	static bool const is_pointer=Is_Pointer<T>::value;
};


INTERNAL_NAMESPACE_END;

/**
 * @brief Defines three memebers: value1, value2, and value3 of type
 * @ref ::diagnostics::Tid_t. They are dummy values for testing. The
 * member is_pointer is set to true, if Tid_t is a pointer and false
 * otherwise.
 */ 
typedef internal::Dummy_Values<Tid_t> Dummy_Values_For_Tid;

/**
 * @brief Defines three memebers: value1, value2, and value3 of type
 * @ref ::diagnostics::Pid_t. They are dummy values for testing. The
 * member is_pointer is set to true, if Pid_t is a pointer and false
 * otherwise.
 */
typedef internal::Dummy_Values<Pid_t> Dummy_Values_For_Pid;

#endif


TEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif
// vim:ts=4:sw=4
