PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE AlbumRoots
                            (id INTEGER PRIMARY KEY,
                            label TEXT,
                            status INTEGER NOT NULL,
                            type INTEGER NOT NULL,
                            identifier TEXT,
                            specificPath TEXT,
                            UNIQUE(identifier, specificPath));
INSERT INTO "AlbumRoots" VALUES(1,NULL,0,1,'volumeid:?uuid=800b21c2-dadc-4930-829e-a96b04ce26fa','/vivo/digikam-devel/data/testimages/a1');
INSERT INTO "AlbumRoots" VALUES(2,'a2',0,1,'volumeid:?uuid=800b21c2-dadc-4930-829e-a96b04ce26fa','/vivo/digikam-devel/data/testimages/a2');
CREATE TABLE Albums
                            (id INTEGER PRIMARY KEY,
                            albumRoot INTEGER NOT NULL,
                            relativePath TEXT NOT NULL,
                            date DATE,
                            caption TEXT,
                            collection TEXT,
                            icon INTEGER,
                            UNIQUE(albumRoot, relativePath));
INSERT INTO "Albums" VALUES(1,1,'/','2011-06-18',NULL,NULL,NULL);
INSERT INTO "Albums" VALUES(2,1,'/jpg','2011-06-27',NULL,NULL,NULL);
INSERT INTO "Albums" VALUES(3,1,'/png','2011-06-27',NULL,NULL,NULL);
INSERT INTO "Albums" VALUES(4,2,'/','2011-06-27',NULL,NULL,NULL);
INSERT INTO "Albums" VALUES(5,2,'/pgf','2011-06-27',NULL,NULL,NULL);
INSERT INTO "Albums" VALUES(6,2,'/pgf/link','2011-06-27',NULL,NULL,NULL);
CREATE TABLE Images
                            (id INTEGER PRIMARY KEY,
                            album INTEGER,
                            name TEXT NOT NULL,
                            status INTEGER NOT NULL,
                            category INTEGER NOT NULL,
                            modificationDate DATETIME,
                            fileSize INTEGER,
                            uniqueHash TEXT,
                            UNIQUE (album, name));
INSERT INTO "Images" VALUES(1,2,'foto001.jpg',1,1,'2011-06-27T22:29:38',145538,'874f072fa8186c7e555c76c139ec3223');
INSERT INTO "Images" VALUES(2,2,'foto001bw.jpg',1,1,'2011-06-27T15:36:34',105505,'62005ab09158c728652c972600f72b22');
INSERT INTO "Images" VALUES(3,3,'snap001.png',1,1,'2011-06-27T15:31:45',173933,'1b9ef89b5b08b2866196e66435436bbc');
INSERT INTO "Images" VALUES(4,3,'snap002.png',1,1,'2011-06-27T15:31:50',71056,'92f83bf9cd9d363180be2e83913b27a4');
INSERT INTO "Images" VALUES(5,4,'big-image.png',1,1,'2011-06-27T16:39:02',114493,'c528d0080c44b6cadfb5f46202f57af7');
INSERT INTO "Images" VALUES(6,4,'icc-test-farbkreis.jpg',1,1,'2011-06-27T16:20:19',75675,'723417e0715e351b1f8dfb44ca9d47a5');
INSERT INTO "Images" VALUES(7,4,'icc-test-no-profile.jpg',1,1,'2011-06-27T16:16:53',50331,'2c2fae970fe09d46a08e3bd663d0c464');
INSERT INTO "Images" VALUES(8,4,'Martian_face_viking.jpg',1,1,'2011-06-27T15:39:52',99416,'8c834a0330d63fd804d5966d2132bf1d');
INSERT INTO "Images" VALUES(9,5,'foto001q5.pgf',1,1,'2011-06-27T16:03:22',89012,'90f2915b9c26374327e8b33b1893a480');
INSERT INTO "Images" VALUES(10,6,'foto001q5.pgf',1,1,'2011-06-27T16:03:22',89012,'90f2915b9c26374327e8b33b1893a480');
INSERT INTO "Images" VALUES(11,6,'otherlink.pgf',1,1,'2011-06-27T16:03:22',89012,'90f2915b9c26374327e8b33b1893a480');
INSERT INTO "Images" VALUES(12,4,'icc-test-farbkreis_v1.png',1,1,'2011-06-27T23:06:01',107932,'49fc239f8d5cf5c4d256ae6bb098aee4');
CREATE TABLE ImageHaarMatrix
                            (imageid INTEGER PRIMARY KEY,
                            modificationDate DATETIME,
                            uniqueHash TEXT,
                            matrix BLOB);
INSERT INTO "ImageHaarMatrix" VALUES(1,'2011-06-27T22:29:38','874f072fa8186c7e555c76c139ec3223',X'000000013FD1980B99BE7C3CBF94F637049E175EBF8AFB37EBBAD1DDFFFFF9F90000041700000024FFFFFEE5FFFFFA7DFFFFFEFC0000008D00000004FFFFFF7F0000050B0000010C00000C00FFFFF97F00001880FFFFF980000002BBFFFFFF7EFFFFFFC8FFFFFF7900000B0700000A01FFFFFFF5FFFFFF8000000287FFFFFFFD0000001BFFFFFEF300000006FFFFFFFEFFFFFFE40000000DFFFFFFF9FFFFFA80FFFFFAFEFFFFFD7CFFFFFC8000000101FFFFFD7EFFFFFE80FFFFFF00000002DDFFFFFFA2FFFFFD3800000205FFFFFB500000008C00000202FFFFF652FFFFFEF400000494FFFFF700FFFFFEEDFFFFFEF8FFFFFDEEFFFFFEB70000010A00000025FFFFFEFAFFFFFB2300000203FFFFFB80FFFFFDDC0000090500000089FFFFFB7F0000000C0000028C00000148FFFFF675000004AFFFFFFF7F00000484FFFFFFF5FFFFF6FF00000009FFFFFFFFFFFFFE00FFFFFDFFFFFFFF00FFFFFF8000000109FFFFF6800000014BFFFFFEEE0000028CFFFFFFF80000008CFFFFFBF9FFFFFEE9FFFFFDF8FFFFFEF500000148FFFFFF7500000025FFFFFDDC0000010A00000009FFFFFD7E00000125FFFFFEED0000018100000205FFFFFEB7FFFFFFFCFFFFFBFC0000000C00000180FFFFFB7FFFFFF6FF00000484FFFFFDFCFFFFFFF5FFFFFB80FFFFFFFFFFFFFEFFFFFFFFFEFFFFFDFFFFFFFF80FFFFFE00FFFFFF00');
INSERT INTO "ImageHaarMatrix" VALUES(2,'2011-06-27T15:36:34','62005ab09158c728652c972600f72b22',X'000000013FD21D3D8B93A3673EFB470FF84618B0BF11434B6C3711E400000582FFFFFFDB00000024FFFFFA7D000004170000008DFFFFFFF7FFFFFEFCFFFFF97F0000050B00000C00000000040000010CFFFFFF7E00001880FFFFF980000002BBFFFFFFF5FFFFFFC8FFFFFF7900000B070000020100000A0100000287FFFFFFFEFFFFFFFDFFFFFEF30000001B00000006FFFFFFE4FFFFFFF90000000DFFFFFA80FFFFFD7CFFFFFAFEFFFFFC80FFFFFD7E00000101FFFFFE80FFFFFF00FFFFD95CFFFFDA5700001AC9000010F400001A67FFFFEE1E000016DAFFFFEDBE000019630000153BFFFFF6620000019B00000378FFFFF0B600000DFB00001C29000008E2FFFFD66D000011B4FFFFEC44000010290000103EFFFFCFB7FFFFC638FFFFDCAE00000282FFFFFFFC0000075300000EF8FFFFFEE400000248FFFFE2B4FFFFFD45FFFFEEF4FFFFFBDC00000B5A000032C0FFFFF480FFFFFBB80000010000000BFFFFFFE24AFFFFE4D300000AE1FFFFD4E600001BB0FFFFD406FFFFD29C00003659000000070000059E00000A28FFFFEA62000005C700000579FFFFE8EFFFFFE8E7000016C0FFFFEBADFFFFE889000014F90000153BFFFFFD710000010F00000B81FFFFFF80000002820000170C000005BDFFFFF43C0000058000000B87FFFFFEFFFFFFF47AFFFFF5C4FFFFF480FFFFD1E7FFFFF5A3FFFFFD4500000100');
INSERT INTO "ImageHaarMatrix" VALUES(3,'2011-06-27T15:31:45','1b9ef89b5b08b2866196e66435436bbc',X'000000013FEBEB18F7043F49BF805D854E05F935BF48E9EA67140324FFFFFFFB00000F00000001010000030000000302FFFFFE7E00000088FFFFDD00FFFFF87800000400FFFFF87F0000000F00000F8100000682FFFFF27FFFFFFFD60000007EFFFFF27EFFFFF2800000001400000108FFFFFC7FFFFFFFDFFFFFFFBD0000001FFFFFF08000000020FFFFFE7FFFFFFFFEFFFFE0800000004000000180FFFFFF00FFFFFFFFFFFFF780FFFFFFFC0000078000000380FFFFFE00FFFFFFF8FFFFFFFE00000806FFFFEF7BFFFFFBFE0000040300000005FFFFE47E0000020600000106FFFFFA80FFFFFD5D00000015FFFFF7FBFFFFFFE0FFFFFFECFFFFFEEF00001B0200000584FFFFEFFAFFFFFEFB00000682000010050000003FFFFFFDFB00000406FFFFFFFF00000380FFFFFBFBFFFFFF80FFFFFF00FFFFE08000002000FFFFDF000000078000000F80FFFFEF8000001000FFFFFE00FFFFF800FFFFFC00FFFFFBBFFFFFF9F50000078B00000705000007020000068B00001683FFFFFFFDFFFFFEFB00000200FFFFFED300000780FFFFFAFDFFFFFFF40000108000001406000001820000058B000001960000059600000783FFFFFC80FFFFFFEBFFFFFFFAFFFFFE8000000002FFFFFF7D000008000000118000000185FFFFFEEA00000100FFFFF0000000002DFFFFFEF500000880000000160000000B0000040000000005');
INSERT INTO "ImageHaarMatrix" VALUES(4,'2011-06-27T15:31:50','92f83bf9cd9d363180be2e83913b27a4',X'000000013FEA905961BAEFA13F74365D1DD7E5FFBF6B464C27F6FF7DFFFFFA80FFFFFEFE00001B0BFFFFCC80FFFFF37F00000C80FFFFEB00FFFFF9FF00001980FFFFF278FFFFE47BFFFFF4FB00000082FFFFFFFFFFFFFF7D0000060000001585FFFFE67F0000338DFFFFFA7D0000030100000D85FFFFE480FFFFE47FFFFFC8FC00000681FFFFCC7900000180FFFFFF80FFFFDD80FFFFEF0000001F00FFFFF78000003E800000038000000F8000000780FFFFFF00FFFFFC00FFFFFE000000158100001600FFFFFD7DFFFFD47DFFFFFA7BFFFFEB7AFFFFEA6AFFFFE9FF00000A82FFFFFAFD00000B0BFFFFEA7E0000168000002B8C0000008000001683FFFFFB000000028100000083FFFFFA7FFFFFF57D0000028600000003FFFFD300FFFFD2FD00000B0500001603FFFFF4FD00002D800000158600000A85FFFFF58000002D83FFFFEA7BFFFFF500FFFFFF00FFFFFEFD0000158C00000580000005830000028C00001505FFFFEB7BFFFFFAFDFFFFEA6AFFFFE9FFFFFFEAFDFFFFEA7E000016800000008000002B8C00000B0B00001683FFFFFD80FFFFFB0000000A06FFFFFA7FFFFFFEFDFFFFD300FFFFD2FD0000160300000B05FFFFF4FD00000A82FFFFFF000000158600002D8000002D83FFFFF50000001486FFFFFD7DFFFFF57AFFFFEA7BFFFFEAFA0000158C00000A85FFFFF57DFFFFF5800000058000000583');
INSERT INTO "ImageHaarMatrix" VALUES(5,'2011-06-27T16:39:02','c528d0080c44b6cadfb5f46202f57af7',X'000000013F75EEA3BE2DC50FBF383CBF33F8A15BBEB95212DABA4DAAFFFFFE75000018B1FFFFE8CF000005AE0000030000000631000003060000018C00000603FFFFFA4FFFFFFFFB00000006FFFFE775FFFFE8F40000188C00000B970000170BFFFFFD7AFFFFFA7DFFFFFEF4FFFFFD80000002850000010B00000582FFFFF9FBFFFFFCF5000006000000030C00000606FFFFFFF50000000CFFFFFA7AFFFFFD74FFFFFA800000028B00000585FFFFF9F50000060CFFFFFA740000058B0000000BFFFFE7E8FFFFFA7BFFFFFD75FFFFFA00FFFFF3FDFFFFFE68FFFFF9FAFFFFFCF4FFFFE85000000B8600000298000018170000058C000017AF00000B8000000C0500000317FFFFFFE8FFFFF47B000000170000060BFFFFFD69FFFFF400FFFFFA75FFFFF3FAFFFFFCE8FFFFF9F400000B8C0000059800000C0B00000617FFFFF475FFFFFA69FFFFF3F4FFFFF9E800000B9800000C17FFFFF469FFFFF3E800002FDD00001817000017AF00001830FFFFCFD0FFFFD069FFFFF4210000035EFFFFE822FFFFE8A0FFFFD09E00003060FFFFD04F000003170000306100002FE2FFFFFA2100000BE0FFFFFA6900000C0B0000315EFFFFD051FFFFF469000018DE00002F60FFFFF4500000186200000C170000065EFFFFCFA30000061700002F3000002F5EFFFFCF1EFFFFCE9FFFFFD121FFFFD050000017E2FFFFE7A1FFFFE823');
INSERT INTO "ImageHaarMatrix" VALUES(6,'2011-06-27T16:20:19','723417e0715e351b1f8dfb44ca9d47a5',X'000000013FC8AA30FD32C5CFBF6C8E2ED66F9CFD3F4F759298D265F5FFFFFD73FFFFFB79FFFFFCF200000082000003870000028EFFFFFEFAFFFFFD7D00000182FFFFFC0000000282FFFFFFFC00000300FFFFFFF2FFFFF900FFFFFDF9FFFFFFFB0000048300000206FFFFFC7AFFFFFCF900000702FFFFF87E0000018F00000783FFFFF8FDFFFFFE72FFFFFEF10000038000000287FFFFFF0000000780FFFFFE000000010EFFFFFFFE0000000F00000103FFFFFFFFFFFFFE7D000000070000028700000300FFFFFE77FFFFFCFCFFFFFB7BFFFFFBFAFFFFF8FB0000040500000280FFFFF87A00000785FFFFFDFB0000038600000206FFFFFC7B0000048000000700FFFFF87D00000402FFFFFBFD00000782FFFFFF7CFFFFFB7E000000870000070300000083FFFFFF7E00000483FFFFFE00FFFFF8FE00000180FFFFFC80FFFFFC00FFFFF880FFFFFEFE000001000000018300000103FFFFFE7E0000008000000182FFFFF8800000018000000304FFFFFD79FFFFFEFDFFFFFC7900000009FFFFFE7800000189000002040000010F0000000600000005000003860000000EFFFFFEF2FFFFFDFBFFFFFB7E0000070300000108FFFFFE7100000381FFFFFDFFFFFFFD7C00000307FFFFFEFF00000181FFFFFFF8FFFFFEF7FFFFFFF10000018EFFFFFFFCFFFFFFF90000000200000003FFFFFEFE000000800000018300000001');
INSERT INTO "ImageHaarMatrix" VALUES(7,'2011-06-27T16:16:53','2c2fae970fe09d46a08e3bd663d0c464',X'000000013FC6D7C0E3D82DDC3F61A829BF5F0828BF59D6E241DE15F6FFFFFDFB00000009000002040000010E000002820000000600000105FFFFFC7C0000000F00000705FFFFFC7A00000786FFFFF87BFFFFFF7D00000082FFFFFE7800000007000003040000000300000108FFFFFF80FFFFF900FFFFFD7C00000385FFFFFEFEFFFFFE0000000783FFFFF8FD0000018900000001FFFFFEF7FFFFF87EFFFFFE7DFFFFFFF80000038000000702FFFFFFFCFFFFFF000000078000000182FFFFFBFE00000380FFFFFF7DFFFFFEF10000010EFFFFFE80000002000000078300000387FFFFFFFAFFFFFFFBFFFFFDFCFFFFFFF20000040000000780FFFFFF0000000205FFFFFEF800000201FFFFFC7AFFFFFE7F000004820000018FFFFFF8FDFFFFFC7F000000080000010100000284FFFFFCF9000001090000000F00000004FFFFFFFE00000007FFFFFE72FFFFFFFD00000102FFFFFE7DFFFFFF80FFFFFFFF00000087FFFFFF7EFFFFFC8000000109FFFFFE00FFFFFFFBFFFFFEF8FFFFFBFDFFFFFDF900000782FFFFFFFA00000384FFFFFFF7FFFFF880FFFFFC00FFFFFEF1FFFFFE7F00000206FFFFFC7B000001000000020100000483FFFFFC7F000001880000000FFFFFF8FE0000010100000287FFFFFFFDFFFFFCFC0000010E000000040000000700000008FFFFFE77FFFFFFFE00000103FFFFFE7E00000080FFFFFFFF');
INSERT INTO "ImageHaarMatrix" VALUES(8,'2011-06-27T15:39:52','8c834a0330d63fd804d5966d2132bf1d',X'000000013FE12F23499E0F60BC80F30ADA6DFB3EBC7381945ACE1B5E0000050C00000684FFFFFD7DFFFFFEE8000000850000008AFFFFFD00FFFFF180FFFFFF6700000393FFFFFFFA00000787FFFFFC7C0000018FFFFFF8720000038F0000018AFFFFFF77FFFFFF7AFFFFFCFD00000185FFFFF900FFFFFCF300000309FFFFFA7AFFFFFC7200000100FFFFFFFBFFFFFFF100000181FFFFFE77FFFFFF7F00000780FFFFFCFFFFFFFE7EFFFFFFF900000304FFFFFF7EFFFFFFFDFFFFFFFFFFFFF17D0000008100000381FFFFE261FFFFE1E1FFFFE43200003BBA00001EFDFFFFFE7F00000586FFFFFE7600000189FFFFC47900003BF4FFFFF8810000078E0000000F000003010000038E0000020600000F77FFFFFC6DFFFFC4CFFFFFF8790000078300000005FFFFFEE7000007040000008900000303FFFFF8FD00000700FFFFC408FFFFF8800000000700000182FFFFFCFC00000082000000010000000300000C02FFFFF974000000890000039C00000E9DFFFFFC6200000005FFFFF880FFFFFDFF00001D8000001D9DFFFFDCCA0000197F00001BCC0000078E000010A80000097A00000084FFFFFA420000083200001E77FFFFFF00FFFFF8710000000BFFFFFDFEFFFFC3810000038400000704000000060000038300000183000001890000008600000301FFFFFCFC0000008200000182000000810000000300000001');
INSERT INTO "ImageHaarMatrix" VALUES(9,'2011-06-27T16:03:22','90f2915b9c26374327e8b33b1893a480',X'00000001000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFDFFFFFFF9FFFFFFF1FFFFFFE1FFFFFFD8FFFFFFD9FFFFFFDAFFFFFFDBFFFFFFDCFFFFFFDDFFFFFFDEFFFFFFDFFFFFFFE2FFFFFFE0FFFFFFE3FFFFFFE4FFFFFFE5FFFFFFE6FFFFFFE7FFFFFFE8FFFFFFE9FFFFFFEAFFFFFFEBFFFFFFECFFFFFFEDFFFFFFEEFFFFFFEFFFFFFFF2FFFFFFF0FFFFFFF3FFFFFFF4FFFFFFF5FFFFFFF6FFFFFFF7FFFFFFFAFFFFFFF8FFFFFFFBFFFFFFFEFFFFFFFCFFFFFFFFFFFFFFFDFFFFFFF9FFFFFFF1FFFFFFE1FFFFFFD8FFFFFFD9FFFFFFDAFFFFFFDBFFFFFFDCFFFFFFDDFFFFFFDEFFFFFFDFFFFFFFE2FFFFFFE0FFFFFFE3FFFFFFE4FFFFFFE5FFFFFFE6FFFFFFE7FFFFFFE8FFFFFFE9FFFFFFEAFFFFFFEBFFFFFFECFFFFFFEDFFFFFFEEFFFFFFEFFFFFFFF2FFFFFFF0FFFFFFF3FFFFFFF4FFFFFFF5FFFFFFF6FFFFFFF7FFFFFFFAFFFFFFF8FFFFFFFBFFFFFFFEFFFFFFFCFFFFFFFFFFFFFFFDFFFFFFF9FFFFFFF1FFFFFFE1FFFFFFD8FFFFFFD9FFFFFFDAFFFFFFDBFFFFFFDCFFFFFFDDFFFFFFDEFFFFFFDFFFFFFFE2FFFFFFE0FFFFFFE3FFFFFFE4FFFFFFE5FFFFFFE6FFFFFFE7FFFFFFE8FFFFFFE9FFFFFFEAFFFFFFEBFFFFFFECFFFFFFEDFFFFFFEEFFFFFFEFFFFFFFF2FFFFFFF0FFFFFFF3FFFFFFF4FFFFFFF5FFFFFFF6FFFFFFF7FFFFFFFAFFFFFFF8FFFFFFFBFFFFFFFEFFFFFFFC');
INSERT INTO "ImageHaarMatrix" VALUES(10,'2011-06-27T16:03:22','90f2915b9c26374327e8b33b1893a480',X'00000001000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFDFFFFFFF9FFFFFFF1FFFFFFE1FFFFFFD8FFFFFFD9FFFFFFDAFFFFFFDBFFFFFFDCFFFFFFDDFFFFFFDEFFFFFFDFFFFFFFE2FFFFFFE0FFFFFFE3FFFFFFE4FFFFFFE5FFFFFFE6FFFFFFE7FFFFFFE8FFFFFFE9FFFFFFEAFFFFFFEBFFFFFFECFFFFFFEDFFFFFFEEFFFFFFEFFFFFFFF2FFFFFFF0FFFFFFF3FFFFFFF4FFFFFFF5FFFFFFF6FFFFFFF7FFFFFFFAFFFFFFF8FFFFFFFBFFFFFFFEFFFFFFFCFFFFFFFFFFFFFFFDFFFFFFF9FFFFFFF1FFFFFFE1FFFFFFD8FFFFFFD9FFFFFFDAFFFFFFDBFFFFFFDCFFFFFFDDFFFFFFDEFFFFFFDFFFFFFFE2FFFFFFE0FFFFFFE3FFFFFFE4FFFFFFE5FFFFFFE6FFFFFFE7FFFFFFE8FFFFFFE9FFFFFFEAFFFFFFEBFFFFFFECFFFFFFEDFFFFFFEEFFFFFFEFFFFFFFF2FFFFFFF0FFFFFFF3FFFFFFF4FFFFFFF5FFFFFFF6FFFFFFF7FFFFFFFAFFFFFFF8FFFFFFFBFFFFFFFEFFFFFFFCFFFFFFFFFFFFFFFDFFFFFFF9FFFFFFF1FFFFFFE1FFFFFFD8FFFFFFD9FFFFFFDAFFFFFFDBFFFFFFDCFFFFFFDDFFFFFFDEFFFFFFDFFFFFFFE2FFFFFFE0FFFFFFE3FFFFFFE4FFFFFFE5FFFFFFE6FFFFFFE7FFFFFFE8FFFFFFE9FFFFFFEAFFFFFFEBFFFFFFECFFFFFFEDFFFFFFEEFFFFFFEFFFFFFFF2FFFFFFF0FFFFFFF3FFFFFFF4FFFFFFF5FFFFFFF6FFFFFFF7FFFFFFFAFFFFFFF8FFFFFFFBFFFFFFFEFFFFFFFC');
INSERT INTO "ImageHaarMatrix" VALUES(11,'2011-06-27T16:03:22','90f2915b9c26374327e8b33b1893a480',X'00000001000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFDFFFFFFF9FFFFFFF1FFFFFFE1FFFFFFD8FFFFFFD9FFFFFFDAFFFFFFDBFFFFFFDCFFFFFFDDFFFFFFDEFFFFFFDFFFFFFFE2FFFFFFE0FFFFFFE3FFFFFFE4FFFFFFE5FFFFFFE6FFFFFFE7FFFFFFE8FFFFFFE9FFFFFFEAFFFFFFEBFFFFFFECFFFFFFEDFFFFFFEEFFFFFFEFFFFFFFF2FFFFFFF0FFFFFFF3FFFFFFF4FFFFFFF5FFFFFFF6FFFFFFF7FFFFFFFAFFFFFFF8FFFFFFFBFFFFFFFEFFFFFFFCFFFFFFFFFFFFFFFDFFFFFFF9FFFFFFF1FFFFFFE1FFFFFFD8FFFFFFD9FFFFFFDAFFFFFFDBFFFFFFDCFFFFFFDDFFFFFFDEFFFFFFDFFFFFFFE2FFFFFFE0FFFFFFE3FFFFFFE4FFFFFFE5FFFFFFE6FFFFFFE7FFFFFFE8FFFFFFE9FFFFFFEAFFFFFFEBFFFFFFECFFFFFFEDFFFFFFEEFFFFFFEFFFFFFFF2FFFFFFF0FFFFFFF3FFFFFFF4FFFFFFF5FFFFFFF6FFFFFFF7FFFFFFFAFFFFFFF8FFFFFFFBFFFFFFFEFFFFFFFCFFFFFFFFFFFFFFFDFFFFFFF9FFFFFFF1FFFFFFE1FFFFFFD8FFFFFFD9FFFFFFDAFFFFFFDBFFFFFFDCFFFFFFDDFFFFFFDEFFFFFFDFFFFFFFE2FFFFFFE0FFFFFFE3FFFFFFE4FFFFFFE5FFFFFFE6FFFFFFE7FFFFFFE8FFFFFFE9FFFFFFEAFFFFFFEBFFFFFFECFFFFFFEDFFFFFFEEFFFFFFEFFFFFFFF2FFFFFFF0FFFFFFF3FFFFFFF4FFFFFFF5FFFFFFF6FFFFFFF7FFFFFFFAFFFFFFF8FFFFFFFBFFFFFFFEFFFFFFFC');
CREATE TABLE ImageInformation
                            (imageid INTEGER PRIMARY KEY,
                            rating INTEGER,
                            creationDate DATETIME,
                            digitizationDate DATETIME,
                            orientation INTEGER,
                            width INTEGER,
                            height INTEGER,
                            format TEXT,
                            colorDepth INTEGER,
                colorModel INTEGER);
INSERT INTO "ImageInformation" VALUES(1,-1,'2011-06-05T16:28:34','2011-06-05T16:28:34',1,720,479,'JPG',8,5);
INSERT INTO "ImageInformation" VALUES(2,-1,'2011-06-05T16:28:34','2011-06-05T16:28:34',1,720,479,'JPG',8,2);
INSERT INTO "ImageInformation" VALUES(3,-1,'2011-06-27T15:31:45',NULL,0,1538,852,'PNG',8,1);
INSERT INTO "ImageInformation" VALUES(4,-1,'2011-06-27T15:31:50',NULL,0,802,1916,'PNG',8,4);
INSERT INTO "ImageInformation" VALUES(5,5,'2011-06-27T16:39:02',NULL,0,2560,2560,'PNG',8,1);
INSERT INTO "ImageInformation" VALUES(6,-1,'2006-03-11T15:42:12','2006-03-11T15:42:12',1,400,400,'JPG',8,5);
INSERT INTO "ImageInformation" VALUES(7,-1,'2011-06-27T16:16:53',NULL,0,798,798,'JPG',8,5);
INSERT INTO "ImageInformation" VALUES(8,-1,'2011-06-18T16:40:36','2011-06-18T16:40:36',0,640,472,'JPG',8,2);
INSERT INTO "ImageInformation" VALUES(9,-1,'2011-06-05T16:28:34','2011-06-05T16:28:34',1,538,358,'PGF',24,1);
INSERT INTO "ImageInformation" VALUES(10,-1,'2011-06-05T16:28:34','2011-06-05T16:28:34',1,538,358,'PGF',24,1);
INSERT INTO "ImageInformation" VALUES(11,-1,'2011-06-05T16:28:34','2011-06-05T16:28:34',1,538,358,'PGF',24,1);
INSERT INTO "ImageInformation" VALUES(12,-1,'2006-03-11T15:42:12','2006-03-11T15:42:12',1,400,400,'PNG',8,1);
CREATE TABLE ImageMetadata
                            (imageid INTEGER PRIMARY KEY,
                            make TEXT,
                            model TEXT,
                            lens TEXT,
                            aperture REAL,
                            focalLength REAL,
                            focalLength35 REAL,
                            exposureTime REAL,
                            exposureProgram INTEGER,
                            exposureMode INTEGER,
                            sensitivity INTEGER,
                            flash INTEGER,
                            whiteBalance INTEGER,
                            whiteBalanceColorTemperature INTEGER,
                            meteringMode INTEGER,
                            subjectDistance REAL,
                            subjectDistanceCategory INTEGER);
INSERT INTO "ImageMetadata" VALUES(1,'NIKON CORPORATION','NIKON D90','Nikon AF-S DX Nikkor 35mm f/1.8G',3.5,35.0,52.0,0.02,0,0,200,NULL,0,NULL,5,NULL,0);
INSERT INTO "ImageMetadata" VALUES(2,'NIKON CORPORATION','NIKON D90','Nikon AF-S DX Nikkor 35mm f/1.8G',3.5,35.0,52.0,0.02,0,0,200,NULL,0,NULL,5,NULL,0);
INSERT INTO "ImageMetadata" VALUES(9,'NIKON CORPORATION','NIKON D90','Nikon AF-S DX Nikkor 35mm f/1.8G',3.5,35.0,52.0,0.02,0,0,200,24,0,NULL,5,NULL,0);
INSERT INTO "ImageMetadata" VALUES(10,'NIKON CORPORATION','NIKON D90','Nikon AF-S DX Nikkor 35mm f/1.8G',3.5,35.0,52.0,0.02,0,0,200,24,0,NULL,5,NULL,0);
INSERT INTO "ImageMetadata" VALUES(11,'NIKON CORPORATION','NIKON D90','Nikon AF-S DX Nikkor 35mm f/1.8G',3.5,35.0,52.0,0.02,0,0,200,24,0,NULL,5,NULL,0);
CREATE TABLE ImagePositions
                            (imageid INTEGER PRIMARY KEY,
                            latitude TEXT,
                            latitudeNumber REAL,
                            longitude TEXT,
                            longitudeNumber REAL,
                            altitude REAL,
                            orientation REAL,
                            tilt REAL,
                            roll REAL,
                            accuracy REAL,
                            description TEXT);
INSERT INTO "ImagePositions" VALUES(1,'0,0.00000000N',0.0,'90,0.00000000E',90.0,200.0,NULL,NULL,NULL,NULL,NULL);
CREATE TABLE ImageComments
                            (id INTEGER PRIMARY KEY,
                            imageid INTEGER,
                            type INTEGER,
                            language TEXT,
                            author TEXT,
                            date DATETIME,
                            comment TEXT,
                            UNIQUE(imageid, type, language, author));
INSERT INTO "ImageComments" VALUES(1,1,1,'x-default',NULL,NULL,'This file is a part of digiKam project
https://www.digikam.org
Copyright (C) 2011 by Francesco Riosa <francesco+kde at pnpitalia it>');
INSERT INTO "ImageComments" VALUES(2,2,1,'x-default',NULL,NULL,'This file is a part of digiKam project
https://www.digikam.org
Copyright (C) 2011 by Francesco Riosa <francesco+kde at pnpitalia it>');
CREATE TABLE ImageCopyright
                            (id INTEGER PRIMARY KEY,
                            imageid INTEGER,
                            property TEXT,
                            value TEXT,
                            extraValue TEXT,
                            UNIQUE(imageid, property, value, extraValue));
CREATE TABLE Tags
                            (id INTEGER PRIMARY KEY,
                            pid INTEGER,
                            name TEXT NOT NULL,
                            icon INTEGER,
                            iconkde TEXT,
                            UNIQUE (name, pid));
INSERT INTO "Tags" VALUES(1,0,'_Digikam_Internal_Tags_',0,NULL);
INSERT INTO "Tags" VALUES(2,1,'Need Resolving History',0,NULL);
INSERT INTO "Tags" VALUES(3,1,'Need Tagging History Graph',0,NULL);
INSERT INTO "Tags" VALUES(4,0,'People',0,NULL);
INSERT INTO "Tags" VALUES(5,4,'Unknown',0,NULL);
INSERT INTO "Tags" VALUES(6,1,'Original Version',0,NULL);
INSERT INTO "Tags" VALUES(7,1,'Intermediate Version',0,NULL);
INSERT INTO "Tags" VALUES(8,1,'Current Version',0,NULL);
INSERT INTO "Tags" VALUES(9,1,'Version Always Visible',0,NULL);
INSERT INTO "Tags" VALUES(10,0,'tagl0a',0,NULL);
INSERT INTO "Tags" VALUES(11,10,'tagl1a',0,NULL);
INSERT INTO "Tags" VALUES(12,10,'tagl1b',0,NULL);
INSERT INTO "Tags" VALUES(13,10,'tagl1c',0,NULL);
INSERT INTO "Tags" VALUES(14,12,'tagl2a',0,NULL);
INSERT INTO "Tags" VALUES(15,12,'tagl2b',0,NULL);
INSERT INTO "Tags" VALUES(16,12,'tagl2c',0,NULL);
INSERT INTO "Tags" VALUES(17,12,'tagl2d',0,NULL);
INSERT INTO "Tags" VALUES(18,15,'tagl3a',0,NULL);
INSERT INTO "Tags" VALUES(19,15,'tagl3b',0,NULL);
INSERT INTO "Tags" VALUES(20,0,'tl0',0,NULL);
INSERT INTO "Tags" VALUES(21,20,'tl0a',0,NULL);
INSERT INTO "Tags" VALUES(22,20,'tl0b',0,NULL);
INSERT INTO "Tags" VALUES(23,21,'tl0a0',0,NULL);
INSERT INTO "Tags" VALUES(24,21,'tl0a1',0,NULL);
INSERT INTO "Tags" VALUES(25,20,'tagl1c',0,NULL);
INSERT INTO "Tags" VALUES(26,1,'Color Label None',0,NULL);
INSERT INTO "Tags" VALUES(27,1,'Color Label Red',0,NULL);
INSERT INTO "Tags" VALUES(28,1,'Color Label Orange',0,NULL);
INSERT INTO "Tags" VALUES(29,1,'Color Label Yellow',0,NULL);
INSERT INTO "Tags" VALUES(30,1,'Color Label Green',0,NULL);
INSERT INTO "Tags" VALUES(31,1,'Color Label Blue',0,NULL);
INSERT INTO "Tags" VALUES(32,1,'Color Label Magenta',0,NULL);
INSERT INTO "Tags" VALUES(33,1,'Color Label Gray',0,NULL);
INSERT INTO "Tags" VALUES(34,1,'Color Label Black',0,NULL);
INSERT INTO "Tags" VALUES(35,1,'Color Label White',0,NULL);
INSERT INTO "Tags" VALUES(36,1,'Pick Label None',0,NULL);
INSERT INTO "Tags" VALUES(37,1,'Pick Label Rejected',0,NULL);
INSERT INTO "Tags" VALUES(38,1,'Pick Label Pending',0,NULL);
INSERT INTO "Tags" VALUES(39,1,'Pick Label Accepted',0,NULL);
INSERT INTO "Tags" VALUES(40,4,'LadyMars',0,NULL);
CREATE TABLE TagsTree
                            (id INTEGER NOT NULL,
                            pid INTEGER NOT NULL,
                            UNIQUE (id, pid));
INSERT INTO "TagsTree" VALUES(1,0);
INSERT INTO "TagsTree" VALUES(2,0);
INSERT INTO "TagsTree" VALUES(2,1);
INSERT INTO "TagsTree" VALUES(3,0);
INSERT INTO "TagsTree" VALUES(3,1);
INSERT INTO "TagsTree" VALUES(4,0);
INSERT INTO "TagsTree" VALUES(5,0);
INSERT INTO "TagsTree" VALUES(5,4);
INSERT INTO "TagsTree" VALUES(6,0);
INSERT INTO "TagsTree" VALUES(6,1);
INSERT INTO "TagsTree" VALUES(7,0);
INSERT INTO "TagsTree" VALUES(7,1);
INSERT INTO "TagsTree" VALUES(8,0);
INSERT INTO "TagsTree" VALUES(8,1);
INSERT INTO "TagsTree" VALUES(9,0);
INSERT INTO "TagsTree" VALUES(9,1);
INSERT INTO "TagsTree" VALUES(10,0);
INSERT INTO "TagsTree" VALUES(11,0);
INSERT INTO "TagsTree" VALUES(11,10);
INSERT INTO "TagsTree" VALUES(12,0);
INSERT INTO "TagsTree" VALUES(12,10);
INSERT INTO "TagsTree" VALUES(13,0);
INSERT INTO "TagsTree" VALUES(13,10);
INSERT INTO "TagsTree" VALUES(14,0);
INSERT INTO "TagsTree" VALUES(14,10);
INSERT INTO "TagsTree" VALUES(14,12);
INSERT INTO "TagsTree" VALUES(15,0);
INSERT INTO "TagsTree" VALUES(15,10);
INSERT INTO "TagsTree" VALUES(15,12);
INSERT INTO "TagsTree" VALUES(16,0);
INSERT INTO "TagsTree" VALUES(16,10);
INSERT INTO "TagsTree" VALUES(16,12);
INSERT INTO "TagsTree" VALUES(17,0);
INSERT INTO "TagsTree" VALUES(17,10);
INSERT INTO "TagsTree" VALUES(17,12);
INSERT INTO "TagsTree" VALUES(18,0);
INSERT INTO "TagsTree" VALUES(18,10);
INSERT INTO "TagsTree" VALUES(18,12);
INSERT INTO "TagsTree" VALUES(18,15);
INSERT INTO "TagsTree" VALUES(19,0);
INSERT INTO "TagsTree" VALUES(19,10);
INSERT INTO "TagsTree" VALUES(19,12);
INSERT INTO "TagsTree" VALUES(19,15);
INSERT INTO "TagsTree" VALUES(20,0);
INSERT INTO "TagsTree" VALUES(21,0);
INSERT INTO "TagsTree" VALUES(21,20);
INSERT INTO "TagsTree" VALUES(22,0);
INSERT INTO "TagsTree" VALUES(22,20);
INSERT INTO "TagsTree" VALUES(23,0);
INSERT INTO "TagsTree" VALUES(23,20);
INSERT INTO "TagsTree" VALUES(23,21);
INSERT INTO "TagsTree" VALUES(24,0);
INSERT INTO "TagsTree" VALUES(24,20);
INSERT INTO "TagsTree" VALUES(24,21);
INSERT INTO "TagsTree" VALUES(25,0);
INSERT INTO "TagsTree" VALUES(25,20);
INSERT INTO "TagsTree" VALUES(26,0);
INSERT INTO "TagsTree" VALUES(26,1);
INSERT INTO "TagsTree" VALUES(27,0);
INSERT INTO "TagsTree" VALUES(27,1);
INSERT INTO "TagsTree" VALUES(28,0);
INSERT INTO "TagsTree" VALUES(28,1);
INSERT INTO "TagsTree" VALUES(29,0);
INSERT INTO "TagsTree" VALUES(29,1);
INSERT INTO "TagsTree" VALUES(30,0);
INSERT INTO "TagsTree" VALUES(30,1);
INSERT INTO "TagsTree" VALUES(31,0);
INSERT INTO "TagsTree" VALUES(31,1);
INSERT INTO "TagsTree" VALUES(32,0);
INSERT INTO "TagsTree" VALUES(32,1);
INSERT INTO "TagsTree" VALUES(33,0);
INSERT INTO "TagsTree" VALUES(33,1);
INSERT INTO "TagsTree" VALUES(34,0);
INSERT INTO "TagsTree" VALUES(34,1);
INSERT INTO "TagsTree" VALUES(35,0);
INSERT INTO "TagsTree" VALUES(35,1);
INSERT INTO "TagsTree" VALUES(36,0);
INSERT INTO "TagsTree" VALUES(36,1);
INSERT INTO "TagsTree" VALUES(37,0);
INSERT INTO "TagsTree" VALUES(37,1);
INSERT INTO "TagsTree" VALUES(38,0);
INSERT INTO "TagsTree" VALUES(38,1);
INSERT INTO "TagsTree" VALUES(39,0);
INSERT INTO "TagsTree" VALUES(39,1);
INSERT INTO "TagsTree" VALUES(40,0);
INSERT INTO "TagsTree" VALUES(40,4);
CREATE TABLE ImageTags
                            (imageid INTEGER NOT NULL,
                            tagid INTEGER NOT NULL,
                            UNIQUE (imageid, tagid));
INSERT INTO "ImageTags" VALUES(1,24);
INSERT INTO "ImageTags" VALUES(3,36);
INSERT INTO "ImageTags" VALUES(3,26);
INSERT INTO "ImageTags" VALUES(3,11);
INSERT INTO "ImageTags" VALUES(3,12);
INSERT INTO "ImageTags" VALUES(3,13);
INSERT INTO "ImageTags" VALUES(3,16);
INSERT INTO "ImageTags" VALUES(3,17);
INSERT INTO "ImageTags" VALUES(3,19);
INSERT INTO "ImageTags" VALUES(4,36);
INSERT INTO "ImageTags" VALUES(4,26);
INSERT INTO "ImageTags" VALUES(4,14);
INSERT INTO "ImageTags" VALUES(4,21);
INSERT INTO "ImageTags" VALUES(4,23);
INSERT INTO "ImageTags" VALUES(8,40);
INSERT INTO "ImageTags" VALUES(5,39);
INSERT INTO "ImageTags" VALUES(5,31);
CREATE TABLE ImageProperties
                            (imageid  INTEGER NOT NULL,
                            property TEXT    NOT NULL,
                            value    TEXT    NOT NULL,
                            UNIQUE (imageid, property));
INSERT INTO "ImageProperties" VALUES(1,'country','Forever Iced');
INSERT INTO "ImageProperties" VALUES(1,'city','Santa Claus');
INSERT INTO "ImageProperties" VALUES(1,'location','North Pole');
INSERT INTO "ImageProperties" VALUES(1,'provinceState','Icecream');
CREATE TABLE Searches
                            (id INTEGER PRIMARY KEY,
                            type INTEGER,
                            name TEXT NOT NULL,
                            query TEXT NOT NULL);
CREATE TABLE DownloadHistory
                            (id  INTEGER PRIMARY KEY,
                            identifier TEXT,
                            filename TEXT,
                            filesize INTEGER,
                            filedate DATETIME,
                            UNIQUE(identifier, filename, filesize, filedate));
CREATE TABLE Settings
                            (keyword TEXT NOT NULL UNIQUE,
                            value TEXT);
INSERT INTO "Settings" VALUES('preAlpha010Update1','true');
INSERT INTO "Settings" VALUES('preAlpha010Update2','true');
INSERT INTO "Settings" VALUES('preAlpha010Update3','true');
INSERT INTO "Settings" VALUES('beta010Update1','true');
INSERT INTO "Settings" VALUES('beta010Update2','true');
INSERT INTO "Settings" VALUES('uniqueHashVersion','2');
INSERT INTO "Settings" VALUES('databaseImageFormats','jpg;jpeg;jpe;jp2;j2k;jpx;jpc;pgx;tif;tiff;png;xpm;ppm;pnm;pgf;gif;bmp;xcf;pcx;bay;bmq;cr2;crw;cs1;dc2;dcr;dng;erf;fff;hdr;k25;kdc;mdc;mos;mrw;nef;orf;pef;pxn;raf;raw;rdc;sr2;srf;x3f;arw;3fr;cine;ia;kc2;mef;nrw;qtk;rw2;sti;rwl;srw;');
INSERT INTO "Settings" VALUES('databaseVideoFormats','mpeg;mpg;mpo;mpe;avi;mov;wmf;asf;mp4;3gp;wmv');
INSERT INTO "Settings" VALUES('databaseAudioFormats','ogg;mp3;wma;wav');
INSERT INTO "Settings" VALUES('FilterSettingsVersion','3');
INSERT INTO "Settings" VALUES('DcrawFilterSettingsVersion','4');
INSERT INTO "Settings" VALUES('DBVersion','6');
INSERT INTO "Settings" VALUES('DBVersionRequired','6');
INSERT INTO "Settings" VALUES('databaseUUID','{29197195-3ad8-42ca-a2aa-fe6322c3d080}');
INSERT INTO "Settings" VALUES('Locale','UTF-8');
INSERT INTO "Settings" VALUES('DeleteRemovedCompleteScanCount','2');
INSERT INTO "Settings" VALUES('Scanned','2011-06-27T22:58:19');
INSERT INTO "Settings" VALUES('databaseUserImageFormats',NULL);
INSERT INTO "Settings" VALUES('databaseUserVideoFormats',NULL);
INSERT INTO "Settings" VALUES('databaseUserAudioFormats',NULL);
CREATE TABLE ImageHistory
                            (imageid INTEGER PRIMARY KEY,
                             uuid TEXT,
                             history TEXT);
INSERT INTO "ImageHistory" VALUES(6,'6616a04ebbccb87b6af2e5f7e7c2df47723417e0715e351b1f8dfb44ca9d47a5',NULL);
CREATE TABLE ImageRelations
                            (subject INTEGER,
                             object INTEGER,
                             type INTEGER,
                             UNIQUE(subject, object, type));
CREATE TABLE TagProperties
                            (tagid INTEGER,
                             property TEXT,
                             value TEXT);
INSERT INTO "TagProperties" VALUES(1,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(2,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(3,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(5,'person',NULL);
INSERT INTO "TagProperties" VALUES(5,'unknownPerson',NULL);
INSERT INTO "TagProperties" VALUES(6,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(7,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(8,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(9,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(10,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(11,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(12,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(13,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(14,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(15,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(16,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(17,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(18,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(19,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(20,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(21,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(22,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(23,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(24,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(25,'tagKeyboardShortcut','');
INSERT INTO "TagProperties" VALUES(26,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(27,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(28,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(29,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(30,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(31,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(32,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(33,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(34,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(35,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(36,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(37,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(38,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(39,'internalTag',NULL);
INSERT INTO "TagProperties" VALUES(40,'person','LadyMars');
INSERT INTO "TagProperties" VALUES(40,'faceEngineId','LadyMars');
CREATE TABLE ImageTagProperties
                            (imageid INTEGER,
                             tagid INTEGER,
                             property TEXT,
                             value TEXT);
INSERT INTO "ImageTagProperties" VALUES(8,40,'tagRegion','<rect x="306" y="88" width="72" height="104"/>');
CREATE INDEX dir_index  ON Images (album);
CREATE INDEX hash_index ON Images (uniqueHash);
CREATE INDEX tag_index  ON ImageTags (tagid);
CREATE INDEX tag_id_index  ON ImageTags (imageid);
CREATE INDEX image_name_index ON Images (name);
CREATE INDEX creationdate_index ON ImageInformation (creationDate);
CREATE INDEX comments_imageid_index ON ImageComments (imageid);
CREATE INDEX copyright_imageid_index ON ImageCopyright (imageid);
CREATE INDEX uuid_index ON ImageHistory (uuid);
CREATE INDEX subject_relations_index ON ImageRelations (subject);
CREATE INDEX object_relations_index ON ImageRelations (object);
CREATE INDEX tagproperties_index ON TagProperties (tagid);
CREATE INDEX imagetagproperties_index ON ImageTagProperties (imageid, tagid);
CREATE INDEX imagetagproperties_imageid_index ON ImageTagProperties (imageid);
CREATE INDEX imagetagproperties_tagid_index ON ImageTagProperties (tagid);
CREATE TRIGGER delete_albumroot DELETE ON AlbumRoots
                BEGIN
                DELETE FROM Albums
                WHERE Albums.albumRoot = OLD.id;
                END;
CREATE TRIGGER delete_album DELETE ON Albums
                BEGIN
                DELETE FROM Images
                WHERE Images.album = OLD.id;
                END;
CREATE TRIGGER delete_image DELETE ON Images
                    BEGIN
                        DELETE FROM ImageTags          WHERE imageid=OLD.id;
                        DELETE From ImageHaarMatrix    WHERE imageid=OLD.id;
                        DELETE From ImageInformation   WHERE imageid=OLD.id;
                        DELETE From ImageMetadata      WHERE imageid=OLD.id;
                        DELETE From ImagePositions     WHERE imageid=OLD.id;
                        DELETE From ImageComments      WHERE imageid=OLD.id;
                        DELETE From ImageCopyright     WHERE imageid=OLD.id;
                        DELETE From ImageProperties    WHERE imageid=OLD.id;
                        DELETE From ImageHistory       WHERE imageid=OLD.id;
                        DELETE FROM ImageRelations     WHERE subject=OLD.id OR object=OLD.id;
                        DELETE FROM ImageTagProperties WHERE imageid=OLD.id;
                        UPDATE Albums SET icon=null    WHERE icon=OLD.id;
                        UPDATE Tags SET icon=null      WHERE icon=OLD.id;
                    END;
CREATE TRIGGER delete_tag DELETE ON Tags
                    BEGIN
                        DELETE FROM ImageTags WHERE tagid=OLD.id;
                        DELETE FROM TagProperties WHERE tagid=OLD.id;
                        DELETE FROM ImageTagProperties WHERE tagid=OLD.id;
                    END;
CREATE TRIGGER insert_tagstree AFTER INSERT ON Tags
                BEGIN
                INSERT INTO TagsTree
                    SELECT NEW.id, NEW.pid
                    UNION
                    SELECT NEW.id, pid FROM TagsTree WHERE id=NEW.pid;
                END;
CREATE TRIGGER delete_tagstree DELETE ON Tags
                BEGIN
                DELETE FROM Tags
                WHERE id  IN (SELECT id FROM TagsTree WHERE pid=OLD.id);
                DELETE FROM TagsTree
                WHERE id IN (SELECT id FROM TagsTree WHERE pid=OLD.id);
                DELETE FROM TagsTree
                    WHERE id=OLD.id;
                END;
CREATE TRIGGER move_tagstree UPDATE OF pid ON Tags
                BEGIN
                DELETE FROM TagsTree
                    WHERE
                    ((id = OLD.id)
                    OR
                    id IN (SELECT id FROM TagsTree WHERE pid=OLD.id))
                    AND
                    pid IN (SELECT pid FROM TagsTree WHERE id=OLD.id);
                INSERT INTO TagsTree
                    SELECT NEW.id, NEW.pid
                    UNION
                    SELECT NEW.id, pid FROM TagsTree WHERE id=NEW.pid
                    UNION
                    SELECT id, NEW.pid FROM TagsTree WHERE pid=NEW.id
                    UNION
                    SELECT A.id, B.pid FROM TagsTree A, TagsTree B
                    WHERE
                    A.pid = NEW.id AND B.id = NEW.pid;
                END;
COMMIT;
