#pragma once

#include "camera_config.h"
#include "io_pipeline.h"
#include "zbar_pipeline.h"
#include "process_pipeline.h"
#include "gtk/gtk.h"

#define MP_MAIN_THUMB_SIZE 24

struct mp_main_state {
	const struct mp_camera_config *camera;
	MPCameraMode mode;
	bool is_present;

	int gain_max;
	int gain_min;

	int exposure_max;
	int exposure_min;

	bool has_auto_focus_continuous;
	bool has_auto_focus_start;

	struct control_state controls;
};

void mp_main_update_state(const struct mp_main_state *state);

void mp_main_set_preview(cairo_surface_t *image);
void mp_main_capture_completed(cairo_surface_t *thumb, const char *fname);

void mp_main_set_zbar_result(MPZBarScanResult *result);

int remap(int value, int input_min, int input_max, int output_min, int output_max);

void draw_surface_scaled_centered(cairo_t *cr, uint32_t dst_width, uint32_t dst_height,
			          cairo_surface_t *surface);

void auto_adjust(const struct image_stats *stats);
bool check_window_active(void);

extern char *debug_message;

