// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ExtrudedVolPluginInfo.C
// ****************************************************************************

#include <ExtrudedVolPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(ExtrudedVol,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(ExtrudedVol,General)

// ****************************************************************************
//  Method: ExtrudedVolGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ExtrudedVolGeneralPluginInfo::GetName() const
{
    return "ExtrudedVol";
}

// ****************************************************************************
//  Method: ExtrudedVolGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ExtrudedVolGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ExtrudedVolGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ExtrudedVolGeneralPluginInfo::GetID() const
{
    return "ExtrudedVol_1.0";
}
// ****************************************************************************
//  Method: ExtrudedVolGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ExtrudedVolGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: ExtrudedVolGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ExtrudedVolGeneralPluginInfo::HasWriter() const
{
    return true;
}
// ****************************************************************************
//  Method:  ExtrudedVolGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a ExtrudedVol database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
ExtrudedVolGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.exvol");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  ExtrudedVolGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a ExtrudedVol database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ExtrudedVolGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  ExtrudedVolGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the ExtrudedVol plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ExtrudedVolGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
