// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AVTARRAYMETADATA_H
#define AVTARRAYMETADATA_H
#include <dbatts_exports.h>
#include <string>
#include <avtVarMetaData.h>


// ****************************************************************************
// Class: avtArrayMetaData
//
// Purpose:
//    Contains array metadata attributes
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class DBATTS_API avtArrayMetaData : public avtVarMetaData
{
public:
    // These constructors are for objects of this class
    avtArrayMetaData();
    avtArrayMetaData(const avtArrayMetaData &obj);
protected:
    // These constructors are for objects derived from this class
    avtArrayMetaData(private_tmfs_t tmfs);
    avtArrayMetaData(const avtArrayMetaData &obj, private_tmfs_t tmfs);
public:
    virtual ~avtArrayMetaData();

    virtual avtArrayMetaData& operator = (const avtArrayMetaData &obj);
    virtual bool operator == (const avtArrayMetaData &obj) const;
    virtual bool operator != (const avtArrayMetaData &obj) const;
private:
    void Init();
    void Copy(const avtArrayMetaData &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    avtArrayMetaData(std::string, std::string, avtCentering, int);
    avtArrayMetaData(std::string, std::string, avtCentering, int, const stringVector &);
    void Print(ostream &, int = 0) const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_nVars = avtVarMetaData::ID__LAST,
        ID_compNames,
        ID__LAST
    };

public:
    int          nVars;
    stringVector compNames;

private:
    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AVTARRAYMETADATA_TMFS AVTVARMETADATA_TMFS "is*"

#endif
