#!/bin/sh

ZEXY_H=z_zexy.h
ZEXY_C=z_zexy.c

#################################
## functions

head_h() {
 echo "/* zexy-setup autogenerated header-file"
 echo " * generated by \"$0\""
 echo " * !! DO NOT MANUALLY EDIT  !!"
 echo " */"
 echo
 echo "#ifndef Z_ZEXY_H__"
 echo "#define Z_ZEXY_H__"
}

foot_h() {
 echo ""
 echo "void z_zexy_setup(void);"
 echo "#endif /* Z_ZEXY_H__ */"
 echo ""
}

head_c() {
 echo "/* zexy-setup autogenerated setup-file"
 echo " * generated by \"$0\""
 echo " * !! DO NOT MANUALLY EDIT  !!"
 echo " */"
 echo 
 echo "#include \"$ZEXY_H\""
 echo
 echo "void z_zexy_setup(void)"
 echo "{"
}

foot_c() {
 echo "}"
 echo
}

setup_names() {
find . -name "*.c" -not -name zexy.c -not -name z_zexy.c | sort | while read f; do
  i=${f##*/}
  i=${i%.c}
  SETUPNAME=$(echo $i | sed -e "s/.*0x.*/setup_&/g" -e "s/~/_tilde/g" -e "/0x/! s/.*/&_setup/")
  if grep -w ${SETUPNAME} $f > /dev/null; then
    echo ${SETUPNAME} ${i}
  fi
done 
}

##################################
## body
head_h > $ZEXY_H
head_c > $ZEXY_C

setup_names | while read SETUPNAME i; do
 echo "void ${SETUPNAME}(void); /* $i */" >> $ZEXY_H
 echo "	${SETUPNAME}(); /* $i */" >> $ZEXY_C
done

foot_h >> $ZEXY_H
foot_c >> $ZEXY_C

