/* Generated by wayland-scanner 1.17.0 */

#ifndef PHOSH_SERVER_PROTOCOL_H
#define PHOSH_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_phosh The phosh protocol
 * @section page_ifaces_phosh Interfaces
 * - @subpage page_iface_phosh_private - Phone shell extensions
 * - @subpage page_iface_phosh_private_xdg_switcher - Interface to list and raise xdg surfaces
 * - @subpage page_iface_phosh_private_dpms_manager - Interface to handle output dpms
 */
struct phosh_private;
struct phosh_private_dpms_manager;
struct phosh_private_xdg_switcher;
struct wl_output;
struct wl_surface;

/**
 * @page page_iface_phosh_private phosh_private
 * @section page_iface_phosh_private_desc Description
 *
 * Private protocol between phosh and the compositor.
 * @section page_iface_phosh_private_api API
 * See @ref iface_phosh_private.
 */
/**
 * @defgroup iface_phosh_private The phosh_private interface
 *
 * Private protocol between phosh and the compositor.
 */
extern const struct wl_interface phosh_private_interface;
/**
 * @page page_iface_phosh_private_xdg_switcher phosh_private_xdg_switcher
 * @section page_iface_phosh_private_xdg_switcher_desc Description
 *
 * The interface is meant to list xdg surfaces (see the xdg-shell
 * stable wayland protocol) and to raise these surfaces to the top
 * of the window stack.
 *
 * It's up to the compositor if it only lists surfaces of the
 * xdg-shell stable protocol or also surfaces using unstable versions of
 * the xdg-shell protocol.
 * @section page_iface_phosh_private_xdg_switcher_api API
 * See @ref iface_phosh_private_xdg_switcher.
 */
/**
 * @defgroup iface_phosh_private_xdg_switcher The phosh_private_xdg_switcher interface
 *
 * The interface is meant to list xdg surfaces (see the xdg-shell
 * stable wayland protocol) and to raise these surfaces to the top
 * of the window stack.
 *
 * It's up to the compositor if it only lists surfaces of the
 * xdg-shell stable protocol or also surfaces using unstable versions of
 * the xdg-shell protocol.
 */
extern const struct wl_interface phosh_private_xdg_switcher_interface;
/**
 * @page page_iface_phosh_private_dpms_manager phosh_private_dpms_manager
 * @section page_iface_phosh_private_dpms_manager_desc Description
 *
 * The interface is meant to handle output DPMS.
 * @section page_iface_phosh_private_dpms_manager_api API
 * See @ref iface_phosh_private_dpms_manager.
 */
/**
 * @defgroup iface_phosh_private_dpms_manager The phosh_private_dpms_manager interface
 *
 * The interface is meant to handle output DPMS.
 */
extern const struct wl_interface phosh_private_dpms_manager_interface;

#ifndef PHOSH_PRIVATE_ERROR_ENUM
#define PHOSH_PRIVATE_ERROR_ENUM
enum phosh_private_error {
	/**
	 * an invalid argument was provided in a request
	 */
	PHOSH_PRIVATE_ERROR_INVALID_ARGUMENT = 0,
};
#endif /* PHOSH_PRIVATE_ERROR_ENUM */

/**
 * @ingroup iface_phosh_private
 * @struct phosh_private_interface
 */
struct phosh_private_interface {
	/**
	 * rotate output
	 *
	 * Rotate the output clockwise 0, 90, 180 or 270 degree.
	 */
	void (*rotate_display)(struct wl_client *client,
			       struct wl_resource *resource,
			       struct wl_resource *surface,
			       uint32_t degree);
	/**
	 * @since 2
	 */
	void (*get_xdg_switcher)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t id);
	/**
	 * @since 4
	 */
	void (*get_dpms_manager)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t id);
};


/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_ROTATE_DISPLAY_SINCE_VERSION 1
/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_GET_XDG_SWITCHER_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_GET_DPMS_MANAGER_SINCE_VERSION 4

#ifndef PHOSH_PRIVATE_XDG_SWITCHER_ERROR_ENUM
#define PHOSH_PRIVATE_XDG_SWITCHER_ERROR_ENUM
enum phosh_private_xdg_switcher_error {
	/**
	 * an invalid argument was provided in a request
	 */
	PHOSH_PRIVATE_XDG_SWITCHER_ERROR_INVALID_ARGUMENT = 0,
};
#endif /* PHOSH_PRIVATE_XDG_SWITCHER_ERROR_ENUM */

/**
 * @ingroup iface_phosh_private_xdg_switcher
 * @struct phosh_private_xdg_switcher_interface
 */
struct phosh_private_xdg_switcher_interface {
	/**
	 * Get current xdg surfaces
	 *
	 * Request to list xdg shell toplevels.
	 * @since 2
	 */
	void (*list_xdg_surfaces)(struct wl_client *client,
				  struct wl_resource *resource);
	/**
	 * destroy the xdg_switcher interface instance
	 *
	 * 
	 * @since 2
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * raise the given xdg surface to the top of the stack
	 *
	 * 
	 * @param app_id The app_id of the xdg surface
	 * @param title The title of the xdg surface
	 * @since 2
	 */
	void (*raise_xdg_surface)(struct wl_client *client,
				  struct wl_resource *resource,
				  const char *app_id,
				  const char *title);
	/**
	 * close the given xdg surface
	 *
	 * 
	 * @param app_id The app_id of the xdg surface
	 * @param title The title of the xdg surface
	 * @since 3
	 */
	void (*close_xdg_surface)(struct wl_client *client,
				  struct wl_resource *resource,
				  const char *app_id,
				  const char *title);
};

#define PHOSH_PRIVATE_XDG_SWITCHER_XDG_SURFACE 0
#define PHOSH_PRIVATE_XDG_SWITCHER_LIST_XDG_SURFACES_DONE 1

/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_XDG_SURFACE_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_LIST_XDG_SURFACES_DONE_SINCE_VERSION 2

/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_LIST_XDG_SURFACES_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_DESTROY_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_RAISE_XDG_SURFACE_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_CLOSE_XDG_SURFACE_SINCE_VERSION 3

/**
 * @ingroup iface_phosh_private_xdg_switcher
 * Sends an xdg_surface event to the client owning the resource.
 * @param resource_ The client's resource
 * @param app_id the app_id of the xdg surface
 * @param title the title of the xdg surface
 */
static inline void
phosh_private_xdg_switcher_send_xdg_surface(struct wl_resource *resource_, const char *app_id, const char *title)
{
	wl_resource_post_event(resource_, PHOSH_PRIVATE_XDG_SWITCHER_XDG_SURFACE, app_id, title);
}

/**
 * @ingroup iface_phosh_private_xdg_switcher
 * Sends an list_xdg_surfaces_done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
phosh_private_xdg_switcher_send_list_xdg_surfaces_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, PHOSH_PRIVATE_XDG_SWITCHER_LIST_XDG_SURFACES_DONE);
}

#ifndef PHOSH_PRIVATE_DPMS_MANAGER_MODE_ENUM
#define PHOSH_PRIVATE_DPMS_MANAGER_MODE_ENUM
enum phosh_private_dpms_manager_mode {
	/**
	 * DPMS mode on
	 */
	PHOSH_PRIVATE_DPMS_MANAGER_MODE_ON = 0,
	/**
	 * DPMS mode standby
	 */
	PHOSH_PRIVATE_DPMS_MANAGER_MODE_STANDBY = 1,
	/**
	 * DPMS mode suspend
	 */
	PHOSH_PRIVATE_DPMS_MANAGER_MODE_SUSPEND = 2,
	/**
	 * DPMS mode off
	 */
	PHOSH_PRIVATE_DPMS_MANAGER_MODE_OFF = 3,
};
#endif /* PHOSH_PRIVATE_DPMS_MANAGER_MODE_ENUM */

/**
 * @ingroup iface_phosh_private_dpms_manager
 * @struct phosh_private_dpms_manager_interface
 */
struct phosh_private_dpms_manager_interface {
	/**
	 * destroy the dpms_manager interface instance
	 *
	 * 
	 * @since 2
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * set the given DPMS mode on the output
	 *
	 * 
	 * @param output the output to set the dpms mode
	 * @param mode the dpms mode to set
	 * @since 4
	 */
	void (*set_mode)(struct wl_client *client,
			 struct wl_resource *resource,
			 struct wl_resource *output,
			 uint32_t mode);
};

#define PHOSH_PRIVATE_DPMS_MANAGER_MODE_CHANGED 0

/**
 * @ingroup iface_phosh_private_dpms_manager
 */
#define PHOSH_PRIVATE_DPMS_MANAGER_MODE_CHANGED_SINCE_VERSION 4

/**
 * @ingroup iface_phosh_private_dpms_manager
 */
#define PHOSH_PRIVATE_DPMS_MANAGER_DESTROY_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private_dpms_manager
 */
#define PHOSH_PRIVATE_DPMS_MANAGER_SET_MODE_SINCE_VERSION 4

/**
 * @ingroup iface_phosh_private_dpms_manager
 * Sends an mode_changed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param output the output that had it's dpms mode changed
 * @param mode the output's dpms mode
 */
static inline void
phosh_private_dpms_manager_send_mode_changed(struct wl_resource *resource_, struct wl_resource *output, uint32_t mode)
{
	wl_resource_post_event(resource_, PHOSH_PRIVATE_DPMS_MANAGER_MODE_CHANGED, output, mode);
}

#ifdef  __cplusplus
}
#endif

#endif
