/* Generated by wayland-scanner 1.17.0 */

#ifndef GAMMA_CONTROL_SERVER_PROTOCOL_H
#define GAMMA_CONTROL_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_gamma_control The gamma_control protocol
 * @section page_ifaces_gamma_control Interfaces
 * - @subpage page_iface_gamma_control_manager - 
 * - @subpage page_iface_gamma_control - 
 * @section page_copyright_gamma_control Copyright
 * <pre>
 *
 * Copyright © 2015 Giulio camuffo
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct gamma_control;
struct gamma_control_manager;
struct wl_output;

/**
 * @page page_iface_gamma_control_manager gamma_control_manager
 * @section page_iface_gamma_control_manager_api API
 * See @ref iface_gamma_control_manager.
 */
/**
 * @defgroup iface_gamma_control_manager The gamma_control_manager interface
 */
extern const struct wl_interface gamma_control_manager_interface;
/**
 * @page page_iface_gamma_control gamma_control
 * @section page_iface_gamma_control_api API
 * See @ref iface_gamma_control.
 */
/**
 * @defgroup iface_gamma_control The gamma_control interface
 */
extern const struct wl_interface gamma_control_interface;

/**
 * @ingroup iface_gamma_control_manager
 * @struct gamma_control_manager_interface
 */
struct gamma_control_manager_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 */
	void (*get_gamma_control)(struct wl_client *client,
				  struct wl_resource *resource,
				  uint32_t id,
				  struct wl_resource *output);
};


/**
 * @ingroup iface_gamma_control_manager
 */
#define GAMMA_CONTROL_MANAGER_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_gamma_control_manager
 */
#define GAMMA_CONTROL_MANAGER_GET_GAMMA_CONTROL_SINCE_VERSION 1

#ifndef GAMMA_CONTROL_ERROR_ENUM
#define GAMMA_CONTROL_ERROR_ENUM
enum gamma_control_error {
	GAMMA_CONTROL_ERROR_INVALID_GAMMA = 0,
};
#endif /* GAMMA_CONTROL_ERROR_ENUM */

/**
 * @ingroup iface_gamma_control
 * @struct gamma_control_interface
 */
struct gamma_control_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 */
	void (*set_gamma)(struct wl_client *client,
			  struct wl_resource *resource,
			  struct wl_array *red,
			  struct wl_array *green,
			  struct wl_array *blue);
	/**
	 */
	void (*reset_gamma)(struct wl_client *client,
			    struct wl_resource *resource);
};

#define GAMMA_CONTROL_GAMMA_SIZE 0

/**
 * @ingroup iface_gamma_control
 */
#define GAMMA_CONTROL_GAMMA_SIZE_SINCE_VERSION 1

/**
 * @ingroup iface_gamma_control
 */
#define GAMMA_CONTROL_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_gamma_control
 */
#define GAMMA_CONTROL_SET_GAMMA_SINCE_VERSION 1
/**
 * @ingroup iface_gamma_control
 */
#define GAMMA_CONTROL_RESET_GAMMA_SINCE_VERSION 1

/**
 * @ingroup iface_gamma_control
 * Sends an gamma_size event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
gamma_control_send_gamma_size(struct wl_resource *resource_, uint32_t size)
{
	wl_resource_post_event(resource_, GAMMA_CONTROL_GAMMA_SIZE, size);
}

#ifdef  __cplusplus
}
#endif

#endif
