/* Generated by wayland-scanner 1.17.0 */

#ifndef INPUT_METHOD_UNSTABLE_V2_SERVER_PROTOCOL_H
#define INPUT_METHOD_UNSTABLE_V2_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_input_method_unstable_v2 The input_method_unstable_v2 protocol
 * Protocol for creating input methods
 *
 * @section page_desc_input_method_unstable_v2 Description
 *
 * This protocol allows applications to act as input methods for compositors.
 *
 * An input method context is used to manage the state of the input method.
 *
 * Text strings are UTF-8 encoded, their indices and lengths are in bytes.
 *
 * This document adheres to the RFC 2119 when using words like "must",
 * "should", "may", etc.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * @section page_ifaces_input_method_unstable_v2 Interfaces
 * - @subpage page_iface_zwp_input_method_v2 - input method
 * - @subpage page_iface_zwp_input_popup_surface_v2 - popup surface
 * - @subpage page_iface_zwp_input_method_keyboard_grab_v2 - keyboard grab
 * - @subpage page_iface_zwp_input_method_manager_v2 - input method manager
 * @section page_copyright_input_method_unstable_v2 Copyright
 * <pre>
 *
 * Copyright © 2008-2011 Kristian Høgsberg
 * Copyright © 2010-2011 Intel Corporation
 * Copyright © 2012-2013 Collabora, Ltd.
 * Copyright © 2012, 2013 Intel Corporation
 * Copyright © 2015, 2016 Jan Arne Petersen
 * Copyright © 2017, 2018 Red Hat, Inc.
 * Copyright © 2018       Purism SPC
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_seat;
struct wl_surface;
struct zwp_input_method_keyboard_grab_v2;
struct zwp_input_method_manager_v2;
struct zwp_input_method_v2;
struct zwp_input_popup_surface_v2;

/**
 * @page page_iface_zwp_input_method_v2 zwp_input_method_v2
 * @section page_iface_zwp_input_method_v2_desc Description
 *
 * An input method object allows for clients to compose text.
 *
 * The objects connects the client to a text input in an application, and
 * lets the client to serve as an input method for a seat.
 *
 * The zwp_input_method_v2 object can occupy two distinct states: active and
 * inactive. In the active state, the object is associated to and
 * communicates with a text input. In the inactive state, there is no
 * associated text input, and the only communication is with the compositor.
 * Initially, the input method is in the inactive state.
 *
 * Requests issued in the inactive state must be accepted by the compositor.
 * Because of the serial mechanism, and the state reset on activate event,
 * they will not have any effect on the state of the next text input.
 *
 * There must be no more than one input method object per seat.
 * @section page_iface_zwp_input_method_v2_api API
 * See @ref iface_zwp_input_method_v2.
 */
/**
 * @defgroup iface_zwp_input_method_v2 The zwp_input_method_v2 interface
 *
 * An input method object allows for clients to compose text.
 *
 * The objects connects the client to a text input in an application, and
 * lets the client to serve as an input method for a seat.
 *
 * The zwp_input_method_v2 object can occupy two distinct states: active and
 * inactive. In the active state, the object is associated to and
 * communicates with a text input. In the inactive state, there is no
 * associated text input, and the only communication is with the compositor.
 * Initially, the input method is in the inactive state.
 *
 * Requests issued in the inactive state must be accepted by the compositor.
 * Because of the serial mechanism, and the state reset on activate event,
 * they will not have any effect on the state of the next text input.
 *
 * There must be no more than one input method object per seat.
 */
extern const struct wl_interface zwp_input_method_v2_interface;
/**
 * @page page_iface_zwp_input_popup_surface_v2 zwp_input_popup_surface_v2
 * @section page_iface_zwp_input_popup_surface_v2_desc Description
 *
 * This interface marks a surface as a popup for interacting with an input
 * method.
 *
 * The compositor should place it near the active text input area. It must
 * be visible if and only if the input method is in the active state.
 *
 * The client must not destroy the underlying wl_surface while the
 * zwp_input_popup_surface_v2 object exists.
 * @section page_iface_zwp_input_popup_surface_v2_api API
 * See @ref iface_zwp_input_popup_surface_v2.
 */
/**
 * @defgroup iface_zwp_input_popup_surface_v2 The zwp_input_popup_surface_v2 interface
 *
 * This interface marks a surface as a popup for interacting with an input
 * method.
 *
 * The compositor should place it near the active text input area. It must
 * be visible if and only if the input method is in the active state.
 *
 * The client must not destroy the underlying wl_surface while the
 * zwp_input_popup_surface_v2 object exists.
 */
extern const struct wl_interface zwp_input_popup_surface_v2_interface;
/**
 * @page page_iface_zwp_input_method_keyboard_grab_v2 zwp_input_method_keyboard_grab_v2
 * @section page_iface_zwp_input_method_keyboard_grab_v2_desc Description
 *
 * The zwp_input_method_keyboard_grab_v2 interface represents an exclusive
 * grab of the wl_keyboard interface associated with the seat.
 * @section page_iface_zwp_input_method_keyboard_grab_v2_api API
 * See @ref iface_zwp_input_method_keyboard_grab_v2.
 */
/**
 * @defgroup iface_zwp_input_method_keyboard_grab_v2 The zwp_input_method_keyboard_grab_v2 interface
 *
 * The zwp_input_method_keyboard_grab_v2 interface represents an exclusive
 * grab of the wl_keyboard interface associated with the seat.
 */
extern const struct wl_interface zwp_input_method_keyboard_grab_v2_interface;
/**
 * @page page_iface_zwp_input_method_manager_v2 zwp_input_method_manager_v2
 * @section page_iface_zwp_input_method_manager_v2_desc Description
 *
 * The input method manager allows the client to become the input method on
 * a chosen seat.
 *
 * No more than one input method must be associated with any seat at any
 * given time.
 * @section page_iface_zwp_input_method_manager_v2_api API
 * See @ref iface_zwp_input_method_manager_v2.
 */
/**
 * @defgroup iface_zwp_input_method_manager_v2 The zwp_input_method_manager_v2 interface
 *
 * The input method manager allows the client to become the input method on
 * a chosen seat.
 *
 * No more than one input method must be associated with any seat at any
 * given time.
 */
extern const struct wl_interface zwp_input_method_manager_v2_interface;

/**
 * @ingroup iface_zwp_input_method_v2
 * @struct zwp_input_method_v2_interface
 */
struct zwp_input_method_v2_interface {
	/**
	 * commit string
	 *
	 * Send the commit string text for insertion to the application.
	 *
	 * Inserts a string at current cursor position (see commit event
	 * sequence). The string to commit could be either just a single
	 * character after a key press or the result of some composing.
	 *
	 * The argument text is a buffer containing the string to insert.
	 * There is a maximum length of wayland messages, so text can not
	 * be longer than 4000 bytes.
	 *
	 * Values set with this event are double-buffered. They must be
	 * applied and reset to initial on the next
	 * zwp_text_input_v3.commit request.
	 *
	 * The initial value of text is an empty string.
	 */
	void (*commit_string)(struct wl_client *client,
			      struct wl_resource *resource,
			      const char *text);
	/**
	 * pre-edit string
	 *
	 * Send the pre-edit string text to the application text input.
	 *
	 * Place a new composing text (pre-edit) at the current cursor
	 * position. Any previously set composing text must be removed. Any
	 * previously existing selected text must be removed. The cursor is
	 * moved to a new position within the preedit string.
	 *
	 * The argument text is a buffer containing the preedit string.
	 * There is a maximum length of wayland messages, so text can not
	 * be longer than 4000 bytes.
	 *
	 * The arguments cursor_begin and cursor_end are counted in bytes
	 * relative to the beginning of the submitted string buffer. Cursor
	 * should be hidden by the text input when both are equal to -1.
	 *
	 * cursor_begin indicates the beginning of the cursor. cursor_end
	 * indicates the end of the cursor. It may be equal or different
	 * than cursor_begin.
	 *
	 * Values set with this event are double-buffered. They must be
	 * applied on the next zwp_input_method_v2.commit event.
	 *
	 * The initial value of text is an empty string. The initial value
	 * of cursor_begin, and cursor_end are both 0.
	 */
	void (*set_preedit_string)(struct wl_client *client,
				   struct wl_resource *resource,
				   const char *text,
				   int32_t cursor_begin,
				   int32_t cursor_end);
	/**
	 * delete text
	 *
	 * Remove the surrounding text.
	 *
	 * before_length and after_length are the number of bytes before
	 * and after the current cursor index (excluding the preedit text)
	 * to delete.
	 *
	 * If any preedit text is present, it is replaced with the cursor
	 * for the purpose of this event. In effect before_length is
	 * counted from the beginning of preedit text, and after_length
	 * from its end (see commit event sequence).
	 *
	 * Values set with this event are double-buffered. They must be
	 * applied and reset to initial on the next
	 * zwp_input_method_v2.commit request.
	 *
	 * The initial values of both before_length and after_length are 0.
	 */
	void (*delete_surrounding_text)(struct wl_client *client,
					struct wl_resource *resource,
					uint32_t before_length,
					uint32_t after_length);
	/**
	 * apply state
	 *
	 * Apply state changes from commit_string, set_preedit_string and
	 * delete_surrounding_text requests.
	 *
	 * The state relating to these events is double-buffered, and each
	 * one modifies the pending state. This request replaces the
	 * current state with the pending state.
	 *
	 * The connected text input is expected to proceed by evaluating
	 * the changes in the following order:
	 *
	 * 1. Replace existing preedit string with the cursor. 2. Delete
	 * requested surrounding text. 3. Insert commit string with the
	 * cursor at its end. 4. Calculate surrounding text to send. 5.
	 * Insert new preedit text in cursor position. 6. Place cursor
	 * inside preedit text.
	 *
	 * The serial number reflects the last state of the
	 * zwp_input_method_v2 object known to the client. The value of the
	 * serial argument must be equal to the number of done events
	 * already issued by that object. When the compositor receives a
	 * commit request with a serial different than the number of past
	 * done events, it must proceed as normal, except it should not
	 * change the current state of the zwp_input_method_v2 object.
	 */
	void (*commit)(struct wl_client *client,
		       struct wl_resource *resource,
		       uint32_t serial);
	/**
	 * create popup surface
	 *
	 * Creates a new zwp_input_popup_surface_v2 object wrapping a
	 * given surface.
	 *
	 * The surface gets assigned the "input_popup" role. If the surface
	 * already has an assigned role, the compositor must issue a
	 * protocol error.
	 */
	void (*get_input_popup_surface)(struct wl_client *client,
					struct wl_resource *resource,
					uint32_t id,
					struct wl_resource *surface);
	/**
	 * grab hardware keyboard
	 *
	 * Allow an input method to receive hardware keyboard input and
	 * process key events to generate text events (with pre-edit) over
	 * the wire. This allows input methods which compose multiple key
	 * events for inputting text like it is done for CJK languages.
	 *
	 * The compositor should send all keyboard events on the seat to
	 * the grab holder via the returned wl_keyboard object.
	 * Nevertheless, the compositor may decide not to forward any
	 * particular event. The compositor must not further process any
	 * event after it has been forwarded to the grab holder.
	 *
	 * Releasing the resulting wl_keyboard object releases the grab.
	 */
	void (*grab_keyboard)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t keyboard);
	/**
	 * destroy the text input
	 *
	 * Destroys the zwp_text_input_v2 object and any associated child
	 * objects, i.e. zwp_input_popup_surface_v2 and
	 * zwp_input_method_keyboard_grab_v2.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZWP_INPUT_METHOD_V2_ACTIVATE 0
#define ZWP_INPUT_METHOD_V2_DEACTIVATE 1
#define ZWP_INPUT_METHOD_V2_SURROUNDING_TEXT 2
#define ZWP_INPUT_METHOD_V2_TEXT_CHANGE_CAUSE 3
#define ZWP_INPUT_METHOD_V2_CONTENT_TYPE 4
#define ZWP_INPUT_METHOD_V2_DONE 5
#define ZWP_INPUT_METHOD_V2_UNAVAILABLE 6

/**
 * @ingroup iface_zwp_input_method_v2
 */
#define ZWP_INPUT_METHOD_V2_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_v2
 */
#define ZWP_INPUT_METHOD_V2_DEACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_v2
 */
#define ZWP_INPUT_METHOD_V2_SURROUNDING_TEXT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_v2
 */
#define ZWP_INPUT_METHOD_V2_TEXT_CHANGE_CAUSE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_v2
 */
#define ZWP_INPUT_METHOD_V2_CONTENT_TYPE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_v2
 */
#define ZWP_INPUT_METHOD_V2_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_v2
 */
#define ZWP_INPUT_METHOD_V2_UNAVAILABLE_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_input_method_v2
 */
#define ZWP_INPUT_METHOD_V2_COMMIT_STRING_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_v2
 */
#define ZWP_INPUT_METHOD_V2_SET_PREEDIT_STRING_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_v2
 */
#define ZWP_INPUT_METHOD_V2_DELETE_SURROUNDING_TEXT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_v2
 */
#define ZWP_INPUT_METHOD_V2_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_v2
 */
#define ZWP_INPUT_METHOD_V2_GET_INPUT_POPUP_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_v2
 */
#define ZWP_INPUT_METHOD_V2_GRAB_KEYBOARD_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_v2
 */
#define ZWP_INPUT_METHOD_V2_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_input_method_v2
 * Sends an activate event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_input_method_v2_send_activate(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_INPUT_METHOD_V2_ACTIVATE);
}

/**
 * @ingroup iface_zwp_input_method_v2
 * Sends an deactivate event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_input_method_v2_send_deactivate(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_INPUT_METHOD_V2_DEACTIVATE);
}

/**
 * @ingroup iface_zwp_input_method_v2
 * Sends an surrounding_text event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_input_method_v2_send_surrounding_text(struct wl_resource *resource_, const char *text, uint32_t cursor, uint32_t anchor)
{
	wl_resource_post_event(resource_, ZWP_INPUT_METHOD_V2_SURROUNDING_TEXT, text, cursor, anchor);
}

/**
 * @ingroup iface_zwp_input_method_v2
 * Sends an text_change_cause event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_input_method_v2_send_text_change_cause(struct wl_resource *resource_, uint32_t cause)
{
	wl_resource_post_event(resource_, ZWP_INPUT_METHOD_V2_TEXT_CHANGE_CAUSE, cause);
}

/**
 * @ingroup iface_zwp_input_method_v2
 * Sends an content_type event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_input_method_v2_send_content_type(struct wl_resource *resource_, uint32_t hint, uint32_t purpose)
{
	wl_resource_post_event(resource_, ZWP_INPUT_METHOD_V2_CONTENT_TYPE, hint, purpose);
}

/**
 * @ingroup iface_zwp_input_method_v2
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_input_method_v2_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_INPUT_METHOD_V2_DONE);
}

/**
 * @ingroup iface_zwp_input_method_v2
 * Sends an unavailable event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_input_method_v2_send_unavailable(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_INPUT_METHOD_V2_UNAVAILABLE);
}

/**
 * @ingroup iface_zwp_input_popup_surface_v2
 * @struct zwp_input_popup_surface_v2_interface
 */
struct zwp_input_popup_surface_v2_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZWP_INPUT_POPUP_SURFACE_V2_TEXT_INPUT_RECTANGLE 0

/**
 * @ingroup iface_zwp_input_popup_surface_v2
 */
#define ZWP_INPUT_POPUP_SURFACE_V2_TEXT_INPUT_RECTANGLE_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_input_popup_surface_v2
 */
#define ZWP_INPUT_POPUP_SURFACE_V2_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_input_popup_surface_v2
 * Sends an text_input_rectangle event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_input_popup_surface_v2_send_text_input_rectangle(struct wl_resource *resource_, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_resource_post_event(resource_, ZWP_INPUT_POPUP_SURFACE_V2_TEXT_INPUT_RECTANGLE, x, y, width, height);
}

/**
 * @ingroup iface_zwp_input_method_keyboard_grab_v2
 * @struct zwp_input_method_keyboard_grab_v2_interface
 */
struct zwp_input_method_keyboard_grab_v2_interface {
	/**
	 * release the grab object
	 *
	 * 
	 */
	void (*release)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZWP_INPUT_METHOD_KEYBOARD_GRAB_V2_KEYMAP 0
#define ZWP_INPUT_METHOD_KEYBOARD_GRAB_V2_KEY 1
#define ZWP_INPUT_METHOD_KEYBOARD_GRAB_V2_MODIFIERS 2
#define ZWP_INPUT_METHOD_KEYBOARD_GRAB_V2_REPEAT_INFO 3

/**
 * @ingroup iface_zwp_input_method_keyboard_grab_v2
 */
#define ZWP_INPUT_METHOD_KEYBOARD_GRAB_V2_KEYMAP_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_keyboard_grab_v2
 */
#define ZWP_INPUT_METHOD_KEYBOARD_GRAB_V2_KEY_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_keyboard_grab_v2
 */
#define ZWP_INPUT_METHOD_KEYBOARD_GRAB_V2_MODIFIERS_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_keyboard_grab_v2
 */
#define ZWP_INPUT_METHOD_KEYBOARD_GRAB_V2_REPEAT_INFO_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_input_method_keyboard_grab_v2
 */
#define ZWP_INPUT_METHOD_KEYBOARD_GRAB_V2_RELEASE_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_input_method_keyboard_grab_v2
 * Sends an keymap event to the client owning the resource.
 * @param resource_ The client's resource
 * @param format keymap format
 * @param fd keymap file descriptor
 * @param size keymap size, in bytes
 */
static inline void
zwp_input_method_keyboard_grab_v2_send_keymap(struct wl_resource *resource_, uint32_t format, int32_t fd, uint32_t size)
{
	wl_resource_post_event(resource_, ZWP_INPUT_METHOD_KEYBOARD_GRAB_V2_KEYMAP, format, fd, size);
}

/**
 * @ingroup iface_zwp_input_method_keyboard_grab_v2
 * Sends an key event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial serial number of the key event
 * @param time timestamp with millisecond granularity
 * @param key key that produced the event
 * @param state physical state of the key
 */
static inline void
zwp_input_method_keyboard_grab_v2_send_key(struct wl_resource *resource_, uint32_t serial, uint32_t time, uint32_t key, uint32_t state)
{
	wl_resource_post_event(resource_, ZWP_INPUT_METHOD_KEYBOARD_GRAB_V2_KEY, serial, time, key, state);
}

/**
 * @ingroup iface_zwp_input_method_keyboard_grab_v2
 * Sends an modifiers event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial serial number of the modifiers event
 * @param mods_depressed depressed modifiers
 * @param mods_latched latched modifiers
 * @param mods_locked locked modifiers
 * @param group keyboard layout
 */
static inline void
zwp_input_method_keyboard_grab_v2_send_modifiers(struct wl_resource *resource_, uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group)
{
	wl_resource_post_event(resource_, ZWP_INPUT_METHOD_KEYBOARD_GRAB_V2_MODIFIERS, serial, mods_depressed, mods_latched, mods_locked, group);
}

/**
 * @ingroup iface_zwp_input_method_keyboard_grab_v2
 * Sends an repeat_info event to the client owning the resource.
 * @param resource_ The client's resource
 * @param rate the rate of repeating keys in characters per second
 * @param delay delay in milliseconds since key down until repeating starts
 */
static inline void
zwp_input_method_keyboard_grab_v2_send_repeat_info(struct wl_resource *resource_, int32_t rate, int32_t delay)
{
	wl_resource_post_event(resource_, ZWP_INPUT_METHOD_KEYBOARD_GRAB_V2_REPEAT_INFO, rate, delay);
}

/**
 * @ingroup iface_zwp_input_method_manager_v2
 * @struct zwp_input_method_manager_v2_interface
 */
struct zwp_input_method_manager_v2_interface {
	/**
	 * request an input method object
	 *
	 * Request a new input zwp_input_method_v2 object associated with
	 * a given seat.
	 */
	void (*get_input_method)(struct wl_client *client,
				 struct wl_resource *resource,
				 struct wl_resource *seat,
				 uint32_t input_method);
	/**
	 * destroy the input method manager
	 *
	 * Destroys the zwp_input_method_manager_v2 object.
	 *
	 * The zwp_input_method_v2 objects originating from it remain
	 * valid.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_zwp_input_method_manager_v2
 */
#define ZWP_INPUT_METHOD_MANAGER_V2_GET_INPUT_METHOD_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_manager_v2
 */
#define ZWP_INPUT_METHOD_MANAGER_V2_DESTROY_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
