#! /usr/bin/perl -w

use strict;
use warnings;

use Date::Calc;
use DBI;

require 'Functions/config.pl';
require 'Functions/db.pl';
require 'Functions/Delete.pl';
require 'Functions/FilterList.pl';

require 'Classes/Filter.pm';

package main;

###################################################################################

my $param = shift;
if ( ! $param ) { die( " usage : perl ./crontab/delete_alerts_older_than.pl \"time_unit\"\n
  where time_unit consist of a number followed by one of those letters :\n
    Y (year), M (month), D (day), W (week), h (hour), m (minute) or s (second)\n\n
\n
Examples : 1W => 1 week / 1Y6M => 1 year and 6 monthes which could also be written 18M\n" ); };

my ( $years, $monthes, $days, $hours, $minutes, $seconds ) = ( 0, 0, 0, 0, 0, 0 );
if ( $param =~ m/(\d+)Y/i ) {$years = $1;};
if ( $param =~ m/(\d+)M/ ) {$monthes = $1;};
if ( $param =~ m/(\d+)W/i ) {$days += $1*7;};
if ( $param =~ m/(\d+)D/i ) {$days += $1;};
if ( $param =~ m/(\d+)h/i ) {$hours = $1;};
if ( $param =~ m/(\d+)m/ ) {$minutes = $1;};
if ( $param =~ m/(\d+)s/i ) {$seconds = $1;};

my $TimeStamp = sprintf( "%04d-%02d-%02d %02d:%02d:%02d", 
             Date::Calc::Add_Delta_YMDHMS( Date::Calc::Today(), Date::Calc::Now(),
                          -$years, -$monthes, -$days, -$hours, -$minutes, -$seconds)
);

###################################################################################

our %conf = ();	# configuration directives

LoadConfig();

  # Open the DB connection :
our $dbh = DB_Open();

my $Filter = Filter->new();

my $Criteria = Criteria->new();
$Criteria->Table( 'CreateTime' );
$Criteria->Field( 'time' );
$Criteria->Operator( '<' );
$Criteria->Value( $TimeStamp );

$Filter->add_Criteria( $Criteria );
$Filter->Formula( 'A' );

my $Nb = $Filter->DeleteAlerts();

print " $Nb alerts matching $param were removed (older than $TimeStamp)\n";
