# -*- coding: utf-8 -*-
"""The hasher interface."""

from __future__ import unicode_literals

import abc


class BaseHasher(object):
  """Base class for objects that calculate hashes."""

  NAME = 'base_hasher'
  DESCRIPTION = 'Calculates a digest hash over input data.'

  # pylint: disable=redundant-returns-doc
  @abc.abstractmethod
  def GetBinaryDigest(self):
    """Retrieves the digest of the hash function as a binary string.

    Returns:
      bytes: binary hash digest calculated over the data blocks passed to
          Update().
    """

  # pylint: disable=redundant-returns-doc
  @abc.abstractmethod
  def GetStringDigest(self):
    """Retrieves the digest of the hash function expressed as a Unicode string.

    Returns:
      str: string hash digest calculated over the data blocks passed to
          Update(). The string consists of printable Unicode characters.
    """

  # pylint: disable=redundant-returns-doc
  @abc.abstractmethod
  def Update(self, data):
    """Updates the current state of the hasher with a new block of data.

    Repeated calls to update are equivalent to one single call with the
    concatenation of the arguments.

    Args:
      data (bytes): data with which to update the context of the hasher.
    """
