#!/bin/bash
# this script for converting of ponyprog translated header files
# EK, 29 apr 2017
# all input files should converted in to UTF-8, it's for sed input

array=( "STR_LANGUAGE_CODE"
"MSG_TRANSLATORCREDITS"
"MSG_TRANSLATORNAME"

"STR_APPNAME_EXT"
"STR_APPDOWNLOAD1"
"STR_APPDOWNLOAD2"

"STR_NONAME"
"STR_BTNOK"
"STR_BTNCANC"
"STR_BTNHELP"
"STR_BTNPROBE"

"STR_BTNCHECKHW"

"STR_BTNNOTE"
"STR_BTNEDIT"

"STR_MSGVERSION"
"STR_MSGYES"
"STR_MSGNO"
"STR_MSGOK"
"STR_MSGTEST"
"STR_MSGFAILED"
"STR_ABOUT"
"STR_MSGPAGE"
"STR_MSGUNKNOWN"
"STR_BUFCHANGED"
"STR_BUFCHANGED2"
"STR_NOTHINGSAVE"
"STR_NOTHINGLOAD"
"STR_NOTHINGPRINT"
"STR_NOTHINGWRITE"
"STR_NOTHINGVERIFY"
"STR_BUSCALIBRA1"
"STR_BUSCALIBRA2"
"STR_BUSCALIBRAOK"
"STR_BUSCALIBRAFAIL"
"STR_MSGNEEDCALIB"
"STR_MSGNEEDSETUP"
"STR_MSGREADING"
"STR_MSGREADOK"
"STR_ASKWRITE"
"STR_MSGWRITING"
"STR_MSGVERIFING"
"STR_MSGWRITEOK"
"STR_MSGWRITEFAIL"
"STR_MSGERASING"
"STR_MSGERASEOK"
"STR_MSGVERIFYFAIL1"
"STR_MSGVERIFYFAIL2"
"STR_MSGVERIFYOK"
"STR_MSGPROGRAMOK"
"STR_MSGPROGRAMFAIL"
"STR_MSGDEVRESET"
"STR_MSGWRITINGSEC"
"STR_MSGWRITESECFAIL"
"STR_MSGREADINGSEC"
"STR_MSGREADSECFAIL"
"STR_MSGREADINGFUSE"
"STR_MSGREADFUSEFAIL"
"STR_MSGWRITINGFUSE"
"STR_MSGWRITEFUSEFAIL"

"STR_MSGSCRIPTERROR"
"STR_MSGSCRIPTBADCOMMAND"
"STR_MSGSCRIPTBADARGUMENT"
"STR_MSGSCRIPTARGMISSING"
"STR_MSGDEFAULTPAUSE"

"STR_BUFEMPTY"
"STR_OPNOTSUP"
"STR_MSGINSPARAM"
"STR_MSGBADPARAM"
"STR_MSGACCEPTCMD"
"STR_MSGOPENFILE"
"STR_MSGOPENPROGFILE"
"STR_MSGOPENDATAFILE"
"STR_MSGFILENOTFOUND"
"STR_MSGFILESAVEFAIL"
"STR_MSGFILESAVEAS"
"STR_MSGFILESAVEPROG"
"STR_MSGFILESAVEDATA"
"STR_MSGCLOSEWINEXIT"
"STR_MSGCLOSEWINSAVE"
"STR_MSGOPENSCRIPT"

"STR_MENUFILE"
"STR_MENUEDIT"
"STR_MENUDEVICE"
"STR_MENUCMD"
"STR_MENUSCRIPT"
"STR_MENUUTIL"
"STR_MENUSETUP"
"STR_MENUOPTIONS"
"STR_MENUQMARK"

"STR_NEWWIN"
"STR_OPEN"
"STR_OPENFLASH"
"STR_OPENDATA"
"STR_SAVE"
"STR_SAVEAS"
"STR_SAVEFLASH"
"STR_SAVEDATA"
"STR_RELOAD"
"STR_PRINT"
"STR_CLOSE"
"STR_EXIT"

"STR_EDITNOTE"
"STR_EDITBUFENA"

"STR_READALL"
"STR_READPROG"
"STR_READDATA"
"STR_READSECBITS"
"STR_WRITEALL"
"STR_WRITEPROG"
"STR_WRITEDATA"
"STR_WRITESECBITS"
"STR_VERIFYALL"
"STR_VERIFYPROG"
"STR_VERIFYDATA"
"STR_VERIFYSECBITS"
"STR_ERASE"
"STR_GETINFO"
"STR_RESET"
"STR_PROGRAM"
"STR_PROGOPTION"

"STR_INTERFSETUP"
"STR_CALIBRATION"
"STR_REMOTEMODE"

"STR_CLEARBUF"
"STR_FILLBUF"
"STR_DOUBLEBANK"
"STR_BYTESWAP"
"STR_DOWNSERNUM"
"STR_SERNUMCONF"

"STR_MENUHELP"
"STR_MENUABOUT"

"STR_MENULOG"

"STR_EDITSCR"
"STR_LOADSCR"
"STR_AUTOLOADSCR"
"STR_RUNSCR"


"STR_MSGDEVTYPE"

"STR_TTOPENFILE"
"STR_TTSAVEFILE"
"STR_TTPRINT"
"STR_TTRELOAD"
"STR_TTREADALL"
"STR_TTREADPROG"
"STR_TTREADDATA"
"STR_TTREADSEC"
"STR_TTWRITEALL"
"STR_TTWRITEPROG"
"STR_TTWRITEDATA"

"STR_TTVERIFYPROG"
"STR_TTVERIFYDATA"
"STR_TTVERIFYSEC"

"STR_TTSELFAMILY"
"STR_TTSELTYPE"

"STR_TTEDITNOTE"

"STR_DEVNOTRESP"
"STR_DEVBADTYPE"
"STR_DEVUNKNOWN"
"STR_DEVLOCKED"
"STR_OPABORTED"
"STR_OPENFAILED"
"STR_ACCDENIED"
"STR_NOTINST"
"STR_HWERROR"
"STR_BUSBUSY"
"STR_I2CNOACK"
"STR_I2CNODEV"
"STR_I2CTIMEOUT"
"STR_I2CSTOPERR"
"STR_WRITEERR"
"STR_BLANKCHECKERR"
"STR_ERRNO"
"STR_SCRIPTERROR"

"STR_DLGIOSETUP"
"STR_MSGINTSETUP"

"STR_LBLCOMLPT"
"STR_LBLSERIAL"
"STR_LBLPARALLEL"
"STR_LBLINTERFSEL"
"STR_LBLINTERFTYPE"
"STR_LBLCOMSELECT"
"STR_LBLCOM1"
"STR_LBLUSBSELECT"
"STR_LBLUSB1"
"STR_LBLLPTSELECT"
"STR_LBLLPT1"
"STR_LBLSELPOLARITY"
"STR_LBLINVRESET"
"STR_LBLINVSCK"
"STR_LBLINVDATAIN"
"STR_LBLINVDATAOUT"

"STR_TTCOM1"
"STR_TTUSB1"
"STR_TTLPT1"

"STR_LBLFILLBUF"

"STR_LBLFROM"
"STR_LBLTO"
"STR_LBLVALUE"

"STR_BTNCLRALL"
"STR_BTNSETALL"
"STR_BTNWRITE"
"STR_BTNREAD"

"STR_MSGFUSEDLG"

"STR_MSGFIRSTBLK"
"STR_MSGNUMBLOCK"
"STR_MSGHIGHENDBLK"

"STR_TTCLRALL"
"STR_TTSETALL"
"STR_TTWRITE"
"STR_TTREAD"

"STR_BTNCLOSE"

"STR_MSGDEVINFO"

"STR_MSGBANKROLL"
"STR_MSGSIZE"
"STR_MSGCRC"
"STR_MSGSECBLOCK"
"STR_HIGHENDURAN"

"STR_MSGEDITBUG"

"STR_MSGHEX"
"STR_MSGDECIMAL"
"STR_MSGCHAR"

"STR_MSGINSNEWVAL"
"STR_MSGENTERTEXT"

"STR_TTHEX"
"STR_TTDECIMAL"
"STR_TTCHAR"

"STR_MSGPROGOPT"

"STR_MSGRELOAD"
"STR_MSGREADPROG"
"STR_MSGREADDATA"
"STR_MSGREADSERNUM"
"STR_MSGBYTESWAP"
"STR_MSGSERNUM"
"STR_MSGERASE"
"STR_MSGWRITEPROG"
"STR_MSGWRITEDATA"
"STR_MSGWRITESEC"
"STR_MSGVERIFYSEC"

"STR_MSGSERNUMCFG"

"STR_MSGADDRESS"
"STR_MSGSIZE2"
"STR_MSGVALUE"
"STR_MSGFORMAT"

"STR_MSGLITTLEEND"
"STR_MSGBIGENDIAN"

"STR_MSGOFFSET"

"STR_TTSNMEMADDR"
"STR_TTSNSIZE"
"STR_TTSNVALUE"
"STR_TTSNOFFSET"
"STR_TTLITTLEEND"
"STR_TTBIGENDIAN"

"STR_BTNABORT"
"STR_BTNRETRY"
"STR_BTNIGNORE"

"STR_MSGALERT"

"STR_MSGDEVNOTE"

"STR_MSGSTATUS"

"STR_MSGHWCHECKDLG"

"STR_LBLNOSOUND"

"STR_LBLSKIPMSG"

"STR_MSGOSCCALIBCFG"

"STR_READOSCCALIB"
"STR_OSCCALIBOPTION"
"STR_MSGREADCALIBOK"

"STR_MSGCHIPID"
"STR_MSGNOTE"
"STR_MSGEEPSIZE"
"STR_MSGFLASHSIZE"

"STR_MSGSNAUTOINC"
"STR_TTSNAUTOINC"

"STR_MSGBANKROLLOVER"
"STR_BUFCHANGED3"

"STR_TTOPENPROG"
"STR_TTOPENDATA"
"STR_TTSAVEPROG"
"STR_TTSAVEDATA"
"STR_TTNEWWIN"
"STR_TTPROGRAM"
"STR_TTSCRIPT"
"STR_TTSETUP"
"STR_TTERASE"

"STR_SECBITS"
"STR_TTSECBITS"

"STR_LBLFUSEDLGHLP"
"STR_FUSEDLGNOTESET"
"STR_FUSEDLGNOTECLR" )


for f in $(find . -type f \( -name "string_table*.h" \));
do
    #replace text in all files recursively
    d2nd=$(cat $f | grep "INCLUDE_STRING_TABLE_H")
    if [[ ! ${d2nd}  = "" ]]; then
        echo "convert file $f"
        prefix="string_table_"
        name="`basename "$f" .h`"
        name=${name#$prefix}
        utfname="`basename "$f" .h`.utf"
        utfname=${utfname#$prefix}
        cp "$f" "$utfname"
       
        sed -i -e 's/\t/ /g' $utfname # remove tabs
        sed -i -e 's/\/\/[[:space:]]\+.*//g' $utfname # remove comments
        sed -i -e 's/\"[[:space:]]\+/\"/g' $utfname # remove comments
        sed -i -e 's/[[:space:]]\+\"/\"/g' $utfname # remove comments
   
        hdr="LANGUAGE_NAME\n$name\nLANGUAGE_CHARSET\nUTF-8"
        sed -i -e 's/#ifndef[[:space:]]\+INCLUDE_STRING_TABLE_H/'$hdr'/g' $utfname  # header 
        
        for index in ${!array[*]}; do
            #echo "${array[i]}"
            sed -i 's/#define[[:space:]]\+'${array[$index]}'\"\(.*\)\".*/t'$index'=\1/' $utfname;
        done
        
        sed -i -e 's/\"\/\/.*//g' $utfname # remove comments
        sed -i -e 's/#define.*//g' $utfname # remove old defines
        sed -i -e 's/USB1/USB/g' $utfname # remove old defines
        sed -i -e 's/COM1/COM/g' $utfname # remove old defines
        sed -i -e 's/LPT1/LPT/g' $utfname # remove old defines
        sed -i -e '/#ifdef[[:space:]]\+WIN32/,/#else/{s/.*//g;}' $utfname # #ifdef WIN32 .. #else
        sed -i -e 's/#endif.*//g' $utfname # remove #endif
        sed -i -e '/^\s*$/d' $utfname # remove space lines
    fi
done

