/* $Cambridge: hermes/src/prayer/cmd/cmd_reply1.c,v 1.3 2008/09/16 09:59:55 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"
#include "cmd.h"

void cmd_reply1(struct session *session)
{
    struct template_vals *tvals = session->template_vals;
    struct request *request = session->request;
    struct options *options = session->options;
    struct assoc *h;
    struct list_item *li;
    struct buffer *b = request->write_buffer;
    unsigned long count = 0;

    if (request->method == POST) {
        request_decode_form(request);
        if (assoc_lookup((h = request->form), "cancel")) {
            session_redirect(session, request,
                             session->compose_parent_cmd);
            return;
        }
        session->reply_all = (assoc_lookup(h, "all")) ? T : NIL;
    }

    if (list_length(options->role_list) == 0L) {
        cmd_reply2(session);
        return;
    }

    count = 0;
    template_vals_foreach_init(tvals, "@roles", count);
    template_vals_foreach_string(tvals, "@roles", count, "name", "default");
    count++;

    for (li = options->role_list->head; li; li = li->next) {
        struct role *role = (struct role *) li;

        template_vals_foreach_init(tvals, "@roles", count);
        template_vals_foreach_string(tvals, "@roles", count,
                                     "name", role->name);
        count++;
    }

    template_vals_string(tvals, "next", "reply2");
    session_seed_template(session, tvals);
    template_expand("roles_select", tvals, b);
    response_html(request, 200);
}
